/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.handler;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryActReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.CycleBuyDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.RateByDayEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.RateByMonthEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageBranchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemStorageQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.IShopApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.DeliveryPeriodDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDeliveryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.DeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.CombinationEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.IfWholeCasePurchaseEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderAddressReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderPreviewReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.GiftInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.activity.OrderActivityRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.OrderPreviewRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.query.ICustomerUserQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRuleItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionValidTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityRuleItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IConditionQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.PreviewCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.ComRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.CombinationRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.ActivityGiftNum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemActivityPriceReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemStorageQueryDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.StorageBranchQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemActivityPriceRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.dto.response.MatchCouponRespDto;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.ItemService;
import com.dtyunxi.yundt.module.trade.api.dto.AgainOrderCacheDao;
import com.dtyunxi.yundt.module.trade.api.dto.OrderExchangeDealDto;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.TargetCustomerInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.OrderCommonItemDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.PlaceOrderItemReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.PlaceOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.SeckillAcitivityDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderBaseReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderItemBaseReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.activity.OrderActivityBizReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.activity.OrderJoinActivityBizReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ControlRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.PreviewOrderRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ShopDeliveryTypeDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.activity.OrderActivityBizRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.activity.OrderJoinActivityBizDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.activity.PromotionActivityRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.shop.ShopInfo;
import com.dtyunxi.yundt.module.trade.api.enums.ActivityTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.ActivityTypeTobEnum;
import com.dtyunxi.yundt.module.trade.api.enums.StockTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.TargetCustomerType;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.ICommonService;
import com.dtyunxi.yundt.module.trade.biz.IHelpService;
import com.dtyunxi.yundt.module.trade.biz.ILocalCacheService;
import com.dtyunxi.yundt.module.trade.biz.IPriceService;
import com.dtyunxi.yundt.module.trade.biz.ISeckillCacheService;
import com.dtyunxi.yundt.module.trade.biz.ISeckillStockService;
import com.dtyunxi.yundt.module.trade.biz.util.KeyGenerator;
import com.dtyunxi.yundt.module.trade.biz.util.PageInfoUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.constants.LimitMinModeEnum;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PlaceOrderHandler
implements IServiceHandler {
    private static Logger logger = LoggerFactory.getLogger(PlaceOrderHandler.class);
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IOrderApi orderApi;
    @Resource
    private IUnitQueryApi unitQueryApi;
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private ICommonService commonService;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IBitemService bitemService;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IShopApi shopApi;
    @Autowired
    private IActivityItemQueryApi activityItemQueryApi;
    @Resource
    private IOrderService orderService;
    @Resource
    private ICustomerUserQueryApi customerUserQueryApi;
    @Resource
    private ILocalCacheService localCacheService;
    @Resource
    private ICacheService cacheService;
    @Value(value="${spring.profiles.active:dev}")
    private String profile;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Value(value="${icommerceb.seckill.orderpath.expires:1800}")
    private int orderPathExpires;
    @Resource
    private ISeckillCacheService seckillCacheService;
    @Resource
    private ISeckillStockService seckillStockService;
    @Resource
    private ICustomerQueryApi icustomerQueryApi;
    @Resource
    private IItemActivityStockApi itemActivityStockApi;
    @Resource
    private IItemStorageQueryApi itemStorageQueryApi;
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private IHelpService helpService;
    @Value(value="${item.storage.userItemCenter:true}")
    private boolean userItemCenter;
    @Resource
    private IConditionQueryApi conditionQueryApi;
    @Resource
    private IActivityRuleItemQueryApi activityRuleItemQueryApi;
    @Resource
    private ITcbjInventoryApi tcbjInventoryApi;
    @Resource
    private IPriceService priceService;
    @Resource
    private ItemService itemService;

    public Integer isCheckAddress(String locationX, String locationY, String shopIds) {
        RestResponse response = this.shopApi.isCheckAddress(locationX, locationY, shopIds);
        if (!"0".equals(response.getResultCode())) {
            throw new BizException(response.getResultCode(), response.getResultMsg());
        }
        return (Integer)response.getData();
    }

    @Deprecated
    public Object handle2(ServiceEvent<?> serviceEvent) {
        PlaceOrderReqDto placeOrderReqDto = (PlaceOrderReqDto)serviceEvent.getData();
        List itemIdList = placeOrderReqDto.getItemList().stream().map(OrderCommonItemDto::getItemId).collect(Collectors.toList());
        Object orderPreviewRespDto = null;
        List orderItemInfoList = null;
        PreviewOrderRespDto orderInfoDto = this.createOrderBaseInfoAndRecommendShop(placeOrderReqDto);
        orderInfoDto.setItemList(orderItemInfoList);
        orderInfoDto.setTotalAmount(orderPreviewRespDto.getTotalAmount());
        orderInfoDto.setPayAmount(orderPreviewRespDto.getPayAmount());
        orderInfoDto.setFreightAmount(orderPreviewRespDto.getFreightAmount());
        orderInfoDto.setTotalItemNum(Integer.valueOf(orderItemInfoList.size()));
        if (orderInfoDto.getTotalAmount() != null && orderInfoDto.getPayAmount() != null) {
            orderInfoDto.setIntegralDiscountAmount(orderInfoDto.getTotalAmount().subtract(orderInfoDto.getPayAmount()));
        }
        OrderAddressReqDto defaultAddress = this.getDefaultAddress(this.context.userId());
        orderInfoDto.setAddress(defaultAddress);
        Map<String, OrderItemInfoDto> skuItemMap = orderItemInfoList.stream().collect(Collectors.toMap(orderItemInfo -> orderItemInfo.getShopId() + "_" + orderItemInfo.getSkuId(), o -> o));
        if (CollectionUtils.isNotEmpty((Collection)orderPreviewRespDto.getSplitList())) {
            List splitList = orderPreviewRespDto.getSplitList().stream().map(order -> {
                PreviewOrderRespDto previewSplitOrder = new PreviewOrderRespDto();
                List items = order.getOrderItems().stream().map(item -> (OrderItemInfoDto)skuItemMap.get(item.getShopId() + "_" + item.getSkuSerial())).collect(Collectors.toList());
                previewSplitOrder.setItemList(items);
                previewSplitOrder.setTotalAmount(order.getTotalAmount());
                previewSplitOrder.setPayAmount(order.getPayAmount());
                previewSplitOrder.setAddress(defaultAddress);
                previewSplitOrder.setFreightAmount(order.getFreightAmount());
                return previewSplitOrder;
            }).collect(Collectors.toList());
            orderInfoDto.setSplitList(splitList);
        }
        return orderInfoDto;
    }

    public Object handle(ServiceEvent<?> serviceEvent) {
        PlaceOrderReqDto placeOrderReqDto = (PlaceOrderReqDto)serviceEvent.getData();
        placeOrderReqDto.setPreViewOrderDate(new Date());
        if ("edit".equals(placeOrderReqDto.getUpdateType())) {
            return this.updatePlaceOrder(placeOrderReqDto);
        }
        if (Objects.nonNull(placeOrderReqDto.getOrderActivity()) && CollectionUtils.isNotEmpty((Collection)placeOrderReqDto.getOrderActivity().getActivityList()) && ActivityTypeEnum.SECKILL.getCode().equals(((OrderActivityBizReqDto)placeOrderReqDto.getOrderActivity().getActivityList().get(0)).getType()) && CollectionUtils.isNotEmpty((Collection)placeOrderReqDto.getItemList()) && placeOrderReqDto.getItemList().size() == 1) {
            return this.secKillPlaceOrder(placeOrderReqDto);
        }
        List itemList = placeOrderReqDto.getItemList();
        if (itemList != null && !itemList.isEmpty() && ((PlaceOrderItemReqDto)itemList.get(0)).getBusType() == ItemBusTypeEnum.INTEGRAL.getType()) {
            placeOrderReqDto.setOrderActivity(null);
        }
        OrderExchangeDealDto orderExchangeDealDto = this.commonService.prepareOrderExchange(itemList.stream().map(placeOrderItemReqDto -> {
            PlaceOrderItemReqDto orderCommonItemDto = placeOrderItemReqDto;
            return orderCommonItemDto;
        }).collect(Collectors.toList()));
        this.validateItem(placeOrderReqDto.getItemList(), orderExchangeDealDto);
        OrderPreviewRespDto orderPreviewRespDto = this.previewOrderInfo(placeOrderReqDto, orderExchangeDealDto, this.context.userId());
        OrderJoinActivityBizDto joinActivityDto = this.convert2OrderJoinActivityBizDto(orderPreviewRespDto);
        List<OrderItemInfoDto> orderItemInfoList = this.getOrderItemInfoList(placeOrderReqDto.getItemList(), orderExchangeDealDto, orderPreviewRespDto);
        List<OrderItemInfoDto> giftItems = this.getGiftItems(orderPreviewRespDto.getGiftItems(), placeOrderReqDto.getCustomerId());
        PreviewOrderRespDto orderInfoDto = this.createOrderBaseInfoAndRecommendShop(placeOrderReqDto);
        orderInfoDto.setCustomerId(placeOrderReqDto.getCustomerId());
        orderInfoDto.setCustomerCode(placeOrderReqDto.getCustomerCode());
        GiftInfoRespDto giftInfoRespDto = orderPreviewRespDto.getGiftInfoRespDto();
        if (giftInfoRespDto != null) {
            giftInfoRespDto.setDeduction(placeOrderReqDto.isGiftAccount());
        }
        orderInfoDto.setGiftInfoRespDto(giftInfoRespDto);
        orderInfoDto.setItemList(orderItemInfoList);
        orderInfoDto.setGiftItems(giftItems);
        orderInfoDto.setTotalAmount(orderPreviewRespDto.getTotalAmount());
        orderInfoDto.setPayAmount(orderPreviewRespDto.getPayAmount());
        orderInfoDto.setFreightAmount(orderPreviewRespDto.getFreightAmount());
        orderInfoDto.setTotalItemNum(this.getTotalItemNum(orderItemInfoList, giftItems));
        orderInfoDto.setTotalDiscountAmount(orderPreviewRespDto.getTotalDiscountAmount());
        orderInfoDto.setActivityShopMapping(orderPreviewRespDto.getActivityShopMapping());
        if (orderInfoDto.getTotalAmount() != null && orderInfoDto.getPayAmount() != null) {
            orderInfoDto.setIntegralDiscountAmount(orderInfoDto.getTotalAmount().subtract(orderInfoDto.getPayAmount()));
        }
        Map<String, OrderItemInfoDto> skuItemMap = orderItemInfoList.stream().collect(Collectors.toMap(orderItemInfo -> orderItemInfo.getShopId() + "_" + orderItemInfo.getSkuId() + "_" + orderItemInfo.getGift(), OrderItemInfoDto2 -> OrderItemInfoDto2, (v1, v2) -> v1));
        if (CollectionUtils.isNotEmpty((Collection)orderPreviewRespDto.getSplitList())) {
            List splitList = orderPreviewRespDto.getSplitList().stream().map(order -> {
                PreviewOrderRespDto previewSplitOrder = new PreviewOrderRespDto();
                List items = order.getOrderItems().stream().map(item -> (OrderItemInfoDto)skuItemMap.get(item.getShopId() + "_" + item.getSkuSerial() + "_" + item.getGift())).collect(Collectors.toList());
                previewSplitOrder.setItemList(items);
                previewSplitOrder.setTotalAmount(order.getTotalAmount());
                previewSplitOrder.setPayAmount(order.getPayAmount());
                previewSplitOrder.setStartPrice(order.getStartingPric());
                previewSplitOrder.setFreightAmount(order.getFreightAmount());
                return previewSplitOrder;
            }).collect(Collectors.toList());
            orderInfoDto.setSplitList(splitList);
        }
        orderInfoDto.setStartPrice(orderPreviewRespDto.getStartingPric());
        this.dealActivityInfo(placeOrderReqDto, orderPreviewRespDto, orderInfoDto);
        if (CollectionUtils.isNotEmpty((Collection)orderPreviewRespDto.getSplitList())) {
            BigDecimal totalStartPricAmount = orderPreviewRespDto.getSplitList().stream().filter(orderRespDto -> orderRespDto.getStartingPric() != null).map(orderRespDto -> orderRespDto.getStartingPric()).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderInfoDto.setStartPrice(totalStartPricAmount);
        }
        this.fillPreviewErrMsg(orderInfoDto);
        orderInfoDto.setExchangeDisplayRespDto(orderPreviewRespDto.getExchangeDisplayRespDto());
        orderInfoDto.setExtFields(orderPreviewRespDto.getExtFields());
        this.checkControl(orderInfoDto);
        this.resetStorage(orderInfoDto);
        this.calculateLimitMinPurchase(orderInfoDto);
        return orderInfoDto;
    }

    private void calculateLimitMinPurchase(PreviewOrderRespDto orderInfoDto) {
        try {
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.icustomerQueryApi.queryById(orderInfoDto.getCustomerId()));
            if (CollectionUtils.isNotEmpty((Collection)orderInfoDto.getItemList())) {
                Integer ifWholePurchase = customerRespDto == null ? null : customerRespDto.getIfWholeCasePurchase();
                String ifWholeCasePurchaseRemark = null;
                for (OrderItemInfoDto orderItemInfoDto : orderInfoDto.getItemList()) {
                    orderItemInfoDto.setIfWholeCasePurchase(ifWholePurchase);
                    if (IfWholeCasePurchaseEnum.YES.getCode().equals(ifWholePurchase)) {
                        if (orderItemInfoDto.getMinPackage() != null) {
                            ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u975e\u7a7a\u3002\u53d6\u6700\u5c0f\u5305\u88c5\u6570";
                            orderItemInfoDto.setLimitMinPurchaseNum(orderItemInfoDto.getMinPackage());
                        } else if (LimitMinModeEnum.CUSTOMER.getCode().equals(orderItemInfoDto.getLimitMinMode())) {
                            orderItemInfoDto.setLimitMinPurchaseNum(orderItemInfoDto.getLimitMin());
                            ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u53ea\u80fd\u53d6\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf";
                        } else {
                            ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u500d\u6570\u63a7\u5236\u60c5\u51b5\u4e0b\u9ed8\u8ba4\u4e3a1";
                        }
                    } else if (LimitMinModeEnum.CUSTOMER.getCode().equals(orderItemInfoDto.getLimitMinMode())) {
                        orderItemInfoDto.setLimitMinPurchaseNum(orderItemInfoDto.getLimitMin());
                        ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf\u6a21\u5f0f\uff0c\u53ea\u80fd\u53d6\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf";
                    } else if (LimitMinModeEnum.MULTIPLE.getCode().equals(orderItemInfoDto.getLimitMinMode())) {
                        if (orderItemInfoDto.getMinPackage() != null && orderItemInfoDto.getLimitMin() != null) {
                            orderItemInfoDto.setLimitMinPurchaseNum(Integer.valueOf(orderItemInfoDto.getLimitMin() * orderItemInfoDto.getMinPackage()));
                            ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u500d\u6570\u63a7\u5236+\u6700\u5c0f\u5305\u88c5\u6570\u975e\u7a7a\u65f6\u8ba1\u7b97\u51fa\u76f8\u4e58\u7684\u8d77\u8ba2\u91cf";
                        } else {
                            ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u500d\u6570\u63a7\u5236\uff0c\u4f46\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u4e0b\u9ed8\u8ba4\u4e3a1";
                        }
                    } else {
                        ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u8d77\u8ba2\u91cf\u8bbe\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u4e3a1";
                    }
                    if (org.apache.commons.collections4.MapUtils.isNotEmpty((Map)orderItemInfoDto.getExtFields())) {
                        orderItemInfoDto.getExtFields().put("ifWholeCasePurchaseRemark", ifWholeCasePurchaseRemark);
                        continue;
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("ifWholeCasePurchaseRemark", ifWholeCasePurchaseRemark);
                    orderItemInfoDto.setExtFields(map);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u4e0b\u5355\u65f6\u8ba1\u7b97\u8d77\u8ba2\u91cf\u9519\u8bef:{}", (Object)e.getMessage());
        }
    }

    private void resetStorage(PreviewOrderRespDto orderInfoDto) {
        List itemList = orderInfoDto.getItemList();
        ArrayList itemIds = Lists.newArrayList();
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>();
        for (OrderItemInfoDto orderItemInfoDto : itemList) {
            if (!Objects.equals(orderItemInfoDto.getIsCombinedPackage(), CombinationEnum.NO.getType())) continue;
            itemIds.add(orderItemInfoDto.getItemId());
            ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
            itemStorageQueryDto.setSkuId(orderItemInfoDto.getSkuId());
            itemStorageQueryDto.setShopId(orderItemInfoDto.getShopId());
            itemStorageQueryDto.setCargoCode(orderItemInfoDto.getCargoCode());
            itemStorageList.add(itemStorageQueryDto);
        }
        if (CollectionUtils.isNotEmpty(itemStorageList)) {
            storageBranchQueryReqDto.setItemStorageList(itemStorageList);
            List itemStorageQueryDtos = this.bitemService.queryBranchItemStorage(storageBranchQueryReqDto);
            Map<String, Long> avaNumMap = itemStorageQueryDtos.stream().collect(Collectors.toMap(e -> e.getSkuId() + "_" + e.getCargoCode(), e -> Optional.of(e).map(ItemStorageQueryDto::getAvaNum).orElse(0L), (o1, o2) -> o1));
            Map controlStorageMap = this.itemService.checkControlRule((List)itemIds, orderInfoDto.getCustomerId());
            for (OrderItemInfoDto orderItemInfoDto : itemList) {
                Long avaNum = avaNumMap.get(orderItemInfoDto.getSkuId() + "_" + orderItemInfoDto.getCargoCode());
                orderItemInfoDto.setStorage(avaNum);
                Long controlStorage = (Long)controlStorageMap.get(orderItemInfoDto.getItemId());
                if (avaNum == null || controlStorage == null) continue;
                orderItemInfoDto.setStorage(Long.valueOf(avaNum - controlStorage < 0L ? 0L : avaNum - controlStorage));
            }
        }
    }

    private void checkControl(PreviewOrderRespDto orderInfoDto) {
        OrderBaseReqDto orderBaseReqDto = new OrderBaseReqDto();
        orderBaseReqDto.setOrderNo(orderInfoDto.getOrderNo());
        orderBaseReqDto.setCustomerId(ParamConverter.convertToLong((Object)orderInfoDto.getCustomerId()));
        orderBaseReqDto.setPayAmount(orderInfoDto.getPayAmount());
        orderBaseReqDto.setTotalAmount(orderInfoDto.getTotalAmount());
        if (CollectionUtils.isNotEmpty((Collection)orderInfoDto.getGiftItems())) {
            BigDecimal totalGiftOrigAmount = orderInfoDto.getGiftItems().stream().map(OrderItemInfoDto::getItemOrigPrice).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderBaseReqDto.setTotalGiftOrigAmount(totalGiftOrigAmount);
        }
        BigDecimal deductionAmount = BigDecimal.ZERO;
        if (orderInfoDto.getGiftInfoRespDto() != null && orderInfoDto.getGiftInfoRespDto().isDeduction()) {
            deductionAmount = orderInfoDto.getGiftInfoRespDto().getDeductionAmount();
        }
        orderBaseReqDto.setDeductionAmount(deductionAmount);
        List orderItemBaseReqDtos = orderInfoDto.getItemList().stream().map(tradeItemReqDto -> {
            OrderItemBaseReqDto orderItemBaseReqDto = new OrderItemBaseReqDto();
            orderItemBaseReqDto.setItemId(ParamConverter.convertToLong((Object)tradeItemReqDto.getItemId()));
            orderItemBaseReqDto.setItemNum(tradeItemReqDto.getItemNum());
            orderItemBaseReqDto.setItemCode(tradeItemReqDto.getItemCode());
            orderItemBaseReqDto.setSubType(tradeItemReqDto.getSubType());
            orderItemBaseReqDto.setAttrs(tradeItemReqDto.getAttrs());
            orderItemBaseReqDto.setImgPath(tradeItemReqDto.getImgPath());
            return orderItemBaseReqDto;
        }).collect(Collectors.toList());
        orderBaseReqDto.setItemList(orderItemBaseReqDtos);
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.iCustomerExtQueryApi.queryListByCustomerIds(Collections.singletonList(orderBaseReqDto.getCustomerId())));
        Long orgId = null;
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
            orgId = ((CustomerRespDto)customerRespDtos.get(0)).getMerchantId();
        }
        ControlRespDto controlRespDto = this.commonService.checkControlRule(orderBaseReqDto, orgId, false, true);
        orderInfoDto.setControlRespDto(controlRespDto);
    }

    private PreviewOrderRespDto updatePlaceOrder(PlaceOrderReqDto placeOrderReqDto) {
        PreviewOrderRespDto previewOrder = new PreviewOrderRespDto();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)placeOrderReqDto.getOrderNo())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ORDER_NO_NOT_EMPTY);
        }
        ArrayList attrs = Lists.newArrayList((Object[])new OrderQueryEnum[]{OrderQueryEnum.ITEM, OrderQueryEnum.ACTIVITY});
        RestResponse restResponse = this.orderBizQueryApi.getOrderDetail(placeOrderReqDto.getOrderNo(), org.apache.commons.lang3.StringUtils.join((Iterable)attrs, (String)","));
        OrderDetailRespDto orderData = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        Integer totalItemNum = orderData.getOrderItems().stream().map(TradeItemRespDto::getItemNum).reduce(Integer::sum).orElse(0);
        previewOrder.setShippingType(Integer.valueOf(1));
        if (CollectionUtils.isNotEmpty((Collection)orderData.getActivityList())) {
            previewOrder.setPayAmount(orderData.getPayAmount());
            previewOrder.setTotalItemNum(totalItemNum);
        } else {
            BigDecimal payAmount = BigDecimal.ZERO;
            Integer newTotalItemNum = 0;
            for (PlaceOrderItemReqDto tradeItemReqDto : placeOrderReqDto.getItemList()) {
                if (tradeItemReqDto.getItemPrice() == null) {
                    tradeItemReqDto.setItemPrice(BigDecimal.ZERO);
                }
                BigDecimal payTotalAmount = tradeItemReqDto.getItemPrice().multiply(new BigDecimal(tradeItemReqDto.getItemNum()));
                payAmount = payAmount.add(payTotalAmount);
                newTotalItemNum = newTotalItemNum + tradeItemReqDto.getItemNum();
            }
            previewOrder.setPayAmount(payAmount);
            previewOrder.setTotalItemNum(newTotalItemNum);
        }
        previewOrder.setCouponList(new ArrayList(1));
        previewOrder.setPromotionActivities(new ArrayList(1));
        previewOrder.setOrderActivity(new OrderJoinActivityBizReqDto());
        return previewOrder;
    }

    private void dealActivityInfo(PlaceOrderReqDto placeOrderReqDto, OrderPreviewRespDto orderPreviewRespDto, PreviewOrderRespDto orderInfoDto) {
        List cartIds;
        List enableActivityIds = orderPreviewRespDto.getEnableActivityIds();
        Map couponIdsMap = placeOrderReqDto.getCouponIdsMap();
        HashMap<Long, List> cartIdsMap = new HashMap<Long, List>();
        List orderItemList = placeOrderReqDto.getItemList();
        for (Object placeOrderItemReqDto : orderItemList) {
            ItemActivityPriceReqDto activityPrice = placeOrderItemReqDto.getActivityPrice();
            if (!Objects.nonNull(activityPrice) || !Objects.nonNull(activityPrice.getActivityId())) continue;
            cartIds = cartIdsMap.computeIfAbsent(activityPrice.getActivityId(), k -> Lists.newArrayList());
            cartIds.add(placeOrderItemReqDto.getId());
        }
        if (CollectionUtils.isNotEmpty(cartIdsMap.keySet()) && CollectionUtils.isNotEmpty((Collection)enableActivityIds)) {
            cartIdsMap.keySet().retainAll(enableActivityIds);
            if (CollectionUtils.isNotEmpty(cartIdsMap.keySet())) {
                ArrayList needCartIds = Lists.newArrayList();
                for (Object activityId : cartIdsMap.keySet()) {
                    cartIds = (List)cartIdsMap.get(activityId);
                    needCartIds.addAll(cartIds);
                }
                orderInfoDto.setCartIds((List)needCartIds);
            } else {
                orderInfoDto.setCartIds(new ArrayList(1));
            }
        } else {
            orderInfoDto.setCartIds(new ArrayList(1));
        }
        Map activityDiscountMap = orderPreviewRespDto.getActivityDiscountMap();
        if (CollectionUtils.isNotEmpty((Collection)placeOrderReqDto.getItemActivityIds())) {
            BigDecimal timeDiscountAmount = new BigDecimal("0");
            for (Long itemActivityId : placeOrderReqDto.getItemActivityIds()) {
                BigDecimal discount = (BigDecimal)activityDiscountMap.get(itemActivityId.toString());
                if (!Objects.nonNull(discount)) continue;
                timeDiscountAmount = timeDiscountAmount.add(discount);
            }
            orderInfoDto.setTimeDiscountAmount(timeDiscountAmount);
        }
        ArrayList promotionActivities = Lists.newArrayList();
        ArrayList couponList = Lists.newArrayList();
        HashMap<Long, PromotionActivityRespDto> promotionMap = new HashMap<Long, PromotionActivityRespDto>();
        HashMap<Long, String> couponNameMap = new HashMap<Long, String>();
        if (null != orderPreviewRespDto.getPreviewResult()) {
            if (CollectionUtils.isNotEmpty((Collection)orderPreviewRespDto.getPreviewResult().getActivityList())) {
                logger.info("\u8d60\u54c1\u6d3b\u52a8\u8d60\u9001\u8d60\u54c1\u5bf9\u5e94\u6570\u91cf:{}", (Object)JSON.toJSONString((Object)orderPreviewRespDto.getActivityGiftNumList()));
                Map<Object, Object> activityGiftNumMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty((Collection)orderPreviewRespDto.getActivityGiftNumList())) {
                    activityGiftNumMap = orderPreviewRespDto.getActivityGiftNumList().stream().collect(Collectors.toMap(ActivityGiftNum::getActivityId, e -> e, (e1, e2) -> e1));
                }
                Map<String, OrderItemInfoDto> giftItemMap = orderInfoDto.getGiftItems().stream().collect(Collectors.toMap(e -> e.getShopId() + e.getSkuId().toString(), e -> e, (e1, e2) -> e1));
                TreeMap promotionRespDtoTreeMap = Maps.newTreeMap((Comparator)new Comparator<ActivityTypeTobEnum>(){

                    @Override
                    public int compare(ActivityTypeTobEnum o1, ActivityTypeTobEnum o2) {
                        return o2.getSort().compareTo(o1.getSort());
                    }
                });
                List activityRespDtos = orderPreviewRespDto.getPreviewResult().getActivityList();
                BigDecimal promotionDiscountAmount = new BigDecimal("0");
                boolean discountFlag = false;
                HashSet selectedActivityIdSet = Sets.newHashSet();
                for (com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionActivityRespDto promotionActivityRespDto : activityRespDtos) {
                    ActivityTypeTobEnum activityTypeTobEnum = ActivityTypeTobEnum.fromCode((Long)promotionActivityRespDto.getActivityTemplateId());
                    PromotionActivityRespDto promotionRespDto = new PromotionActivityRespDto();
                    CubeBeanUtils.copyProperties((Object)promotionRespDto, (Object)promotionActivityRespDto, (String[])new String[0]);
                    promotionRespDto.setActivityType(ActivityType.getByType((Long)promotionActivityRespDto.getActivityTemplateId()));
                    if (CollectionUtils.isNotEmpty((Collection)enableActivityIds) && enableActivityIds.contains(promotionActivityRespDto.getActivityId()) && promotionRespDto.getStatus() == 1) {
                        if (ActivityTypeTobEnum.TIME_DISCOUNT_TOB_ACTIVITY.getCode().equals(activityTypeTobEnum.getCode()) || ActivityTypeTobEnum.SECKILL_TOB_ACTIVITY.getCode().equals(activityTypeTobEnum.getCode())) {
                            selectedActivityIdSet.add(promotionActivityRespDto.getActivityId());
                        }
                        promotionRespDto.setSelected(Boolean.valueOf(true));
                        BigDecimal discount = (BigDecimal)activityDiscountMap.get(promotionActivityRespDto.getActivityId().toString());
                        if (Objects.nonNull(discount)) {
                            promotionRespDto.setDiscountAmount(discount);
                            promotionDiscountAmount = promotionDiscountAmount.add(discount);
                            discountFlag = true;
                        }
                        promotionMap.put(promotionActivityRespDto.getActivityId(), promotionRespDto);
                    } else {
                        promotionRespDto.setSelected(Boolean.valueOf(false));
                    }
                    if (ActivityTypeTobEnum.FULL_PRESENT_TOB_ACTIVITY.getCode().equals(promotionActivityRespDto.getActivityTemplateId()) && activityGiftNumMap.containsKey(promotionActivityRespDto.getActivityId())) {
                        ArrayList activityGiftItemList = Lists.newArrayList();
                        ActivityGiftNum activityGiftNum = (ActivityGiftNum)activityGiftNumMap.get(promotionActivityRespDto.getActivityId());
                        Map giftNumRelationMap = activityGiftNum.getActivityGiftNumRelationMap();
                        for (Map.Entry giftNumRelationEntry : giftNumRelationMap.entrySet()) {
                            if (!giftItemMap.containsKey(giftNumRelationEntry.getKey())) continue;
                            OrderItemInfoDto orderItemInfoDto = giftItemMap.get(giftNumRelationEntry.getKey());
                            OrderItemInfoDto groupGiftItemInfo = new OrderItemInfoDto();
                            CubeBeanUtils.copyProperties((Object)groupGiftItemInfo, (Object)orderItemInfoDto, (String[])new String[]{"itemNum"});
                            groupGiftItemInfo.setItemNum((Integer)giftNumRelationEntry.getValue());
                            activityGiftItemList.add(groupGiftItemInfo);
                        }
                        promotionRespDto.setActivityGiftItemList((List)activityGiftItemList);
                    }
                    if (promotionRespDtoTreeMap.containsKey(activityTypeTobEnum)) {
                        ((List)promotionRespDtoTreeMap.get(activityTypeTobEnum)).add(promotionRespDto);
                        continue;
                    }
                    promotionRespDtoTreeMap.put(activityTypeTobEnum, Lists.newArrayList((Object[])new PromotionActivityRespDto[]{promotionRespDto}));
                }
                if (discountFlag) {
                    orderInfoDto.setPromotionDiscountAmount(promotionDiscountAmount);
                }
                for (OrderItemInfoDto orderItemInfoDto : orderInfoDto.getItemList()) {
                    if (!CollectionUtils.isNotEmpty((Collection)orderItemInfoDto.getActivityPriceList())) continue;
                    boolean notMatched = true;
                    for (ItemActivityPriceRespDto itemActivityPriceRespDto : orderItemInfoDto.getActivityPriceList()) {
                        if (notMatched && selectedActivityIdSet.contains(itemActivityPriceRespDto.getActivityId())) {
                            notMatched = false;
                            itemActivityPriceRespDto.setStatus(Integer.valueOf(1));
                            continue;
                        }
                        itemActivityPriceRespDto.setStatus(Integer.valueOf(0));
                    }
                }
                for (Map.Entry entry : promotionRespDtoTreeMap.entrySet()) {
                    List value = (List)entry.getValue();
                    ActivityTypeTobEnum key = (ActivityTypeTobEnum)entry.getKey();
                    BigDecimal totalDiscountAmount = value.stream().map(PromotionActivityRespDto::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    PromotionActivityRespDto dto2 = new PromotionActivityRespDto();
                    dto2.setActivityType(((PromotionActivityRespDto)value.get(0)).getActivityType());
                    dto2.setActivityTypeTobDesc(key.getDesc());
                    dto2.setDiscountAmount(totalDiscountAmount);
                    dto2.setPromotionActivityRespDtos(value);
                    promotionActivities.add(dto2);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)orderPreviewRespDto.getPreviewResult().getCouponList())) {
                List couponRespDtos = orderPreviewRespDto.getPreviewResult().getCouponList();
                Map reasonMap = orderPreviewRespDto.getActivityReasonMap();
                BigDecimal couponDiscountAmount = new BigDecimal("0");
                for (PreviewCouponRespDto couponRespDto : couponRespDtos) {
                    MatchCouponRespDto matchCouponRespDto = new MatchCouponRespDto();
                    CubeBeanUtils.copyProperties((Object)matchCouponRespDto, (Object)couponRespDto, (String[])new String[0]);
                    List couponIds = (List)couponIdsMap.get(couponRespDto.getActivityId().toString());
                    if (CollectionUtils.isNotEmpty((Collection)enableActivityIds) && enableActivityIds.contains(couponRespDto.getActivityId())) {
                        String reason = (String)reasonMap.get(couponRespDto.getActivityId().toString());
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reason)) {
                            matchCouponRespDto.setSelected(Boolean.valueOf(((Long)couponIds.get(0)).equals(couponRespDto.getId())));
                        } else {
                            matchCouponRespDto.setSelected(Boolean.valueOf(couponIds.contains(couponRespDto.getId())));
                        }
                    } else {
                        matchCouponRespDto.setSelected(Boolean.valueOf(false));
                    }
                    if (matchCouponRespDto.getSelected().booleanValue()) {
                        BigDecimal discount = (BigDecimal)activityDiscountMap.get(couponRespDto.getActivityId().toString());
                        couponDiscountAmount = couponDiscountAmount.add(discount);
                        couponNameMap.put(matchCouponRespDto.getActivityId(), matchCouponRespDto.getCouponName());
                    }
                    couponList.add(matchCouponRespDto);
                }
                orderInfoDto.setCouponDiscountAmount(couponDiscountAmount);
            }
        }
        OrderJoinActivityBizReqDto orderActivity = placeOrderReqDto.getOrderActivity();
        if (CollectionUtils.isEmpty((Collection)enableActivityIds)) {
            orderActivity = new OrderJoinActivityBizReqDto();
            orderActivity.setActivityList(new ArrayList(1));
        }
        if (Objects.nonNull(orderActivity) && CollectionUtils.isNotEmpty((Collection)orderActivity.getActivityList()) && CollectionUtils.isNotEmpty((Collection)enableActivityIds)) {
            List newList = orderActivity.getActivityList().stream().filter(dto -> {
                List couponIds = (List)couponIdsMap.get(dto.getActivityId().toString());
                if (CollectionUtils.isNotEmpty((Collection)couponIds) && enableActivityIds.contains(dto.getActivityId()) && ((Long)couponIds.get(0)).equals(Long.valueOf((String)dto.getCouponIds().get(0)))) {
                    dto.setActivityName((String)couponNameMap.get(dto.getActivityId()));
                    return true;
                }
                if (CollectionUtils.isEmpty((Collection)couponIds) && enableActivityIds.contains(dto.getActivityId())) {
                    PromotionActivityRespDto promotionActivityRespDto = (PromotionActivityRespDto)promotionMap.get(dto.getActivityId());
                    if (Objects.nonNull(promotionActivityRespDto)) {
                        dto.setShopSkuList(promotionActivityRespDto.getShopSkuList());
                        dto.setActivityName(promotionActivityRespDto.getActivityName());
                    }
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            orderActivity.setActivityList(newList);
        }
        orderInfoDto.setOrderActivity(orderActivity);
        orderInfoDto.setPromotionActivities((List)promotionActivities);
        orderInfoDto.setCouponList((List)couponList);
        for (OrderItemInfoDto orderItemInfoDto : orderInfoDto.getItemList()) {
            PromotionActivityRespDto promotionActivityRespDto;
            if (!Objects.nonNull(orderItemInfoDto.getLackActivityId()) || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orderItemInfoDto.getLackStockTip()) || !Objects.nonNull(promotionActivityRespDto = (PromotionActivityRespDto)promotionMap.get(orderItemInfoDto.getLackActivityId()))) continue;
            orderItemInfoDto.setLackStockTip("\u63d0\u793a\uff1a\u5f53\u524d\u201c" + promotionActivityRespDto.getActivityName() + "\u201d\u5e93\u5b58\u4ec5\u5269" + orderItemInfoDto.getLackRemainingStock() + "\uff0c\u8d2d\u4e70\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u5c06\u4e0d\u53c2\u4e0e\u6b64\u6d3b\u52a8\u3002");
        }
    }

    private PreviewOrderRespDto secKillPlaceOrder(PlaceOrderReqDto placeOrderReqDto) {
        Long orgInfoId;
        Long activityId = ((OrderActivityBizReqDto)placeOrderReqDto.getOrderActivity().getActivityList().get(0)).getActivityId();
        PlaceOrderItemReqDto item = (PlaceOrderItemReqDto)placeOrderReqDto.getItemList().get(0);
        Long skuId = item.getSkuId();
        Integer itemNum = item.getItemNum();
        Long customerId = placeOrderReqDto.getCustomerId();
        String customerCode = null;
        if (customerId == null) {
            RestResponse shopDtoRestResponse = this.shopQueryApi.queryById(((PlaceOrderItemReqDto)placeOrderReqDto.getItemList().get(0)).getShopId().longValue(), new String[0]);
            RestResponse sellerRespDtoRestResponse = this.sellerQueryApi.queryById(((ShopDto)shopDtoRestResponse.getData()).getSellerId());
            Long sellerOrgId = ((SellerRespDto)sellerRespDtoRestResponse.getData()).getOrganizationId();
            Assert.notNull((Object)placeOrderReqDto.getOrgInfoId(), (String)" \u7ec4\u7ec7id", (Object[])new Object[0]);
            RestResponse restResponse = this.iCustomerExtQueryApi.queryCustomerByOrgAndMerch(placeOrderReqDto.getOrgInfoId(), sellerOrgId);
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
            if (Objects.nonNull(customerRespDto)) {
                customerId = customerRespDto.getId();
                customerCode = customerRespDto.getCode();
            }
            orgInfoId = placeOrderReqDto.getOrgInfoId();
        } else {
            List customerList = (List)RestResponseHelper.extractData((RestResponse)this.iCustomerExtQueryApi.queryListByCustomerIds((List)Lists.newArrayList((Object[])new Long[]{customerId})));
            orgInfoId = ((CustomerRespDto)customerList.get(0)).getOrgInfoId();
            customerCode = ((CustomerRespDto)customerList.get(0)).getCode();
        }
        if (Objects.isNull(customerId)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.CUSTOMER_NOT_EXIST);
        }
        placeOrderReqDto.setCustomerId(customerId);
        String pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        String group = "yundt-cube-center-common-" + pfile;
        this.validateActivity(activityId);
        this.validateTargetCustomer(activityId, customerId, group);
        this.validateItem(placeOrderReqDto.getItemList());
        this.validateUserJoinActvityNum(activityId, orgInfoId, group);
        Integer stockType = this.getStockType();
        this.validateItemStock(activityId, skuId, item.getShopId(), itemNum, stockType);
        this.validateItemLimit(activityId, itemNum, group);
        String orderPath = this.generateOrderPath(activityId, skuId, customerId, group);
        OrderExchangeDealDto orderExchangeDealDto = this.commonService.prepareOrderExchange(placeOrderReqDto.getItemList().stream().map(placeOrderItemReqDto -> {
            PlaceOrderItemReqDto orderCommonItemDto = placeOrderItemReqDto;
            return orderCommonItemDto;
        }).collect(Collectors.toList()));
        this.commonService.recalculatePrice(customerId, placeOrderReqDto.getItemList());
        OrderPreviewRespDto orderPreviewRespDto = this.previewSeckillOrderInfo(placeOrderReqDto, orderExchangeDealDto, this.context.userId());
        List<OrderItemInfoDto> orderItemInfoList = this.getSeckillOrderItemInfoList(placeOrderReqDto, orderExchangeDealDto);
        PreviewOrderRespDto orderInfoDto = this.createOrderBaseInfoAndRecommendShop(placeOrderReqDto);
        orderInfoDto.setCustomerId(customerId);
        orderInfoDto.setCustomerCode(customerCode);
        GiftInfoRespDto giftInfoRespDto = orderPreviewRespDto.getGiftInfoRespDto();
        if (giftInfoRespDto != null) {
            giftInfoRespDto.setDeduction(placeOrderReqDto.isGiftAccount());
        }
        orderInfoDto.setGiftInfoRespDto(giftInfoRespDto);
        orderInfoDto.setPath(orderPath);
        orderInfoDto.setItemList(orderItemInfoList);
        orderInfoDto.setTotalAmount(orderPreviewRespDto.getTotalAmount());
        orderInfoDto.setPayAmount(orderPreviewRespDto.getPayAmount());
        orderInfoDto.setFreightAmount(orderPreviewRespDto.getFreightAmount());
        orderInfoDto.setTotalItemNum(orderItemInfoList.get(0).getItemNum());
        orderInfoDto.setTotalDiscountAmount(orderPreviewRespDto.getTotalDiscountAmount());
        orderInfoDto.setSeckillAmount(orderInfoDto.getTotalDiscountAmount());
        orderInfoDto.setOrderActivity(placeOrderReqDto.getOrderActivity());
        orderInfoDto.setPromotionActivities(new ArrayList(1));
        orderInfoDto.setCouponList(new ArrayList(1));
        for (OrderItemInfoDto orderItemInfoDto : orderInfoDto.getItemList()) {
            if (!CollectionUtils.isNotEmpty((Collection)orderItemInfoDto.getActivityPriceList())) continue;
            for (ItemActivityPriceRespDto priceRespDto : orderItemInfoDto.getActivityPriceList()) {
                if (!Objects.equals(priceRespDto.getActivityId(), activityId)) continue;
                priceRespDto.setStatus(Integer.valueOf(1));
            }
        }
        this.checkControl(orderInfoDto);
        return orderInfoDto;
    }

    private OrderPreviewRespDto previewSeckillOrderInfo(PlaceOrderReqDto placeOrderReqDto, OrderExchangeDealDto orderExchangeDealDto, Long userId) {
        OrderPreviewReqDto orderViewParam = this.commonService.getSeckillOrderViewParam(placeOrderReqDto, orderExchangeDealDto, userId);
        if (placeOrderReqDto.getAddress() != null && placeOrderReqDto.getAddress().getId() != null && orderViewParam.getDeliveryAddress() == null) {
            OrderAddressReqDto orderAddressReqDto = new OrderAddressReqDto();
            orderAddressReqDto.setId(placeOrderReqDto.getAddress().getId());
            orderViewParam.setDeliveryAddress(orderAddressReqDto);
        }
        orderViewParam.setCustomerId(placeOrderReqDto.getCustomerId().toString());
        logger.info("\u4e0b\u5355\u8ba2\u5355\u9884\u89c8\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orderViewParam));
        orderViewParam.setRuleId(placeOrderReqDto.getRuleId());
        this.filterReqParam(orderViewParam);
        return (OrderPreviewRespDto)RestResponseHelper.extractData((RestResponse)this.orderApi.previewSeckillOrder(orderViewParam));
    }

    private List<OrderItemInfoDto> getSeckillOrderItemInfoList(PlaceOrderReqDto placeOrderReqDto, OrderExchangeDealDto orderExchangeDealDto) {
        List placeOrderItemList = placeOrderReqDto.getItemList();
        BigDecimal rebateTotalAmount = placeOrderReqDto.getRebateTotalAmount();
        ArrayList itemLit = Lists.newArrayList();
        Map attrs = null;
        for (PlaceOrderItemReqDto placeOrderItemReqDto : placeOrderItemList) {
            ItemDetailRespDto itemDetailRespDto = orderExchangeDealDto.getByItemId(placeOrderItemReqDto.getItemId());
            String imgPath = this.commonService.getItemImgPath(itemDetailRespDto);
            ItemSkuRespDto sku = this.commonService.getItemSkuRespDto(placeOrderItemReqDto.getSkuId(), itemDetailRespDto);
            if (null != sku) {
                attrs = (Map)ObjectHelper.Json2Bean((String)sku.getAttr(), Map.class);
            }
            OrderItemInfoDto orderItemInfoDto = new OrderItemInfoDto();
            CubeBeanUtils.copyProperties((Object)orderItemInfoDto, (Object)placeOrderItemReqDto, (String[])new String[0]);
            orderItemInfoDto.setDiscountAmount(orderItemInfoDto.getSellPrice().subtract(placeOrderItemReqDto.getActivityPrice().getActivityPrice()));
            orderItemInfoDto.setDiscountTotalAmount(orderItemInfoDto.getDiscountAmount().multiply(BigDecimal.valueOf(orderItemInfoDto.getItemNum().intValue())));
            orderItemInfoDto.setImgPath(imgPath);
            orderItemInfoDto.setAttrs(attrs);
            orderItemInfoDto.setGift(Integer.valueOf(0));
            orderItemInfoDto.setItemName(itemDetailRespDto.getItem().getName());
            orderItemInfoDto.setItemCode(itemDetailRespDto.getItem().getCode());
            orderItemInfoDto.setSubType(placeOrderItemReqDto.getSubType());
            orderItemInfoDto.setStorage(placeOrderItemReqDto.getStorage());
            Integer itemType = placeOrderItemReqDto.getItemType() != null ? placeOrderItemReqDto.getItemType() : ItemTypeEnum.GENERAL.getType();
            orderItemInfoDto.setItemType(itemType);
            Integer busType = placeOrderItemReqDto.getBusType() != null ? placeOrderItemReqDto.getBusType() : ItemBusTypeEnum.ORDINARY.getType();
            orderItemInfoDto.setBusType(busType);
            orderItemInfoDto.setShelfType(ShelfTypeEnum.NORMAL.getType());
            orderItemInfoDto.setRebateAmount(rebateTotalAmount);
            itemLit.add(orderItemInfoDto);
        }
        return itemLit;
    }

    private Integer getStockType() {
        RestResponse response = this.itemActivityStockApi.queryActivityStockType(null);
        return (Integer)RestResponseHelper.extractData((RestResponse)response);
    }

    private List<OrderItemInfoDto> getOrderItemInfoList(BigDecimal activityPrice, List<PlaceOrderItemReqDto> placeOrderItems) {
        ArrayList itemLit = Lists.newArrayList();
        for (PlaceOrderItemReqDto itemReqDto : placeOrderItems) {
            ItemRespDto itemRespDto = this.localCacheService.getItemRespDto(itemReqDto.getItemId(), itemReqDto.getSkuId());
            if (null == itemReqDto || CollectionUtils.isEmpty((Collection)itemRespDto.getItemSkuList())) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_NOT_EXIST);
            }
            OrderItemInfoDto orderItemInfoDto = new OrderItemInfoDto();
            ItemSkuRespDto sku = (ItemSkuRespDto)itemRespDto.getItemSkuList().get(0);
            orderItemInfoDto.setAttrs((Map)ObjectHelper.Json2Bean((String)sku.getAttr(), Map.class));
            CubeBeanUtils.copyProperties((Object)orderItemInfoDto, (Object)itemReqDto, (String[])new String[0]);
            orderItemInfoDto.setImgPath(itemReqDto.getImgPath());
            orderItemInfoDto.setDiscountAmount(orderItemInfoDto.getSellPrice().subtract(activityPrice));
            orderItemInfoDto.setSellPrice(activityPrice);
            orderItemInfoDto.setItemNum(itemReqDto.getItemNum());
            orderItemInfoDto.setItemName(itemRespDto.getName());
            itemLit.add(orderItemInfoDto);
        }
        return itemLit;
    }

    private String generateOrderPath(Long activityId, Long skuId, Long userId, String group) {
        String salt = String.valueOf(System.currentTimeMillis());
        String pathMD5Code = this.getPathMD5Code(activityId.toString(), skuId.toString(), userId.toString(), salt);
        this.cacheService.setCache(group, pathMD5Code, (Object)KeyGenerator.getOrderPathKey(activityId, skuId, userId), this.orderPathExpires);
        return pathMD5Code;
    }

    private String getPathMD5Code(String activityId, String skuId, String userId, String salt) {
        String md5Sb = activityId + skuId + userId + salt;
        return MD5Util.getMd5ByString((String)md5Sb);
    }

    private ActivityRespDto validateActivity(Long activityId) {
        ActivityRespDto activity;
        if (!this.localCacheService.isValid(activityId)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ACTIVITY_FINISH);
        }
        if ((activity = this.getActivityById(activityId)) == null) {
            throw new BizException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        if (ActivityStatusEnum.FINISH.getKey().equals(activity.getActivityStatus())) {
            this.localCacheService.invalid(activityId);
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ACTIVITY_FINISH);
        }
        if (!ActivityStatusEnum.ACTIVATE.getKey().equals(activity.getActivityStatus())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ACTIVITY_NOT_START);
        }
        return activity;
    }

    private ActivityRespDto getActivityById(Long activityId) {
        SeckillAcitivityDto activityRespDto = this.seckillCacheService.getByActivityId(activityId);
        if (activityRespDto != null) {
            return activityRespDto.getActivity();
        }
        ActivityRespDto activity = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(activityId.longValue()).getData();
        this.seckillCacheService.addSeckillActivity(activity);
        return activity;
    }

    private void validateTargetCustomer(Long activityId, Long customerId, String group) {
        String targetCustomer = (String)this.cacheService.getCache(group, KeyGenerator.getTargetCustomerKey(activityId), String.class);
        TargetCustomerInfoDto targetCustomerInfoDto = (TargetCustomerInfoDto)JSON.parseObject((String)targetCustomer, TargetCustomerInfoDto.class);
        if (Objects.isNull(targetCustomerInfoDto)) {
            return;
        }
        TargetCustomerType populationType = TargetCustomerType.getByType((Integer)targetCustomerInfoDto.getType());
        if (null == populationType) {
            populationType = TargetCustomerType.ALL;
        }
        switch (populationType) {
            case ALL: {
                return;
            }
            case CATEGORY: {
                this.category(customerId, targetCustomerInfoDto);
                break;
            }
            case CROWD: {
                this.crowd(customerId, targetCustomerInfoDto);
            }
        }
    }

    private void category(Long userId, TargetCustomerInfoDto value) {
        if (Objects.isNull(value)) {
            return;
        }
        RestResponse restResp = this.icustomerQueryApi.queryById(userId);
        CustomerRespDto customerInfo = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)restResp);
        if (Objects.nonNull(customerInfo)) {
            Long customerTypeId = customerInfo.getCustomerTypeId();
            List regionCodeList = customerInfo.getRegionCodeList();
            List customerTypeIds = value.getCustomerTypeIds();
            List customerAreaCodes = value.getCustomerAreaCodes();
            List subAreaCodes = value.getSubAreaCodes();
            List blackCustomerIds = value.getBlackCustomerIds();
            if (CollectionUtils.isEmpty((Collection)subAreaCodes)) {
                subAreaCodes = customerAreaCodes;
            }
            if (!CollectionUtils.isEmpty((Collection)customerTypeIds) && !customerTypeIds.contains(customerTypeId)) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.NOT_ELIGIBLE_TO_JOIN);
            }
            if (!CollectionUtils.isEmpty((Collection)subAreaCodes)) {
                regionCodeList.retainAll(subAreaCodes);
                if (CollectionUtils.isEmpty((Collection)regionCodeList)) {
                    BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.NOT_ELIGIBLE_TO_JOIN);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)blackCustomerIds) && blackCustomerIds.contains(userId)) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.NOT_ELIGIBLE_TO_JOIN);
            }
        }
    }

    private void crowd(Long userId, TargetCustomerInfoDto value) {
        if (Objects.isNull(value) || CollectionUtils.isEmpty((Collection)value.getCustomerIds())) {
            return;
        }
        if (value.getCustomerIds().contains(userId)) {
            return;
        }
        BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.NOT_ELIGIBLE_TO_JOIN);
    }

    private BigDecimal validateItem(Long activityId, Long itemId, Long skuId, Long shopId, String group) {
        BigDecimal localCachePrice;
        boolean isValid = this.localCacheService.isValidItem(itemId, skuId);
        if (!isValid) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_NOT_EXIST);
        }
        if ((localCachePrice = this.localCacheService.getActivityPrice(activityId, skuId, shopId)) != null) {
            return localCachePrice;
        }
        BigDecimal activityPrice = (BigDecimal)this.cacheService.hget(group, KeyGenerator.getItemPriceKey(activityId), KeyGenerator.getBySeparator("_", shopId, skuId), BigDecimal.class);
        if (null == activityPrice) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ACTIVITY_ITEM_INVALID);
        }
        return activityPrice;
    }

    private void validateItem(List<PlaceOrderItemReqDto> itemList) {
        ItemActivityPriceReqDto activityPrice;
        if (CollectionUtils.isEmpty(itemList)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.TRADE_ITEM_NOT_EMPTY);
        }
        if (Objects.isNull(activityPrice = itemList.get(0).getActivityPrice())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.INVALID_PARAM);
        }
    }

    private void validateUserJoinActvityNum(Long activityId, Long userId, String group) {
        Integer joinNum = (Integer)this.cacheService.hget(group, KeyGenerator.getCustomerJoinActivityNumKey(activityId), userId.toString(), Integer.class);
        Integer actvityLimit = (Integer)this.cacheService.getCache(group, KeyGenerator.getActivityLimitKey(activityId), Integer.class);
        if (null == joinNum || null == actvityLimit) {
            return;
        }
        if (joinNum >= actvityLimit) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.USER_JOIN_ACTIVITY_NO_EXCEED);
        }
    }

    private void validateItemStock(Long activityId, Long skuId, Long shopId, Integer itemNum, Integer stockType) {
        if (this.localCacheService.isEmptyStock(activityId, skuId, shopId)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_STOCK_NOT_ENOUGH);
        }
        Long stock = this.seckillStockService.queryStock(activityId, skuId, shopId, ActivityItemTypeEnum.ITEM);
        if (StockTypeEnum.SHARE.getCode().equals(stockType)) {
            if (!(stock != null && stock == -1L || stock != null && stock >= 0L && (long)itemNum.intValue() <= stock)) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_STOCK_NOT_ENOUGH);
            }
        } else if (stock == null || stock < 0L || (long)itemNum.intValue() > stock) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_STOCK_NOT_ENOUGH);
        }
    }

    private void validateItemVirStock(Long skuId, Long shopId, Integer itemNum) {
        Long stock;
        ItemStorageBranchQueryReqDto itemStorageBranchQueryReqDto = new ItemStorageBranchQueryReqDto();
        ShelfReqDto itemShelfReqDto = new ShelfReqDto();
        itemShelfReqDto.setShopId(shopId);
        itemShelfReqDto.setSkuId(skuId);
        ArrayList<ShelfReqDto> selfList = new ArrayList<ShelfReqDto>(1);
        selfList.add(itemShelfReqDto);
        itemStorageBranchQueryReqDto.setShelfList(selfList);
        RestResponse listRestResponse = this.itemStorageQueryApi.queryBranchItemStorage(itemStorageBranchQueryReqDto);
        List itemStorageQueryRespDtoList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        if (CollectionUtils.isNotEmpty((Collection)itemStorageQueryRespDtoList) && ((stock = ((ItemStorageQueryRespDto)itemStorageQueryRespDtoList.get(0)).getAvaNum()) == null || stock < 0L || (long)itemNum.intValue() > stock)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_STOCK_NOT_ENOUGH);
        }
    }

    private void validateItemLimit(Long activityId, Integer itemNum, String group) {
        Integer numLimit = (Integer)this.cacheService.getCache(group, KeyGenerator.getItemLimitKey(activityId), Integer.class);
        if (null == numLimit) {
            return;
        }
        if (numLimit < itemNum) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ACTIVITY_ITEM_LIMIT);
        }
    }

    public void fillPreviewErrMsg(PreviewOrderRespDto orderInfoDto) {
        this.setStartPricErrMsg(null, orderInfoDto);
    }

    private void setStartPricErrMsg(PreviewOrderRespDto parentOrder, PreviewOrderRespDto orderInfoDto) {
        if (CollectionUtils.isNotEmpty((Collection)orderInfoDto.getSplitList())) {
            StringBuilder totalErrMsg = new StringBuilder("");
            BigDecimal totalCutAmount = BigDecimal.ZERO;
            for (PreviewOrderRespDto previewOrderRespDto : orderInfoDto.getSplitList()) {
                this.setStartPricErrMsg(orderInfoDto, previewOrderRespDto);
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)previewOrderRespDto.getPreviewErrMsg())) continue;
                totalErrMsg.append(previewOrderRespDto.getPreviewErrMsg() + ";");
                if (previewOrderRespDto.getCutAmount() == null) continue;
                totalCutAmount = totalCutAmount.add(previewOrderRespDto.getCutAmount());
            }
            if (totalErrMsg.length() > 0) {
                orderInfoDto.setPreviewErrMsg(totalErrMsg.toString().substring(0, totalErrMsg.length() - 1));
                orderInfoDto.setPreventSubmitMsg("\u5dee\uffe5" + totalCutAmount + "\u8d77\u9001");
            }
        } else {
            BigDecimal actAmount = this.getActAmount(orderInfoDto);
            if (orderInfoDto.getStartPrice() != null && orderInfoDto.getStartPrice().compareTo(actAmount) > 0) {
                String shopName = this.getShopName(parentOrder, orderInfoDto);
                BigDecimal cutAmount = orderInfoDto.getStartPrice().subtract(actAmount);
                orderInfoDto.setPreviewErrMsg("\u5e97\u94fa:" + shopName + "\uffe5" + orderInfoDto.getStartPrice().setScale(2) + "\u8d77\u9001");
                orderInfoDto.setPreventSubmitMsg("\u5dee\uffe5" + cutAmount.setScale(2) + "\u8d77\u9001");
                orderInfoDto.setCutAmount(cutAmount);
            }
        }
    }

    private BigDecimal getActAmount(PreviewOrderRespDto orderInfoDto) {
        if (orderInfoDto.getFreightAmount() == null) {
            return orderInfoDto.getPayAmount();
        }
        return orderInfoDto.getPayAmount().subtract(orderInfoDto.getFreightAmount());
    }

    private String getShopName(PreviewOrderRespDto parentOrder, PreviewOrderRespDto orderInfoDto) {
        String shopName = ((OrderItemInfoDto)orderInfoDto.getItemList().get(0)).getShopName();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)shopName)) {
            List shopList = orderInfoDto.getShopList();
            if (CollectionUtils.isEmpty((Collection)shopList) && parentOrder != null) {
                shopList = parentOrder.getShopList();
            }
            if (CollectionUtils.isNotEmpty((Collection)shopList)) {
                Long shopId = ((OrderItemInfoDto)orderInfoDto.getItemList().get(0)).getShopId();
                for (ShopInfo shopInfo : shopList) {
                    if (shopId == null || !shopId.equals(shopInfo.getId())) continue;
                    return shopInfo.getName();
                }
            }
            return "";
        }
        return shopName;
    }

    private Integer getTotalItemNum(List<OrderItemInfoDto> orderItemInfoList, List<OrderItemInfoDto> giftItems) {
        Integer totalItemNum = orderItemInfoList.stream().mapToInt(OrderItemInfoDto::getItemNum).sum();
        return totalItemNum;
    }

    public void setShopDeliveryInfo(PreviewOrderRespDto orderInfoDto, Long shopId) {
        RestResponse shopResp = this.shopQueryApi.queryById(shopId.longValue(), new String[0]);
        ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)shopResp);
        if (shopDto == null) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOP_NOT_EXIST);
        }
        LinkedList shopDeliveryTypeDtoList = Lists.newLinkedList();
        ShopDeliveryDto shopDeliveryDto = shopDto.getShopDeliveryDto();
        logger.info("\u5e97\u94fa\u914d\u9001\u4fe1\u606f: shopId={}, shopDeliveryDto={}", (Object)shopId, (Object)JSON.toJSONString((Object)shopDeliveryDto));
        if (shopDto.getCityDelivery() != null && shopDto.getCityDelivery().booleanValue() && shopDeliveryDto.getCityDeliveryPeriod() != null) {
            List<String> cityDeliveryPeriodList = this.getShopDeliveryTimeList(shopDeliveryDto.getCityDeliveryPeriod());
            cityDeliveryPeriodList = this.getDurationListByDate(cityDeliveryPeriodList, shopDeliveryDto.getCityDeliveryPeriod().getPredictPickTime());
            ShopDeliveryTypeDto cityDeliveryTypeDto = new ShopDeliveryTypeDto(Integer.valueOf(DeliveryTypeEnum.CITY_DELIVERY.getCode()), DeliveryTypeEnum.CITY_DELIVERY.getName(), cityDeliveryPeriodList);
            shopDeliveryTypeDtoList.add(cityDeliveryTypeDto);
        }
        if (shopDto.getSelfPickUp() != null && shopDto.getSelfPickUp().booleanValue() && shopDeliveryDto.getSelfPickUpPeriod() != null) {
            List<String> selfPickUpPeriodList = this.getShopDeliveryTimeList(shopDeliveryDto.getSelfPickUpPeriod());
            selfPickUpPeriodList = this.getDurationListByDate(selfPickUpPeriodList, shopDeliveryDto.getSelfPickUpPeriod().getPredictPickTime());
            ShopDeliveryTypeDto selfPickUpDeliveryTypeDto = new ShopDeliveryTypeDto(Integer.valueOf(DeliveryTypeEnum.SELF_PICK_UP.getCode()), DeliveryTypeEnum.SELF_PICK_UP.getName(), selfPickUpPeriodList);
            shopDeliveryTypeDtoList.add(selfPickUpDeliveryTypeDto);
            OrderAddressReqDto addressReqDto = orderInfoDto.getAddress() != null ? orderInfoDto.getAddress() : new OrderAddressReqDto();
            addressReqDto.setPickUpAddress(shopDto.getShopDeliveryDto().getDetailAddress());
            orderInfoDto.setAddress(addressReqDto);
        }
        orderInfoDto.setShopDeliveryTypeDtoList((List)shopDeliveryTypeDtoList);
    }

    private List<String> getDurationListByDate(List<String> durationList, String predictPickUpTime) {
        Object[] duration;
        Integer predict = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)predictPickUpTime) ? Integer.parseInt(predictPickUpTime) : 0;
        LocalTime start = predict > 0 ? LocalTime.now().plusMinutes(predict.intValue()) : LocalTime.now();
        int j = -1;
        boolean flag = false;
        for (int i = 0; i < durationList.size(); ++i) {
            duration = org.apache.commons.lang3.StringUtils.split((String)durationList.get(i), (String)"-");
            if (start.isAfter(LocalTime.parse(duration[0])) && start.isBefore(LocalTime.parse(duration[1]))) {
                j = i;
                flag = true;
                break;
            }
            if (!start.isBefore(LocalTime.parse(duration[0]))) continue;
            j = i;
            break;
        }
        if (flag) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
            duration = org.apache.commons.lang3.StringUtils.split((String)durationList.get(j), (String)"-");
            duration[0] = start.format(formatter);
            durationList.set(j, org.apache.commons.lang3.StringUtils.join((Object[])duration, (String)"-"));
        }
        return j >= 0 ? durationList.subList(j, durationList.size()) : Lists.newArrayList();
    }

    private List<String> getShopDeliveryTimeList(DeliveryPeriodDto deliveryPeriodDto) {
        List<Object> list = null;
        logger.info("\u914d\u9001\u65f6\u95f4\u6bb5\u8ba1\u7b97: {}", (Object)JSON.toJSONString((Object)deliveryPeriodDto));
        try {
            Boolean deliveryAllDay = deliveryPeriodDto.getDeliveryAllDay();
            List deliveryPeriodList = deliveryPeriodDto.getDeliveryPeriodList();
            int timeInterval = Integer.parseInt(deliveryPeriodDto.getTimeInterval());
            if (deliveryAllDay != null && deliveryAllDay.booleanValue()) {
                list = this.getDurationList(null, null, timeInterval);
            } else if (CollectionUtils.isNotEmpty((Collection)deliveryPeriodList)) {
                list = deliveryPeriodList.stream().map(period -> {
                    String[] t = org.apache.commons.lang3.StringUtils.split((String)period, (String)",");
                    return this.getDurationList(t[0], t[1], timeInterval);
                }).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            logger.error("\u914d\u9001\u65f6\u95f4\u6bb5\u8ba1\u7b97\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
        return CollectionUtils.isNotEmpty(list) ? list : Lists.newArrayList();
    }

    private List<String> getDurationList(String start, String end, int interval) {
        LocalTime localTimeStart = null;
        LocalTime localTimeEnd = null;
        Duration duration = null;
        long count = 0L;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)start) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)end)) {
            localTimeStart = LocalTime.parse("00:00");
            count = 1440 / interval;
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)start) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)end)) {
            localTimeStart = LocalTime.parse(start);
            localTimeEnd = LocalTime.parse(end);
            duration = Duration.between(localTimeStart, localTimeEnd);
            count = duration.toMinutes() / (long)interval;
        }
        List list = Stream.iterate(localTimeStart, time -> time.plusMinutes(interval)).limit(count + 1L).collect(Collectors.toList());
        ArrayList durationList = Lists.newArrayList();
        for (int i = 0; i < list.size() - 1; ++i) {
            durationList.add(list.get(i) + "-" + list.get(i + 1));
        }
        return durationList;
    }

    private Map<String, Date> getCycleBuyEndDate(Integer cycleType, Integer[] cycleValue, Date startDate, Integer totalCycleCount) {
        HashMap dateMap = Maps.newHashMap();
        Date endDate = null;
        try {
            if (CycleBuyDeliveryTypeEnum.BY_DAY.getCode() == cycleType.intValue()) {
                int startDayOfWeek;
                int rate = cycleValue[0];
                if (Arrays.asList(RateByDayEnum.EVERYDAY.getCode(), RateByDayEnum.EVERY_OTHER_DAY.getCode(), RateByDayEnum.EVERY_TWO_DAYS.getCode(), RateByDayEnum.EVERY_THREE_DAYS.getCode()).contains(rate)) {
                    endDate = new DateTime((Object)startDate).plusDays(rate * (totalCycleCount - 1)).toDate();
                }
                int currentDayOfWeek = new DateTime((Object)startDate).getDayOfWeek();
                int totalWorkDayOfWeek = 5;
                int totalRestDayOfWeek = 2;
                if (RateByDayEnum.WORKDAY.getCode() == rate) {
                    int surplusCycleCount;
                    if (Arrays.asList(6, 7).contains(currentDayOfWeek)) {
                        startDate = this.getNextMonday(startDate);
                    }
                    startDayOfWeek = new DateTime((Object)startDate).getDayOfWeek();
                    int surplusExecuteDays = totalWorkDayOfWeek - startDayOfWeek + 1;
                    endDate = totalCycleCount <= surplusExecuteDays ? new DateTime((Object)startDate).plusDays(totalCycleCount - 1).toDate() : ((surplusCycleCount = totalCycleCount - surplusExecuteDays) % totalWorkDayOfWeek == 0 ? new DateTime((Object)this.getNextMonday(startDate)).plusDays((surplusCycleCount / totalWorkDayOfWeek - 1) * 7 + 4).toDate() : new DateTime((Object)this.getNextMonday(startDate)).plusDays(surplusCycleCount / totalWorkDayOfWeek * 7 + surplusCycleCount % totalWorkDayOfWeek - 1).toDate());
                }
                if (RateByDayEnum.REST_DAY.getCode() == rate) {
                    if (!Arrays.asList(6, 7).contains(currentDayOfWeek)) {
                        startDate = new DateTime((Object)this.getNextMonday(startDate)).minusDays(2).toDate();
                    }
                    if (6 == (startDayOfWeek = new DateTime((Object)startDate).getDayOfWeek())) {
                        endDate = new DateTime((Object)startDate).minusDays(5).plusDays(totalCycleCount / totalRestDayOfWeek * 7 + totalCycleCount % totalRestDayOfWeek * 6 - 1).toDate();
                    }
                    if (7 == startDayOfWeek) {
                        if (1 == totalCycleCount) {
                            endDate = startDate;
                        } else {
                            int surplusCycleCount = totalCycleCount - 1;
                            endDate = new DateTime((Object)this.getNextMonday(startDate)).plusDays(surplusCycleCount / totalRestDayOfWeek * 7 + surplusCycleCount % totalRestDayOfWeek * 6 - 1).toDate();
                        }
                    }
                }
            }
            if (CycleBuyDeliveryTypeEnum.BY_WEEK.getCode() == cycleType.intValue()) {
                int currentDayOfWeek = new DateTime((Object)startDate).getDayOfWeek();
                cycleValue = (Integer[])Stream.of(cycleValue).mapToInt(Integer::intValue).sorted().boxed().toArray(Integer[]::new);
                int[] rate = Stream.of(cycleValue).mapToInt(Integer::intValue).sorted().filter(r -> r >= currentDayOfWeek).toArray();
                if (totalCycleCount <= rate.length) {
                    endDate = new DateTime((Object)startDate).plusDays(rate[totalCycleCount - 1] - currentDayOfWeek).toDate();
                } else {
                    int surplusCycleCount = totalCycleCount - rate.length;
                    int maxRate = cycleValue[cycleValue.length - 1];
                    endDate = surplusCycleCount % cycleValue.length == 0 ? new DateTime((Object)this.getNextMonday(startDate)).plusDays((surplusCycleCount / cycleValue.length - 1) * 7 + maxRate - 1).toDate() : new DateTime((Object)this.getNextMonday(startDate)).plusDays(surplusCycleCount / cycleValue.length * 7 + cycleValue[surplusCycleCount % cycleValue.length - 1] - 1).toDate();
                }
                startDate = rate.length > 0 ? new DateTime((Object)startDate).plusDays(rate[0] - currentDayOfWeek).toDate() : new DateTime((Object)startDate).minusDays(currentDayOfWeek - cycleValue[0]).plusDays(7).toDate();
            }
            if (CycleBuyDeliveryTypeEnum.BY_MONTH.getCode() == cycleType.intValue()) {
                int currentDayOfMonth = new DateTime((Object)startDate).getDayOfMonth();
                boolean isLastDayOfMonth = RateByMonthEnum.LAST.getCode() == cycleValue[0].intValue();
                int rate = isLastDayOfMonth ? new DateTime((Object)startDate).dayOfMonth().getMaximumValue() : cycleValue[0].intValue();
                DateTime startDateTime = new DateTime((Object)startDate);
                if (currentDayOfMonth <= rate) {
                    startDate = this.getYearMonthDay(startDateTime.getYear(), startDateTime.getMonthOfYear(), rate, isLastDayOfMonth);
                } else {
                    DateTime nextStartDateTime = startDateTime.plusMonths(1);
                    startDate = this.getYearMonthDay(nextStartDateTime.getYear(), nextStartDateTime.getMonthOfYear(), rate, isLastDayOfMonth);
                }
                DateTime endMonth = new DateTime((Object)startDate).plusMonths(totalCycleCount - 1);
                endDate = this.getYearMonthDay(endMonth.getYear(), endMonth.getMonthOfYear(), rate, isLastDayOfMonth);
            }
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u914d\u7f6e\u5468\u671f\u7684\u5230\u65e5\u671f\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
        dateMap.put("startDate", startDate);
        dateMap.put("endDate", endDate);
        return dateMap;
    }

    private Date getNextMonday(Date date) {
        LocalDate today = new LocalDate((Object)date);
        int old = today.getDayOfWeek();
        LocalDate next = today.plusDays(8 - old);
        return next.toDate();
    }

    private Date getYearMonthDay(int year, int month, int day, boolean isLastDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        if (isLastDay) {
            calendar.set(5, calendar.getActualMaximum(5));
        } else {
            calendar.set(5, day);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private PreviewOrderRespDto createOrderBaseInfoAndRecommendShop(PlaceOrderReqDto placeOrderReqDto) {
        PreviewOrderRespDto orderInfoDto = new PreviewOrderRespDto();
        Long itemShopId = ((PlaceOrderItemReqDto)placeOrderReqDto.getItemList().get(0)).getShopId();
        Set shopIds = placeOrderReqDto.getItemList().stream().map(OrderCommonItemDto::getShopId).collect(Collectors.toSet());
        List shops = (List)this.shopQueryApi.queryBaseListByIds(shopIds).getData();
        List shopDtoList = BeanCopierUtils.copyList((List)shops, ShopInfo.class);
        ShopInfo itemShop = (ShopInfo)shopDtoList.get(0);
        if (!this.userItemCenter) {
            WarehouseRespDto warehouseRespDto = this.buildWarehouse(((ShopBaseDto)shops.get(0)).getOrganizationId());
            itemShop.setWarehouseCode(warehouseRespDto.getCode());
            itemShop.setWarehouseId(warehouseRespDto.getId());
        }
        orderInfoDto.setShopList(shopDtoList);
        orderInfoDto.setShippingType(Integer.valueOf(itemShop.getType().intValue()));
        return orderInfoDto;
    }

    private WarehouseRespDto buildWarehouse(Long orgId) {
        try {
            WarehouseQueryReqDto warehouseQueryReqDto = new WarehouseQueryReqDto();
            warehouseQueryReqDto.setOrganizationIds((List)Lists.newArrayList((Object[])new Long[]{orgId}));
            warehouseQueryReqDto.setType("0");
            warehouseQueryReqDto.setMainWarehouse(Integer.valueOf(1));
            RestResponse pageInfoRestResp = this.warehouseQueryApi.queryWarehousePage(warehouseQueryReqDto, Integer.valueOf(1), Integer.valueOf(1));
            PageInfo warehousePageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
            return (WarehouseRespDto)warehousePageInfo.getList().get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u4e0a\u67b6\u672a\u914d\u7f6e\u4ed3\u5e93,\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
        }
    }

    private void setPromotionActivityInfo(PreviewOrderRespDto orderInfoDto, List<Long> enableActivityIds) {
        if (CollectionUtils.isEmpty(enableActivityIds)) {
            return;
        }
        ArrayList promotionActivities = Lists.newArrayList();
        ArrayList orderActivityBizReqDtos = Lists.newArrayList();
        enableActivityIds.forEach(activityId -> {
            ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(activityId.longValue()).getData();
            OrderActivityBizRespDto orderActivityBizRespDto = new OrderActivityBizRespDto();
            orderActivityBizRespDto.setActivityId(activityRespDto.getId());
            orderActivityBizRespDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
            CubeBeanUtils.copyProperties((Object)orderActivityBizRespDto, (Object)activityRespDto, (String[])new String[0]);
            orderActivityBizReqDtos.add(orderActivityBizRespDto);
            if (ActivityDimensionEnum.ITEM.getKey().equals(activityRespDto.getActivityTemplate().getDimension())) {
                ActivityItemQueryReqDto itemQueryReqDto = new ActivityItemQueryReqDto();
                itemQueryReqDto.setActivityId(activityId);
                List activityItems = (List)this.activityItemQueryApi.queryAll(itemQueryReqDto).getData();
                orderInfoDto.getItemList().forEach(orderItemInfoDto -> activityItems.stream().filter(activityItemRespDto -> activityItemRespDto.getSkuId().equals(orderItemInfoDto.getSkuId())).findFirst().ifPresent(activityItemRespDto -> orderItemInfoDto.setSellPrice(activityItemRespDto.getActivityPrice())));
            }
            if (ActivityDimensionEnum.ORDER.getKey().equals(activityRespDto.getActivityTemplate().getDimension())) {
                promotionActivities.add(orderActivityBizRespDto);
            }
        });
        OrderJoinActivityBizDto orderActivity = new OrderJoinActivityBizDto();
        orderActivity.setActivityList((List)orderActivityBizReqDtos);
    }

    private void validateItem(List<PlaceOrderItemReqDto> itemList, OrderExchangeDealDto orderExchangeDealDto) {
        for (PlaceOrderItemReqDto placeOrderItemReqDto : itemList) {
            ItemShelfRespDto onSelfInfo;
            ItemDetailRespDto itemDetailRespDto = orderExchangeDealDto.getByItemId(placeOrderItemReqDto.getItemId());
            if (null == itemDetailRespDto || null == itemDetailRespDto.getItem() || null == itemDetailRespDto.getItemSkuList()) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_NOT_EXIST);
            }
            if ((onSelfInfo = orderExchangeDealDto.getOnSelfInfo(placeOrderItemReqDto.getSkuId(), placeOrderItemReqDto.getShopId())) == null || !ItemStatus.ITEM_ONSHELF.getStatus().equals(onSelfInfo.getStatus())) {
                throw new BizException("\u5546\u54c1\u5df2\u4e0b\u67b6,\u5546\u54c1\u540d\u79f0\uff1a\u3010" + placeOrderItemReqDto.getItemName() + "\u3011");
            }
            ShopDto shopDto = orderExchangeDealDto.getByShopId(placeOrderItemReqDto.getShopId());
            if (null != shopDto && null != shopDto.getId()) continue;
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOP_NOT_EXIST);
        }
    }

    private OrderPreviewRespDto previewOrderInfo(PlaceOrderReqDto placeOrderReqDto, OrderExchangeDealDto orderExchangeDealDto, Long userId) {
        if (!"1".equals(placeOrderReqDto.getPlaceType()) && placeOrderReqDto.getCustomerId() == null) {
            RestResponse listRestResponse = this.iCustomerExtQueryApi.queryCustomerIdsByUserId(userId);
            List customerIds = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            if (CollectionUtils.isEmpty((Collection)customerIds)) {
                throw new BizException("\u4ee3\u5ba2\u4e0b\u5355\u9700\u6307\u5b9acustomerId");
            }
            RestResponse customerListRestResp = this.iCustomerExtQueryApi.queryListByCustomerIds(customerIds);
            List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)customerListRestResp);
            placeOrderReqDto.setCustomerId(((CustomerRespDto)customerRespDtoList.get(0)).getId());
            placeOrderReqDto.setCustomerCode(((CustomerRespDto)customerRespDtoList.get(0)).getCode());
        }
        if (placeOrderReqDto.getCustomerId() == null) {
            RestResponse shopDtoRestResponse = this.shopQueryApi.queryById(((PlaceOrderItemReqDto)placeOrderReqDto.getItemList().get(0)).getShopId().longValue(), new String[0]);
            RestResponse sellerRespDtoRestResponse = this.sellerQueryApi.queryById(((ShopDto)shopDtoRestResponse.getData()).getSellerId());
            Long organizationId = ((SellerRespDto)sellerRespDtoRestResponse.getData()).getOrganizationId();
            Assert.notNull((Object)placeOrderReqDto.getOrgInfoId(), (String)" \u7ec4\u7ec7id", (Object[])new Object[0]);
            RestResponse listRestResponse = this.iCustomerExtQueryApi.queryCustomerByOrgAndMerch(placeOrderReqDto.getOrgInfoId(), organizationId);
            placeOrderReqDto.setCustomerId(((CustomerRespDto)listRestResponse.getData()).getId());
            placeOrderReqDto.setCustomerCode(((CustomerRespDto)listRestResponse.getData()).getCode());
        } else {
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.icustomerQueryApi.queryById(placeOrderReqDto.getCustomerId()));
            Assert.notNull((Object)customerRespDto, (String)" \u5ba2\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            placeOrderReqDto.setCustomerId(customerRespDto.getId());
            placeOrderReqDto.setCustomerCode(customerRespDto.getCode());
        }
        this.commonService.recalculatePrice(placeOrderReqDto.getCustomerId(), placeOrderReqDto.getItemList());
        Integer viewType = ConditionValidTypeEnum.THROW_EXCEPTION.getType();
        if (placeOrderReqDto.getMatchActivity().booleanValue()) {
            List<OrderActivityBizReqDto> itemActivityList;
            List<OrderActivityBizReqDto> activityList = this.commonService.getPromotionActivityList(placeOrderReqDto.getItemList(), placeOrderReqDto.getCustomerId());
            if (placeOrderReqDto.getOrderActivity() == null) {
                OrderJoinActivityBizReqDto orderJoinActivityBizReqDto = new OrderJoinActivityBizReqDto();
                orderJoinActivityBizReqDto.setActivityList(new ArrayList());
                placeOrderReqDto.setOrderActivity(orderJoinActivityBizReqDto);
            } else {
                List oldActivityList = placeOrderReqDto.getOrderActivity().getActivityList();
                if (CollectionUtils.isNotEmpty((Collection)oldActivityList)) {
                    ArrayList newList = Lists.newArrayList();
                    for (OrderActivityBizReqDto dto : oldActivityList) {
                        if (ActivityTypeEnum.PROMOTION.getCode().equals(dto.getType()) || ActivityTypeEnum.COUPON.getCode().equals(dto.getType()) || ActivityTypeTobEnum.SECKILL_TOB_ACTIVITY.getName().equals(dto.getActivityType())) continue;
                        dto.setSort(ActivityTypeTobEnum.getSortByName((String)dto.getActivityType()).intValue());
                        newList.add(dto);
                    }
                    placeOrderReqDto.getOrderActivity().setActivityList((List)newList);
                }
            }
            if ("add".equals(placeOrderReqDto.getUpdateType()) && CollectionUtils.isNotEmpty(itemActivityList = this.addAgainPlaceOrder(placeOrderReqDto))) {
                placeOrderReqDto.getOrderActivity().getActivityList().addAll(itemActivityList);
            }
            if (CollectionUtils.isNotEmpty(activityList)) {
                placeOrderReqDto.getOrderActivity().getActivityList().addAll(activityList);
            }
            viewType = ConditionValidTypeEnum.NO_THROW_EXCEPTION.getType();
        }
        logger.info("\u9884\u89c8\u63a5\u53e3\u6d3b\u52a8\u6392\u5e8f\u524d\uff1a{}", (Object)JSON.toJSONString((Object)placeOrderReqDto.getOrderActivity().getActivityList()));
        if (CollectionUtils.isNotEmpty((Collection)placeOrderReqDto.getOrderActivity().getActivityList())) {
            List activitySortedList = placeOrderReqDto.getOrderActivity().getActivityList().stream().filter(e -> !ActivityTypeTobEnum.SECKILL_TOB_ACTIVITY.getName().equals(e.getActivityType())).sorted(Comparator.comparing(OrderActivityBizReqDto::getSort).reversed()).collect(Collectors.toList());
            placeOrderReqDto.getOrderActivity().setActivityList(activitySortedList);
        }
        logger.info("\u9884\u89c8\u63a5\u53e3\u6d3b\u52a8\u6392\u5e8f\u540e\uff1a{}", (Object)JSON.toJSONString((Object)placeOrderReqDto.getOrderActivity().getActivityList()));
        this.clearCombinationActivity(placeOrderReqDto);
        logger.info("\u8fc7\u6ee4\u6389\u5355\u4e70\u7684\u4f18\u60e0\u5957\u88c5\u5546\u54c1\u540e\uff1a{}", (Object)JSON.toJSONString((Object)placeOrderReqDto.getOrderActivity().getActivityList()));
        OrderPreviewReqDto orderViewParam = this.commonService.getOrderViewParam(placeOrderReqDto, orderExchangeDealDto, userId);
        orderViewParam.setViewType(viewType);
        if (placeOrderReqDto.getAddress() != null && placeOrderReqDto.getAddress().getId() != null && orderViewParam.getDeliveryAddress() == null) {
            OrderAddressReqDto orderAddressReqDto = new OrderAddressReqDto();
            orderAddressReqDto.setId(placeOrderReqDto.getAddress().getId());
            orderViewParam.setDeliveryAddress(orderAddressReqDto);
        }
        orderViewParam.setPreviewActivity(Boolean.valueOf(true));
        orderViewParam.setCustomerId(placeOrderReqDto.getCustomerId().toString());
        logger.info("\u4e0b\u5355\u8ba2\u5355\u9884\u89c8\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orderViewParam));
        orderViewParam.setRuleId(placeOrderReqDto.getRuleId());
        this.filterReqParam(orderViewParam);
        return (OrderPreviewRespDto)RestResponseHelper.extractData((RestResponse)this.orderApi.previewOrder(orderViewParam));
    }

    private void filterReqParam(OrderPreviewReqDto orderViewParam) {
        for (TradeItemReqDto e : orderViewParam.getOrderItems()) {
            e.setRebateAmount(BigDecimal.ZERO);
        }
    }

    public <T extends EngineParams> void clearCombinationActivity(PlaceOrderReqDto placeOrderReqDto) {
        List activityList = placeOrderReqDto.getOrderActivity().getActivityList();
        Map<Long, OrderActivityBizReqDto> activityMap = activityList.stream().collect(Collectors.toMap(OrderActivityBizReqDto::getActivityId, activity -> activity, (e1, e2) -> e1));
        List activitys = activityList.stream().map(OrderActivityBizReqDto::getActivityId).collect(Collectors.toList());
        List allCombinationIds = activityList.stream().filter(activity -> ActivityTypeTobEnum.COMBINATION_ACTIVITY.getName().equals(activity.getActivityType())).map(OrderActivityBizReqDto::getActivityId).collect(Collectors.toList());
        List itemCombinationIds = placeOrderReqDto.getItemList().stream().filter(dto -> dto.getIsCombinedPackage() == 1).map(PlaceOrderItemReqDto::getActivityId).distinct().collect(Collectors.toList());
        ArrayList newActivityList = Lists.newArrayList();
        for (Long activityId : activitys) {
            if (allCombinationIds.contains(activityId) && !itemCombinationIds.contains(activityId)) continue;
            newActivityList.add(activityMap.get(activityId));
        }
        placeOrderReqDto.getOrderActivity().setActivityList((List)newActivityList);
    }

    private List<OrderActivityBizReqDto> addAgainPlaceOrder(PlaceOrderReqDto placeOrderReqDto) {
        String cacheKey;
        AgainOrderCacheDao cache;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)placeOrderReqDto.getOrderNo())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ORDER_NO_NOT_EMPTY);
        }
        if (Objects.isNull(cache = (AgainOrderCacheDao)this.cacheService.getCache(cacheKey = "addAgainPlaceOrder_" + placeOrderReqDto.getOrderNo(), AgainOrderCacheDao.class))) {
            ArrayList attrs = Lists.newArrayList((Object[])new OrderQueryEnum[]{OrderQueryEnum.ITEM, OrderQueryEnum.ACTIVITY});
            RestResponse restResponse = this.orderBizQueryApi.getOrderDetail(placeOrderReqDto.getOrderNo(), org.apache.commons.lang3.StringUtils.join((Iterable)attrs, (String)","));
            OrderDetailRespDto orderData = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
            cache = new AgainOrderCacheDao();
            if (CollectionUtils.isEmpty((Collection)orderData.getActivityList())) {
                ArrayList<OrderActivityBizReqDto> list = new ArrayList<OrderActivityBizReqDto>(1);
                cache.setActivityList(list);
                this.cacheService.add(cacheKey, (Object)cache, 604800);
                return list;
            }
            List itemActivityIds = orderData.getActivityList().stream().filter(act -> ActivityTypeEnum.TIME_DISCOUNT.getCode().equals(act.getType())).map(OrderActivityRespDto::getActivityId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(itemActivityIds)) {
                ArrayList<OrderActivityBizReqDto> list = new ArrayList<OrderActivityBizReqDto>(1);
                cache.setActivityList(list);
                this.cacheService.add(cacheKey, (Object)cache, 604800);
                return list;
            }
            ArrayList activityBizList = Lists.newArrayList();
            for (TradeItemRespDto orderItem : orderData.getOrderItems()) {
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orderItem.getActivityIds())) continue;
                ArrayList<String> activityIdList = new ArrayList<String>(Arrays.asList(orderItem.getActivityIds().split(",")));
                activityIdList.retainAll(itemActivityIds);
                if (!CollectionUtils.isNotEmpty(activityIdList)) continue;
                OrderActivityBizReqDto activityBizReqDto = new OrderActivityBizReqDto();
                activityBizReqDto.setActivityId(Long.valueOf((String)activityIdList.get(0)));
                activityBizReqDto.setType(ActivityTypeEnum.TIME_DISCOUNT.getCode());
                activityBizReqDto.setActivityType(ActivityTypeTobEnum.TIME_DISCOUNT_TOB_ACTIVITY.getName());
                activityBizReqDto.setShopId(Long.valueOf(orderItem.getShopId()));
                activityBizReqDto.setSkuId(Long.valueOf(orderItem.getSkuSerial()));
                activityBizList.add(activityBizReqDto);
            }
            cache.setActivityList((List)activityBizList);
            this.cacheService.add(cacheKey, (Object)cache, 604800);
        }
        return cache.getActivityList();
    }

    private OrderJoinActivityBizDto convert2OrderJoinActivityBizDto(OrderPreviewRespDto previewRespDto) {
        if (CollectionUtils.isEmpty((Collection)previewRespDto.getEnableActivityIds())) {
            return null;
        }
        ArrayList orderActivityBizReqDtos = Lists.newArrayList();
        previewRespDto.getEnableActivityIds().forEach(activityId -> {
            OrderActivityBizRespDto orderActivityBizRespDto = new OrderActivityBizRespDto();
            orderActivityBizRespDto.setActivityId(activityId);
            orderActivityBizReqDtos.add(orderActivityBizRespDto);
            if (null != previewRespDto.getActivityShopMapping() && previewRespDto.getActivityShopMapping().containsKey(activityId)) {
                orderActivityBizRespDto.setShopList((List)previewRespDto.getActivityShopMapping().get(activityId));
            }
        });
        OrderJoinActivityBizDto orderActivity = new OrderJoinActivityBizDto();
        orderActivity.setActivityList((List)orderActivityBizReqDtos);
        return orderActivity;
    }

    private List<OrderItemInfoDto> getOrderItemInfoList(List<PlaceOrderItemReqDto> placeOrderItemList, OrderExchangeDealDto orderExchangeDealDto, OrderPreviewRespDto orderPreviewRespDto) {
        ArrayList<PlaceOrderItemReqDto> placeOrderItems = new ArrayList<PlaceOrderItemReqDto>();
        ArrayList<PlaceOrderItemReqDto> combinedPackageItems = new ArrayList<PlaceOrderItemReqDto>();
        for (PlaceOrderItemReqDto placeOrderItemReqDto : placeOrderItemList) {
            if (placeOrderItemReqDto.getIsCombinedPackage() == 0) {
                placeOrderItems.add(placeOrderItemReqDto);
                continue;
            }
            combinedPackageItems.add(placeOrderItemReqDto);
        }
        Map<String, TradeItemRespDto> skuMap = null;
        if (CollectionUtils.isNotEmpty((Collection)orderPreviewRespDto.getOrderItems())) {
            skuMap = orderPreviewRespDto.getOrderItems().stream().filter(item -> !Integer.valueOf(1).equals(item.getGift())).collect(Collectors.toMap(orderItem -> orderItem.getShopId() + "_" + orderItem.getSkuSerial() + "_" + orderItem.getGift() + "_" + orderItem.getIfExchange() + "_" + orderItem.getExchangeActivityId(), orderItem -> orderItem, (v1, v2) -> v1));
        }
        logger.info("\u9884\u89c8\u7ed3\u679cmap:{}", (Object)JSON.toJSONString(skuMap));
        ArrayList itemLit = Lists.newArrayList();
        Map attrs = null;
        for (PlaceOrderItemReqDto placeOrderItemReqDto : placeOrderItems) {
            ItemDetailRespDto itemDetailRespDto = orderExchangeDealDto.getByItemId(placeOrderItemReqDto.getItemId());
            TradeItemRespDto tradeItemRespDto = null;
            if (MapUtils.isNotEmpty(skuMap)) {
                tradeItemRespDto = skuMap.get(placeOrderItemReqDto.getShopId() + "_" + placeOrderItemReqDto.getSkuId() + "_" + placeOrderItemReqDto.getGift() + "_" + placeOrderItemReqDto.getIfExchange() + "_" + placeOrderItemReqDto.getExchangeActivityId());
                logger.info("\u9884\u89c8\u7ed3\u679cmap\u5339\u914d\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)tradeItemRespDto));
            }
            String imgPath = this.commonService.getItemImgPath(itemDetailRespDto);
            ItemSkuRespDto sku = this.commonService.getItemSkuRespDto(placeOrderItemReqDto.getSkuId(), itemDetailRespDto);
            if (null != sku) {
                attrs = (Map)ObjectHelper.Json2Bean((String)sku.getAttr(), Map.class);
            }
            OrderItemInfoDto orderItemInfoDto = new OrderItemInfoDto();
            CubeBeanUtils.copyProperties((Object)orderItemInfoDto, (Object)placeOrderItemReqDto, (String[])new String[0]);
            orderItemInfoDto.setExtFields(placeOrderItemReqDto.getExtFields());
            if (null != tradeItemRespDto) {
                orderItemInfoDto.setRebateAmount(tradeItemRespDto.getRebateAmount());
                orderItemInfoDto.setSellPrice(tradeItemRespDto.getItemMarketPrice());
                orderItemInfoDto.setExchangePrice(tradeItemRespDto.getExchangePrice());
                if (Objects.nonNull(tradeItemRespDto.getDiscountTotalAmount())) {
                    orderItemInfoDto.setDiscountTotalAmount(tradeItemRespDto.getDiscountTotalAmount());
                    BigDecimal discountAmount = tradeItemRespDto.getDiscountTotalAmount().divide(BigDecimal.valueOf(orderItemInfoDto.getItemNum().intValue()), 2, 1);
                    orderItemInfoDto.setDiscountAmount(discountAmount);
                }
                if (CollectionUtils.isNotEmpty(tradeItemRespDto.getLackRemainingStockMap().keySet())) {
                    ArrayList activityIds = Lists.newArrayList(tradeItemRespDto.getLackRemainingStockMap().keySet());
                    Long lackRemainingStock = (Long)tradeItemRespDto.getLackRemainingStockMap().get(activityIds.get(0));
                    orderItemInfoDto.setLackActivityId((Long)activityIds.get(0));
                    orderItemInfoDto.setLackRemainingStock(lackRemainingStock);
                    if (Objects.nonNull(placeOrderItemReqDto.getActivityPrice()) && ((Long)activityIds.get(0)).equals(placeOrderItemReqDto.getActivityPrice().getActivityId())) {
                        orderItemInfoDto.setLackStockTip("\u63d0\u793a\uff1a\u5f53\u524d\u201c" + placeOrderItemReqDto.getActivityPrice().getActivityName() + "\u201d\u5e93\u5b58\u4ec5\u5269" + lackRemainingStock + "\uff0c\u8d2d\u4e70\u6570\u91cf\u8d85\u51fa\u5e93\u5b58\u5c06\u4e0d\u53c2\u4e0e\u6b64\u6d3b\u52a8\u3002");
                    }
                }
            }
            orderItemInfoDto.setImgPath(imgPath);
            orderItemInfoDto.setAttrs(attrs);
            orderItemInfoDto.setGift(Integer.valueOf(0));
            orderItemInfoDto.setItemName(itemDetailRespDto.getItem().getName());
            orderItemInfoDto.setItemCode(itemDetailRespDto.getItem().getCode());
            orderItemInfoDto.setSubType(placeOrderItemReqDto.getSubType());
            orderItemInfoDto.setStorage(placeOrderItemReqDto.getStorage());
            Integer itemType = placeOrderItemReqDto.getItemType() != null ? placeOrderItemReqDto.getItemType() : ItemTypeEnum.GENERAL.getType();
            orderItemInfoDto.setItemType(itemType);
            Integer busType = placeOrderItemReqDto.getBusType() != null ? placeOrderItemReqDto.getBusType() : ItemBusTypeEnum.ORDINARY.getType();
            orderItemInfoDto.setBusType(busType);
            orderItemInfoDto.setShelfType(ShelfTypeEnum.NORMAL.getType());
            orderItemInfoDto.setRemark(placeOrderItemReqDto.getRemark());
            orderItemInfoDto.setActivityPriceList(placeOrderItemReqDto.getActivityPriceList());
            itemLit.add(orderItemInfoDto);
        }
        if (CollectionUtils.isNotEmpty(combinedPackageItems)) {
            logger.info("\u4e0b\u8ba2\u5355\u9884\u89c8\u7ec4\u5408\u5957\u88c5\u4fe1\u606f-------info,{}", combinedPackageItems);
            Map<Long, List<PlaceOrderItemReqDto>> combinedPackageItemMap = combinedPackageItems.stream().collect(Collectors.groupingBy(e -> e.getActivityId()));
            Map<Long, OrderItemInfoDto> combinedPackageMap = this.combinedPackageInfo(combinedPackageItemMap);
            for (Map.Entry<Long, List<PlaceOrderItemReqDto>> entry : combinedPackageItemMap.entrySet()) {
                itemLit.add(combinedPackageMap.get(entry.getKey()));
            }
        }
        return itemLit;
    }

    private Map<Long, OrderItemInfoDto> combinedPackageInfo(Map<Long, List<PlaceOrderItemReqDto>> map) {
        logger.info("\u4e0b\u8ba2\u5355\u9884\u89c8\u7ec4\u5408\u5957\u88c5Info");
        HashMap<Long, OrderItemInfoDto> resultMap = new HashMap<Long, OrderItemInfoDto>();
        ArrayList<Long> activityIds = new ArrayList<Long>();
        for (Map.Entry<Long, List<PlaceOrderItemReqDto>> entry : map.entrySet()) {
            activityIds.add(entry.getKey());
        }
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityIds(activityIds);
        List activityRespDtos = (List)this.activityQueryApi.queryActivityList(activityDto).getData();
        List conditionRespDtos = this.conditionQueryApi.queryConditions(activityIds, 1196944223312880296L);
        HashMap conditionParamsMap = CollectionUtils.isNotEmpty((Collection)conditionRespDtos) ? conditionRespDtos.stream().collect(Collectors.toMap(e -> e.getActivityId(), e -> e.getConditionParams(), (e1, e2) -> e1)) : new HashMap();
        TcbjInventoryActReqDto tcbjInventoryActReqDto = new TcbjInventoryActReqDto();
        tcbjInventoryActReqDto.setActivityIdList(activityIds);
        List tcbjInventoryActRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.inventoryActQuery(tcbjInventoryActReqDto));
        HashMap inventoryActDetailMap = CollectionUtils.isNotEmpty((Collection)tcbjInventoryActRespDtos) ? tcbjInventoryActRespDtos.stream().collect(Collectors.toMap(e -> e.getActivityId(), e -> e.getDetailRespDtoList())) : new HashMap();
        logger.info("\u7ec4\u5408\u5957\u88c5\u6d3b\u52a8\u5546\u54c1\uff0c\u5e93\u5b58\u67e5\u8be2,{}", (Object)JSONObject.toJSONString((Object)tcbjInventoryActRespDtos));
        List activityRuleItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.activityRuleItemQueryApi.queryActivityRuleItemByActivityIds(activityIds));
        Map<Long, List<ActivityRuleItemRespDto>> activityRuleItemMap = activityRuleItemRespDtos.stream().collect(Collectors.groupingBy(e -> e.getActivityId()));
        if (CollectionUtils.isNotEmpty((Collection)activityRespDtos)) {
            OrderItemInfoDto orderItemInfoDto = null;
            ArrayList combinedPackageItemList = null;
            for (ActivityRespDto dto : activityRespDtos) {
                BigDecimal activitySurplus;
                List<PlaceOrderItemReqDto> placeOrderItemReqDtos = map.get(dto.getId());
                orderItemInfoDto = new OrderItemInfoDto();
                Integer num = placeOrderItemReqDtos.get(0).getCombinedPackageNum() != null ? placeOrderItemReqDtos.get(0).getCombinedPackageNum() : this.getCombinedPackageNum(placeOrderItemReqDtos.get(0));
                placeOrderItemReqDtos.forEach(e -> {
                    e.setShoppingCartItemId(e.getId());
                    e.setItemNum(Integer.valueOf(e.getItemNum() / num));
                });
                orderItemInfoDto.setItemNum(num);
                orderItemInfoDto.setSellPrice(this.getPackagePrice((String)conditionParamsMap.get(dto.getId())));
                orderItemInfoDto.setThresholdType(this.getThresholdType((String)conditionParamsMap.get(dto.getId())));
                orderItemInfoDto.setImgPath(dto.getActivityLogo());
                orderItemInfoDto.setAttrs(this.getCombinedPackageAttrs(placeOrderItemReqDtos));
                orderItemInfoDto.setGift(Integer.valueOf(0));
                orderItemInfoDto.setItemName(dto.getActivityName());
                orderItemInfoDto.setItemCode(dto.getThirdPartyCode());
                orderItemInfoDto.setSubType(SubTypeEnum.PRODUCT.getType());
                Long stock = 0L;
                List tcbjInventoryActDetailRespDtos = null;
                if (inventoryActDetailMap.get(dto.getId()) != null) {
                    tcbjInventoryActDetailRespDtos = (List)inventoryActDetailMap.get(dto.getId());
                }
                List<ActivityRuleItemRespDto> activityRuleItemDtos = activityRuleItemMap.get(dto.getId());
                if (tcbjInventoryActDetailRespDtos != null && (activitySurplus = tcbjInventoryActDetailRespDtos.stream().filter(e -> e.getCargoCode().equals(((ActivityRuleItemRespDto)activityRuleItemDtos.get(0)).getSkuCode())).map(e -> e.getActivitySurplus()).reduce(BigDecimal.ZERO, BigDecimal::add)).intValue() > 0) {
                    stock = activitySurplus.divide(new BigDecimal(activityRuleItemDtos.get(0).getNum())).longValue();
                }
                orderItemInfoDto.setStorage(stock);
                orderItemInfoDto.setItemType(ItemTypeEnum.GENERAL.getType());
                orderItemInfoDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
                orderItemInfoDto.setShelfType(ShelfTypeEnum.NORMAL.getType());
                orderItemInfoDto.setIsCombinedPackage(Integer.valueOf(1));
                combinedPackageItemList = new ArrayList();
                CubeBeanUtils.copyCollection(combinedPackageItemList, placeOrderItemReqDtos, OrderItemInfoDto.class);
                orderItemInfoDto.setCombinedPackageItemList(combinedPackageItemList);
                orderItemInfoDto.setRemark(placeOrderItemReqDtos.get(0).getRemark());
                resultMap.put(dto.getId(), orderItemInfoDto);
            }
        }
        logger.info("\u4e0b\u8ba2\u5355\u9884\u89c8\u8fd4\u56de\u7ec4\u5408\u5957\u88c5Map,{}", (Object)JSONObject.toJSONString(resultMap));
        return resultMap;
    }

    private Integer getCombinedPackageNum(PlaceOrderItemReqDto placeOrderItemReqDto) {
        Integer num = 0;
        ArrayList<Long> activityIds = new ArrayList<Long>();
        activityIds.add(placeOrderItemReqDto.getActivityId());
        RestResponse activityRuleItemRespDtos = this.activityRuleItemQueryApi.queryActivityRuleItemByActivityIds(activityIds);
        if (activityRuleItemRespDtos.getData() != null) {
            for (ActivityRuleItemRespDto datum : (List)activityRuleItemRespDtos.getData()) {
                if (!datum.getItemId().equals(placeOrderItemReqDto.getItemId())) continue;
                num = Math.toIntExact((long)placeOrderItemReqDto.getItemNum().intValue() / datum.getNum());
            }
        }
        return num;
    }

    private Integer getThresholdType(String conditionParams) {
        Integer thresholdType = 0;
        if (conditionParams != null) {
            JSONObject jsonObject = JSON.parseObject((String)conditionParams);
            CombinationRule combinationRule = (CombinationRule)JSON.parseObject((String)jsonObject.getString("CombinationCondition.rule"), CombinationRule.class);
            thresholdType = combinationRule.getThresholdType();
        }
        return thresholdType;
    }

    private Map<String, Object> getCombinedPackageAttrs(List<PlaceOrderItemReqDto> dtoList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int num = 0;
        for (PlaceOrderItemReqDto dto : dtoList) {
            num += dto.getItemNum().intValue();
        }
        map.put(dtoList.size() + "\u79cd," + num + "\u4ef6", "\u5957");
        return map;
    }

    private BigDecimal getPackagePrice(String conditionParams) {
        JSONObject jsonObject;
        CombinationRule combinationRule;
        ComRuleContentDto contents;
        BigDecimal totalPrice = null;
        if (conditionParams != null && Objects.nonNull(contents = (combinationRule = (CombinationRule)JSON.parseObject((String)(jsonObject = JSON.parseObject((String)conditionParams)).getString("CombinationCondition.rule"), CombinationRule.class)).getComRuleContent())) {
            totalPrice = contents.getTotalPrice();
        }
        return totalPrice;
    }

    private List<OrderItemInfoDto> getGiftItems(List<TradeItemRespDto> tradeItemRespDtos, Long customerId) {
        ArrayList giftItems = Lists.newArrayList();
        if (CollectionUtils.isEmpty(tradeItemRespDtos)) {
            return giftItems;
        }
        Map<Long, String> unitNameMap = this.getLongStringMap(tradeItemRespDtos);
        Map<String, List<TradeItemRespDto>> itemMap = tradeItemRespDtos.stream().collect(Collectors.groupingBy(item -> item.getShopId() + "_" + item.getSkuSerial()));
        for (Map.Entry<String, List<TradeItemRespDto>> itemEntryMap : itemMap.entrySet()) {
            String key = itemEntryMap.getKey();
            List<TradeItemRespDto> value = itemEntryMap.getValue();
            int itemNum = 0;
            for (TradeItemRespDto itemRespDto : value) {
                itemNum += itemRespDto.getItemNum().intValue();
            }
            TradeItemRespDto giftItem = value.get(0);
            logger.info("[\u8d60\u54c1\u53d6\u503c],data----:" + JSONObject.toJSONString((Object)giftItem));
            giftItem.setItemNum(Integer.valueOf(itemNum));
            Long itemId = Long.valueOf(giftItem.getItemSerial());
            Long shopId = Long.valueOf(giftItem.getShopId());
            Long skuId = Long.valueOf(giftItem.getSkuSerial());
            String giftSkuIds = giftItem.getGiftSkuIds();
            ShelfReqDto shelfReqDto = new ShelfReqDto();
            shelfReqDto.setShopId(shopId);
            shelfReqDto.setItemId(itemId);
            PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(JSON.toJSONString((Object)shelfReqDto), Integer.valueOf(1), Integer.valueOf(1)).getData();
            if (!PageInfoUtil.isNotEmpty(pageInfo).booleanValue()) continue;
            for (ItemShelfRespDto itemShelfRespDto : pageInfo.getList()) {
                if (!itemShelfRespDto.getSkuId().equals(skuId)) continue;
                Map<Long, ItemDetailRespDto> giftItemDetail = this.commonService.queryItemDetails(Lists.newArrayList((Object[])new Long[]{itemId}), shopId);
                ItemDetailRespDto itemDetailRespDto = giftItemDetail.get(itemId);
                ItemSkuRespDto sku = this.commonService.getItemSkuRespDto(itemShelfRespDto.getSkuId(), itemDetailRespDto);
                OrderItemInfoDto orderItemInfoDto = new OrderItemInfoDto();
                orderItemInfoDto.setAttrs((Map)ObjectHelper.Json2Bean((String)sku.getAttr(), Map.class));
                orderItemInfoDto.setImgPath(this.commonService.getItemImgPath(itemDetailRespDto));
                orderItemInfoDto.setItemName(itemDetailRespDto.getItem().getName());
                orderItemInfoDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
                orderItemInfoDto.setShelfType(ShelfTypeEnum.NORMAL.getType());
                orderItemInfoDto.setSellPrice(BigDecimal.ZERO);
                orderItemInfoDto.setGift(Integer.valueOf(1));
                orderItemInfoDto.setItemNum(giftItem.getItemNum());
                String unitName = unitNameMap.get(Long.valueOf(giftItem.getUnit()));
                orderItemInfoDto.setUnit(giftItem.getUnit());
                orderItemInfoDto.setUnitName(unitName);
                orderItemInfoDto.setSubType(giftItem.getSubType());
                orderItemInfoDto.setSkuId(itemShelfRespDto.getSkuId());
                orderItemInfoDto.setItemId(itemId);
                orderItemInfoDto.setItemName(itemDetailRespDto.getItem().getName());
                orderItemInfoDto.setShopId(shopId);
                orderItemInfoDto.setGiftSkuIds(giftSkuIds);
                orderItemInfoDto.setItemCode(itemDetailRespDto.getItem().getCode());
                BigDecimal onShelfPrice = itemShelfRespDto.getPrice();
                BigDecimal policyPrice = this.priceService.getOrderItemPolicyPrice(orderItemInfoDto, customerId);
                if (policyPrice != null && policyPrice.doubleValue() >= 0.0) {
                    onShelfPrice = policyPrice;
                }
                orderItemInfoDto.setItemOrigPrice(onShelfPrice);
                giftItems.add(orderItemInfoDto);
            }
        }
        return giftItems;
    }

    private Map<Long, String> getLongStringMap(List<TradeItemRespDto> tradeItemRespDtos) {
        HashSet<Long> unitIds = new HashSet<Long>();
        for (TradeItemRespDto tradeItemRespDto : tradeItemRespDtos) {
            if (!StringUtils.isNotEmpty((String)tradeItemRespDto.getUnit())) continue;
            Long aLong = null;
            try {
                aLong = Long.valueOf(tradeItemRespDto.getUnit());
                unitIds.add(aLong);
            }
            catch (Exception e) {
                logger.info("\u8f6c\u5316\u5355\u4f4d\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)tradeItemRespDto.getUnit()));
                logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
            }
        }
        List unitRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitQueryApi.queryByIds(StringUtils.join(unitIds, (String)",")));
        Map<Long, String> unitNameMap = unitRespDtos.stream().collect(Collectors.toMap(UnitRespDto::getId, UnitRespDto::getName, (e1, e2) -> e1));
        return unitNameMap;
    }

    private OrderAddressReqDto getDefaultAddress(Long userId) {
        Long customerId = this.orderService.getCustomerIdByUserId(userId);
        if (Objects.isNull(customerId)) {
            return null;
        }
        RestResponse listRestResponse = this.customerUserQueryApi.queryAddressListByOrgInfoId(customerId);
        List addressDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        if (CollectionUtils.isEmpty((Collection)addressDtos)) {
            return null;
        }
        for (AddressDto addressDto : addressDtos) {
            if (!"1".equals(addressDto.getAddressType()) || addressDto.getStatus() != 1) continue;
            OrderAddressReqDto orderAddressReqDto = new OrderAddressReqDto();
            CubeBeanUtils.copyProperties((Object)orderAddressReqDto, (Object)addressDto, (String[])new String[0]);
            return orderAddressReqDto;
        }
        return null;
    }
}

