/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.util;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.StockTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.ILocalCacheService;
import com.dtyunxi.yundt.module.trade.biz.ISeckillStockService;
import com.dtyunxi.yundt.module.trade.biz.util.KeyGenerator;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SeckillActivityUtil {
    private static final String COMMONC_CACHE_PREFIX = "yundt-cube-center-common-";
    @Value(value="${spring.profiles.active:dev}")
    private String profile;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IItemActivityStockApi itemActivityStockApi;
    @Resource
    private ILocalCacheService localCacheService;
    @Resource
    private ISeckillStockService seckillStockService;

    public void validateItemLimit(Long activityId, Integer itemNum) {
        String pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        String group = COMMONC_CACHE_PREFIX + pfile;
        Integer numLimit = (Integer)this.cacheService.getCache(group, KeyGenerator.getItemLimitKey(activityId), Integer.class);
        if (null == numLimit) {
            return;
        }
        if (numLimit < itemNum) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ACTIVITY_ITEM_LIMIT);
        }
    }

    private Integer getStockType() {
        RestResponse response = this.itemActivityStockApi.queryActivityStockType(null);
        return (Integer)RestResponseHelper.extractData((RestResponse)response);
    }

    public void validateItemStock(Long activityId, Long skuId, Long shopId, Integer itemNum) {
        Integer stockType = this.getStockType();
        if (this.localCacheService.isEmptyStock(activityId, skuId, shopId)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_STOCK_NOT_ENOUGH);
        }
        Long stock = this.seckillStockService.queryStock(activityId, skuId, shopId, ActivityItemTypeEnum.ITEM);
        if (StockTypeEnum.SHARE.getCode().equals(stockType)) {
            if (!(stock != null && stock == -1L || stock != null && stock >= 0L && (long)itemNum.intValue() <= stock)) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_STOCK_NOT_ENOUGH);
            }
        } else if (stock == null || stock < 0L || (long)itemNum.intValue() > stock) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_STOCK_NOT_ENOUGH);
        }
    }
}

