/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.SeckillAcitivityDto;
import com.dtyunxi.yundt.module.trade.biz.ISeckillCacheService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SeckillCacheServiceImpl
implements ISeckillCacheService {
    @Resource
    private ICacheService cacheService;
    @Value(value="${spring.profiles.active:dev}")
    private String profile;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    private static final int overTime = 259200;

    private String getActicityKey(Long activityId) {
        return "seckill_activity:" + activityId;
    }

    @Override
    public void addSeckillActivity(ActivityRespDto activity) {
        SeckillAcitivityDto seckillAcitivityDto = new SeckillAcitivityDto();
        seckillAcitivityDto.setActivity(activity);
        String pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        this.cacheService.setCache("yundt-cube-center-common-" + pfile, this.getActicityKey(activity.getId()), (Object)seckillAcitivityDto, 259200);
    }

    @Override
    public SeckillAcitivityDto getByActivityId(Long activityId) {
        String pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        SeckillAcitivityDto cache = (SeckillAcitivityDto)this.cacheService.getCache("yundt-cube-center-common-" + pfile, this.getActicityKey(activityId), SeckillAcitivityDto.class);
        return cache;
    }
}

