/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.util;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeliveryTypeEnum;
import com.dtyunxi.yundt.module.trade.api.dto.CustomerDeliveryTypeRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.DeliverMethodEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeliveryRuleUtils {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryRuleUtils.class);
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private ISellerExtQueryApi sellerExtQueryApi;

    public boolean isSellerDelivery(Long customerId) {
        logger.info("\u6821\u9a8c\u662f\u5426\u5546\u5bb6\u53d1\u8d27\uff0c\u5c0fb\u5ba2\u6237id\uff1a{}", (Object)customerId);
        return customerId == null || this.isSellerDelivery((CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(customerId)));
    }

    public boolean isSellerDelivery(List<Long> shopIds) {
        logger.info("\u6821\u9a8c\u662f\u5426\u5546\u5bb6\u53d1\u8d27\uff0c\u5e97\u94faid\uff1a{}", shopIds);
        if (CollectionUtils.isEmpty(shopIds)) {
            return true;
        }
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerRespDto(shopIds));
        return CollectionUtils.isEmpty((Collection)customerRespDtos) || this.isSellerDelivery((CustomerRespDto)customerRespDtos.get(0));
    }

    public boolean isSellerDelivery(CustomerRespDto customerRespDto) {
        logger.info("\u6821\u9a8c\u662f\u5426\u5546\u5bb6\u53d1\u8d27\uff0c\u5c0fb\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)customerRespDto));
        return customerRespDto == null || !DeliverMethodEnum.factory.getCode().equals(customerRespDto.getDeliverMethod()) || this.isSellerDelivery((SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(customerRespDto.getMerchantId())), customerRespDto);
    }

    private boolean isSellerDelivery(SellerRespDto sellerRespDto, CustomerRespDto customerRespDto) {
        if (sellerRespDto == null || customerRespDto == null) {
            logger.info("\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u5546\u5bb6\u53d1\u8d27");
            return true;
        }
        return !Integer.valueOf(1).equals(sellerRespDto.getIsFactoryDelivery());
    }

    public List<CustomerDeliveryTypeRespDto> getCurrLoginDelivery(List<Long> customerIds) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(customerIds)) {
            return list;
        }
        for (Long customerId : customerIds) {
            CustomerDeliveryTypeRespDto respDto = new CustomerDeliveryTypeRespDto();
            respDto.setCustomerId(customerId);
            Integer deliveryType = this.isSellerDelivery(customerId) ? OrderDeliveryTypeEnum.SELLER.getType() : OrderDeliveryTypeEnum.FACTORY.getType();
            respDto.setDeliveryType(deliveryType);
            list.add(respDto);
        }
        return list;
    }
}

