/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.pay;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.RefundOrderReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.service.RefundOrderService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.dto.request.SimplePayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.TradePayRespDto;
import com.dtyunxi.yundt.module.trade.biz.pay.AbstractPayHelp;
import com.yx.tcbj.center.rebate.api.IOfflineBalanceBillApi;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceBillReqDto;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillSourceEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillTypeEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBusinessEnum;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settlementPayPayHelp")
public class SettlementPayPayHelp
extends AbstractPayHelp<TradePayRespDto> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContext context;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private IOfflineBalanceBillApi offlineBalanceBillApi;

    @Override
    protected SimplePayReqDto buildResult(SimplePayReqDto request) {
        return request;
    }

    @Override
    public void errorCallBack(SimplePayReqDto simplePayReqDto) {
    }

    @Override
    public void successCallBackDefine(SimplePayReqDto request) {
    }

    @Override
    public boolean allowSubmitOrder(SimplePayReqDto request) {
        return false;
    }

    @Override
    public boolean isPrePayed(SimplePayReqDto simplePayReqDto) {
        return false;
    }

    @Override
    public SimplePayReqDto initParam(Object ... objects) {
        SimplePayReqDto basePayReqDto = new SimplePayReqDto();
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)basePayReqDto);
        }
        this.logger.info("\u521d\u59cb\u53c2\u6570[{}]", (Object)JSON.toJSONString((Object)basePayReqDto));
        return basePayReqDto;
    }

    @Override
    public void customerConfirmRefund(SimplePayReqDto simplePayReqDto) {
        RefundOrderReqDto refundOrderReqDto = new RefundOrderReqDto();
        refundOrderReqDto.setOrderNo(simplePayReqDto.getOrderNo());
        refundOrderReqDto.setReason(simplePayReqDto.getReason());
        refundOrderReqDto.setUserId(this.context.userId());
        refundOrderReqDto.setUserName(this.context.userName());
        refundOrderReqDto.setDate(new Date());
        this.logger.info("\u8ba2\u5355\u72b6\u6001\u88ab\u53d6\u6d88\u5173\u95ed\uff0c\u8c03\u7528\u7ed3\u7b97\u539f\u8def\u9000\u6b3e\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)refundOrderReqDto));
        RestResponseHelper.extractData((RestResponse)this.refundOrderService.refundOrder(refundOrderReqDto));
        if (simplePayReqDto.getRefundAmount() != null && BigDecimal.ZERO.compareTo(simplePayReqDto.getRefundAmount()) < 0) {
            OfflineBalanceBillReqDto billReqDto = new OfflineBalanceBillReqDto();
            billReqDto.setBillDate(new Date());
            billReqDto.setBillType(OfflineBalanceBillTypeEnum.REFUND.getCode());
            billReqDto.setBusinessContent(OfflineBalanceBusinessEnum.BUSINESS_ORDER.getCode());
            billReqDto.setCustomerId(Long.valueOf(simplePayReqDto.getCustomerId()));
            billReqDto.setAmount(simplePayReqDto.getRefundAmount());
            billReqDto.setBillSource(OfflineBalanceBillSourceEnum.ONLINE_PAYMENT.getCode());
            billReqDto.setRelationNo(simplePayReqDto.getOrderNo());
            billReqDto.setReceiptRecordsNo(simplePayReqDto.getPayNo());
            this.logger.info("\u5728\u7ebf\u652f\u4ed8,\u751f\u6210\u5df2\u5ba1\u6838\u9000\u6b3e\u5355{}", (Object)JSON.toJSONString((Object)billReqDto));
            RestResponseHelper.extractData((RestResponse)this.offlineBalanceBillApi.addOfflineBalanceBill(billReqDto));
        }
    }
}

