/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.BrotherCustomerShopRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryActReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryActRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.ITrolleyApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.IfWholeCasePurchaseEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TrolleyItemModReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TrolleyItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TrolleyItemRepDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TrolleyRepDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ITrolleyQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ExchangeActivityTargetDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ItemSkuActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ActivityPriceBranchQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.SupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.ExchangeActivityTargetRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.NotSupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRuleItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityRuleItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IConditionQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityPriceQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityTagQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.ComRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.CombinationRule;
import com.dtyunxi.yundt.module.bitem.api.IBItemPriceService;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.IBshopService;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemDepthQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemStorageQueryDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.StorageBranchQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemActivityPriceRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemInfoRespDto;
import com.dtyunxi.yundt.module.bitem.biz.impl.BItemModuleHelper;
import com.dtyunxi.yundt.module.bitem.biz.price.ItemPriceHelper;
import com.dtyunxi.yundt.module.bitem.biz.util.PageInfoUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ItemActivityInfoRespDto;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.IShoppingCart;
import com.dtyunxi.yundt.module.trade.api.ItemService;
import com.dtyunxi.yundt.module.trade.api.dto.ShoppingCartGroupDto;
import com.dtyunxi.yundt.module.trade.api.dto.ShoppingCartItemExtDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.CartItemBatchReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.CombinedPackageItemReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.ShoppingCartItemReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.TrolleyQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ItemOrderActivityTagDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.MutShoppingCartItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.MutShoppingCartRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ShoppingCartActivityItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ShoppingCartItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ShoppingCartRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.impl.ShoppingCartCommonImpl;
import com.dtyunxi.yundt.module.trade.biz.util.DeliveryRuleUtils;
import com.dtyunxi.yundt.module.trade.biz.vo.BatchAddItemVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.constants.LimitMinModeEnum;
import com.yx.tcbj.center.api.query.ISellerSkuPriceQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;

@Service
public class ShoppingCartImpl
implements IShoppingCart {
    private static Logger logger = LoggerFactory.getLogger(ShoppingCartImpl.class);
    @Resource
    private ITrolleyApi trolleyApi;
    @Resource
    private ITrolleyQueryApi trolleyQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IBitemService bitemService;
    @Resource
    private IItemActivityTagQueryApi itemActivityTagQueryApi;
    @Resource
    private IActivityItemQueryApi activityItemQueryApi;
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IItemActivityPriceQueryApi itemActivityPriceQueryApi;
    @Resource
    private IOrderService orderService;
    @Autowired
    private IBItemPriceService ibItemPriceService;
    @Resource
    private ItemPriceHelper itemPriceHelper;
    @Resource
    private BItemModuleHelper bItemModuleHelper;
    @Resource
    private IBshopService bshopService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private IItemActivityStockApi itemActivityStockApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IActivityRuleItemQueryApi activityRuleItemQueryApi;
    @Resource
    private IConditionQueryApi conditionQueryApi;
    @Resource
    private ISellerSkuPriceQueryApi sellerSkuPriceQueryApi;
    @Resource
    private ItemService itemService;
    @Resource
    private ITcbjInventoryApi tcbjInventoryApi;
    @Autowired
    private ShoppingCartCommonImpl shoppingCartCommonService;
    @Autowired
    private DeliveryRuleUtils deliveryRuleUtils;

    public Long addItem(ShoppingCartItemReqDto shoppingCartItemReqDto) {
        ShopDto shopDto;
        TrolleyRepDto substationCart;
        Boolean enough;
        ItemDetailRespDto itemDetailRespDto;
        Long tenantId = this.context.tenantId();
        Long instanceId = this.context.instanceId();
        Long userId = this.context.userId();
        if (Objects.nonNull(shoppingCartItemReqDto.getUserId())) {
            userId = shoppingCartItemReqDto.getUserId();
        }
        if (null == (itemDetailRespDto = (ItemDetailRespDto)this.itemQueryApi.queryItemDetail(shoppingCartItemReqDto.getItemId(), "sku,medias", null).getData())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_NOT_EXIST);
        }
        if (this.deliveryRuleUtils.isSellerDelivery(Lists.newArrayList((Object[])new Long[]{shoppingCartItemReqDto.getShopId()})) && !(enough = Boolean.valueOf(this.validateStorage(shoppingCartItemReqDto.getShopId(), shoppingCartItemReqDto.getItemId(), shoppingCartItemReqDto.getSkuId(), shoppingCartItemReqDto.getItemNum()))).booleanValue()) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH);
        }
        if (null == (substationCart = this.getUserShoppingCart(userId, shoppingCartItemReqDto.getSubstationId()))) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOPPING_CART_NOT_EXIST);
        }
        if (null == (shopDto = (ShopDto)this.shopQueryApi.queryById(shoppingCartItemReqDto.getShopId().longValue(), new String[0]).getData())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOP_NOT_EXIST);
        }
        TrolleyItemReqDto trolleyItemReqDto = new TrolleyItemReqDto();
        trolleyItemReqDto.setTenantId(tenantId);
        trolleyItemReqDto.setInstanceId(instanceId);
        trolleyItemReqDto.setItemNum(shoppingCartItemReqDto.getItemNum());
        trolleyItemReqDto.setItemName(shoppingCartItemReqDto.getItemName());
        trolleyItemReqDto.setTrolleyId(substationCart.getId());
        trolleyItemReqDto.setItemSrc("icommerceb");
        trolleyItemReqDto.setGroupKey(shoppingCartItemReqDto.getShopId().toString());
        trolleyItemReqDto.setItemSerial(String.valueOf(shoppingCartItemReqDto.getItemId()));
        trolleyItemReqDto.setSkuSerial(String.valueOf(shoppingCartItemReqDto.getSkuId()));
        trolleyItemReqDto.setAddChannel(shoppingCartItemReqDto.getAddChannel());
        trolleyItemReqDto.setType(shopDto.getType() == null ? null : Integer.valueOf(shopDto.getType().intValue()));
        ShoppingCartItemExtDto extension = this.getShoppingCartItemExtDto(itemDetailRespDto, shoppingCartItemReqDto);
        trolleyItemReqDto.setExtension(ObjectHelper.bean2Json((Object)extension));
        RestResponse trolleyItemRepDtoRestResponse = this.trolleyApi.addTrolleyItem(trolleyItemReqDto);
        logger.info("\u65b0\u589e\u8d2d\u7269\u8f66\u9879\u63a5\u53e3\u8fd4\u56de\u53c2\u6570, {}", (Object)trolleyItemRepDtoRestResponse.toString());
        return ((TrolleyItemRepDto)trolleyItemRepDtoRestResponse.getData()).getId();
    }

    public List<String> addItemBatch(CartItemBatchReqDto cartItemBatchReqDto) {
        List cartItemList = cartItemBatchReqDto.getCartItemList();
        ArrayList<String> list = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)cartItemList)) {
            TrolleyRepDto substationCart;
            Long userId;
            ShoppingCartItemReqDto shoppingCartItemReqDto = (ShoppingCartItemReqDto)cartItemList.get(0);
            Long l = userId = Objects.nonNull(cartItemBatchReqDto.getCustomerId()) ? cartItemBatchReqDto.getCustomerId() : (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
            if (Objects.isNull(userId)) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.CUSTOMER_NOT_EXIST);
            }
            if (null == (substationCart = this.getUserShoppingCart(userId, shoppingCartItemReqDto.getSubstationId()))) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOPPING_CART_NOT_EXIST);
            }
            TrolleyItemReqDto reqDto = new TrolleyItemReqDto();
            reqDto.setTrolleyId(substationCart.getId());
            RestResponse listRestResp = this.trolleyQueryApi.queryTrolleyItems(reqDto);
            List trolleyItemRepDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
            if (CollectionUtils.isNotEmpty((Collection)trolleyItemRepDtos)) {
                Integer originTotalNum = trolleyItemRepDtos.stream().filter(dto -> shoppingCartItemReqDto.getItemId().toString().equals(dto.getItemSerial())).map(TrolleyItemRepDto::getItemNum).reduce(Integer::sum).orElse(0);
                Integer currentTotalNum = cartItemList.stream().map(ShoppingCartItemReqDto::getItemNum).reduce(Integer::sum).orElse(0);
                Integer totalNum = originTotalNum + currentTotalNum;
                String itemName = shoppingCartItemReqDto.getItemName();
                if (null != shoppingCartItemReqDto.getWholesaleLimitMin() && totalNum < shoppingCartItemReqDto.getWholesaleLimitMin()) {
                    throw new BizException(TradeModuleExcpCode.BUY_NUM_MIN_NOT_VALID.getCode(), "\u5546\u54c1\uff1a" + itemName + TradeModuleExcpCode.BUY_NUM_MIN_NOT_VALID.getMsg());
                }
                if (null != shoppingCartItemReqDto.getWholesaleLimitMax() && totalNum > shoppingCartItemReqDto.getWholesaleLimitMax()) {
                    throw new BizException(TradeModuleExcpCode.BUY_NUM_MAX_NOT_VALID.getCode(), "\u5546\u54c1\uff1a" + itemName + TradeModuleExcpCode.BUY_NUM_MAX_NOT_VALID.getMsg());
                }
            }
            for (ShoppingCartItemReqDto cartItemReqDto : cartItemList) {
                try {
                    cartItemReqDto.setUserId(userId);
                    list.add(String.valueOf(this.addItem(cartItemReqDto)));
                }
                catch (BizException e) {
                    if (TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH.getCode().equals(e.getCode())) {
                        logger.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    throw e;
                }
            }
        }
        return list;
    }

    public List<String> addItemBatchExt(CartItemBatchReqDto cartItemBatchReqDto) {
        List cartItemList = cartItemBatchReqDto.getCartItemList();
        ArrayList<String> list = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)cartItemList)) {
            TrolleyRepDto substationCart;
            Long userId;
            ShoppingCartItemReqDto shoppingCartItemReqDto = (ShoppingCartItemReqDto)cartItemList.get(0);
            Long l = userId = Objects.nonNull(cartItemBatchReqDto.getCustomerId()) ? cartItemBatchReqDto.getCustomerId() : (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
            if (Objects.isNull(userId)) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.CUSTOMER_NOT_EXIST);
            }
            if (null == (substationCart = this.getUserShoppingCart(userId, shoppingCartItemReqDto.getSubstationId()))) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOPPING_CART_NOT_EXIST);
            }
            TrolleyItemReqDto reqDto = new TrolleyItemReqDto();
            reqDto.setTrolleyId(substationCart.getId());
            RestResponse listRestResp = this.trolleyQueryApi.queryTrolleyItems(reqDto);
            List trolleyItemRepDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
            if (CollectionUtils.isNotEmpty((Collection)trolleyItemRepDtos)) {
                Integer originTotalNum = trolleyItemRepDtos.stream().filter(dto -> shoppingCartItemReqDto.getItemId().toString().equals(dto.getItemSerial())).map(TrolleyItemRepDto::getItemNum).reduce(Integer::sum).orElse(0);
                Integer currentTotalNum = cartItemList.stream().map(ShoppingCartItemReqDto::getItemNum).reduce(Integer::sum).orElse(0);
                Integer totalNum = originTotalNum + currentTotalNum;
                String string = shoppingCartItemReqDto.getItemName();
                if (null != shoppingCartItemReqDto.getWholesaleLimitMin() && totalNum < shoppingCartItemReqDto.getWholesaleLimitMin()) {
                    throw new BizException(TradeModuleExcpCode.BUY_NUM_MIN_NOT_VALID.getCode(), "\u5546\u54c1\uff1a" + string + TradeModuleExcpCode.BUY_NUM_MIN_NOT_VALID.getMsg());
                }
                if (null != shoppingCartItemReqDto.getWholesaleLimitMax() && totalNum > shoppingCartItemReqDto.getWholesaleLimitMax()) {
                    throw new BizException(TradeModuleExcpCode.BUY_NUM_MAX_NOT_VALID.getCode(), "\u5546\u54c1\uff1a" + string + TradeModuleExcpCode.BUY_NUM_MAX_NOT_VALID.getMsg());
                }
            }
            Long customerId = this.getCustomerId(shoppingCartItemReqDto.getShopId());
            ArrayList<Future<Long>> asycList = new ArrayList<Future<Long>>(cartItemList.size());
            for (ShoppingCartItemReqDto shoppingCartItemReqDto2 : cartItemList) {
                shoppingCartItemReqDto2.setUserId(userId);
                shoppingCartItemReqDto2.setCustomerId(customerId);
                Long tenantId = this.context.tenantId();
                Long instanceId = this.context.instanceId();
                String userType = ServiceContext.getContext().getRequestUserType();
                String requestId = ServiceContext.getContext().getRequestId();
                Future<Long> future = this.shoppingCartCommonService.asycAddItem(shoppingCartItemReqDto2, tenantId, instanceId, userId, userType, requestId);
                asycList.add(future);
            }
            for (Future future : asycList) {
                try {
                    if (Objects.equals("0", future.get())) continue;
                    list.add(future.get().toString());
                }
                catch (InterruptedException e) {
                    logger.error("\u52a0\u8d2d\u7269\u8f66\u5931\u8d251{}", (Throwable)e);
                }
                catch (ExecutionException e) {
                    logger.error("\u52a0\u8d2d\u7269\u8f66\u5931\u8d252{}", (Throwable)e);
                }
            }
        }
        return list;
    }

    private Long getCustomerId(Long shopId) {
        String orgId;
        if (shopId == null) {
            return null;
        }
        String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNumeric((CharSequence)customerId)) {
            return Long.valueOf(customerId);
        }
        ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryById(shopId.longValue(), new String[0]));
        if (shopDto != null && StringUtils.isNumeric((CharSequence)(orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid")))) {
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCustomerByOrgAndMerch(Long.valueOf(orgId), shopDto.getOrganizationId()));
            return customerRespDto != null ? customerRespDto.getId() : null;
        }
        return null;
    }

    public List<String> addItemImport(CartItemBatchReqDto cartItemBatchReqDto, Long shopId) {
        TrolleyRepDto substationCart;
        Long userId;
        List cartItemList = cartItemBatchReqDto.getCartItemList();
        if (CollectionUtils.isEmpty((Collection)cartItemList)) {
            return Lists.newArrayList();
        }
        ShoppingCartItemReqDto shoppingCartItemReqDto = (ShoppingCartItemReqDto)cartItemList.get(0);
        Long l = userId = Objects.nonNull(cartItemBatchReqDto.getCustomerId()) ? cartItemBatchReqDto.getCustomerId() : (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        if (Objects.isNull(userId)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.CUSTOMER_NOT_EXIST);
        }
        if (Objects.isNull(userId)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.CUSTOMER_NOT_EXIST);
        }
        if (null == (substationCart = this.getUserShoppingCart(userId, shoppingCartItemReqDto.getSubstationId()))) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOPPING_CART_NOT_EXIST);
        }
        TrolleyItemReqDto reqDto = new TrolleyItemReqDto();
        reqDto.setTrolleyId(substationCart.getId());
        RestResponse listRestResp = this.trolleyQueryApi.queryTrolleyItems(reqDto);
        List trolleyItemRepDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
        if (CollectionUtils.isNotEmpty((Collection)trolleyItemRepDtos)) {
            Integer originTotalNum = trolleyItemRepDtos.stream().filter(dto -> shoppingCartItemReqDto.getItemId().toString().equals(dto.getItemSerial())).map(TrolleyItemRepDto::getItemNum).reduce(Integer::sum).orElse(0);
            Integer currentTotalNum = cartItemList.stream().map(ShoppingCartItemReqDto::getItemNum).reduce(Integer::sum).orElse(0);
            Integer totalNum = originTotalNum + currentTotalNum;
            String itemName = shoppingCartItemReqDto.getItemName();
            if (null != shoppingCartItemReqDto.getWholesaleLimitMin() && totalNum < shoppingCartItemReqDto.getWholesaleLimitMin()) {
                throw new BizException(TradeModuleExcpCode.BUY_NUM_MIN_NOT_VALID.getCode(), "\u5546\u54c1\uff1a" + itemName + TradeModuleExcpCode.BUY_NUM_MIN_NOT_VALID.getMsg());
            }
            if (null != shoppingCartItemReqDto.getWholesaleLimitMax() && totalNum > shoppingCartItemReqDto.getWholesaleLimitMax()) {
                throw new BizException(TradeModuleExcpCode.BUY_NUM_MAX_NOT_VALID.getCode(), "\u5546\u54c1\uff1a" + itemName + TradeModuleExcpCode.BUY_NUM_MAX_NOT_VALID.getMsg());
            }
        }
        Long tenantId = this.context.tenantId();
        Long instanceId = this.context.instanceId();
        String userType = ServiceContext.getContext().getRequestUserType();
        String requestId = ServiceContext.getContext().getRequestId();
        ArrayList batchAddItemVoList = Lists.newArrayList();
        Stream.iterate(0, n -> n + 1).limit(this.getCount(cartItemList.size()).intValue()).forEach(i -> {
            List<ShoppingCartItemReqDto> shopinngCartList = cartItemList.stream().skip((long)i.intValue() * 100L).limit(100L).collect(Collectors.toList());
            Future<BatchAddItemVo> future = this.shoppingCartCommonService.asycAddItemBatch(shopinngCartList, tenantId, instanceId, userId, userType, requestId, shopId);
            try {
                batchAddItemVoList.add(future.get());
            }
            catch (InterruptedException e) {
                logger.error("\u52a0\u8d2d\u7269\u8f66\u6821\u9a8c\u5931\u8d251{}", (Throwable)e);
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.VALIDATION_FAIL);
            }
            catch (ExecutionException e) {
                logger.error("\u52a0\u8d2d\u7269\u8f66\u6821\u9a8c\u5931\u8d252{}", (Throwable)e);
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.VALIDATION_FAIL);
            }
            logger.info("\u52a0\u8d2d\u7269\u8f66\u5f02\u5e38\u8fd4\u56de\u6570\u636e\uff1afuture = {}", future);
        });
        return this.addTrolleyItem(batchAddItemVoList);
    }

    private List<String> addTrolleyItem(List<BatchAddItemVo> batchAddItemVoList) {
        ArrayList list = Lists.newArrayList();
        for (BatchAddItemVo vo : batchAddItemVoList) {
            if (vo.getError().booleanValue()) {
                logger.info("\u52a0\u8d2d\u7269\u8f66\u5931\u8d25[{}], BatchAddItemVo = {}", (Object)vo.getErrorMsg(), (Object)vo);
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.VALIDATION_FAIL);
                continue;
            }
            list.addAll(vo.getTrolleyItemList());
        }
        List trolleyIds = (List)RestResponseHelper.extractData((RestResponse)this.trolleyApi.batchAddTrolleyItem((List)list));
        logger.info("\u65b0\u589e\u8d2d\u7269\u8f66\u9879\u63a5\u53e3\u8fd4\u56de\u53c2\u6570, {}", (Object)trolleyIds.toString());
        return trolleyIds.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
    }

    private Integer getCount(Integer size) {
        return (100 + size - 1) / 100;
    }

    public Future<Long> asycAddItem(ShoppingCartItemReqDto cartItemReqDto) {
        try {
            logger.info("\u5f02\u6b65\u52a0\u8d2d\u7269\u8f66 userId={}, itemId={}", (Object)cartItemReqDto.getUserId(), (Object)cartItemReqDto.getItemId());
            Long id = this.addItem(cartItemReqDto);
            logger.info("\u5f02\u6b65\u52a0\u8d2d\u7269\u8f66\u6210\u529f\uff0cid={}", (Object)id);
            return new AsyncResult((Object)id);
        }
        catch (BizException e) {
            if (TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH.getCode().equals(e.getCode())) {
                logger.error("{}, {}", (Object)TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH.getMsg(), (Object)e);
            } else {
                logger.error("\u52a0\u8d2d\u7269\u8f66\u5931\u8d25{}", (Throwable)e);
            }
            return new AsyncResult((Object)0L);
        }
    }

    public boolean validateStorage(Long shopId, Long itemId, Long skuId, Integer itemNum) {
        Boolean enough = false;
        RestResponse listRestResponse = this.itemSkuQueryApi.queryBySkuId((List)Lists.newArrayList((Object[])new Long[]{skuId}));
        List itemSkuRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>(1);
        ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
        itemStorageQueryDto.setSkuId(skuId);
        itemStorageQueryDto.setShopId(shopId);
        itemStorageQueryDto.setCargoCode(((ItemSkuRespDto)itemSkuRespDtos.get(0)).getCargoCode());
        itemStorageList.add(itemStorageQueryDto);
        storageBranchQueryReqDto.setItemStorageList(itemStorageList);
        List itemStorageQueryDtos = this.bitemService.queryBranchItemStorage(storageBranchQueryReqDto);
        Long storage = ((ItemStorageQueryDto)itemStorageQueryDtos.get(0)).getAvaNum();
        Map<Long, Long> controlStorageMap = this.setStorageValue(shopId, Lists.newArrayList((Object[])new Long[]{itemId}), null);
        storage = storage - controlStorageMap.getOrDefault(itemId, 0L);
        if (storage >= (long)itemNum.intValue()) {
            enough = true;
        }
        return enough;
    }

    private ShoppingCartItemExtDto getShoppingCartItemExtDto(ItemDetailRespDto itemDetailRespDto, ShoppingCartItemReqDto shoppingCartItemReqDto) {
        ShopDto shopDto;
        List skus;
        ShoppingCartItemExtDto shoppingCartItemExtDto = new ShoppingCartItemExtDto();
        String imgPath = null;
        BigDecimal sellPrice = null;
        String attrs = null;
        String shopName = null;
        List medias = itemDetailRespDto.getItemMediasList();
        if (CollectionUtils.isNotEmpty((Collection)medias)) {
            imgPath = medias.stream().findFirst().map(ItemMediasRespDto::getPath1).orElse(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)(skus = itemDetailRespDto.getItemSkuList()))) {
            for (ItemSkuRespDto sku : skus) {
                if (!shoppingCartItemReqDto.getSkuId().equals(sku.getId())) continue;
                List priceList = sku.getItemPriceList();
                if (CollectionUtils.isNotEmpty((Collection)priceList)) {
                    sellPrice = priceList.stream().filter(price -> "\u552e\u4ef7".equals(price.getName())).map(ItemPriceRespDto::getPrice).findFirst().orElse(null);
                }
                attrs = sku.getAttr();
            }
        }
        if ((shopDto = (ShopDto)this.shopQueryApi.queryById(shoppingCartItemReqDto.getShopId().longValue(), new String[0]).getData()) != null) {
            shopName = shopDto.getName();
        }
        shoppingCartItemExtDto.setImgPath(imgPath);
        shoppingCartItemExtDto.setAttrs(attrs);
        shoppingCartItemExtDto.setSellPrice(sellPrice);
        shoppingCartItemExtDto.setShopName(shopName);
        shoppingCartItemExtDto.setBusType(itemDetailRespDto.getItem().getBusType());
        return shoppingCartItemExtDto;
    }

    private TrolleyRepDto getUserShoppingCart(Long userId, String substationId) {
        TrolleyRepDto trolleyRepDto = (TrolleyRepDto)this.trolleyQueryApi.getTrolley(this.context.tenantId(), this.context.instanceId(), "icommerceb", String.valueOf(userId), StringUtils.isBlank((CharSequence)substationId) ? "0" : substationId, Integer.valueOf(1)).getData();
        return trolleyRepDto;
    }

    public void removeItem(String ids) {
        String[] arr;
        if (StringUtils.isBlank((CharSequence)ids)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOPPING_CART_ITEM_NOT_EMPTY);
        }
        for (String id : arr = ids.split(",")) {
            RestResponse restResponse = this.trolleyApi.removeTrolleyItem(Long.valueOf(id));
            RestResponseHelper.extractData((RestResponse)restResponse);
        }
    }

    public void modifyItem(Long id, Integer itemNum) {
        TrolleyItemModReqDto trolleyItem = new TrolleyItemModReqDto();
        trolleyItem.setId(id);
        trolleyItem.setItemNum(itemNum);
        TrolleyItemReqDto reqDto = new TrolleyItemReqDto();
        reqDto.setId(id);
        RestResponse listRestResp = this.trolleyQueryApi.queryTrolleyItems(reqDto);
        List trolleyItemRepDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
        if (CollectionUtils.isNotEmpty((Collection)trolleyItemRepDtos)) {
            TrolleyItemRepDto trolleyItemRepDto = (TrolleyItemRepDto)trolleyItemRepDtos.get(0);
            if (trolleyItemRepDto.getActivityType() == 0) {
                Boolean enough;
                TrolleyItemReqDto itemReqDto = new TrolleyItemReqDto();
                itemReqDto.setTrolleyId(trolleyItemRepDto.getTrolleyId());
                itemReqDto.setItemSerial(trolleyItemRepDto.getItemSerial());
                RestResponse listRestResp2 = this.trolleyQueryApi.queryTrolleyItems(itemReqDto);
                List itemRepDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp2);
                Integer totalNum = 0;
                for (TrolleyItemRepDto itemRepDto : itemRepDtos) {
                    if (itemRepDto.getSkuSerial().equals(trolleyItemRepDto.getSkuSerial())) {
                        totalNum = totalNum + itemNum;
                        continue;
                    }
                    totalNum = totalNum + itemRepDto.getItemNum();
                }
                RestResponse itemRestResp = this.itemQueryApi.queryByItemIds(trolleyItemRepDto.getItemSerial());
                List itemList = (List)RestResponseHelper.extractData((RestResponse)itemRestResp);
                Integer wholesaleLimitMin = null;
                Integer wholesaleLimitMax = null;
                if (StringUtils.isNotEmpty((CharSequence)((ItemRespDto)itemList.get(0)).getWholesaleLimitMin())) {
                    wholesaleLimitMin = Double.valueOf(((ItemRespDto)itemList.get(0)).getWholesaleLimitMin()).intValue();
                }
                if (StringUtils.isNotEmpty((CharSequence)((ItemRespDto)itemList.get(0)).getWholesaleLimitMax())) {
                    wholesaleLimitMax = Double.valueOf(((ItemRespDto)itemList.get(0)).getWholesaleLimitMax()).intValue();
                }
                if (null != wholesaleLimitMin && totalNum < wholesaleLimitMin) {
                    throw new BizException(TradeModuleExcpCode.BUY_NUM_MIN_NOT_VALID.getCode(), "\u5546\u54c1\uff1a" + trolleyItemRepDto.getItemName() + TradeModuleExcpCode.BUY_NUM_MIN_NOT_VALID.getMsg());
                }
                if (null != wholesaleLimitMax && totalNum > wholesaleLimitMax) {
                    throw new BizException(TradeModuleExcpCode.BUY_NUM_MAX_NOT_VALID.getCode(), "\u5546\u54c1\uff1a" + trolleyItemRepDto.getItemName() + TradeModuleExcpCode.BUY_NUM_MAX_NOT_VALID.getMsg());
                }
                Long shopId = Long.valueOf(trolleyItemRepDto.getGroupKey());
                if (this.deliveryRuleUtils.isSellerDelivery(Lists.newArrayList((Object[])new Long[]{shopId})) && !(enough = Boolean.valueOf(this.validateStorage(shopId, Long.valueOf(trolleyItemRepDto.getItemSerial()), Long.valueOf(trolleyItemRepDto.getSkuSerial()), itemNum))).booleanValue()) {
                    BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH);
                }
            } else {
                BigDecimal activitySurplus;
                ArrayList activityIds = Lists.newArrayList();
                activityIds.add(Long.valueOf(trolleyItemRepDto.getItemSerial()));
                List activityRuleItemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.activityRuleItemQueryApi.queryActivityRuleItemByActivityIds((List)activityIds));
                boolean enough = false;
                TcbjInventoryActReqDto tcbjInventoryActReqDto = new TcbjInventoryActReqDto();
                tcbjInventoryActReqDto.setActivityId(Long.valueOf(trolleyItemRepDto.getItemSerial()));
                List tcbjInventoryActRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.inventoryActQuery(tcbjInventoryActReqDto));
                Collection tcbjInventoryActDetailRespDtos = null;
                if (tcbjInventoryActRespDtos != null && ((TcbjInventoryActRespDto)tcbjInventoryActRespDtos.get(0)).getDetailRespDtoList() != null) {
                    tcbjInventoryActDetailRespDtos = ((TcbjInventoryActRespDto)tcbjInventoryActRespDtos.get(0)).getDetailRespDtoList();
                }
                if (CollectionUtils.isNotEmpty(tcbjInventoryActDetailRespDtos) && (activitySurplus = tcbjInventoryActDetailRespDtos.stream().filter(e -> e.getCargoCode().equals(((ActivityRuleItemRespDto)activityRuleItemRespDtoList.get(0)).getSkuCode())).map(e -> e.getActivitySurplus()).reduce(BigDecimal.ZERO, BigDecimal::add)).intValue() > 0) {
                    boolean bl = enough = activitySurplus.compareTo(new BigDecimal(((ActivityRuleItemRespDto)activityRuleItemRespDtoList.get(0)).getNum() * (long)itemNum.intValue())) >= 0;
                }
                if (!enough) {
                    BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ACTIVITY_ITEM_STOCK_LIMIT);
                }
            }
        }
        RestResponse restResponse = this.trolleyApi.modifyTrolleyItem(trolleyItem);
        RestResponseHelper.extractData((RestResponse)restResponse);
    }

    public ShoppingCartRespDto queryUserItemList(TrolleyQueryReqDto trolleyQueryReqDto) {
        ShoppingCartRespDto result = this.queryShoppingCarItemList(trolleyQueryReqDto);
        result = this.filterShoppingCarItemByShop(result);
        return result;
    }

    public ShoppingCartRespDto queryItemList(TrolleyQueryReqDto trolleyQueryReqDto) {
        ShoppingCartRespDto result = this.queryShoppingCarItemList(trolleyQueryReqDto);
        this.setItemPolicyPrice(result.getNormalCartItemList(), trolleyQueryReqDto);
        this.setItemPolicyPrice(result.getLoseCartItemList(), trolleyQueryReqDto);
        this.setCartItemPriceInvalidList(result.getNormalCartItemList(), result);
        this.setItemActivityPrice(result.getNormalCartItemList());
        this.groupByExchangeActivityId(result.getNormalCartItemList(), trolleyQueryReqDto);
        logger.info("\u8bbe\u7f6e\u6362\u8d2d\u6d3b\u52a8\u4fe1\u606f\uff1a{}", (Object)result);
        this.buildTags(result, trolleyQueryReqDto.getCustomerId());
        this.verifySingleBuyItem(result, trolleyQueryReqDto);
        return result;
    }

    private void verifySingleBuyItem(ShoppingCartRespDto result, TrolleyQueryReqDto trolleyQueryReqDto) {
        if (CollectionUtils.isEmpty((Collection)result.getNormalCartItemList())) {
            return;
        }
        List<Object> customerIdList = Lists.newArrayList();
        if (Objects.isNull(trolleyQueryReqDto.getCustomerId())) {
            String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
            if (StringUtils.isNumeric((CharSequence)customerId)) {
                logger.info("\u4e1a\u52a1\u5458\u7aef\uff1a{}", (Object)customerId);
                if (CollectionUtils.isNotEmpty((Collection)trolleyQueryReqDto.getBroCustomerShopRespDtos())) {
                    customerIdList = trolleyQueryReqDto.getBroCustomerShopRespDtos().stream().map(BrotherCustomerShopRespDto::getCustomerId).collect(Collectors.toList());
                }
            } else {
                customerIdList = this.bitemService.getCustomerIdListByUserId(this.context.userId());
            }
        } else {
            customerIdList = Lists.newArrayList((Object[])new Long[]{trolleyQueryReqDto.getCustomerId()});
        }
        List<ShoppingCartItemRespDto> loseCartItemList = CollectionUtils.isNotEmpty((Collection)result.getLoseCartItemList()) ? result.getLoseCartItemList() : Lists.newArrayList();
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds((List)customerIdList));
        ArrayList itemIds = Lists.newArrayList();
        ArrayList shopIds = Lists.newArrayList();
        for (ShoppingCartItemRespDto cartItem : result.getNormalCartItemList()) {
            itemIds.add(cartItem.getItemId());
            shopIds.add(cartItem.getShopId());
        }
        SupportSingleItemDto supportSingleItemDto = new SupportSingleItemDto();
        supportSingleItemDto.setItemIds((List)itemIds);
        supportSingleItemDto.setShopIds((List)shopIds);
        supportSingleItemDto.setCustomerRespDtos(customerRespDtos);
        List notSupportSingleItems = this.bitemService.getNotSupportSingleItem(supportSingleItemDto);
        Map<String, NotSupportSingleItemDto> notSupportSingleItemDtoMap = notSupportSingleItems.stream().collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getItemId(), e -> e, (e1, e2) -> e1));
        Iterator iterator = result.getNormalCartItemList().iterator();
        while (iterator.hasNext()) {
            ShoppingCartItemRespDto next = (ShoppingCartItemRespDto)iterator.next();
            if (!notSupportSingleItemDtoMap.containsKey(next.getShopId() + "_" + next.getItemId())) continue;
            next.setStatus(Integer.valueOf(0));
            next.setLoseType(Integer.valueOf(4));
            loseCartItemList.add(next);
            iterator.remove();
        }
        result.setLoseCartItemList((List)loseCartItemList);
    }

    private void setExchangeActivityId(List<ShoppingCartItemRespDto> normalCartItemList) {
        if (CollectionUtils.isEmpty(normalCartItemList)) {
            return;
        }
        HashMap shopDtoMap = Maps.newHashMap();
        List customerRespDtos = Lists.newArrayList();
        Set shopIds = normalCartItemList.stream().map(ShoppingCartItemRespDto::getShopId).collect(Collectors.toSet());
        List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(shopIds));
        ArrayList merchantIds = Lists.newArrayList();
        for (ShopDto shopDto : shopDtos) {
            merchantIds.add(shopDto.getOrganizationId());
            shopDtoMap.put(shopDto.getId(), shopDto);
        }
        String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNumeric((CharSequence)customerId)) {
            logger.info("\u4e1a\u52a1\u5458\u7aef\uff1a{}", (Object)customerId);
            customerRespDtos.add(RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(Long.valueOf(customerId))));
        } else {
            logger.info("h5\u7aef");
            String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
            customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds((List)merchantIds, Long.valueOf(orgId)));
        }
        logger.info("\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)customerRespDtos));
        ExchangeActivityTargetDto exchangeActivityTargetDto = new ExchangeActivityTargetDto();
        exchangeActivityTargetDto.setCustomerRespDtos(customerRespDtos);
        exchangeActivityTargetDto.setActivityTemplateId(Long.valueOf(BizActivityType.EXCHANGE_ACTIVITY.getId()));
        HashMap map = Maps.newHashMap();
        for (ShoppingCartItemRespDto normalCartItem : normalCartItemList) {
            ItemSkuDto itemSkuDto = new ItemSkuDto();
            itemSkuDto.setShopId(normalCartItem.getShopId());
            itemSkuDto.setItemId(normalCartItem.getItemId());
            itemSkuDto.setSkuId(normalCartItem.getSkuId());
            if (shopDtoMap.containsKey(normalCartItem.getShopId())) {
                ShopDto shopDto = (ShopDto)shopDtoMap.get(normalCartItem.getShopId());
                itemSkuDto.setShopOrgId(shopDto.getOrganizationId());
            }
            if (map.containsKey(normalCartItem.getShopId())) {
                ((List)map.get(normalCartItem.getShopId())).add(itemSkuDto);
                continue;
            }
            map.put(normalCartItem.getShopId(), Lists.newArrayList((Object[])new ItemSkuDto[]{itemSkuDto}));
        }
        exchangeActivityTargetDto.setShopSkuIds((Map)map);
        logger.info("\u67e5\u8be2\u6362\u8d2d\u6d3b\u52a8\u5206\u7ec4\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)exchangeActivityTargetDto));
        List exchangeTargetRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityStockApi.validateExchangeActivityTarget(exchangeActivityTargetDto));
        logger.info("\u6362\u8d2d\u6d3b\u52a8\u5206\u7ec4\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)exchangeTargetRespDtos));
        Map<String, ExchangeActivityTargetRespDto> exchangeMap = exchangeTargetRespDtos.stream().collect(Collectors.toMap(e -> e.getShopId() + "#" + e.getSkuId(), e -> e, (e1, e2) -> e1));
        for (ShoppingCartItemRespDto shoppingCartItemRespDto : normalCartItemList) {
            String key = shoppingCartItemRespDto.getShopId() + "#" + shoppingCartItemRespDto.getSkuId();
            if (!exchangeMap.containsKey(key)) continue;
            ExchangeActivityTargetRespDto exchangeRespDto = exchangeMap.get(key);
            shoppingCartItemRespDto.setActivityId(exchangeRespDto.getActivityId());
            shoppingCartItemRespDto.setActivityName(exchangeRespDto.getActivityName());
            shoppingCartItemRespDto.setActivityTag(exchangeRespDto.getActivityTag());
        }
    }

    private void groupByExchangeActivityId(List<ShoppingCartItemRespDto> normalCartItemList, TrolleyQueryReqDto trolleyQueryReqDto) {
        List shoppingCartGroupDtos = trolleyQueryReqDto.getShoppingCartGroupDtos();
        if (CollectionUtils.isEmpty(normalCartItemList) || CollectionUtils.isEmpty((Collection)shoppingCartGroupDtos)) {
            return;
        }
        HashMap shopDtoMap = Maps.newHashMap();
        List customerRespDtos = Lists.newArrayList();
        Set shopIds = normalCartItemList.stream().map(ShoppingCartItemRespDto::getShopId).collect(Collectors.toSet());
        List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(shopIds));
        ArrayList merchantIds = Lists.newArrayList();
        for (ShopDto shopDto : shopDtos) {
            merchantIds.add(shopDto.getOrganizationId());
            shopDtoMap.put(shopDto.getId(), shopDto);
        }
        String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNumeric((CharSequence)customerId)) {
            logger.info("\u4e1a\u52a1\u5458\u7aef\uff1a{}", (Object)customerId);
            if (CollectionUtils.isNotEmpty((Collection)trolleyQueryReqDto.getBroCustomerShopRespDtos())) {
                List customerIds = trolleyQueryReqDto.getBroCustomerShopRespDtos().stream().map(BrotherCustomerShopRespDto::getCustomerId).collect(Collectors.toList());
                customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customerIds));
            }
        } else {
            logger.info("h5\u7aef");
            String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
            customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds((List)merchantIds, Long.valueOf(orgId)));
        }
        logger.info("\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)customerRespDtos);
        ExchangeActivityTargetDto exchangeActivityTargetDto = new ExchangeActivityTargetDto();
        exchangeActivityTargetDto.setCustomerRespDtos(customerRespDtos);
        exchangeActivityTargetDto.setActivityTemplateId(Long.valueOf(BizActivityType.EXCHANGE_ACTIVITY.getId()));
        HashMap map = Maps.newHashMap();
        for (ShoppingCartItemRespDto normalCartItem : normalCartItemList) {
            ItemSkuDto itemSkuDto = new ItemSkuDto();
            itemSkuDto.setShopId(normalCartItem.getShopId());
            itemSkuDto.setItemId(normalCartItem.getItemId());
            itemSkuDto.setSkuId(normalCartItem.getSkuId());
            if (shopDtoMap.containsKey(normalCartItem.getShopId())) {
                ShopDto shopDto = (ShopDto)shopDtoMap.get(normalCartItem.getShopId());
                itemSkuDto.setShopOrgId(shopDto.getOrganizationId());
            }
            if (map.containsKey(normalCartItem.getShopId())) {
                ((List)map.get(normalCartItem.getShopId())).add(itemSkuDto);
                continue;
            }
            map.put(normalCartItem.getShopId(), Lists.newArrayList((Object[])new ItemSkuDto[]{itemSkuDto}));
        }
        exchangeActivityTargetDto.setShopSkuIds((Map)map);
        logger.info("\u67e5\u8be2\u6362\u8d2d\u6d3b\u52a8\u5206\u7ec4\u5165\u53c2\uff1a{}", (Object)exchangeActivityTargetDto);
        List exchangeTargetRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityStockApi.validateExchangeActivityList(exchangeActivityTargetDto));
        logger.info("\u6362\u8d2d\u6d3b\u52a8\u5206\u7ec4\u4fe1\u606f\uff1a{}", (Object)exchangeTargetRespDtos);
        Map<String, ExchangeActivityTargetRespDto> exchangeMap = exchangeTargetRespDtos.stream().collect(Collectors.toMap(e -> e.getShopId() + "#" + e.getSkuId() + "#" + e.getActivityId(), e -> e, (e1, e2) -> e1));
        Map<Long, ShoppingCartGroupDto> groupMap = shoppingCartGroupDtos.stream().collect(Collectors.toMap(ShoppingCartGroupDto::getShopId, e -> e, (e1, e2) -> e1));
        for (ShoppingCartItemRespDto shoppingCartItemRespDto : normalCartItemList) {
            ShoppingCartGroupDto cartGroupDto = groupMap.get(shoppingCartItemRespDto.getShopId());
            if (cartGroupDto == null || !CollectionUtils.isNotEmpty((Collection)cartGroupDto.getActivityIds())) continue;
            ExchangeActivityTargetRespDto exchangeRespDto = null;
            for (Long activityId : cartGroupDto.getActivityIds()) {
                String key = shoppingCartItemRespDto.getShopId() + "#" + shoppingCartItemRespDto.getSkuId() + "#" + activityId;
                if (!exchangeMap.containsKey(key)) continue;
                exchangeRespDto = exchangeMap.get(key);
                break;
            }
            if (exchangeRespDto == null) continue;
            shoppingCartItemRespDto.setActivityId(exchangeRespDto.getActivityId());
            shoppingCartItemRespDto.setActivityName(exchangeRespDto.getActivityName());
            shoppingCartItemRespDto.setActivityTag(exchangeRespDto.getActivityTag());
        }
    }

    private ShoppingCartRespDto queryShoppingCarItemList(TrolleyQueryReqDto trolleyQueryReqDto) {
        TrolleyRepDto userTrolley;
        ShoppingCartRespDto result = new ShoppingCartRespDto();
        String substationId = null;
        if (null == trolleyQueryReqDto || null == trolleyQueryReqDto.getSubstationId()) {
            substationId = "0";
        }
        ArrayList itemList = Lists.newArrayList();
        Long userId = Objects.nonNull(trolleyQueryReqDto.getCustomerId()) ? trolleyQueryReqDto.getCustomerId() : (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        if (Objects.isNull(userId)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.CUSTOMER_NOT_EXIST);
        }
        if (null == (userTrolley = this.getUserShoppingCart(userId, substationId))) {
            return result;
        }
        ArrayList allTrolleyItems = Lists.newArrayList();
        TrolleyItemReqDto trolleyItemReqDto = new TrolleyItemReqDto();
        trolleyItemReqDto.setType(trolleyQueryReqDto.getType());
        trolleyItemReqDto.setTrolleyId(userTrolley.getId());
        List list = (List)this.trolleyQueryApi.queryTrolleyItems(trolleyItemReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return result;
        }
        ArrayList trolleyItemRepDtoList = Lists.newArrayList();
        HashSet<Long> itemIdList = new HashSet<Long>();
        HashSet<Long> shopIdList = new HashSet<Long>();
        for (TrolleyItemRepDto trolleyItem : list) {
            if (Integer.valueOf(1).equals(trolleyItem.getActivityType())) {
                trolleyItemRepDtoList.add(trolleyItem);
            }
            itemIdList.add(Long.valueOf(trolleyItem.getItemSerial()));
            shopIdList.add(Long.valueOf(trolleyItem.getGroupKey()));
        }
        if (CollectionUtils.isNotEmpty((Collection)trolleyItemRepDtoList)) {
            result.setTrolleyItemRepDtoList((List)trolleyItemRepDtoList);
        }
        logger.info("\u7ec4\u5408\u5957\u88c5\u4fe1\u606f\uff0c{}", (Object)trolleyItemRepDtoList);
        ItemSearchRespDto itemSearchRespDto = this.queryItemESByItemIdsAndShopIds(itemIdList, shopIdList);
        logger.info("[\u8d2d\u7269\u8f66\u5217\u8868]es\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)itemSearchRespDto));
        if (null == itemSearchRespDto || !PageInfoUtil.isNotEmpty((PageInfo)itemSearchRespDto.getPageInfo())) {
            logger.info("\u672a\u7b5b\u9009\u51fa\u6709\u6548\u641c\u7d22\u6761\u4ef6");
            return result;
        }
        List itemRespDtos = itemSearchRespDto.getPageInfo().getList();
        Map itemMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getItemId, Function.identity(), (o1, o2) -> o2));
        ArrayList itemShelfRespDtos = Lists.newArrayList();
        HashMap skuMap = Maps.newHashMap();
        HashSet itemIds = Sets.newHashSet();
        HashMap<Long, Integer> subTypeMap = new HashMap<Long, Integer>();
        for (ItemRespDto itemRespDto : itemRespDtos) {
            if (CollectionUtils.isNotEmpty((Collection)itemRespDto.getItemShelfInfoList())) {
                itemShelfRespDtos.addAll(itemRespDto.getItemShelfInfoList());
            }
            if (itemIds.add(itemRespDto.getItemId())) {
                subTypeMap.put(itemRespDto.getItemId(), itemRespDto.getSubType());
            }
            if (!CollectionUtils.isNotEmpty((Collection)itemRespDto.getItemSkuList())) continue;
            ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)itemRespDto.getItemSkuList().get(0);
            skuMap.put(itemRespDto.getShopId() + "_" + itemSkuRespDto.getId(), itemSkuRespDto);
        }
        Map<String, ItemShelfRespDto> itemShelfMap = itemShelfRespDtos.stream().collect(Collectors.toMap(item -> item.getShopId() + item.getSkuId().toString(), item -> item, (e1, e2) -> e1));
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>();
        HashSet shopIds = Sets.newHashSet();
        HashMap<Long, List> shopSkuMap = new HashMap<Long, List>();
        for (TrolleyItemRepDto trolleyItemRepDto : list) {
            List shopItemIdList;
            if (trolleyItemRepDto.getActivityType() != 0) continue;
            Long itemId = Long.valueOf(trolleyItemRepDto.getItemSerial());
            Long skuId = Long.valueOf(trolleyItemRepDto.getSkuSerial());
            Long shopId = Long.valueOf(trolleyItemRepDto.getGroupKey());
            shopIds.add(shopId);
            ItemSkuRespDto skuRespDto = (ItemSkuRespDto)skuMap.get(shopId + "_" + skuId);
            ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
            itemStorageQueryDto.setSkuId(skuId);
            itemStorageQueryDto.setShopId(shopId);
            itemStorageQueryDto.setCargoCode(skuRespDto != null ? skuRespDto.getCargoCode() : "");
            itemStorageList.add(itemStorageQueryDto);
            if (shopSkuMap.containsKey(shopId)) {
                shopItemIdList = (List)shopSkuMap.get(shopId);
                if (shopItemIdList.contains(itemId)) continue;
                shopItemIdList.add(itemId);
                continue;
            }
            shopItemIdList = Lists.newArrayList((Object[])new Long[]{itemId});
            shopSkuMap.put(shopId, shopItemIdList);
        }
        storageBranchQueryReqDto.setCustomerId(trolleyQueryReqDto.getCustomerId());
        storageBranchQueryReqDto.setItemStorageList(itemStorageList);
        List itemStorageQueryDtos = this.bitemService.queryBranchItemStorage(storageBranchQueryReqDto);
        Map<String, Long> avaNumMap = itemStorageQueryDtos.stream().collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getSkuId() + "_" + e.getCargoCode(), e -> Optional.of(e).map(ItemStorageQueryDto::getAvaNum).orElse(0L), (o1, o2) -> o1));
        HashMap<Long, Map<Long, Long>> itemStorageMap = new HashMap<Long, Map<Long, Long>>();
        logger.info("\u5e97\u94fa\u5bf9\u5e94skuIdMap={}", (Object)JSON.toJSONString(shopSkuMap));
        if (!shopSkuMap.isEmpty()) {
            Map brotherCustomerShopRespDtoMap = trolleyQueryReqDto.getBroCustomerShopRespDtos().stream().collect(Collectors.toMap(BrotherCustomerShopRespDto::getId, Function.identity()));
            for (Long shopId : shopSkuMap.keySet()) {
                Map<Long, Long> itemIdToInventoryMap = this.setStorageValue(shopId, (List)shopSkuMap.get(shopId), (BrotherCustomerShopRespDto)brotherCustomerShopRespDtoMap.get(shopId));
                if (itemIdToInventoryMap.isEmpty()) {
                    logger.info("\u5e97\u94fa\u5bf9\u5e94sku\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7");
                    continue;
                }
                itemStorageMap.put(shopId, itemIdToInventoryMap);
            }
        }
        List shopList = (List)this.shopQueryApi.queryByIds((Set)shopIds).getData();
        logger.info("[\u8d2d\u7269\u8f66\u5217\u8868]sku\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)skuMap));
        for (TrolleyItemRepDto trolleyItemRepDto : list) {
            if (trolleyItemRepDto.getActivityType() != 0) continue;
            ShoppingCartItemRespDto shoppingCartItemRespDto = this.convertToShoppingCartItemRespDto(trolleyItemRepDto, itemShelfMap, skuMap, avaNumMap, shopList, itemStorageMap);
            shoppingCartItemRespDto.setSubType((Integer)subTypeMap.get(Long.valueOf(trolleyItemRepDto.getItemSerial())));
            if (itemMap.containsKey(shoppingCartItemRespDto.getItemId())) {
                shoppingCartItemRespDto.setItemCode(((ItemRespDto)itemMap.get(shoppingCartItemRespDto.getItemId())).getCode());
            }
            itemList.add(shoppingCartItemRespDto);
        }
        this.calculateLimitMinPurchase(itemList, shopList, userId);
        this.setCartItemList(itemList, result, shopIds, trolleyQueryReqDto.getBroCustomerShopRespDtos());
        return result;
    }

    private ShoppingCartRespDto filterShoppingCarItemByShopExt(ShoppingCartRespDto shoppingCartRespDto, TrolleyQueryReqDto trolleyQueryReqDto) {
        if (shoppingCartRespDto == null) {
            return null;
        }
        ArrayList customerIds = Lists.newArrayList();
        List<Long> shopIds = new ArrayList<Long>();
        String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNumeric((CharSequence)customerId)) {
            List broCustomerShopRespDtos = trolleyQueryReqDto.getBroCustomerShopRespDtos();
            if (CollectionUtils.isEmpty((Collection)broCustomerShopRespDtos)) {
                broCustomerShopRespDtos = this.bshopService.queryBrotherCustomerShop();
            }
            for (BrotherCustomerShopRespDto broShop : broCustomerShopRespDtos) {
                shopIds.add(broShop.getId());
                customerIds.add(broShop.getCustomerId());
            }
        } else {
            List shopDtos = this.bshopService.customerShop();
            if (CollectionUtils.isNotEmpty((Collection)shopDtos)) {
                shopIds = shopDtos.stream().map(ShopDto::getId).collect(Collectors.toList());
            }
        }
        return this.getShoppingCartRespDto(shoppingCartRespDto, shopIds, customerIds);
    }

    private ShoppingCartRespDto filterShoppingCarItemByShop(ShoppingCartRespDto shoppingCartRespDto) {
        if (shoppingCartRespDto == null) {
            return null;
        }
        List<Long> shopIds = new ArrayList<Long>();
        List shopDtos = this.bshopService.customerShop();
        if (CollectionUtils.isNotEmpty((Collection)shopDtos)) {
            shopIds = shopDtos.stream().map(ShopDto::getId).collect(Collectors.toList());
        }
        return this.getShoppingCartRespDto(shoppingCartRespDto, shopIds, Lists.newArrayList());
    }

    private ShoppingCartRespDto getShoppingCartRespDto(ShoppingCartRespDto shoppingCartRespDto, List<Long> shopIds, List<Long> customerIds) {
        ArrayList itemList;
        if (!CollectionUtils.isEmpty((Collection)shoppingCartRespDto.getNormalCartItemList())) {
            itemList = Lists.newArrayList();
            for (ShoppingCartItemRespDto shoppingCartItemRespDto : shoppingCartRespDto.getNormalCartItemList()) {
                if (!shopIds.contains(shoppingCartItemRespDto.getShopId())) continue;
                itemList.add(shoppingCartItemRespDto);
            }
            shoppingCartRespDto.setNormalCartItemList((List)itemList);
        }
        if (!CollectionUtils.isEmpty((Collection)shoppingCartRespDto.getLoseCartItemList())) {
            itemList = Lists.newArrayList();
            for (ShoppingCartItemRespDto shoppingCartItemRespDto : shoppingCartRespDto.getLoseCartItemList()) {
                if (!shopIds.contains(shoppingCartItemRespDto.getShopId())) continue;
                itemList.add(shoppingCartItemRespDto);
            }
            shoppingCartRespDto.setLoseCartItemList((List)itemList);
        }
        if (!CollectionUtils.isEmpty((Collection)shoppingCartRespDto.getTrolleyItemRepDtoList())) {
            ArrayList trolleyItemList = Lists.newArrayList();
            for (TrolleyItemRepDto trolleyItemRepDto : shoppingCartRespDto.getTrolleyItemRepDtoList()) {
                if (!shopIds.contains(Long.valueOf(trolleyItemRepDto.getGroupKey()))) continue;
                trolleyItemList.add(trolleyItemRepDto);
            }
            logger.info("\u7ec4\u5408\u5957\u88c5setCombinedPackageItemSize,{}", (Object)trolleyItemList.size());
            if (CollectionUtils.isNotEmpty((Collection)trolleyItemList)) {
                this.setCombinedPackageItem(trolleyItemList, shoppingCartRespDto, customerIds);
            }
        }
        return shoppingCartRespDto;
    }

    private Map<String, ItemRespDto> queryItemEsShelf(Map<Long, ShoppingCartItemRespDto> map) {
        HashMap<String, ItemRespDto> shelfItemMap = new HashMap<String, ItemRespDto>();
        HashSet<Long> itemIdList = new HashSet<Long>();
        HashSet<Long> shopIdList = new HashSet<Long>();
        for (Map.Entry<Long, ShoppingCartItemRespDto> entry : map.entrySet()) {
            List list = entry.getValue().getCombinedPackageItemList();
            list.forEach(e -> {
                itemIdList.add(e.getItemId());
                shopIdList.add(e.getShopId());
            });
        }
        ItemSearchRespDto itemSearchRespDto = this.queryItemESByItemIdsAndShopIds(itemIdList, shopIdList);
        logger.info("ES\u67e5\u8be2\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u4e0a\u67b6\u4fe1\u606f\uff0c{}", (Object)JSONObject.toJSONString((Object)itemSearchRespDto));
        if (null != itemSearchRespDto && itemSearchRespDto.getPageInfo() != null && CollectionUtils.isNotEmpty((Collection)itemSearchRespDto.getPageInfo().getList())) {
            for (ItemRespDto itemRespDto : itemSearchRespDto.getPageInfo().getList()) {
                ItemShelfRespDto itemShelfRespDto;
                if (!CollectionUtils.isNotEmpty((Collection)itemRespDto.getItemShelfInfoList()) || (itemShelfRespDto = (ItemShelfRespDto)itemRespDto.getItemShelfInfoList().get(0)).getStatus() != 1) continue;
                shelfItemMap.put(itemRespDto.getShopId() + "-" + itemRespDto.getItemId(), itemRespDto);
            }
        }
        return shelfItemMap;
    }

    private void setCombinedPackageItem(List<TrolleyItemRepDto> trolleyItemRepDtos, ShoppingCartRespDto shoppingCartRespDto, List<Long> customerIds) {
        ArrayList itemList;
        logger.info("\u7ec4\u5408\u5957\u88c5");
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityIds(trolleyItemRepDtos.stream().map(e -> Long.valueOf(e.getSkuSerial())).collect(Collectors.toList()));
        List activityRespDtos = (List)this.activityQueryApi.queryActivityList(activityDto).getData();
        if (CollectionUtils.isEmpty((Collection)activityRespDtos)) {
            return;
        }
        Map<Long, ShoppingCartItemRespDto> map = this.combinedPackageInfo(activityRespDtos, trolleyItemRepDtos, customerIds);
        Map<String, ItemRespDto> shelfItemMap = this.queryItemEsShelf(map);
        ArrayList normalCartItemList = Lists.newArrayList();
        ArrayList loseCartItemList = Lists.newArrayList();
        for (ActivityRespDto activityRespDto : activityRespDtos) {
            ShoppingCartItemRespDto shoppingCartItemRespDto = map.get(activityRespDto.getId());
            if (ActivityStatusEnum.ACTIVATE.getKey().equals(activityRespDto.getActivityStatus()) && shoppingCartItemRespDto.getStorage() > 0L) {
                boolean isVaild = true;
                for (ShoppingCartItemRespDto cartItemRespDto : shoppingCartItemRespDto.getCombinedPackageItemList()) {
                    ItemRespDto itemRespDto = shelfItemMap.get(cartItemRespDto.getShopId() + "-" + cartItemRespDto.getItemId());
                    if (itemRespDto == null) {
                        isVaild = false;
                        continue;
                    }
                    List itemSkuList = itemRespDto.getItemSkuList();
                    if (CollectionUtils.isNotEmpty((Collection)itemSkuList)) {
                        cartItemRespDto.setUnit(((ItemSkuRespDto)itemSkuList.get(0)).getUnit());
                    }
                    if (null != cartItemRespDto.getSellPrice()) continue;
                    isVaild = false;
                }
                if (isVaild) {
                    normalCartItemList.add(shoppingCartItemRespDto);
                    continue;
                }
                loseCartItemList.add(shoppingCartItemRespDto);
                continue;
            }
            loseCartItemList.add(shoppingCartItemRespDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)normalCartItemList)) {
            logger.info("\u6709\u6548\u7ec4\u5408\u5957\u88c5,{}", (Object)normalCartItemList);
            if (CollectionUtils.isNotEmpty((Collection)shoppingCartRespDto.getNormalCartItemList())) {
                shoppingCartRespDto.getNormalCartItemList().addAll(normalCartItemList);
            } else {
                itemList = Lists.newArrayList();
                itemList.addAll(normalCartItemList);
                shoppingCartRespDto.setNormalCartItemList((List)itemList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)loseCartItemList)) {
            logger.info("\u5931\u6548\u7ec4\u5408\u5957\u88c5,{}", (Object)loseCartItemList);
            if (CollectionUtils.isNotEmpty((Collection)shoppingCartRespDto.getLoseCartItemList())) {
                shoppingCartRespDto.getLoseCartItemList().addAll(loseCartItemList);
            } else {
                itemList = Lists.newArrayList();
                itemList.addAll(loseCartItemList);
                shoppingCartRespDto.setLoseCartItemList((List)itemList);
            }
        }
    }

    private Map<Long, ShoppingCartItemRespDto> combinedPackageInfo(List<ActivityRespDto> activityRespDtos, List<TrolleyItemRepDto> trolleyItemRepDtos, List<Long> customerIds) {
        Map<String, TrolleyItemRepDto> trolleyItemMap = trolleyItemRepDtos.stream().collect(Collectors.toMap(e -> e.getSkuSerial(), e -> e, (e1, e2) -> e1));
        HashMap<Long, ShoppingCartItemRespDto> map = new HashMap<Long, ShoppingCartItemRespDto>();
        List activityIds = activityRespDtos.stream().map(e -> e.getId()).collect(Collectors.toList());
        List conditionRespDtos = this.conditionQueryApi.queryConditions(activityIds, 1196944223312880296L);
        HashMap conditionParamsMap = CollectionUtils.isNotEmpty((Collection)conditionRespDtos) ? conditionRespDtos.stream().collect(Collectors.toMap(e -> e.getActivityId(), e -> e.getConditionParams(), (e1, e2) -> e1)) : new HashMap();
        ShoppingCartItemRespDto shoppingCartItemRespDto = null;
        for (ActivityRespDto activityRespDto : activityRespDtos) {
            TrolleyItemRepDto trolleyItemRepDto = trolleyItemMap.get(activityRespDto.getId().toString());
            shoppingCartItemRespDto = new ShoppingCartItemRespDto();
            shoppingCartItemRespDto.setId(trolleyItemRepDto.getId());
            shoppingCartItemRespDto.setItemName(activityRespDto.getActivityName());
            shoppingCartItemRespDto.setActivityName(activityRespDto.getActivityName());
            shoppingCartItemRespDto.setItemNum(trolleyItemRepDto.getItemNum());
            shoppingCartItemRespDto.setShopId(Long.valueOf(trolleyItemRepDto.getGroupKey()));
            shoppingCartItemRespDto.setImgPath(activityRespDto.getActivityLogo());
            shoppingCartItemRespDto.setItemCode(activityRespDto.getRemark());
            shoppingCartItemRespDto.setSellPrice(this.getPackagePrice((String)conditionParamsMap.get(activityRespDto.getId())));
            shoppingCartItemRespDto.setThresholdType(this.getThresholdType((String)conditionParamsMap.get(activityRespDto.getId())));
            shoppingCartItemRespDto.setActivityTag("\u7ec4\u5408\u5957\u88c5");
            shoppingCartItemRespDto.setAddChannel(trolleyItemRepDto.getAddChannel());
            shoppingCartItemRespDto.setIsCombinedPackage(Integer.valueOf(1));
            map.put(activityRespDto.getId(), shoppingCartItemRespDto);
        }
        if (MapUtils.isNotEmpty(map)) {
            this.combinedPackageItemInfo(map, customerIds);
        }
        return map;
    }

    private void combinedPackageItemInfo(Map<Long, ShoppingCartItemRespDto> map, List<Long> customerIds) {
        logger.info("\u7ec4\u88c5\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u4fe1\u606f");
        ArrayList<Long> activityIds = new ArrayList<Long>();
        for (Map.Entry<Long, ShoppingCartItemRespDto> entry : map.entrySet()) {
            activityIds.add(entry.getKey());
        }
        TcbjInventoryActReqDto tcbjInventoryActReqDto = new TcbjInventoryActReqDto();
        tcbjInventoryActReqDto.setActivityIdList(activityIds);
        List tcbjInventoryActRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.inventoryActQuery(tcbjInventoryActReqDto));
        HashMap inventoryActMap = CollectionUtils.isNotEmpty((Collection)tcbjInventoryActRespDtos) ? tcbjInventoryActRespDtos.stream().collect(Collectors.toMap(e -> e.getActivityId(), e -> e.getDetailRespDtoList())) : new HashMap();
        List activityRuleItemRespDtoList = (List)this.activityRuleItemQueryApi.queryActivityRuleItemByActivityIds(activityIds).getData();
        if (CollectionUtils.isNotEmpty((Collection)activityRuleItemRespDtoList)) {
            Map<Long, List<ActivityRuleItemRespDto>> itemMap = activityRuleItemRespDtoList.stream().collect(Collectors.groupingBy(e -> e.getActivityId()));
            for (Map.Entry<Long, ShoppingCartItemRespDto> entry : map.entrySet()) {
                ShoppingCartItemRespDto shoppingCartItemRespDto = entry.getValue();
                List<ActivityRuleItemRespDto> activityRuleItemRespDtos = itemMap.get(entry.getKey());
                List tcbjInventoryActDetailRespDtos = null;
                if (inventoryActMap.get(entry.getKey()) != null) {
                    tcbjInventoryActDetailRespDtos = (List)inventoryActMap.get(entry.getKey());
                }
                Long stock = 0L;
                this.activityRuleItemInfo(activityRuleItemRespDtos, customerIds);
                ArrayList combinedPackageItemList = Lists.newArrayList();
                ShoppingCartItemRespDto combinedPackageItem = null;
                for (ActivityRuleItemRespDto dto : activityRuleItemRespDtos) {
                    BigDecimal activitySurplus;
                    combinedPackageItem = new ShoppingCartItemRespDto();
                    combinedPackageItem.setItemId(dto.getItemId());
                    combinedPackageItem.setItemName(dto.getItemName());
                    combinedPackageItem.setItemCode(dto.getItemCode());
                    combinedPackageItem.setItemNum(Integer.valueOf(Math.toIntExact(dto.getNum())));
                    combinedPackageItem.setSkuId(dto.getSkuId());
                    combinedPackageItem.setSkuCode(dto.getSkuCode());
                    combinedPackageItem.setCargoCode(dto.getSkuCode());
                    combinedPackageItem.setShopId(dto.getShopId());
                    combinedPackageItem.setActivityId(dto.getActivityId());
                    combinedPackageItem.setImgPath(dto.getImgPath());
                    combinedPackageItem.setStorage(null);
                    combinedPackageItem.setSellPrice(dto.getSellPrice());
                    combinedPackageItem.setPackageUnitPrice(dto.getPrice());
                    combinedPackageItem.setAddChannel(shoppingCartItemRespDto.getAddChannel());
                    combinedPackageItem.setStatus(Integer.valueOf(1));
                    combinedPackageItem.setBusType(Integer.valueOf(0));
                    combinedPackageItem.setSubType(dto.getSubType());
                    combinedPackageItem.setIsCombinedPackage(Integer.valueOf(1));
                    combinedPackageItem.setId(shoppingCartItemRespDto.getId());
                    combinedPackageItem.setAttrs((Map)JSON.parseObject((String)dto.getAttr()));
                    combinedPackageItemList.add(combinedPackageItem);
                    if (!CollectionUtils.isNotEmpty((Collection)tcbjInventoryActDetailRespDtos) || (activitySurplus = tcbjInventoryActDetailRespDtos.stream().filter(e -> e.getCargoCode().equals(dto.getSkuCode())).map(e -> e.getActivitySurplus()).reduce(BigDecimal.ZERO, BigDecimal::add)).intValue() <= 0) continue;
                    stock = activitySurplus.divide(new BigDecimal(dto.getNum())).longValue();
                }
                shoppingCartItemRespDto.setStorage(stock);
                shoppingCartItemRespDto.setAttrs(this.setCombinedPackageAttrs(activityRuleItemRespDtos));
                shoppingCartItemRespDto.setShopName(activityRuleItemRespDtos.get(0).getShopName());
                shoppingCartItemRespDto.setCombinedPackageItemList((List)combinedPackageItemList);
            }
        }
        logger.info("\u6700\u7ec8\u7ec4\u88c5\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u4fe1\u606f\uff0c{}", map);
    }

    private void activityRuleItemInfo(List<ActivityRuleItemRespDto> list, List<Long> customerIds) {
        List itemIdList = list.stream().map(e -> e.getItemId()).collect(Collectors.toList());
        Map<Long, Long> itemNumMap = list.stream().collect(Collectors.toMap(e -> e.getItemId(), e -> e.getNum()));
        String itemIds = itemIdList.stream().map(e -> e.toString()).collect(Collectors.joining(","));
        ItemDepthQueryReqDto itemDepthReqDto = new ItemDepthQueryReqDto();
        itemDepthReqDto.setShopId(list.get(0).getShopId());
        if (CollectionUtils.isNotEmpty(customerIds)) {
            itemDepthReqDto.setCustomerIdList(customerIds);
        }
        itemDepthReqDto.setItemIds(itemIds);
        PageInfo itemInfoRespDtoPageInfo = this.bitemService.queryItemPageDepth(itemDepthReqDto, Integer.valueOf(1), Integer.valueOf(itemIdList.size()));
        if (itemInfoRespDtoPageInfo == null || CollectionUtils.isEmpty((Collection)itemInfoRespDtoPageInfo.getList())) {
            logger.info("\u4e0a\u67b6\u5546\u54c1\u641c\u7d22\u63a5\u53e3\u4e3a\u7a7a");
            return;
        }
        List itemInfoRespList = itemInfoRespDtoPageInfo.getList();
        itemInfoRespList.forEach(itemInfo -> ((ItemSkuRespDto)itemInfo.getItemSkuList().get(0)).setShoppingCartItemNum(Integer.valueOf(Math.toIntExact((Long)itemNumMap.get(itemInfo.getItemId())))));
        logger.info("\u8bbe\u7f6e\u8d2d\u7269\u8f66\u7ec4\u5408\u5957\u88c5\u7684\u4ef7\u683c\u524d,{}", (Object)JSONObject.toJSONString((Object)itemInfoRespList));
        HashMap<Long, BigDecimal> priceMap = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty((Collection)itemInfoRespList)) {
            this.bitemService.setItemPolicyPriceInfo(itemInfoRespList);
            for (ItemInfoRespDto itemInfoRespDto : itemInfoRespList) {
                if (null != ((ItemSkuRespDto)itemInfoRespDto.getItemSkuList().get(0)).getPrice()) {
                    priceMap.put(itemInfoRespDto.getItemId(), ((ItemSkuRespDto)itemInfoRespDto.getItemSkuList().get(0)).getPrice());
                    continue;
                }
                if (null == itemInfoRespDto.getSellPrice()) continue;
                priceMap.put(itemInfoRespDto.getItemId(), itemInfoRespDto.getSellPrice());
            }
            logger.info("\u8bbe\u7f6e\u8d2d\u7269\u8f66\u7ec4\u5408\u5957\u88c5\u7684\u4ef7\u683c\u540e,{}", (Object)JSONObject.toJSONString((Object)itemInfoRespList));
        }
        Map itemMediasMap = (Map)this.itemQueryApi.queryItemMediasByItemIds(itemIdList).getData();
        for (ActivityRuleItemRespDto dto : list) {
            dto.setSellPrice((BigDecimal)priceMap.get(dto.getItemId()));
            dto.setImgPath((String)itemMediasMap.get(dto.getItemId()));
        }
    }

    private Map<String, Object> setCombinedPackageAttrs(List<ActivityRuleItemRespDto> dtoList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int num = 0;
        for (ActivityRuleItemRespDto dto : dtoList) {
            num = (int)((long)num + dto.getNum());
        }
        map.put(dtoList.size() + "\u79cd," + num + "\u4ef6", "\u5957");
        return map;
    }

    private void buildTags(ShoppingCartRespDto result, Long customerId) {
        if (result == null || CollectionUtils.isEmpty((Collection)result.getNormalCartItemList())) {
            return;
        }
        List collectItemInfoRespDto = result.getNormalCartItemList().stream().map(data -> {
            ItemInfoRespDto newData = new ItemInfoRespDto();
            BeanUtil.copyProperties((Object)data, (Object)newData, (String[])new String[0]);
            return newData;
        }).collect(Collectors.toList());
        List itemTags = this.bitemService.getItemTags(collectItemInfoRespDto, customerId);
        Map itemTagGroup = itemTags.stream().collect(Collectors.groupingBy(itemInfoRespDto -> itemInfoRespDto.getItemId() + "-" + itemInfoRespDto.getShopId(), Collectors.toList()));
        Iterator iterator = result.getNormalCartItemList().iterator();
        while (iterator.hasNext()) {
            ShoppingCartItemRespDto shoppingCartItemRespDto;
            List itemInfoRespDtos = itemTagGroup.get((shoppingCartItemRespDto = (ShoppingCartItemRespDto)iterator.next()).getItemId() + "-" + shoppingCartItemRespDto.getShopId());
            shoppingCartItemRespDto.setTags(!CollectionUtils.isEmpty(itemInfoRespDtos) ? ((ItemInfoRespDto)itemInfoRespDtos.get(0)).getTags() : null);
        }
    }

    public MutShoppingCartRespDto queryMutItemList(TrolleyQueryReqDto trolleyQueryReqDto) {
        ShoppingCartRespDto shoppingCartRespDto = this.queryItemList(trolleyQueryReqDto);
        shoppingCartRespDto = this.filterShoppingCarItemByShopExt(shoppingCartRespDto, trolleyQueryReqDto);
        MutShoppingCartRespDto mutShoppingCartRespDto = new MutShoppingCartRespDto();
        BeanUtil.copyProperties((Object)shoppingCartRespDto, (Object)mutShoppingCartRespDto, (String[])new String[0]);
        Map group = (CollectionUtils.isEmpty((Collection)shoppingCartRespDto.getNormalCartItemList()) ? new ArrayList() : shoppingCartRespDto.getNormalCartItemList()).stream().collect(Collectors.groupingBy(ShoppingCartItemRespDto::getShopId, Collectors.toList()));
        ArrayList<MutShoppingCartItemRespDto> list = new ArrayList<MutShoppingCartItemRespDto>();
        for (Map.Entry longListEntry : group.entrySet()) {
            Object shoppingCartItemRespDto2;
            HashMap exchangeActivityMap = Maps.newHashMap();
            for (Object shoppingCartItemRespDto2 : longListEntry.getValue()) {
                if (exchangeActivityMap.containsKey(shoppingCartItemRespDto2.getActivityId())) {
                    ((List)exchangeActivityMap.get(shoppingCartItemRespDto2.getActivityId())).add(shoppingCartItemRespDto2);
                    continue;
                }
                exchangeActivityMap.put(shoppingCartItemRespDto2.getActivityId(), Lists.newArrayList((Object[])new ShoppingCartItemRespDto[]{shoppingCartItemRespDto2}));
            }
            ArrayList activity = Lists.newArrayList();
            shoppingCartItemRespDto2 = exchangeActivityMap.entrySet().iterator();
            while (shoppingCartItemRespDto2.hasNext()) {
                Map.Entry entry = (Map.Entry)shoppingCartItemRespDto2.next();
                ShoppingCartActivityItemRespDto activityItemRespDto = new ShoppingCartActivityItemRespDto();
                activityItemRespDto.setActivityId(((ShoppingCartItemRespDto)((List)entry.getValue()).get(0)).getActivityId());
                activityItemRespDto.setActivityName(((ShoppingCartItemRespDto)((List)entry.getValue()).get(0)).getActivityName());
                activityItemRespDto.setActivityTag(((ShoppingCartItemRespDto)((List)entry.getValue()).get(0)).getActivityTag());
                activityItemRespDto.setShoppingCartItemRespDtos((List)entry.getValue());
                activity.add(activityItemRespDto);
            }
            MutShoppingCartItemRespDto newMutShoppingCartItemRespDto = new MutShoppingCartItemRespDto();
            newMutShoppingCartItemRespDto.setShopId(((ShoppingCartItemRespDto)longListEntry.getValue().get(0)).getShopId());
            newMutShoppingCartItemRespDto.setShopName(((ShoppingCartItemRespDto)longListEntry.getValue().get(0)).getShopName());
            newMutShoppingCartItemRespDto.setNormalCartItemListForActivity((List)activity);
            list.add(newMutShoppingCartItemRespDto);
        }
        mutShoppingCartRespDto.setNormalCartItemListForShop(list);
        return mutShoppingCartRespDto;
    }

    private Map<Long, Long> setStorageValue(Long shopId, List<Long> itemIds, BrotherCustomerShopRespDto brotherCustomerShopRespDto) {
        logger.info("\u8d2d\u7269\u8f66\u5546\u54c1\u5217\u8868\u8bbe\u7f6e\u5b89\u5168\u5e93\u5e93\u5b58");
        Long customerId = null;
        if (brotherCustomerShopRespDto != null) {
            customerId = brotherCustomerShopRespDto.getCustomerId();
        } else {
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerRespDto(Collections.singletonList(shopId)));
            if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                customerId = ((CustomerRespDto)customerRespDtos.get(0)).getId();
            }
        }
        if (null != customerId) {
            return this.itemService.checkControlRule(itemIds, customerId);
        }
        return new HashMap<Long, Long>();
    }

    private void setItemPolicyPrice(List<ShoppingCartItemRespDto> normalCartItemList, TrolleyQueryReqDto trolleyQueryReqDto) {
        if (CollectionUtils.isEmpty(normalCartItemList)) {
            return;
        }
        List<Object> customerIdList = Lists.newArrayList();
        if (Objects.isNull(trolleyQueryReqDto.getCustomerId())) {
            String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
            if (StringUtils.isNumeric((CharSequence)customerId)) {
                logger.info("\u4e1a\u52a1\u5458\u7aef\uff1a{}", (Object)customerId);
                if (CollectionUtils.isNotEmpty((Collection)trolleyQueryReqDto.getBroCustomerShopRespDtos())) {
                    customerIdList = trolleyQueryReqDto.getBroCustomerShopRespDtos().stream().map(BrotherCustomerShopRespDto::getCustomerId).collect(Collectors.toList());
                }
            } else {
                customerIdList = this.bitemService.getCustomerIdListByUserId(this.context.userId());
            }
        } else {
            customerIdList = Lists.newArrayList((Object[])new Long[]{trolleyQueryReqDto.getCustomerId()});
        }
        try {
            CommunalPriceQueryReqDto reqDto = new CommunalPriceQueryReqDto();
            reqDto.setCustomerIds((List)customerIdList);
            reqDto.setPolicyDate(new Date());
            ArrayList skuPriceReqDtoList = new ArrayList();
            normalCartItemList.forEach(cartItemInfo -> {
                CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                skuPriceReqDto.setSkuId(cartItemInfo.getSkuId());
                skuPriceReqDto.setItemId(cartItemInfo.getItemId());
                skuPriceReqDto.setShopId(cartItemInfo.getShopId());
                skuPriceReqDto.setSkuSellPrice(cartItemInfo.getSellPrice());
                skuPriceReqDtoList.add(skuPriceReqDto);
            });
            reqDto.setSkuList(skuPriceReqDtoList);
            List itemSkuPolicyPriceRespDtos = (List)this.ibItemPriceService.getItemPrice(reqDto).getData();
            if (!CollectionUtils.isEmpty((Collection)itemSkuPolicyPriceRespDtos)) {
                logger.info("\u5ba2\u6237id\u5217\u8868\u4e3a:{}\uff0c\u4ef7\u683c\u5217\u8868\u4e3a:{}", (Object)JSONObject.toJSONString((Object)customerIdList), (Object)JSONObject.toJSONString((Object)itemSkuPolicyPriceRespDtos));
                if (CollectionUtils.isNotEmpty((Collection)customerIdList) && customerIdList.size() > 1) {
                    Map<String, ItemPolicyPriceRespDto> policyMap = itemSkuPolicyPriceRespDtos.stream().collect(Collectors.toMap(e -> e.getShopId() + ":" + e.getSkuId(), e -> e, (e1, e2) -> e1));
                    normalCartItemList.forEach(cartItemInfo -> {
                        ItemPolicyPriceRespDto skuPolicyPrice = (ItemPolicyPriceRespDto)policyMap.get(cartItemInfo.getShopId() + ":" + cartItemInfo.getSkuId());
                        cartItemInfo.setItemSkuPolicyPrice(skuPolicyPrice);
                        if (Objects.nonNull(skuPolicyPrice)) {
                            BigDecimal defaultMatchPrice = this.itemPriceHelper.getDefaultMatchPrice(skuPolicyPrice, cartItemInfo.getItemNum());
                            cartItemInfo.setSellPrice(defaultMatchPrice);
                        }
                    });
                } else {
                    normalCartItemList.forEach(cartItemInfo -> {
                        ItemPolicyPriceRespDto skuPolicyPrice = itemSkuPolicyPriceRespDtos.stream().filter(e -> Objects.equals(cartItemInfo.getShopId(), e.getShopId()) && e.getSkuId().equals(cartItemInfo.getSkuId())).findFirst().orElse(null);
                        cartItemInfo.setItemSkuPolicyPrice(skuPolicyPrice);
                        if (Objects.nonNull(skuPolicyPrice)) {
                            BigDecimal defaultMatchPrice = this.itemPriceHelper.getDefaultMatchPrice(skuPolicyPrice, cartItemInfo.getItemNum());
                            cartItemInfo.setSellPrice(defaultMatchPrice);
                        }
                    });
                }
            }
        }
        catch (Exception e3) {
            logger.error("\u5ba2\u6237{}\u67e5\u8be2\u4ef7\u683c\u4e2d\u5fc3\u653f\u7b56\u4ef7\u5f02\u5e38\uff1a{}", (Object)customerIdList, (Object)e3.getMessage());
        }
    }

    public Integer queryItemListNum(TrolleyQueryReqDto trolleyQueryReqDto) {
        ShoppingCartRespDto result = this.queryShoppingCarItemList(trolleyQueryReqDto);
        if ((result = this.filterShoppingCarItemByShopExt(result, trolleyQueryReqDto)) != null && result.getNormalCartItemList() != null) {
            return result.getNormalCartItemList().size();
        }
        return 0;
    }

    public ItemSearchRespDto queryItemESByItemIdsAndShopIds(Set<Long> itemIdList, Set<Long> shopIdList) {
        ItemSearchQueryReqDto itemSearchQueryReqDto = new ItemSearchQueryReqDto();
        itemSearchQueryReqDto.setInstanceId(this.context.instanceId());
        itemSearchQueryReqDto.setTenantId(this.context.tenantId());
        itemSearchQueryReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        itemSearchQueryReqDto.setItemIds((List)Lists.newArrayList(itemIdList));
        itemSearchQueryReqDto.setShopIds((List)Lists.newArrayList(shopIdList));
        itemSearchQueryReqDto.setIsOffShelf(Boolean.valueOf(false));
        ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemByDirIdDepth(itemSearchQueryReqDto, Integer.valueOf(1), Integer.valueOf(itemIdList.size() * shopIdList.size())));
        return itemSearchRespDto;
    }

    private void setCartItemList(List<ShoppingCartItemRespDto> cartItems, ShoppingCartRespDto shoppingCartRespDto, Set<Long> shopIds, List<BrotherCustomerShopRespDto> broCustomerShopRespDtos) {
        Map brotherShopMap = broCustomerShopRespDtos.stream().collect(Collectors.toMap(BrotherCustomerShopRespDto::getId, Function.identity()));
        HashMap map = Maps.newHashMap();
        for (Long shopId : shopIds) {
            boolean isSellerDelivery = brotherShopMap.containsKey(shopId) ? this.deliveryRuleUtils.isSellerDelivery(((BrotherCustomerShopRespDto)brotherShopMap.get(shopId)).getCustomerId()) : this.deliveryRuleUtils.isSellerDelivery(Lists.newArrayList((Object[])new Long[]{shopId}));
            map.put(shopId, isSellerDelivery);
        }
        ArrayList normalCartItemList = Lists.newArrayList();
        ArrayList loseCartItemList = Lists.newArrayList();
        for (ShoppingCartItemRespDto cartItem : cartItems) {
            if (cartItem.getStatus() == null || cartItem.getStatus() == 0) {
                cartItem.setLoseType(Integer.valueOf(1));
                loseCartItemList.add(cartItem);
                continue;
            }
            Boolean isSellerDelivery = (Boolean)map.get(cartItem.getShopId());
            cartItem.setDeliveryType(isSellerDelivery != false ? OrderDeliveryTypeEnum.SELLER.getType() : OrderDeliveryTypeEnum.FACTORY.getType());
            if (!(isSellerDelivery != null && !isSellerDelivery.booleanValue() || cartItem.getStorage() != null && cartItem.getStorage() > 0L && cartItem.getStorage().compareTo(cartItem.getItemNum() != null ? cartItem.getItemNum().longValue() : new Long(0L).longValue()) >= 0 && cartItem.getStorage().compareTo(cartItem.getLimitMinPurchaseNum().longValue()) >= 0)) {
                cartItem.setLoseType(Integer.valueOf(2));
                loseCartItemList.add(cartItem);
                continue;
            }
            normalCartItemList.add(cartItem);
        }
        shoppingCartRespDto.setNormalCartItemList((List)normalCartItemList);
        shoppingCartRespDto.setLoseCartItemList((List)loseCartItemList);
    }

    private void setCartItemPriceInvalidList(List<ShoppingCartItemRespDto> cartItems, ShoppingCartRespDto shoppingCartRespDto) {
        ArrayList normalCartItemList = Lists.newArrayList();
        List loseCartItemList = shoppingCartRespDto.getLoseCartItemList();
        List list = loseCartItemList = CollectionUtils.isEmpty((Collection)loseCartItemList) ? Lists.newArrayList() : loseCartItemList;
        if (CollectionUtils.isEmpty(cartItems)) {
            return;
        }
        for (ShoppingCartItemRespDto cartItem : cartItems) {
            if (cartItem.getItemSkuPolicyPrice() == null || cartItem.getSellPrice() == null) {
                cartItem.setLoseType(Integer.valueOf(3));
                loseCartItemList.add(cartItem);
                continue;
            }
            normalCartItemList.add(cartItem);
        }
        shoppingCartRespDto.setNormalCartItemList((List)normalCartItemList);
        shoppingCartRespDto.setLoseCartItemList(loseCartItemList);
    }

    private void setItemActivityPrice(List<ShoppingCartItemRespDto> cartItems) {
        if (CollectionUtils.isEmpty(cartItems)) {
            return;
        }
        Set shopIds = cartItems.stream().map(ShoppingCartItemRespDto::getShopId).collect(Collectors.toSet());
        HashMap<Long, Long> customerIdMap = new HashMap<Long, Long>();
        Map map = this.bshopService.queryCustomerInfoByShopIds(shopIds);
        for (Long shopId : map.keySet()) {
            customerIdMap.put(shopId, ((CustomerInfoDto)map.get(shopId)).getCustomerId());
        }
        ArrayList skuActivityPriceDtos = Lists.newArrayList();
        for (ShoppingCartItemRespDto cartItem : cartItems) {
            ItemSkuActivityPriceDto skuActivityPriceDto = new ItemSkuActivityPriceDto();
            skuActivityPriceDto.setItemId(cartItem.getItemId());
            skuActivityPriceDto.setSkuId(cartItem.getSkuId());
            skuActivityPriceDto.setShopId(cartItem.getShopId());
            skuActivityPriceDto.setCustomerId((Long)customerIdMap.get(cartItem.getShopId()));
            skuActivityPriceDto.setSellPrice(cartItem.getSellPrice());
            skuActivityPriceDtos.add(skuActivityPriceDto);
        }
        ActivityPriceBranchQueryReqDto branchQueryReqDto = new ActivityPriceBranchQueryReqDto();
        branchQueryReqDto.setItemSkuActivityPriceList((List)skuActivityPriceDtos);
        branchQueryReqDto.setFilterSecKill(Boolean.valueOf(true));
        branchQueryReqDto.setFilterNotBegin(Boolean.valueOf(true));
        List itemSkuActivityPriceDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityStockApi.queryBranchItemSkuActivityPrice(branchQueryReqDto));
        Map<String, List<ItemSkuActivityPriceDto>> priceMaps = itemSkuActivityPriceDtos.stream().collect(Collectors.groupingBy(priceDto -> priceDto.getShopId() + priceDto.getSkuId().toString()));
        for (ShoppingCartItemRespDto cartItemRespDto : cartItems) {
            String key = cartItemRespDto.getShopId() + cartItemRespDto.getSkuId().toString();
            if (!priceMaps.containsKey(key)) continue;
            ArrayList activityPriceList = Lists.newArrayList();
            for (ItemSkuActivityPriceDto priceDto2 : priceMaps.get(key)) {
                if (Objects.isNull(priceDto2.getActivityId())) continue;
                ActivityType type = ActivityType.getByType((Long)priceDto2.getActivityTemplateId());
                ItemActivityPriceRespDto priceRespDto = new ItemActivityPriceRespDto();
                priceRespDto.setActivityId(priceDto2.getActivityId());
                priceRespDto.setActivityName(priceDto2.getActivityTag());
                priceRespDto.setActivityType(type);
                priceRespDto.setSkuId(priceDto2.getSkuId());
                priceRespDto.setItemId(priceDto2.getItemId());
                priceRespDto.setActivityPrice(priceDto2.getActivityPrice());
                priceRespDto.setShopId(priceDto2.getShopId());
                priceRespDto.setPromotionMethod(priceDto2.getPromotionMethod());
                priceRespDto.setDiscount(priceDto2.getDiscount());
                activityPriceList.add(priceRespDto);
            }
            cartItemRespDto.setActivityPriceList((List)activityPriceList);
        }
    }

    private Map<Long, List<ItemActivityTagDto>> queryTags(List<Long> itemIds) {
        Map<Object, Object> itemTagsMap = Maps.newHashMap();
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setDimensionList((List)Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.ITEM.getKey()}));
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setTenantId(this.context.tenantId());
        queryReqDto.setItemIdList(itemIds);
        queryReqDto.setPreheatStartTime(new Date());
        List tags = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)tags)) {
            return itemTagsMap;
        }
        itemTagsMap = tags.stream().collect(Collectors.groupingBy(ItemActivityTagDto::getItemId));
        return itemTagsMap;
    }

    private ItemActivityPriceRespDto getItemActivityPriceRespDto(Long skuId, ItemActivityTagDto tagDto) {
        ActivityItemQueryReqDto itemQueryReqDto = new ActivityItemQueryReqDto();
        Long activityId = tagDto.getActivityId();
        itemQueryReqDto.setActivityId(activityId);
        itemQueryReqDto.setSkuId(skuId);
        List activityItems = (List)this.activityItemQueryApi.queryAll(itemQueryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)activityItems)) {
            return null;
        }
        try {
            ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(activityId.longValue()).getData();
            if (activityRespDto.getActivityTemplateId().equals(ActivityType.GROUP_ACTIVITY.getId())) {
                return null;
            }
            ActivityItemRespDto activityItemRespDto = (ActivityItemRespDto)activityItems.get(0);
            ItemActivityPriceRespDto itemActivityPriceRespDto = new ItemActivityPriceRespDto();
            itemActivityPriceRespDto.setSkuId(skuId);
            itemActivityPriceRespDto.setActivityPrice(activityItemRespDto.getActivityPrice());
            itemActivityPriceRespDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
            itemActivityPriceRespDto.setActivityId(activityRespDto.getId());
            return itemActivityPriceRespDto;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private ShoppingCartItemRespDto convertToShoppingCartItemRespDto(TrolleyItemRepDto trolleyItemRepDto, Map<String, ItemShelfRespDto> itemShelfMap, Map<String, ItemSkuRespDto> skuMap, Map<String, Long> avaNumMap, List<ShopDto> shopList, Map<Long, Map<Long, Long>> itemStorageMap) {
        logger.info("\u5e97\u94fa\u5bf9\u5e94itemStorageMap={}", (Object)JSON.toJSONString(itemStorageMap));
        ShoppingCartItemExtDto shoppingCartItemExtDto = (ShoppingCartItemExtDto)ObjectHelper.Json2Bean((String)trolleyItemRepDto.getExtension(), ShoppingCartItemExtDto.class);
        Long itemId = Long.valueOf(trolleyItemRepDto.getItemSerial());
        Long skuId = Long.valueOf(trolleyItemRepDto.getSkuSerial());
        Long shopId = Long.valueOf(trolleyItemRepDto.getGroupKey());
        ItemSkuRespDto skuRespDto = skuMap.get(shopId + "_" + skuId);
        ShoppingCartItemRespDto shoppingCartItemRespDto = new ShoppingCartItemRespDto();
        shoppingCartItemRespDto.setId(trolleyItemRepDto.getId());
        shoppingCartItemRespDto.setItemId(itemId);
        shoppingCartItemRespDto.setSkuId(skuId);
        shoppingCartItemRespDto.setShopId(shopId);
        shoppingCartItemRespDto.setItemNum(trolleyItemRepDto.getItemNum());
        shoppingCartItemRespDto.setAddChannel(trolleyItemRepDto.getAddChannel());
        shoppingCartItemRespDto.setItemName(trolleyItemRepDto.getItemName());
        shoppingCartItemRespDto.setType(trolleyItemRepDto.getType());
        if (Objects.nonNull(skuRespDto)) {
            Long inventory;
            Object skuStorageMap;
            shoppingCartItemRespDto.setMinPackage(skuRespDto.getMinPackage());
            shoppingCartItemRespDto.setUnit(skuRespDto.getUnit());
            shoppingCartItemRespDto.setSkuCode(skuRespDto.getCode());
            shoppingCartItemRespDto.setCargoCode(skuRespDto.getCargoCode());
            Long storage = avaNumMap.get(shopId + "_" + skuId + "_" + skuRespDto.getCargoCode());
            shoppingCartItemRespDto.setStorage(storage);
            if (!itemStorageMap.isEmpty() && itemStorageMap.containsKey(shopId) && (skuStorageMap = itemStorageMap.get(shopId)) != null && !skuStorageMap.isEmpty() && skuStorageMap.containsKey(itemId) && null != (inventory = (Long)skuStorageMap.get(itemId))) {
                logger.info("\u8bbe\u7f6e\u5b89\u5168\u5e93\u5b58\uff0citem={},inventory={}", (Object)itemId, (Object)inventory);
                long storageNum = shoppingCartItemRespDto.getStorage() - inventory;
                storageNum = storageNum < 0L ? 0L : storageNum;
                shoppingCartItemRespDto.setStorage(Long.valueOf(storageNum));
            }
        }
        ItemShelfRespDto itemShelfRespDto = itemShelfMap.get(shopId + skuId.toString());
        this.newSetSellePriceAndStatus(shoppingCartItemRespDto, itemShelfRespDto);
        if (CollectionUtils.isNotEmpty(shopList)) {
            for (ShopDto shopDto : shopList) {
                if (!Objects.equals(shopDto.getId(), shopId)) continue;
                shoppingCartItemRespDto.setShopName(shopDto.getName());
                shoppingCartItemRespDto.setShopId(shopDto.getId());
            }
        }
        if (null != shoppingCartItemExtDto) {
            Map attrs = (Map)JSONObject.parseObject((String)shoppingCartItemExtDto.getAttrs(), Map.class);
            shoppingCartItemRespDto.setAttrs(attrs);
            shoppingCartItemRespDto.setBusType(shoppingCartItemExtDto.getBusType());
            shoppingCartItemRespDto.setImgPath(shoppingCartItemExtDto.getImgPath());
            if (null == shoppingCartItemRespDto.getSellPrice()) {
                shoppingCartItemRespDto.setSellPrice(shoppingCartItemExtDto.getSellPrice());
            }
        }
        return shoppingCartItemRespDto;
    }

    private void calculateLimitMinPurchase(List<ShoppingCartItemRespDto> itemList, List<ShopDto> shopList, Long userId) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        Map<Object, Object> shopCustomerMaps = new HashMap();
        try {
            List mercharIds = shopList.stream().map(e -> e.getOrganizationId()).collect(Collectors.toList());
            logger.info("\u8ba1\u7b97\u8d77\u8ba2\u91cf\u83b7\u53d6\u7684\u5ba2\u6237\u8bf7\u6c42\u4fe1\u606f\u4e3a:mercharIds={},userId={}", mercharIds, (Object)userId);
            List custoemrList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds(mercharIds, userId));
            Map<Long, CustomerRespDto> orgIdMap = custoemrList.stream().collect(Collectors.toMap(e -> e.getMerchantId(), e -> e, (e1, e2) -> e1));
            shopCustomerMaps = shopList.stream().collect(Collectors.toMap(e -> e.getId(), e -> (CustomerRespDto)orgIdMap.get(e.getOrganizationId()), (e1, e2) -> e1));
        }
        catch (Exception e3) {
            e3.printStackTrace();
            logger.error("\u8d2d\u7269\u8f66\u8ba1\u7b97\u8d77\u8ba2\u91cf\u5931\u8d25:{}", (Object)e3.getMessage());
        }
        CustomerRespDto customerRespDto = null;
        String ifWholeCasePurchaseRemark = null;
        for (ShoppingCartItemRespDto shoppingCartItemRespDto : itemList) {
            customerRespDto = (CustomerRespDto)shopCustomerMaps.get(shoppingCartItemRespDto.getShopId());
            if (customerRespDto != null) {
                shoppingCartItemRespDto.setIfWholeCasePurchase(customerRespDto.getIfWholeCasePurchase());
            }
            if (IfWholeCasePurchaseEnum.YES.getCode().equals(shoppingCartItemRespDto.getIfWholeCasePurchase())) {
                if (shoppingCartItemRespDto.getMinPackage() != null) {
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u975e\u7a7a\u3002\u53d6\u6700\u5c0f\u5305\u88c5\u6570";
                    shoppingCartItemRespDto.setLimitMinPurchaseNum(shoppingCartItemRespDto.getMinPackage());
                } else if (LimitMinModeEnum.CUSTOMER.getCode().equals(shoppingCartItemRespDto.getLimitMinMode())) {
                    shoppingCartItemRespDto.setLimitMinPurchaseNum(shoppingCartItemRespDto.getLimitMin());
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u53ea\u80fd\u53d6\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf";
                } else {
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u500d\u6570\u63a7\u5236\u60c5\u51b5\u4e0b\u9ed8\u8ba4\u4e3a1";
                }
            } else if (LimitMinModeEnum.CUSTOMER.getCode().equals(shoppingCartItemRespDto.getLimitMinMode())) {
                shoppingCartItemRespDto.setLimitMinPurchaseNum(shoppingCartItemRespDto.getLimitMin());
                ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf\u6a21\u5f0f\uff0c\u53ea\u80fd\u53d6\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf";
            } else if (LimitMinModeEnum.MULTIPLE.getCode().equals(shoppingCartItemRespDto.getLimitMinMode())) {
                if (shoppingCartItemRespDto.getMinPackage() != null && shoppingCartItemRespDto.getLimitMin() != null) {
                    shoppingCartItemRespDto.setLimitMinPurchaseNum(Integer.valueOf(shoppingCartItemRespDto.getLimitMin() * shoppingCartItemRespDto.getMinPackage()));
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u500d\u6570\u63a7\u5236+\u6700\u5c0f\u5305\u88c5\u6570\u975e\u7a7a\u65f6\u8ba1\u7b97\u51fa\u76f8\u4e58\u7684\u8d77\u8ba2\u91cf";
                } else {
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u500d\u6570\u63a7\u5236\uff0c\u4f46\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u4e0b\u9ed8\u8ba4\u4e3a1";
                }
            } else {
                ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u8d77\u8ba2\u91cf\u8bbe\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u4e3a1";
            }
            if (org.apache.commons.collections4.MapUtils.isNotEmpty((Map)shoppingCartItemRespDto.getExtFields())) {
                shoppingCartItemRespDto.getExtFields().put("ifWholeCasePurchaseRemark", ifWholeCasePurchaseRemark);
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ifWholeCasePurchaseRemark", ifWholeCasePurchaseRemark);
            shoppingCartItemRespDto.setExtFields(map);
        }
    }

    private void setSellePriceAndStatus(ShoppingCartItemRespDto shoppingCartItemRespDto, Long skuId, Long shopId) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setSkuId(skuId);
        shelfReqDto.setShopId(shopId);
        PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(JSON.toJSONString((Object)shelfReqDto), Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null != pageInfo && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            shoppingCartItemRespDto.setSellPrice(((ItemShelfRespDto)pageInfo.getList().get(0)).getPrice());
            if (((ItemShelfRespDto)pageInfo.getList().get(0)).getStatus() == 1) {
                shoppingCartItemRespDto.setStatus(Integer.valueOf(1));
            } else {
                shoppingCartItemRespDto.setStatus(Integer.valueOf(0));
            }
        }
    }

    private void newSetSellePriceAndStatus(ShoppingCartItemRespDto shoppingCartItemRespDto, ItemShelfRespDto itemShelfRespDto) {
        if (Objects.nonNull(itemShelfRespDto)) {
            shoppingCartItemRespDto.setSellPrice(itemShelfRespDto.getPrice());
            if (itemShelfRespDto.getStatus() == 1) {
                shoppingCartItemRespDto.setStatus(Integer.valueOf(1));
            } else {
                shoppingCartItemRespDto.setStatus(Integer.valueOf(0));
            }
            shoppingCartItemRespDto.setStockDisplay(itemShelfRespDto.getStockDisplay());
            shoppingCartItemRespDto.setLimitMin(itemShelfRespDto.getLimitMin());
            shoppingCartItemRespDto.setLimitMinMode(itemShelfRespDto.getLimitMinMode());
            shoppingCartItemRespDto.setMultipleStatus(itemShelfRespDto.getMultipleStatus());
        }
    }

    private Integer getStatus(Long shopId, Long skuId, Long itemId) {
        boolean isOnShelf = this.bitemService.isOnshelf(shopId, itemId, skuId);
        if (!isOnShelf) {
            return 0;
        }
        return 1;
    }

    public void setItemOrderActivity(List<ShoppingCartItemRespDto> cartItems) {
        Map<Object, Object> itemTags = Maps.newHashMap();
        List itemIts = cartItems.stream().map(ShoppingCartItemRespDto::getItemId).collect(Collectors.toList());
        List shopIds = cartItems.stream().map(ShoppingCartItemRespDto::getShopId).collect(Collectors.toList());
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setItemIdList(itemIts);
        queryReqDto.setShopIdList(shopIds);
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setTenantId(this.context.tenantId());
        queryReqDto.setDimension(ActivityDimensionEnum.ORDER.getKey());
        List tags = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityTagQueryApi.queryList(queryReqDto));
        itemTags = tags.stream().collect(Collectors.groupingBy(tagDto -> tagDto.getShopId().toString() + tagDto.getItemId().toString()));
        for (ShoppingCartItemRespDto cartItem : cartItems) {
            ItemOrderActivityTagDto itemOrderActivityTagDto = new ItemOrderActivityTagDto();
            List tagDtos = (List)itemTags.get(cartItem.getShopId().toString() + cartItem.getItemId().toString());
            if (CollectionUtils.isEmpty((Collection)tagDtos)) continue;
            ItemActivityTagDto itemActivityTagDto = tagDtos.stream().findFirst().orElse(null);
            CubeBeanUtils.copyProperties((Object)itemOrderActivityTagDto, (Object)itemActivityTagDto, (String[])new String[0]);
            ItemActivityInfoRespDto itemActivityInfoRespDto = this.convertToItemActivityInfoRespDto(itemActivityTagDto);
            ActivityType activityType = itemActivityInfoRespDto.getActivityType();
            itemOrderActivityTagDto.setActivityType(activityType.name());
            Integer promotionMethod = itemActivityInfoRespDto.getPromotionMethod();
            if (promotionMethod == null || promotionMethod != 1) continue;
            itemOrderActivityTagDto.setPromotionMethod(itemActivityInfoRespDto.getPromotionMethod());
            cartItem.setItemOrderActivityTagDto(itemOrderActivityTagDto);
        }
    }

    private ItemActivityInfoRespDto convertToItemActivityInfoRespDto(ItemActivityTagDto itemActivityTagDto) {
        ItemActivityInfoRespDto activityInfo = new ItemActivityInfoRespDto();
        try {
            ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(itemActivityTagDto.getActivityId().longValue()).getData();
            CubeBeanUtils.copyProperties((Object)activityInfo, (Object)activityRespDto, (String[])new String[0]);
            if (null == activityRespDto.getPreheatStartTime()) {
                activityInfo.setPreheatStartTime(activityRespDto.getBeginTime());
            }
            activityInfo.setDimension(activityRespDto.getActivityTemplate().getDimension());
            activityInfo.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
            activityInfo.setPromotionMethod(activityRespDto.getPromotionMethod());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return activityInfo;
    }

    public Long addCombinedPackageItem(CombinedPackageItemReqDto combinedPackageItemReqDto) {
        ShopDto shopDto;
        TrolleyRepDto substationCart;
        BigDecimal activitySurplus;
        Long tenantId = this.context.tenantId();
        Long instanceId = this.context.instanceId();
        Long userId = Objects.nonNull(combinedPackageItemReqDto.getCustomerId()) ? combinedPackageItemReqDto.getCustomerId() : (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        logger.info("\u7ec4\u5408\u5957\u88c5\u52a0\u5165\u8d2d\u7269\u8f66userid,{}", (Object)userId.toString());
        RestResponse activityRespDtoRestResponse = this.activityQueryApi.queryActivityDetail(combinedPackageItemReqDto.getActivityId().longValue());
        logger.info("\u7ec4\u5408\u5546\u54c1\u52a0\u5165\u8d2d\u7269 \u6d3b\u52a8\u72b6\u6001\uff0c{}", (Object)((ActivityRespDto)activityRespDtoRestResponse.getData()).getActivityStatus());
        logger.info("\u72b6\u6001\uff0c{}", (Object)ActivityStatusEnum.ACTIVATE.getKey());
        if (!ActivityStatusEnum.ACTIVATE.getKey().equals(((ActivityRespDto)activityRespDtoRestResponse.getData()).getActivityStatus())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ACTIVITY_FINISH);
        }
        ArrayList activityIds = Lists.newArrayList();
        activityIds.add(combinedPackageItemReqDto.getActivityId());
        RestResponse activityRuleItemRespDtoList = this.activityRuleItemQueryApi.queryActivityRuleItemByActivityIds((List)activityIds);
        if (CollectionUtils.isEmpty((Collection)((Collection)activityRuleItemRespDtoList.getData()))) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ACTIVITY_ITEM_NOT_EXIST);
        }
        List itemIds = ((List)activityRuleItemRespDtoList.getData()).stream().map(ActivityRuleItemRespDto::getItemId).collect(Collectors.toList());
        ItemSearchQueryReqDto itemSearchQueryReqDto = new ItemSearchQueryReqDto();
        itemSearchQueryReqDto.setInstanceId(this.context.instanceId());
        itemSearchQueryReqDto.setTenantId(this.context.tenantId());
        itemSearchQueryReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
        itemSearchQueryReqDto.setShopId(combinedPackageItemReqDto.getShopId());
        itemSearchQueryReqDto.setItemIds(itemIds);
        itemSearchQueryReqDto.setStatus(Integer.valueOf(1));
        ItemSearchRespDto itemSearchRespDto = (ItemSearchRespDto)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemByDirIdDepth(itemSearchQueryReqDto, Integer.valueOf(1), Integer.valueOf(1000)));
        if (CollectionUtils.isEmpty((Collection)itemSearchRespDto.getPageInfo().getList())) {
            throw new BizException("-1", "\u5e97\u94fa\u6682\u65e0\u4e0a\u67b6\u5546\u54c1");
        }
        logger.info("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u4e0a\u67b6\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)itemSearchRespDto.getPageInfo().getList()));
        Map<Long, ItemRespDto> shelfItemMap = itemSearchRespDto.getPageInfo().getList().stream().collect(Collectors.toMap(e -> e.getId(), e -> e, (e1, e2) -> e1));
        for (ActivityRuleItemRespDto activityRuleItemResp : (List)activityRuleItemRespDtoList.getData()) {
            if (shelfItemMap.containsKey(activityRuleItemResp.getItemId())) continue;
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_OFF_SHELF);
        }
        Long stock = 0L;
        TcbjInventoryActReqDto tcbjInventoryActReqDto = new TcbjInventoryActReqDto();
        tcbjInventoryActReqDto.setActivityId(combinedPackageItemReqDto.getActivityId());
        List tcbjInventoryActRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.inventoryActQuery(tcbjInventoryActReqDto));
        Collection tcbjInventoryActDetailRespDtos = null;
        if (tcbjInventoryActRespDtos != null && ((TcbjInventoryActRespDto)tcbjInventoryActRespDtos.get(0)).getDetailRespDtoList() != null) {
            tcbjInventoryActDetailRespDtos = ((TcbjInventoryActRespDto)tcbjInventoryActRespDtos.get(0)).getDetailRespDtoList();
        }
        if (CollectionUtils.isNotEmpty(tcbjInventoryActDetailRespDtos) && (activitySurplus = tcbjInventoryActDetailRespDtos.stream().filter(e -> e.getCargoCode().equals(((ActivityRuleItemRespDto)((List)activityRuleItemRespDtoList.getData()).get(0)).getSkuCode())).map(e -> e.getActivitySurplus()).reduce(BigDecimal.ZERO, BigDecimal::add)).intValue() > 0) {
            stock = activitySurplus.divide(new BigDecimal(((ActivityRuleItemRespDto)((List)activityRuleItemRespDtoList.getData()).get(0)).getNum())).longValue();
        }
        if (stock == 0L) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ACTIVITY_ITEM_STOCK_LIMIT);
        }
        if (null == (substationCart = this.getUserShoppingCart(userId, null))) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOPPING_CART_NOT_EXIST);
        }
        if (null == (shopDto = (ShopDto)this.shopQueryApi.queryById(combinedPackageItemReqDto.getShopId().longValue(), new String[0]).getData())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOP_NOT_EXIST);
        }
        TrolleyItemReqDto trolleyItemReqDto = new TrolleyItemReqDto();
        trolleyItemReqDto.setTenantId(tenantId);
        trolleyItemReqDto.setInstanceId(instanceId);
        trolleyItemReqDto.setItemNum(combinedPackageItemReqDto.getItemNum());
        trolleyItemReqDto.setItemName(combinedPackageItemReqDto.getActivityName());
        trolleyItemReqDto.setTrolleyId(substationCart.getId());
        trolleyItemReqDto.setItemSrc("icommerceb");
        trolleyItemReqDto.setGroupKey(combinedPackageItemReqDto.getShopId().toString());
        trolleyItemReqDto.setItemSerial(String.valueOf(combinedPackageItemReqDto.getActivityId()));
        trolleyItemReqDto.setSkuSerial(String.valueOf(combinedPackageItemReqDto.getActivityId()));
        trolleyItemReqDto.setAddChannel(combinedPackageItemReqDto.getAddChannel());
        trolleyItemReqDto.setType(shopDto.getType() == null ? null : Integer.valueOf(shopDto.getType().intValue()));
        trolleyItemReqDto.setActivityType(Integer.valueOf(1));
        ShoppingCartItemExtDto extension = this.getShoppingCombinedPackage((ActivityRespDto)activityRespDtoRestResponse.getData(), combinedPackageItemReqDto.getShopId());
        trolleyItemReqDto.setExtension(ObjectHelper.bean2Json((Object)extension));
        RestResponse trolleyItemRepDtoRestResponse = this.trolleyApi.addTrolleyItem(trolleyItemReqDto);
        logger.info("\u65b0\u589e\u8d2d\u7269\u8f66\u9879\u63a5\u53e3\u8fd4\u56de\u53c2\u6570" + JSON.toJSONString((Object)trolleyItemRepDtoRestResponse));
        return ((TrolleyItemRepDto)trolleyItemRepDtoRestResponse.getData()).getId();
    }

    public void batchRemoveItem(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOPPING_CART_ITEM_NOT_EMPTY);
        }
        RestResponse restResponse = this.trolleyApi.batchRemoveTrolleyItem(ids);
        RestResponseHelper.extractData((RestResponse)restResponse);
    }

    private ShoppingCartItemExtDto getShoppingCombinedPackage(ActivityRespDto activityRespDto, Long shopId) {
        ShoppingCartItemExtDto shoppingCartItemExtDto = new ShoppingCartItemExtDto();
        Object imgPath = null;
        Object sellPrice = null;
        Object attrs = null;
        String shopName = null;
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
        if (shopDto != null) {
            shopName = shopDto.getName();
        }
        ArrayList activityIds = Lists.newArrayList();
        activityIds.add(activityRespDto.getId());
        List activityRuleItemRespDtoList = (List)this.activityRuleItemQueryApi.queryActivityRuleItemByActivityIds((List)activityIds).getData();
        List conditionRespDtos = this.conditionQueryApi.queryConditions((List)activityIds, 1196944223312880296L);
        shoppingCartItemExtDto.setImgPath(activityRespDto.getActivityLogo());
        shoppingCartItemExtDto.setAttrs(this.setCombinedPackageAttrs(activityRuleItemRespDtoList).toString());
        shoppingCartItemExtDto.setSellPrice(this.getPackagePrice(((ConditionRespDto)conditionRespDtos.get(0)).getConditionParams()));
        shoppingCartItemExtDto.setShopName(shopName);
        shoppingCartItemExtDto.setBusType(Integer.valueOf(0));
        return shoppingCartItemExtDto;
    }

    private BigDecimal getPackagePrice(String conditionParams) {
        JSONObject jsonObject;
        CombinationRule combinationRule;
        ComRuleContentDto contents;
        BigDecimal totalPrice = null;
        if (conditionParams != null && Objects.nonNull(contents = (combinationRule = (CombinationRule)JSON.parseObject((String)(jsonObject = JSON.parseObject((String)conditionParams)).getString("CombinationCondition.rule"), CombinationRule.class)).getComRuleContent())) {
            totalPrice = contents.getTotalPrice();
        }
        return totalPrice;
    }

    private Integer getThresholdType(String conditionParams) {
        Integer thresholdType = 0;
        if (conditionParams != null) {
            JSONObject jsonObject = JSON.parseObject((String)conditionParams);
            CombinationRule combinationRule = (CombinationRule)JSON.parseObject((String)jsonObject.getString("CombinationCondition.rule"), CombinationRule.class);
            thresholdType = combinationRule.getThresholdType();
        }
        return thresholdType;
    }
}

