/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.ICargoStorageApi;
import com.dtyunxi.yundt.cube.center.inventory.api.ITransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoStorageQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.module.trade.api.dto.request.StorageQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.StorageReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.ToBCargoStorageCreateReqDto;
import com.dtyunxi.yundt.module.trade.biz.IStorageService;
import com.dtyunxi.yundt.module.trade.biz.constant.StorageTypeEnum;
import com.dtyunxi.yundt.module.trade.biz.util.LogUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class IdentityStorageServiceImpl
implements IStorageService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICargoStorageApi cargoStorageApi;
    @Resource
    private ICargoStorageQueryApi cargoStorageQueryApi;
    @Resource
    private ITcbjInventoryApi iTcbjInventoryApi;
    @Resource
    private ITransferOrderApi itransferOrderApi;
    @Resource
    private ICsInventoryExposedApi csInventoryExposedApi;
    @Resource
    private ICsInventoryExposedApi inventoryExposedApi;
    private final String BUSINESS_APPROVE = "1";
    private final String FINANCE_APPROVE = "2";

    @Override
    public String type() {
        return StorageTypeEnum.IDENTITY.getCode();
    }

    @Override
    public RestResponse queryItemStorage(StorageQueryReqDto queryReqDto) {
        return this.cargoStorageQueryApi.queryCargoStorageExt(queryReqDto.getCargoStorageQueryReqDto());
    }

    @Override
    public RestResponse operatingItemStorage(StorageReqDto reqDto) {
        this.logger.info("[operatingItemStorage]>>>{}", (Object)JSONObject.toJSONString((Object)reqDto));
        TcbjProOccupyReqDto tcbjProOccupyReqDto = new TcbjProOccupyReqDto();
        ToBCargoStorageCreateReqDto cargoStorageCreateReqDto = reqDto.getCargoStorageCreateReqDto();
        tcbjProOccupyReqDto.setOrderNo(cargoStorageCreateReqDto.getOrderNo());
        ArrayList<TcbjProOccupyItemReqDto> list = new ArrayList<TcbjProOccupyItemReqDto>();
        if (cargoStorageCreateReqDto.getCargoSerialAndBatchs() != null && !cargoStorageCreateReqDto.getCargoSerialAndBatchs().isEmpty()) {
            Map cargoCodeAndItem = cargoStorageCreateReqDto.getCargoList().stream().collect(Collectors.groupingBy(CargoStorageInfoCreateReqDto::getCargoCode, Collectors.toList()));
            for (Map.Entry stringStringEntry : cargoStorageCreateReqDto.getCargoSerialAndBatchs().entrySet()) {
                String[] split = ((String)stringStringEntry.getValue()).split(",");
                for (int i = 0; i < split.length; ++i) {
                    String batchAndNums = split[i];
                    String batch = batchAndNums.substring(0, batchAndNums.lastIndexOf("#"));
                    String num = batchAndNums.substring(batchAndNums.lastIndexOf("#") + 1);
                    List cargoStorageInfoCreateReqDtos = (List)cargoCodeAndItem.get(stringStringEntry.getKey());
                    CargoStorageInfoCreateReqDto combinationCargoStorage = cargoStorageInfoCreateReqDtos.stream().filter(cargoReqDto -> Objects.nonNull(cargoReqDto.getExtFields().get("batch")) && cargoReqDto.getExtFields().get("tempBatch").toString().contains(batchAndNums) && cargoReqDto.getExtFields().get("batch").toString().split(",").length != cargoReqDto.getUsed()).findFirst().orElseGet(() -> null);
                    if (Objects.isNull(combinationCargoStorage)) {
                        CargoStorageInfoCreateReqDto cargoStorageInfoCreateReqDto = cargoStorageInfoCreateReqDtos.stream().filter(cargoReqDto -> Objects.isNull(cargoReqDto.getExtFields().get("batch"))).findFirst().orElseGet(() -> null);
                        if (cargoStorageInfoCreateReqDto == null) continue;
                        TcbjProOccupyItemReqDto tcbjProOccupyItemReqDto = this.getTcbjProOccupyItemReqDto(cargoStorageInfoCreateReqDto, Integer.parseInt(num));
                        tcbjProOccupyItemReqDto.setBatch(batch);
                        list.add(tcbjProOccupyItemReqDto);
                        continue;
                    }
                    TcbjProOccupyItemReqDto tcbjProOccupyItemReqDto = this.getTcbjProOccupyItemReqDto(combinationCargoStorage, Integer.parseInt(num));
                    tcbjProOccupyItemReqDto.setBatch(batch);
                    list.add(tcbjProOccupyItemReqDto);
                    combinationCargoStorage.setUsed(Integer.valueOf(combinationCargoStorage.getUsed() == null ? 1 : combinationCargoStorage.getUsed() + 1));
                    ArrayList<String> tempBatchList = new ArrayList<String>(Arrays.asList(combinationCargoStorage.getExtFields().get("tempBatch").toString().split(",")));
                    if (!CollectionUtils.isNotEmpty(tempBatchList)) continue;
                    tempBatchList.removeIf(b -> b.equals(batch + "#" + num));
                    combinationCargoStorage.getExtFields().put("tempBatch", CollectionUtils.isNotEmpty(tempBatchList) ? StringUtils.join(tempBatchList, (String)",") : "");
                }
            }
        } else {
            for (CargoStorageInfoCreateReqDto cargoStorageInfoCreateReqDto : cargoStorageCreateReqDto.getCargoList()) {
                TcbjProOccupyItemReqDto tcbjProOccupyItemReqDto = this.getTcbjProOccupyItemReqDto(cargoStorageInfoCreateReqDto, cargoStorageInfoCreateReqDto.getNum().intValue());
                list.add(tcbjProOccupyItemReqDto);
            }
        }
        tcbjProOccupyReqDto.setAuditType(reqDto.getAuditType() + "");
        tcbjProOccupyReqDto.setTcbjProOccupyItemReqDtos(list);
        tcbjProOccupyReqDto.setOrderType("101");
        tcbjProOccupyReqDto.setAuditType(String.valueOf(reqDto.getAuditType()));
        RestResponse<String> preemptInventoryResp = this.refactorPreemptInventory(tcbjProOccupyReqDto);
        return preemptInventoryResp;
    }

    private RestResponse<String> refactorPreemptInventory(TcbjProOccupyReqDto tcbjProOccupyReqDto) {
        this.logger.info("refactorPreemptInventory==>\u5e93\u5b58\u9884\u5360\u5904\u7406\uff0c\u4e0b\u5355\u5904\u7406\u3001\u4e1a\u52a1\u5ba1\u6279\u3001\u8d22\u52a1\u5ba1\u6279,tcbjProOccupyReqDto:{}", (Object)LogUtils.buildLogContent(tcbjProOccupyReqDto));
        RestResponse<String> result = RestResponse.SUCCEED;
        String auditType = tcbjProOccupyReqDto.getAuditType();
        result = "1".equals(auditType) || "2".equals(auditType) ? this.approvePreempt(tcbjProOccupyReqDto) : this.placeOrderPreempt(tcbjProOccupyReqDto);
        return result;
    }

    private RestResponse<String> approvePreempt(TcbjProOccupyReqDto tcbjProOccupyReqDto) {
        this.logger.info("approvePreempt==>\u4e1a\u52a1\u5ba1\u6279\u3001\u8d22\u52a1\u5ba1\u6279\uff0c\u5ba1\u6279\u901a\u8fc7\u64cd\u4f5c,orderNo:{}", (Object)tcbjProOccupyReqDto.getOrderNo());
        String auditType = tcbjProOccupyReqDto.getAuditType();
        String sourceType = CsInventorySourceTypeEnum.OUT_BUSINESS_APPROVE_PREEMPT.getCode();
        if ("2".equals(auditType)) {
            sourceType = CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT.getCode();
        }
        RestResponse result = RestResponse.SUCCEED;
        List tcbjProOccupyItemReqDtoList = tcbjProOccupyReqDto.getTcbjProOccupyItemReqDtos();
        CsInventoryOperateReqDto csInventoryOperateReqDto = new CsInventoryOperateReqDto();
        csInventoryOperateReqDto.setSourceNo(tcbjProOccupyReqDto.getOrderNo());
        csInventoryOperateReqDto.setSourceType(sourceType);
        csInventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        ArrayList operateCargoReqDtoList = Lists.newArrayList();
        for (TcbjProOccupyItemReqDto itemReqDto : tcbjProOccupyItemReqDtoList) {
            CsInventoryOperateCargoReqDto operateCargoReqDto = new CsInventoryOperateCargoReqDto();
            operateCargoReqDto.setWarehouseCode(itemReqDto.getWarehouseCode());
            operateCargoReqDto.setCargoCode(itemReqDto.getCargoCode());
            operateCargoReqDto.setBatch(itemReqDto.getBatch());
            operateCargoReqDto.setActivityId(itemReqDto.getActivityId());
            operateCargoReqDto.setChangeInventory(new BigDecimal(itemReqDto.getNum()));
            operateCargoReqDtoList.add(operateCargoReqDto);
        }
        csInventoryOperateReqDto.setOperateCargoReqDtoList((List)operateCargoReqDtoList);
        this.logger.info("approvePreempt==>\u4e1a\u52a1\u5ba1\u6279\u3001\u8d22\u52a1\u5ba1\u6279\uff0c\u5ba1\u6279\u901a\u8fc7\u64cd\u4f5c,csInventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(csInventoryOperateReqDto));
        RestResponse preemptInventoryResp = this.csInventoryExposedApi.approvePassInventory(csInventoryOperateReqDto);
        this.logger.info("approvePreempt==>\u4e1a\u52a1\u5ba1\u6279\u3001\u8d22\u52a1\u5ba1\u6279\uff0c\u5ba1\u6279\u901a\u8fc7\u64cd\u4f5c,preemptInventoryResp:{}", (Object)LogUtils.buildLogContent(preemptInventoryResp));
        Boolean preemptResult = (Boolean)RestResponseHelper.extractData((RestResponse)preemptInventoryResp);
        if (!preemptResult.booleanValue()) {
            result = RestResponse.FAILED;
        }
        return result;
    }

    private RestResponse<String> placeOrderPreempt(TcbjProOccupyReqDto tcbjProOccupyReqDto) {
        this.logger.info("placeOrderPreempt==>\u4e0b\u5355\u9884\u5360\u5e93\u5b58,orderNo:{}", (Object)tcbjProOccupyReqDto.getOrderNo());
        RestResponse result = RestResponse.SUCCEED;
        List tcbjProOccupyItemReqDtoList = tcbjProOccupyReqDto.getTcbjProOccupyItemReqDtos();
        CsInventoryOperateReqDto csInventoryOperateReqDto = new CsInventoryOperateReqDto();
        csInventoryOperateReqDto.setSourceNo(tcbjProOccupyReqDto.getOrderNo());
        csInventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        csInventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        ArrayList operateCargoReqDtoList = Lists.newArrayList();
        for (TcbjProOccupyItemReqDto itemReqDto : tcbjProOccupyItemReqDtoList) {
            CsInventoryOperateCargoReqDto operateCargoReqDto = new CsInventoryOperateCargoReqDto();
            operateCargoReqDto.setWarehouseCode(itemReqDto.getWarehouseCode());
            operateCargoReqDto.setCargoCode(itemReqDto.getCargoCode());
            operateCargoReqDto.setBatch(itemReqDto.getBatch());
            operateCargoReqDto.setActivityId(itemReqDto.getActivityId());
            operateCargoReqDto.setChangeInventory(new BigDecimal(itemReqDto.getNum()));
            operateCargoReqDtoList.add(operateCargoReqDto);
        }
        csInventoryOperateReqDto.setOperateCargoReqDtoList((List)operateCargoReqDtoList);
        this.logger.info("placeOrderPreempt==>\u4e0b\u5355\u9884\u5360\u5e93\u5b58,csInventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(csInventoryOperateReqDto));
        RestResponse preemptInventoryResp = this.csInventoryExposedApi.preemptInventory(csInventoryOperateReqDto);
        this.logger.info("placeOrderPreempt==>\u4e0b\u5355\u9884\u5360\u5e93\u5b58,preemptInventoryResp:{}", (Object)LogUtils.buildLogContent(preemptInventoryResp));
        Boolean preemptResult = (Boolean)RestResponseHelper.extractData((RestResponse)preemptInventoryResp);
        if (!preemptResult.booleanValue()) {
            result = RestResponse.FAILED;
        }
        return result;
    }

    private TcbjProOccupyItemReqDto getTcbjProOccupyItemReqDto(CargoStorageInfoCreateReqDto cargoStorageInfoCreateReqDto, int i) {
        TcbjProOccupyItemReqDto tcbjProOccupyItemReqDto = new TcbjProOccupyItemReqDto();
        BeanUtils.copyProperties((Object)cargoStorageInfoCreateReqDto, (Object)tcbjProOccupyItemReqDto);
        tcbjProOccupyItemReqDto.setCargoCode(cargoStorageInfoCreateReqDto.getCargoCode());
        tcbjProOccupyItemReqDto.setWarehouseCode(cargoStorageInfoCreateReqDto.getWarehouseCode());
        tcbjProOccupyItemReqDto.setNum(Integer.valueOf(i));
        Map extFields = cargoStorageInfoCreateReqDto.getExtFields();
        Object activityId = extFields.get("activityId");
        Object combinationFlag = extFields.get("combinationFlag");
        tcbjProOccupyItemReqDto.setActivityId(activityId != null && StringUtils.isNumeric((CharSequence)activityId.toString()) ? Long.valueOf(activityId.toString()) : null);
        tcbjProOccupyItemReqDto.setCombinationFlag(combinationFlag != null && StringUtils.isNumeric((CharSequence)combinationFlag.toString()) ? Integer.valueOf(combinationFlag.toString()) : null);
        return tcbjProOccupyItemReqDto;
    }

    @Override
    public RestResponse returnItemStorage(StorageReqDto reqDto) {
        JSONObject sjon = new JSONObject();
        sjon.put("orderNo", (Object)reqDto.getCargoStorageCreateReqDto().getOrderNo());
        this.logger.info("\u53d6\u6d88\u5360\u7528\u63a5\u53e3\u5c40\u8bf7\u6c42\u53c2\u6570,reqDto----:" + JSONObject.toJSONString((Object)sjon.toJSONString()));
        CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto = new CsInventoryReleasePreemptOperateReqDto();
        releasePreemptOperateReqDto.setSourceNo(reqDto.getCargoStorageCreateReqDto().getOrderNo());
        releasePreemptOperateReqDto.setSourceType(CsInventorySourceTypeEnum.IN_SALE_RELEASE.getCode());
        RestResponse stringRestResponse = this.inventoryExposedApi.releaseInventoryByPreemption(releasePreemptOperateReqDto);
        RestResponseHelper.extractData((RestResponse)stringRestResponse);
        return stringRestResponse;
    }
}

