/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.pay;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.module.trade.api.dto.request.SimplePayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.TradePayRespDto;
import com.dtyunxi.yundt.module.trade.biz.pay.AbstractPayHelp;
import com.yx.tcbj.center.rebate.api.IOfflineBalanceBillApi;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceBillReqDto;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillSourceEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillTypeEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBusinessEnum;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="normalPayPayHelp")
public class NormalPayPayHelp
extends AbstractPayHelp<TradePayRespDto> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOfflineBalanceBillApi offlineBalanceBillApi;
    @Autowired
    private IOrderBizQueryApi orderBizQueryApi;

    @Override
    public SimplePayReqDto initParam(Object ... objects) {
        SimplePayReqDto simplePayReqDto = new SimplePayReqDto();
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)simplePayReqDto);
        }
        return simplePayReqDto;
    }

    @Override
    protected SimplePayReqDto buildResult(SimplePayReqDto request) {
        return request;
    }

    @Override
    public void errorCallBack(SimplePayReqDto request) {
    }

    @Override
    public void successCallBackDefine(SimplePayReqDto simplePayReqDto) {
        OrderDetailRespDto orderDetailRespDto = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)this.orderBizQueryApi.getOrderDetail(simplePayReqDto.getOrderNo()));
        this.logger.info("[\u652f\u4ed8\u6210\u529f\u56de\u8c03\u3011\uff0c\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderDetailRespDto));
        if (orderDetailRespDto != null && simplePayReqDto.getPayAmount() != null && orderDetailRespDto.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
            simplePayReqDto.setPayAmount(orderDetailRespDto.getPayAmount());
            this.addOrderPayRecord(simplePayReqDto);
        }
    }

    @Override
    public boolean allowSubmitOrder(SimplePayReqDto request) {
        return true;
    }

    @Override
    public boolean isPrePayed(SimplePayReqDto simplePayReqDto) {
        return false;
    }

    @Override
    public void customerConfirmRefund(SimplePayReqDto simplePayReqDto) {
        if (simplePayReqDto.getRefundAmount() != null && BigDecimal.ZERO.compareTo(simplePayReqDto.getRefundAmount()) < 0) {
            OfflineBalanceBillReqDto billReqDto = new OfflineBalanceBillReqDto();
            billReqDto.setBillDate(new Date());
            billReqDto.setBillType(OfflineBalanceBillTypeEnum.REFUND.getCode());
            billReqDto.setBusinessContent(OfflineBalanceBusinessEnum.BUSINESS_ORDER.getCode());
            billReqDto.setCustomerId(Long.valueOf(simplePayReqDto.getCustomerId()));
            billReqDto.setAmount(simplePayReqDto.getRefundAmount());
            billReqDto.setBillSource(OfflineBalanceBillSourceEnum.ORDER_OFF_SUBMIT.getCode());
            billReqDto.setRelationNo(simplePayReqDto.getOrderNo());
            billReqDto.setReceiptRecordsNo(simplePayReqDto.getPayNo());
            this.logger.info("\u5728\u7ebf\u652f\u4ed8,\u751f\u6210\u5df2\u5ba1\u6838\u9000\u6b3e\u5355{}", (Object)JSON.toJSONString((Object)billReqDto));
            RestResponseHelper.extractData((RestResponse)this.offlineBalanceBillApi.addOfflineBalanceBill(billReqDto));
        }
    }
}

