/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.payment.api.config.IPayCenterConfigApi;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryAccountRequest;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IPayment;
import com.dtyunxi.yundt.module.trade.api.dto.request.QueryAccountReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.payconfig.AliPayPartnerConfigRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.payconfig.BasePayPartnerConfigRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.payconfig.WxPayPartnerConfigRespDto;
import com.dtyunxi.yundt.module.trade.biz.config.PayConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentImpl
implements IPayment {
    @Resource
    private IContext context;
    @Autowired
    private IPayCenterConfigApi payCenterConfigApi;
    @Autowired
    private PayConfig payConfig;
    private static Logger logger = LoggerFactory.getLogger(PaymentImpl.class);

    public List<BasePayPartnerConfigRespDto> queryPayAccount(QueryAccountReqDto queryAccountRequest) {
        QueryAccountRequest accountRequest = new QueryAccountRequest();
        BeanUtil.copyProperties((Object)queryAccountRequest, (Object)accountRequest, (String[])new String[0]);
        RestResponse listRestResponse = this.payCenterConfigApi.queryPayAccountNoStatus(accountRequest);
        RestResponseHelper.checkOrThrow((RestResponse)listRestResponse);
        List list = (List)listRestResponse.getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList<BasePayPartnerConfigRespDto> partnerConfigRespDtoList = new ArrayList<BasePayPartnerConfigRespDto>();
        list.forEach(e -> {
            if ("102".equals(e.getPartnerCode())) {
                WxPayPartnerConfigRespDto dto = new WxPayPartnerConfigRespDto();
                partnerConfigRespDtoList.add((BasePayPartnerConfigRespDto)dto);
                BeanUtil.copyProperties((Object)e, (Object)dto, (String[])new String[0]);
                dto.setMerId(e.getPtMerId());
                dto.setAppId(e.getPtAccount());
                dto.setCertificate(e.getLcPrivKey());
                dto.setApiSecret(e.getPtPubKey());
                dto.setAppSecret(e.getLcPubKey());
                dto.setId(e.getId());
            } else if ("103".equals(e.getPartnerCode())) {
                AliPayPartnerConfigRespDto dto = new AliPayPartnerConfigRespDto();
                partnerConfigRespDtoList.add((BasePayPartnerConfigRespDto)dto);
                BeanUtil.copyProperties((Object)e, (Object)dto, (String[])new String[0]);
                dto.setMerId(e.getPtMerId());
                dto.setAppId(e.getPtAccount());
                dto.setMerchantPrivateKey(e.getLcPrivKey());
                dto.setMerchantPublicKey(e.getPtPubKey());
                dto.setId(e.getId());
            }
        });
        return partnerConfigRespDtoList;
    }

    public List<BasePayPartnerConfigRespDto> queryPayAccount() {
        QueryAccountReqDto queryAccountRequest = new QueryAccountReqDto();
        queryAccountRequest.setAppCode(this.payConfig.getAppId());
        queryAccountRequest.setStoreCode(this.payConfig.getStoreId());
        queryAccountRequest.setPartnerCode("102,");
        return this.queryPayAccount(queryAccountRequest);
    }
}

