/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IShopAggrService;
import com.dtyunxi.yundt.module.trade.biz.ICommonService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ShopAggrServiceImpl
implements IShopAggrService {
    private static Logger logger = LoggerFactory.getLogger(ShopAggrServiceImpl.class);
    @Resource
    ICommonService commonService;
    @Resource
    private IContext context;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;

    public List<ShopDto> queryUpStreamShop() {
        Long userId = this.context.userId();
        Assert.notNull((Object)userId, (String)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList sellerRespDtoList = Lists.newArrayList();
        ServiceContext serviceContext = ServiceContext.getContext();
        String sellerOrgId = serviceContext.getAttachment("yes.req.cus.b2b.sellerorgid");
        if (sellerOrgId != null) {
            logger.info("\u4ee3\u5ba2\u4e0b\u5355\u67e5\u8be2\u5546\u5bb6\uff1asellerOrgId={}", (Object)sellerOrgId);
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            ArrayList sellerOrgIdList = Lists.newArrayList();
            sellerOrgIdList.add(Long.valueOf(sellerOrgId));
            sellerQueryReqDto.setOrganizationIds((List)sellerOrgIdList);
            sellerQueryReqDto.setTenantId(this.context.tenantId());
            List placeRes = (List)this.sellerQueryApi.queryList(sellerQueryReqDto).getData();
            if (CollectionUtils.isNotEmpty((Collection)placeRes)) {
                sellerRespDtoList.addAll(placeRes);
            }
        } else {
            List<SellerRespDto> res = this.commonService.getSellerDtoByUserId(userId);
            if (CollectionUtils.isNotEmpty(res)) {
                sellerRespDtoList.addAll(res);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)sellerRespDtoList)) {
            List sellerIds = sellerRespDtoList.stream().map(e -> e.getId()).collect(Collectors.toList());
            ShopQueryDto queryCondition = new ShopQueryDto();
            queryCondition.setSellerIdList(sellerIds);
            queryCondition.setTenantId(this.context.tenantId());
            List shopDtos = (List)this.shopQueryApi.shopList(queryCondition).getData();
            return shopDtos;
        }
        return null;
    }
}

