/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OptLogReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.tob.query.IOptLogQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.ILogService;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.IReturnOrderService;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OptLogRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderLogRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReFundOrderDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.RefundOrderLogRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.OrderTradeStatusEnum;
import com.dtyunxi.yundt.module.trade.api.enums.RefundOrderStatusToBEnum;
import com.dtyunxi.yundt.module.trade.api.enums.ReturnStatusToBEnum;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderLogServiceImpl
implements ILogService {
    @Resource
    private IOptLogQueryApi iOptLogQueryApi;
    private static Logger logger = LoggerFactory.getLogger(OrderLogServiceImpl.class);
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IReturnOrderService returnOrderService;
    @Resource
    private IContext context;

    public OrderLogRespDto getMgmtOrderLog(String orderNo) {
        RestResponse listRestResponse = this.iOptLogQueryApi.queryByNoAndType(orderNo, OptBizTypeEnum.ORDER.getType());
        OrderLogRespDto orderLogRespDto = new OrderLogRespDto();
        if (listRestResponse != null && listRestResponse.getData() != null) {
            List optLogRespDtos = ((List)listRestResponse.getData()).stream().map(this::buildSupplierReturnItem).collect(Collectors.toList());
            orderLogRespDto.setOptLogList(optLogRespDtos);
        }
        try {
            OrderRespDto OrderRespDto1 = this.orderService.getSimpleOrderDetail(orderNo);
            orderLogRespDto.setOrderNo(OrderRespDto1.getOrderNo());
            orderLogRespDto.setOrderTradeStatus(OrderRespDto1.getOrderTradeStatus());
            orderLogRespDto.setOrderTradeStatusName(OrderTradeStatusEnum.toName((String)OrderRespDto1.getOrderTradeStatus()));
            orderLogRespDto.setPlaceType(OrderRespDto1.getPlaceType());
        }
        catch (Exception e) {
            logger.info("\u8f6c\u5316\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)orderNo));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        return orderLogRespDto;
    }

    public RefundOrderLogRespDto getReturnOrderLog(String returnNo) {
        RestResponse listRestResponse = this.iOptLogQueryApi.queryByNoAndType(returnNo, OptBizTypeEnum.RETURN.getType());
        RefundOrderLogRespDto orderLogRespDto = new RefundOrderLogRespDto();
        orderLogRespDto.setReturnNo(returnNo);
        if (listRestResponse != null && listRestResponse.getData() != null) {
            List optLogRespDtos = ((List)listRestResponse.getData()).stream().map(this::buildSupplierReturnItem).collect(Collectors.toList());
            orderLogRespDto.setOptLogList(optLogRespDtos);
        }
        try {
            ReFundOrderDetailRespDto OrderRespDto1 = this.returnOrderService.queryById(returnNo);
            orderLogRespDto.setOrderNo(OrderRespDto1.getOrderNo());
            orderLogRespDto.setOrderRefundStatus(OrderRespDto1.getOrderRefundStatus());
            orderLogRespDto.setOrderRefundStatusName(RefundOrderStatusToBEnum.toName((String)OrderRespDto1.getOrderRefundStatus()));
            orderLogRespDto.setOrderTradeStatus(OrderRespDto1.getOrderTradeStatus());
            orderLogRespDto.setOrderTradeStatusName(ReturnStatusToBEnum.toName((String)OrderRespDto1.getOrderTradeStatus()));
            orderLogRespDto.setPlaceType(OrderRespDto1.getPlaceType());
        }
        catch (Exception e) {
            logger.info("\u8f6c\u5316\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)returnNo));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        return orderLogRespDto;
    }

    private OptLogRespDto buildSupplierReturnItem(OptLogReqDto optLogReqDto) {
        OptLogRespDto optLogRespDto = new OptLogRespDto();
        optLogRespDto.setBizNo(optLogReqDto.getBizNo());
        optLogRespDto.setBizType(OptBizTypeEnum.valueOf((String)optLogReqDto.getBizType()).getDesc());
        optLogRespDto.setDescription(optLogReqDto.getDescription());
        String[] split = optLogReqDto.getDescription().split("\u91d1\u989d\uff1a");
        optLogRespDto.setAmount(split.length > 1 ? split[1] : "0");
        optLogRespDto.setId(optLogReqDto.getId());
        optLogRespDto.setOptPerson(optLogReqDto.getOptPerson());
        optLogRespDto.setOptTime(optLogReqDto.getOptTime());
        optLogRespDto.setOptType(optLogReqDto.getOptType());
        try {
            optLogRespDto.setOptTypeName(OptTypeEnum.valueOf((String)optLogReqDto.getOptType()).getDesc());
        }
        catch (Exception e) {
            logger.info("\u8f6c\u5316\u5931\u8d25,json---:" + JSONObject.toJSONString((Object)optLogReqDto));
            logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        return optLogRespDto;
    }
}

