/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl.scheduler.task;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.module.api.IConfig;
import com.dtyunxi.module.bo.ConfigItem;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DefaultValue;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryApi;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderBizRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.ITradeService;
import com.dtyunxi.yundt.module.trade.api.enums.OrderTradeStatusEnum;
import com.dtyunxi.yundt.module.trade.api.enums.PayStatusEnum;
import com.dtyunxi.yundt.module.trade.biz.ICommonService;
import com.dtyunxi.yundt.module.trade.biz.util.PageInfoUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OrderTask {
    private static Logger logger = LoggerFactory.getLogger(OrderTask.class);
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private ITradeService tradeService;
    @Resource
    private IContext context;
    @Resource
    private IOrderService orderService;
    @Resource(name="yundt.module.trade")
    private IConfig config;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IAfterSalesQueryApi afterSalesQueryApi;
    @Resource
    private ICommonService commonService;

    private Long getMaxId(PageInfo<OrderBizRespDto> pageInfo) {
        if (PageInfoUtil.isNotEmpty(pageInfo).booleanValue()) {
            int size = pageInfo.getList().size();
            return ((OrderBizRespDto)pageInfo.getList().get(size - 1)).getId();
        }
        return null;
    }

    public void autoComplete() {
        Integer days = this.getInteger("trade", "com.dtyunxi.yundt.module.trade.order.autoCompleteTime");
        days = this.checkDay(days, null, "\u3010tob\u5546\u57ce\u8ba2\u5355\u81ea\u52a8\u5b8c\u6210\u65f6\u95f4\u672a\u914d\u7f6e\uff0c\u9ed8\u8ba47\u5929\u3011", "tob\u5546\u57ce\u8ba2\u5355\u81ea\u52a8\u5b8c\u6210\u65f6\u95f4{}\u5929");
        this.queryAndComplete(days, null, null, null);
    }

    private Integer checkDay(Integer days, String value, String message, String log) {
        if (null == days) {
            days = 7;
            if (StringUtils.isNotEmpty((CharSequence)value) && "com.dtyunxi.yundt.module.trade.order.autoCompleteReturnTime".equals(value)) {
                days = 15;
            }
            logger.info(message);
        }
        logger.info(log, (Object)days);
        return days;
    }

    private void queryAndComplete(Integer days, Date startTime, Date endTime, Integer value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -days.intValue());
        Date autoCompleteTime = calendar.getTime();
        OrderQueryReqDto orderQueryReqDto = new OrderQueryReqDto();
        orderQueryReqDto.setInstanceId(this.context.instanceId());
        orderQueryReqDto.setTenantId(this.context.tenantId());
        orderQueryReqDto.setIsReturn(value);
        orderQueryReqDto.setOrderTradeStatus("ALL_DELIVERY");
        orderQueryReqDto.setIsContainItem(DefaultValue.NO);
        orderQueryReqDto.setEndTime(autoCompleteTime);
        orderQueryReqDto.setDataType(Integer.valueOf(3));
        Long maxId = Long.MAX_VALUE;
        Long totalNum = 0L;
        do {
            ArrayList sqlFilters = Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.lt((String)"id", (Object)maxId)});
            orderQueryReqDto.setSqlFilterList((List)sqlFilters);
            logger.info("\u8ba2\u5355\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)orderQueryReqDto));
            String filter = ObjectHelper.bean2Json((Object)orderQueryReqDto);
            PageInfo pageInfo = (PageInfo)this.orderBizQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1000)).getData();
            logger.info("\u8ba2\u5355\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
            this.complete(pageInfo.getList(), days);
            maxId = this.getMaxId((PageInfo<OrderBizRespDto>)pageInfo);
            totalNum = totalNum + (long)pageInfo.getList().size();
        } while (maxId != null);
        logger.info("\u672c\u6b21\u626b\u63cf\u8ba2\u5355\u603b\u6570\uff1a{}", (Object)totalNum);
    }

    private Integer getInteger(String group, String key) {
        Integer days = null;
        try {
            ConfigItem configItem = this.config.fetchOne(group, key);
            logger.info("\u81ea\u52a8\u5b8c\u6210\u83b7\u53d6\u65f6\u95f4\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)configItem));
            if (null != configItem && null != configItem.getValue()) {
                days = Integer.valueOf(configItem.getValue());
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u914d\u7f6e\u9879\u5931\u8d25", (Throwable)e);
        }
        return days;
    }

    private void complete(List<OrderBizRespDto> orderList, int days) {
        for (OrderBizRespDto order : orderList) {
            try {
                this.orderService.updateOrderDeliveryStatus(order.getTradeNo(), "CONFIRM");
                logger.info("\u3010\u8ba2\u5355\uff1a{}\uff0c\u81ea\u52a8\u5b8c\u6210\u3011", (Object)order.getTradeNo());
            }
            catch (Exception e) {
                logger.error("\u3010\u8ba2\u5355\u81ea\u52a8\u5b8c\u6210\u5f02\u5e38\uff1atradeNo={}\u3011", (Object)order.getTradeNo(), (Object)e);
            }
        }
    }

    public void autoCancel() {
        OrderQueryReqDto orderQueryReqDto = new OrderQueryReqDto();
        orderQueryReqDto.setInstanceId(this.context.instanceId());
        orderQueryReqDto.setTenantId(this.context.tenantId());
        orderQueryReqDto.setOrderTradeStatus(OrderTradeStatusEnum.WAIT_CS_AUDIT.getCode());
        orderQueryReqDto.setIsContainItem(DefaultValue.NO);
        Long maxId = 0L;
        Long totalNum = 0L;
        do {
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.gt((String)"id", (Object)maxId));
            sqlFilters.add(SqlFilter.eq((String)"payStatus", (Object)PayStatusEnum.WAIT_PAY.getCode()));
            orderQueryReqDto.setSqlFilterList((List)sqlFilters);
            String filter = ObjectHelper.bean2Json((Object)orderQueryReqDto);
            PageInfo pageInfo = (PageInfo)this.orderBizQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1000)).getData();
            this.cancel(pageInfo.getList());
            maxId = this.getMaxId((PageInfo<OrderBizRespDto>)pageInfo);
            totalNum = totalNum + (long)pageInfo.getList().size();
        } while (maxId != null);
        logger.info("\u672c\u6b21\u626b\u63cf\u8ba2\u5355\u603b\u6570\uff1a{}", (Object)totalNum);
    }

    private void cancel(List<OrderBizRespDto> orderList) {
        for (OrderBizRespDto order : orderList) {
            try {
                Date current = new Date();
                Long payEffectMillis = 0L;
                if (null == order.getCloseTime()) {
                    Integer payEffectiveTime = this.commonService.getEffectiveTime();
                    payEffectMillis = order.getPlaceTime().getTime() - current.getTime() + (long)(payEffectiveTime * 60 * 1000);
                } else {
                    payEffectMillis = order.getCloseTime().getTime() - current.getTime();
                }
                if (payEffectMillis > 0L) continue;
                this.orderService.autoCancelOrder(order.getOrderNo());
                logger.info("\u3010\u8ba2\u5355\uff1a{}\uff0c\u81ea\u52a8\u53d6\u6d88\u3011", (Object)order.getOrderNo());
            }
            catch (Exception e) {
                logger.error("\u3010\u8ba2\u5355\u81ea\u52a8\u53d6\u6d88\u5f02\u5e38\uff1atradeNo={}\u3011", (Object)order.getOrderNo(), (Object)e);
            }
        }
    }
}

