/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.util;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeliveryTypeEnum;
import com.dtyunxi.yundt.module.trade.api.dto.CustomerDeliveryTypeRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.DeliverMethodEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeliveryRuleUtils {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryRuleUtils.class);
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;

    public boolean isSellerDelivery(Long customerId) {
        logger.info("\u6821\u9a8c\u662f\u5426\u5546\u5bb6\u53d1\u8d27\uff0c\u5c0fb\u5ba2\u6237id\uff1a{}", (Object)customerId);
        boolean isSellerDelivery = customerId == null || this.isSellerDelivery((CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(customerId)));
        logger.info("isSellerDelivery={}", (Object)isSellerDelivery);
        return isSellerDelivery;
    }

    public boolean isSellerDelivery(List<Long> shopIds) {
        logger.info("\u6821\u9a8c\u662f\u5426\u5546\u5bb6\u53d1\u8d27\uff0c\u5e97\u94faid\uff1a{}", shopIds);
        if (CollectionUtils.isEmpty(shopIds)) {
            return true;
        }
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerRespDto(shopIds));
        boolean isSellerDelivery = CollectionUtils.isEmpty((Collection)customerRespDtos) || this.isSellerDelivery((CustomerRespDto)customerRespDtos.get(0));
        logger.info("isSellerDelivery={}", (Object)isSellerDelivery);
        return isSellerDelivery;
    }

    public boolean isSellerDelivery(CustomerRespDto customerRespDto) {
        logger.info("\u6821\u9a8c\u662f\u5426\u5546\u5bb6\u53d1\u8d27\uff0c\u5c0fb\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)customerRespDto));
        return customerRespDto == null || !DeliverMethodEnum.factory.getCode().equals(customerRespDto.getDeliverMethod()) || this.isSellerDelivery((SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(customerRespDto.getMerchantId())), customerRespDto);
    }

    private boolean isSellerDelivery(SellerRespDto sellerRespDto, CustomerRespDto customerRespDto) {
        if (sellerRespDto == null || customerRespDto == null) {
            logger.info("\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u5546\u5bb6\u53d1\u8d27");
            return true;
        }
        return !Integer.valueOf(1).equals(sellerRespDto.getIsFactoryDelivery());
    }

    public List<CustomerDeliveryTypeRespDto> getCurrLoginDelivery(List<Long> customerIds) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(customerIds)) {
            return list;
        }
        for (Long customerId : customerIds) {
            CustomerDeliveryTypeRespDto respDto = new CustomerDeliveryTypeRespDto();
            respDto.setCustomerId(customerId);
            Integer deliveryType = this.isSellerDelivery(customerId) ? OrderDeliveryTypeEnum.SELLER.getType() : OrderDeliveryTypeEnum.FACTORY.getType();
            respDto.setDeliveryType(deliveryType);
            list.add(respDto);
        }
        return list;
    }

    public boolean isSellerDeliveryWithSmallB(List<Long> shopIds) {
        logger.info("\u6821\u9a8c\u662f\u5426\u5546\u5bb6\u53d1\u8d27\uff0c\u5e97\u94faid\uff1a{}", shopIds);
        if (CollectionUtils.isEmpty(shopIds)) {
            return true;
        }
        List customerRespDtos = (List)RestResponseHelper.extractData(this.queryCustomerRespDto(shopIds));
        boolean isSellerDelivery = CollectionUtils.isEmpty((Collection)customerRespDtos) || this.isSellerDelivery((CustomerRespDto)customerRespDtos.get(0));
        logger.info("isSellerDelivery={}", (Object)isSellerDelivery);
        return isSellerDelivery;
    }

    public RestResponse<List<CustomerRespDto>> queryCustomerRespDto(List<Long> shopIds) {
        List customerRespDtos = Lists.newArrayList();
        String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNumeric((CharSequence)customerId) && !this.isSmallBLogin()) {
            logger.info("\u4e1a\u52a1\u5458\u7aef\uff1a{}", (Object)customerId);
            customerRespDtos.add(this.customerQueryApi.queryById(Long.valueOf(customerId)).getData());
        } else {
            if (CollectionUtils.isEmpty(shopIds)) {
                return new RestResponse((Object)customerRespDtos);
            }
            logger.info("h5\u7aef");
            HashSet<Long> shopIdSet = new HashSet<Long>(shopIds);
            List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(shopIdSet));
            ArrayList merchantIds = Lists.newArrayList();
            for (ShopDto shopDto : shopDtos) {
                merchantIds.add(shopDto.getOrganizationId());
            }
            String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
            logger.info("yes.req.cus.b2b.organizationid,{}", (Object)orgId);
            customerRespDtos = (List)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds((List)merchantIds, orgId != null ? Long.valueOf(orgId) : null).getData();
        }
        return new RestResponse((Object)customerRespDtos);
    }

    private boolean isSmallBLogin() {
        String isSmallBStr = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.smallb");
        boolean isSmallB = "true".equals(isSmallBStr);
        logger.info("\u662f\u5426\u5c0fb\u89d2\u8272\u767b\u5f55\uff1aisSmallBStr={}, isSmallB={}", (Object)isSmallBStr, (Object)isSmallB);
        return isSmallB;
    }
}

