/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl.action;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiftConfigRangeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GivePriceTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiveTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.SwitchEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.ItemSkuListQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftConfigBaseRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.ItemSkuListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftConfigQueryApi;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.GiftInfoRespDto;
import com.dtyunxi.yundt.module.trade.biz.impl.action.AbstractAction;
import com.dtyunxi.yundt.module.trade.biz.impl.action.ActionContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GiveAction
extends AbstractAction {
    private final IGiftConfigQueryApi giftConfigQueryApi = (IGiftConfigQueryApi)SpringBeanUtil.getBean(IGiftConfigQueryApi.class);

    @Override
    protected void start(ActionContext actionContext) {
        BalanceDetailRespDto account = this.getAccount(actionContext);
        if (Objects.equals(SwitchEnum.OFF.getCode(), account.getGiveFlag())) {
            return;
        }
        GiftConfigBaseRespDto configBase = this.getConfigBase(actionContext);
        GiftInfoRespDto info = this.getInfo(actionContext);
        ItemSkuListQueryReqDto dto = new ItemSkuListQueryReqDto();
        dto.setShopId(actionContext.getContentData("shop", Long.class));
        List<OrderItemInfoDto> item = this.getItem(actionContext);
        HashSet set = Sets.newHashSet();
        item.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getGiftSkuIds())) {
                Stream.of(x.getGiftSkuIds().split(",")).forEach(y -> set.add(Long.valueOf(y)));
            }
        });
        PageInfo skuList = (PageInfo)RestResponseHelper.extractData((RestResponse)this.giftConfigQueryApi.getSkuList(dto, Integer.valueOf(1), Integer.valueOf(1000)));
        List items = item.stream().filter(x -> Objects.equals(1, x.getItemType())).filter(x -> {
            if (Objects.nonNull(skuList) && CollectionUtils.isNotEmpty((Collection)skuList.getList())) {
                for (ItemSkuListRespDto itemSkuListRespDto : skuList.getList()) {
                    if (!Objects.equals(itemSkuListRespDto.getSkuId(), x.getSkuId())) continue;
                    return false;
                }
            }
            return true;
        }).filter(x -> {
            if (CollectionUtils.isNotEmpty((Collection)configBase.getRebateRangeList()) && configBase.getRebateRangeList().contains(GiftConfigRangeEnum.RANGE_SECTION.getCode())) {
                return !set.contains(x.getSkuId());
            }
            return true;
        }).map(OrderItemInfoDto::getSkuId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        if (Objects.equals(account.getGiveType(), GiveTypeEnum.PROPORTION.getCode())) {
            item.stream().filter(x -> items.contains(x.getSkuId())).forEach(x -> x.setAddAmount(BigDecimal.valueOf(x.getItemNum().intValue()).multiply(account.getQuantityScaleAmount()).setScale(4, 5).divide(account.getQuantityScaleSum(), 4, 5).multiply(account.getGiveProportion()).setScale(2, 5).divide(BigDecimal.valueOf(100L), 2, 5)));
        } else {
            item.stream().filter(x -> items.contains(x.getSkuId())).forEach(x -> {
                boolean discountFlag = Objects.equals(account.getGivePriceType(), GivePriceTypeEnum.DISCOUNT_PRICE.getCode());
                boolean selectDiscount = CollectionUtils.isNotEmpty((Collection)configBase.getRebateRangeList()) && configBase.getRebateRangeList().contains(GiftConfigRangeEnum.RANGE_THREE.getCode());
                boolean discount = discountFlag || selectDiscount;
                BigDecimal totalPrice = x.getSellPrice().multiply(BigDecimal.valueOf(x.getItemNum().intValue())).setScale(2, 5);
                if (discount) {
                    totalPrice = totalPrice.subtract(Optional.ofNullable(x.getDiscountPrice()).orElse(BigDecimal.ZERO));
                }
                if (CollectionUtils.isNotEmpty((Collection)configBase.getRebateRangeList()) && configBase.getRebateRangeList().contains(GiftConfigRangeEnum.RANGE_FRIST.getCode())) {
                    totalPrice = totalPrice.subtract(Optional.ofNullable(x.getDiscountTotalAmount()).orElse(BigDecimal.ZERO));
                }
                x.setAddAmount(totalPrice.multiply(account.getGiveProportion()).setScale(2, 5).divide(BigDecimal.valueOf(100L), 2, 5));
            });
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (OrderItemInfoDto orderItemInfoDto : item) {
            if (!Objects.nonNull(orderItemInfoDto.getAddAmount())) continue;
            totalAmount = totalAmount.add(orderItemInfoDto.getAddAmount());
        }
        info.setAddAmount(totalAmount);
    }
}

