/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.OrderStatusChangeOrderDetailDto;
import com.dtyunxi.yundt.module.trade.biz.ILocalCacheService;
import com.dtyunxi.yundt.module.trade.biz.ISeckillService;
import com.dtyunxi.yundt.module.trade.biz.util.KeyGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SeckillServiceImpl
implements ISeckillService {
    private static Logger logger = LoggerFactory.getLogger(SeckillServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private IOrderQueryApi orderQueryApi;
    @Resource
    ILocalCacheService localCacheService;
    @Value(value="${spring.profiles.active:dev}")
    private String profile;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;

    @Override
    public void rollbackUserJoinActivityNum(Long customerId, List<OrderStatusChangeOrderDetailDto.OrderActivityInfoReqDto> activityInfoReqDtos) {
        if (CollectionUtils.isEmpty(activityInfoReqDtos)) {
            return;
        }
        String pfile = StrUtil.isBlank((CharSequence)this.globalProfile) ? this.profile : this.globalProfile;
        activityInfoReqDtos.forEach(activity -> {
            Long joinNum = this.cacheService.hincrBy("yundt-cube-center-common-" + pfile, KeyGenerator.getCustomerJoinActivityNumKey(activity.getActivityId()), customerId.toString(), -1);
            logger.info("\u3010activityId={},customerId={}, \u53c2\u4e0e\u6d3b\u52a8\u6b21\u6570-1\uff0c\u5f53\u524d\u53c2\u4e0e\u6b21\u6570={}\u3011", new Object[]{activity.getActivityId(), customerId, joinNum});
        });
    }

    @Override
    public void rollBackStock(Long activityId, String tradeNo) {
        RestResponse orderDetail = this.orderQueryApi.getOrderDetail(tradeNo);
        OrderDetailRespDto orderDetailRespDto = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)orderDetail);
        logger.info("\u53d6\u6d88\u8ba2\u5355activityId={},tradeNo={},\u589e\u52a0\u5e93\u5b58", (Object)activityId, (Object)tradeNo);
        List orderItems = orderDetailRespDto.getOrderItems();
        for (TradeItemRespDto tradeItemRespDto : orderItems) {
            this.localCacheService.removeStockEmptyFlag(activityId, Long.valueOf(tradeItemRespDto.getSkuSerial()), Long.valueOf(tradeItemRespDto.getShopId()));
        }
    }
}

