/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.rest;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.AuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.GiftAccountReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnConfirmRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ApplyReturnItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.ReturnOrderStatusCountRespDto;
import com.dtyunxi.yundt.module.trade.api.ILogService;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.IReturnOrderService;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.NullifyOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderAuditToBReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReFundOrderReceiveSaveReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReFundOrderReceiveSaveToBReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.RefundRecordSaveReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderPageSearchReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderSaveReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderSaveTempReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderUpdateReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ReturnItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderDeliveredRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.PayMethodRecordRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReFundOrderDetailExcelDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReFundOrderDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReceiveDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.RefundOrderLogRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReturnOrderItemExcelDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReturnOrderPayRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReturnOrderRespDto;
import com.dtyunxi.yundt.module.trade.biz.util.EasyPoiExportUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8ba2\u8d27\u7ba1\u7406\uff1a\u9000\u8ba2\u5355\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/returnOrder"})
public class ReturnOrderRest {
    private static final Logger logger = LoggerFactory.getLogger(ReturnOrderRest.class);
    @Resource
    private ILogService logService;
    @Autowired
    private IReturnOrderService returnOrderService;
    @Autowired
    private IOrderService orderService;

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u9000\u8ba2\u5355\u7ba1\u7406", notes="\u5206\u9875\u67e5\u8be2\u9000\u8ba2\u5355\u7ba1\u7406")
    public RestResponse<PageInfo<ReturnOrderRespDto>> pageReturnOrder(@Valid ReturnOrderPageSearchReqDto addressQueryReqDto, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        PageInfo returnOrderRespDtoPageInfo = this.returnOrderService.pageReturnOrder(addressQueryReqDto, pageNum, pageSize);
        return new RestResponse((Object)returnOrderRespDtoPageInfo);
    }

    @GetMapping(value={"/count"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u9000\u8ba2\u5355\u7ba1\u7406\u7684\u6570\u91cf", notes="\u5206\u9875\u67e5\u8be2\u9000\u8ba2\u5355\u7ba1\u7406\u6570\u91cf")
    public RestResponse<ReturnOrderStatusCountRespDto> countReturnOrder(@Valid ReturnOrderPageSearchReqDto addressQueryReqDto) {
        return this.returnOrderService.countReturnOrder(addressQueryReqDto);
    }

    @GetMapping(value={"/{returnNo}"})
    @ApiOperation(value="\u9000\u8ba2\u5355\u8be6\u60c5", notes="\u6839\u636e[\u9000\u8ba2\u5355returnNo]\u67e5\u8be2\u9000\u8ba2\u5355\u8be6\u60c5")
    RestResponse<ReFundOrderDetailRespDto> queryById(@PathVariable(value="returnNo") @NotNull String returnNo) {
        ReFundOrderDetailRespDto reFundOrderDetailRespDto1 = this.returnOrderService.queryById(returnNo);
        return new RestResponse((Object)reFundOrderDetailRespDto1);
    }

    @GetMapping(value={"/exportReturnOrderItemInfo/{returnNo}"})
    @ApiOperation(value="\u5bfc\u51fa\u9000\u8ba2\u5355\u8be6\u60c5\u5217\u8868", notes="\u6839\u636e[\u9000\u8ba2\u5355returnNo]\u5bfc\u51fa\u9000\u8ba2\u5355\u8be6\u60c5\u5217\u8868")
    public RestResponse<Object> exportReturnOrderItemInfoGet(@PathVariable(value="returnNo") @NotNull String returnNo) {
        block11: {
            ReFundOrderDetailRespDto orderDetailRespDto = this.returnOrderService.queryById(returnNo);
            try {
                String exportUrl;
                if (CollectionUtils.isEmpty((Collection)orderDetailRespDto.getApplyReturnItemRespDtoList())) break block11;
                ArrayList rList = Lists.newArrayList();
                ReturnOrderItemExcelDto returnOrderItemExcelDto = null;
                String excelName = null;
                List itemList = orderDetailRespDto.getApplyReturnItemRespDtoList();
                for (ApplyReturnItemRespDto itemRespDto : itemList) {
                    returnOrderItemExcelDto = new ReturnOrderItemExcelDto();
                    returnOrderItemExcelDto.setItemCode(itemRespDto.getItemCode());
                    returnOrderItemExcelDto.setItemName(itemRespDto.getItemName());
                    Integer subType = itemRespDto.getSubType();
                    if (subType == 1) {
                        returnOrderItemExcelDto.setItemTypeName("\u4ea7\u54c1");
                    } else if (subType == 2) {
                        returnOrderItemExcelDto.setItemTypeName("\u8d60\u54c1");
                    } else if (subType == 3) {
                        returnOrderItemExcelDto.setItemTypeName("\u7269\u6599");
                    } else {
                        returnOrderItemExcelDto.setItemTypeName("");
                    }
                    returnOrderItemExcelDto.setSkuDesc(itemRespDto.getSkuDesc());
                    returnOrderItemExcelDto.setTradeNo(itemRespDto.getTradeNo());
                    returnOrderItemExcelDto.setReturnNum(itemRespDto.getReturnNum());
                    returnOrderItemExcelDto.setUnitName(itemRespDto.getUnitName());
                    returnOrderItemExcelDto.setBatchNo(itemRespDto.getBatchNo());
                    returnOrderItemExcelDto.setItemMarketPrice(itemRespDto.getItemMarketPrice());
                    returnOrderItemExcelDto.setPromotionPrice(itemRespDto.getPromotionPrice());
                    returnOrderItemExcelDto.setEachShareAmount(itemRespDto.getEachShareAmount());
                    returnOrderItemExcelDto.setEachDiscountAmount(itemRespDto.getEachDiscountAmount());
                    returnOrderItemExcelDto.setEachGiftDeductionAmount(itemRespDto.getEachGiftDeductionAmount());
                    returnOrderItemExcelDto.setItemAmount(itemRespDto.getItemAmount());
                    returnOrderItemExcelDto.setSubTotalReturnAmount(itemRespDto.getSubTotalReturnAmount());
                    returnOrderItemExcelDto.setRefundAmount(itemRespDto.getRefundAmount());
                    returnOrderItemExcelDto.setRemark(itemRespDto.getRemark());
                    rList.add(returnOrderItemExcelDto);
                }
                excelName = "cube/" + orderDetailRespDto.getCustomerName() + "-\u9000\u8ba2\u5355\u8be6\u60c5-" + DateUtil.getDateFormat((Date)DateUtil.parseDate((String)orderDetailRespDto.getBuildOrderDetail().getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyyMMddHHmmss");
                try {
                    exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, ReturnOrderItemExcelDto.class, null, (String)excelName, (String)"xls");
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u51fa\u9000\u8ba2\u5355\u8be6\u60c5-\u9519\u8bef:{}", (Object)e.toString());
                    return new RestResponse("-1", "\u5bfc\u51fa\u9000\u8ba2\u5355\u8be6\u60c5-\u9519\u8bef:" + e);
                }
                return new RestResponse("0", "\u5bfc\u51fa\u9000\u8ba2\u5355\u8be6\u60c5\u6210\u529f", (Object)exportUrl);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new RestResponse("-1", "\u5bfc\u51fa\u5931\u8d25", null);
    }

    @PostMapping(value={"/exportReturnOrderItemInfo/{returnNo}"})
    @ApiOperation(value="\u5bfc\u51fa\u9000\u8ba2\u5355\u8be6\u60c5\u5b9e\u9000\u590d\u6838\u7ed3\u679c", notes="\u6839\u636e[\u9000\u8ba2\u5355returnNo]\u5bfc\u51fa\u9000\u8ba2\u5355\u8be6\u60c5\u5b9e\u9000\u590d\u6838\u7ed3\u679c")
    public RestResponse<Object> exportReturnOrderItemInfoPost(@PathVariable(value="returnNo") @NotNull String returnNo) {
        block7: {
            ReFundOrderDetailRespDto orderDetailRespDto = this.returnOrderService.queryById(returnNo);
            try {
                String exportUrl;
                if (CollectionUtils.isEmpty((Collection)orderDetailRespDto.getApplyReturnItemRespDtoList())) break block7;
                ArrayList rList = Lists.newArrayList();
                ReFundOrderDetailExcelDto detailExcelDto = null;
                String excelName = null;
                List itemDetails = orderDetailRespDto.getReturnItemDetail();
                Map<String, List<ReFundOrderDetailRespDto.ItemDetail>> map = itemDetails.stream().collect(Collectors.groupingBy(ReFundOrderDetailRespDto.ItemDetail::getItemCode));
                for (Map.Entry<String, List<ReFundOrderDetailRespDto.ItemDetail>> entry : map.entrySet()) {
                    detailExcelDto = new ReFundOrderDetailExcelDto();
                    String itemCode = entry.getKey();
                    List<ReFundOrderDetailRespDto.ItemDetail> list = entry.getValue();
                    ReFundOrderDetailRespDto.ItemDetail detail = list.get(0);
                    logger.info("\u5bfc\u51fa\u9000\u8ba2\u5355\u8be6\u60c5\u5b9e\u9000\u590d\u6838\u7ed3\u679c,\u8ba2\u5355\u53f7:{}\u5546\u54c1\u7f16\u7801:{}\u8be6\u60c5{}", new Object[]{orderDetailRespDto.getReturnNo(), detail.getItemCode(), JSONObject.toJSONString(list)});
                    detailExcelDto.setItemCode(itemCode);
                    detailExcelDto.setItemName(detail.getItemName());
                    detailExcelDto.setItemTypeName(detail.getItemTypeName());
                    detailExcelDto.setSkuName(detail.getSkuName());
                    detailExcelDto.setTradeNo(detail.getTradeNo());
                    detailExcelDto.setUnitName(detail.getUnitName());
                    detailExcelDto.setRetailPrice(detail.getRetailPrice());
                    detailExcelDto.setPromotionPrice(detail.getPromotionPrice());
                    detailExcelDto.setEachShareAmount(detail.getEachShareAmount());
                    detailExcelDto.setEachGiftDeductionAmount(detail.getEachGiftDeductionAmount());
                    detailExcelDto.setEachDiscountAmount(detail.getEachDiscountAmount());
                    detailExcelDto.setItemPrice(detail.getItemPrice());
                    detailExcelDto.setRemark(detail.getRemark());
                    StringBuilder batchNo = new StringBuilder();
                    StringBuilder isAllowReturn = new StringBuilder();
                    StringBuilder returnAmount = new StringBuilder();
                    Integer num = 0;
                    BigDecimal subTotalReturnAmount = new BigDecimal("0.00");
                    for (int i = 0; i < list.size(); ++i) {
                        ReFundOrderDetailRespDto.ItemDetail itemDetail = list.get(i);
                        batchNo.append(itemDetail.getBatchNo()).append(" ;");
                        isAllowReturn.append(itemDetail.getIsAllowReturn() == 0 ? "\u4e0d\u5141\u8bb8\u9000" : "\u5141\u8bb8\u9000").append(" ;");
                        returnAmount.append(itemDetail.getItemPrice()).append(" ;");
                        subTotalReturnAmount = subTotalReturnAmount.add(itemDetail.getSubTotal());
                        if (list.size() == i + 1) {
                            batchNo.deleteCharAt(batchNo.length() - 1);
                            isAllowReturn.deleteCharAt(isAllowReturn.length() - 1);
                            returnAmount.deleteCharAt(returnAmount.length() - 1);
                        }
                        num = num + itemDetail.getNum();
                        detailExcelDto.setReturnAmount(returnAmount.toString());
                        detailExcelDto.setBatchNo(batchNo.toString());
                        detailExcelDto.setIsAllowReturn(isAllowReturn.toString());
                        detailExcelDto.setSubTotalReturnAmount(subTotalReturnAmount);
                    }
                    detailExcelDto.setItemNum(num);
                    rList.add(detailExcelDto);
                }
                excelName = "cube/" + orderDetailRespDto.getCustomerName() + "-\u5b9e\u9000\u590d\u6838\u7ed3\u679c-" + DateUtil.getDateFormat((Date)DateUtil.parseDate((String)orderDetailRespDto.getBuildOrderDetail().getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyyMMddHHmmss");
                try {
                    exportUrl = EasyPoiExportUtil.getExportUrl((List)rList, ReFundOrderDetailExcelDto.class, null, (String)excelName, (String)"xls");
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u51fa\u5b9e\u9000\u590d\u6838\u7ed3\u679c-\u9519\u8bef:{}", (Object)e.toString());
                    return new RestResponse("-1", "\u5bfc\u51fa\u5b9e\u9000\u590d\u6838\u7ed3\u679c-\u9519\u8bef:" + e);
                }
                return new RestResponse("0", "\u5bfc\u51fa\u5b9e\u9000\u590d\u6838\u7ed3\u679c\u6210\u529f", (Object)exportUrl);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new RestResponse("-1", "\u5bfc\u51fa\u5931\u8d25", null);
    }

    @GetMapping(value={"disabled/{id}"})
    @ApiOperation(value="\u9000\u8ba2\u5355\u4f5c\u5e9f\u63a5\u53e3", notes="\u6839\u636e[\u9000\u8ba2\u5355id]\u9000\u8ba2\u5355\u4f5c\u5e9f\u63a5\u53e3")
    RestResponse<Void> disabledById(@PathVariable(value="id") @NotNull Long id) {
        return new RestResponse(null);
    }

    @PutMapping(value={"/{payNo}/abandon"})
    @ApiOperation(value="\u5e9f\u5f03\u6536\u8d39\u8bb0\u5f55", notes="\u5e9f\u5f03\u6536\u8d39\u8bb0\u5f55")
    RestResponse<Void> abandonPayRecord(@PathVariable(value="payNo") String payNo) {
        this.returnOrderService.abandonPayRecord(payNo);
        return RestResponse.VOID;
    }

    @RequestMapping(value={"add"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u9000\u8ba2\u5355", notes="\u65b0\u589e\u9000\u8ba2\u5355\uff1a\u9488\u5bf9\u5df2\u7b7e\u6536\u5e76\u4e14\u6709\u672a\u9000\u8d27\u7684\u5546\u54c1\uff0c\u4fbf\u53ef\u652f\u6301\u9000\u8ba2\u5355")
    RestResponse<Void> addReturnOrder(@Valid @RequestBody ReturnOrderSaveReqDto returnOrderItemSaveReqDto) {
        this.returnOrderService.addReturnOrder(returnOrderItemSaveReqDto);
        return new RestResponse();
    }

    @RequestMapping(value={"update"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7f16\u8f91\u9000\u8d27\u5355", notes="\u7f16\u8f91\u9000\u8d27\u5355\uff1a\u9488\u5bf9\u5df2\u7b7e\u6536\u5e76\u4e14\u6709\u672a\u9000\u8d27\u7684\u5546\u54c1\uff0c\u4fbf\u53ef\u652f\u6301\u9000\u8ba2\u5355")
    RestResponse<Void> update(@Valid @RequestBody ReturnOrderUpdateReqDto re) {
        this.returnOrderService.updateReturnOrder(re);
        return new RestResponse();
    }

    @PostMapping(value={"/nullify-order"})
    @ApiOperation(value="\u4f5c\u5e9f\u8ba2\u5355(\u5df2\u5b8c\u6210)", notes="\u4f5c\u5e9f\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="NullifyOrderReqDto", value="\u4f5c\u5e9f\u8ba2\u5355", dataType="NullifyOrderReqDto", paramType="body", required=true)})
    public RestResponse<Void> nullifyOrder(@Valid @RequestBody NullifyOrderReqDto nullifyOrderReqDto) {
        this.returnOrderService.cancelByReturn(nullifyOrderReqDto);
        return RestResponse.VOID;
    }

    @RequestMapping(value={"add-temporary"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6682\u5b58\u9000\u8ba2\u5355", notes="\u6682\u5b58\u9000\u8ba2\u5355\uff1a\u9488\u5bf9\u5df2\u7b7e\u6536\u5e76\u4e14\u6709\u672a\u9000\u8d27\u7684\u5546\u54c1\uff0c\u4fbf\u53ef\u652f\u6301\u9000\u8ba2\u5355")
    RestResponse<Long> addTempReturnOrderSave(@Valid @RequestBody ReturnOrderSaveTempReqDto returnOrderItemSaveReqDto) {
        return new RestResponse(null);
    }

    @ApiOperation(value="\u9000\u8ba2\u5355\u5ba1\u6838(\u5df2\u5b8c\u6210)")
    @ApiImplicitParam(name="orderAuditReqDto", dataType="OrderAuditReqDto", paramType="body", required=true, value="\u5ba1\u6838\u8ba2\u5355\u53c2\u6570")
    @PostMapping(value={"/audit-order"})
    public RestResponse<Void> auditOrder(@Valid @RequestBody OrderAuditToBReqDto orderAuditToBReqDto) {
        this.returnOrderService.auditOrder(orderAuditToBReqDto);
        return RestResponse.VOID;
    }

    @RequestMapping(value={"audit"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ApiOperation(value="\u5ba1\u6838\u9000\u8ba2\u5355", notes="\u7ba1\u7406\u5458\u5ba1\u6838\u9000\u8ba2\u5355,\u4ec5\u652f\u6301\u4fee\u6539\u9000\u8d27\u6570\u91cf\u3001\u5546\u54c1\u5907\u6ce8\u3001\u5b9e\u9645\u9000\u6b3e\u91d1\u989d\u3001\u4fee\u6539\u9000\u8d27\u5355\u5907\u6ce8\u3001\u9644\u4ef6")
    RestResponse<Long> auditUpdate(@Valid @RequestBody ReturnOrderUpdateReqDto returnOrderUpdateReqDto) {
        return new RestResponse(null);
    }

    @RequestMapping(value={"receive/{returnNo}"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5165\u5e93\u6536\u8d27\u8bb0\u5f55", notes="\u6839\u636e[\u9000\u8ba2\u5355returnNo]\u83b7\u53d6\u9000\u8ba2\u5355\u7684\u9000\u8d27\u5165\u5e93\u4fe1\u606f")
    RestResponse<ReceiveDetailRespDto> findReceiveDetailById(@PathVariable(value="returnNo") @NotNull(message="returnNo\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="returnNo\u4e0d\u80fd\u4e3a\u7a7a") String returnNo) {
        ReceiveDetailRespDto mgmtDeliveryRecord = this.returnOrderService.findReceiveDetailById(returnNo);
        return new RestResponse((Object)mgmtDeliveryRecord);
    }

    @PostMapping(value={"/receive/add"})
    @ApiOperation(value="\u9000\u8d27\u5546\u54c1\u5165\u5e93\u63a5\u53e3")
    public RestResponse<Void> addReFundOrderReceive(@Valid @RequestBody ReFundOrderReceiveSaveReqDto reFundOrderReceiveSaveReqDto) {
        this.returnOrderService.addReFundOrderReceive(reFundOrderReceiveSaveReqDto);
        return RestResponse.VOID;
    }

    @GetMapping(value={"log/{returnNo}"})
    @ApiOperation(value="\u83b7\u53d6\u9000\u8ba2\u5355\u65e5\u5fd7", notes="\u6839\u636e[\u9000\u8ba2\u5355id]\u83b7\u53d6\u8be6\u60c5")
    RestResponse<RefundOrderLogRespDto> findReturnOrderLogById(@PathVariable(value="returnNo") @NotNull String returnNo) {
        RefundOrderLogRespDto orderLogRespDto = this.logService.getReturnOrderLog(returnNo);
        return new RestResponse((Object)orderLogRespDto);
    }

    @PostMapping(value={"log/refund/audit"})
    @ApiOperation(value="\u9000\u6b3e\u5ba1\u6838", notes="\u6839\u636e[\u9000\u8ba2\u5355id]\u5bf9\u7b26\u5408\u6761\u4ef6\u7684\u8ba2\u5355\u8fdb\u884c\u9000\u6b3e\u5ba1\u6838")
    RestResponse<Void> auditOrderAndRefund(@PathVariable(value="id") @NotNull Long id) {
        return RestResponse.VOID;
    }

    @GetMapping(value={"page/return-log"})
    @ApiOperation(value="\u83b7\u53d6\u9000\u6b3e\u8bb0\u5f55\u5206\u9875", notes="\u6839\u636e[\u9000\u8ba2\u5355ID]\u83b7\u53d6\u9000\u6b3e\u8bb0\u5f55\u8bb0\u5f55\u5206\u9875\u4ec5\u652f\u6301\u5206\u9875,\u4e0d\u652f\u6301\u641c\u7d22")
    RestResponse<Void> pageReturnLogById(@PathVariable(value="id") @NotNull Long id, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return new RestResponse(null);
    }

    @GetMapping(value={"/return-record/{returnNo}"})
    @ApiOperation(value="\u67e5\u8be2\u9000\u8ba2\u5355\u9000\u6b3e\u8bb0\u5f55\uff08\u540e\u53f0\uff09")
    @ApiImplicitParam(name="returnNo", dataType="String", paramType="path", required=true, value="\u9000\u8ba2\u5355\u53f7")
    public RestResponse<ReturnOrderPayRespDto> getMgmtPayRecord(@PathVariable(value="returnNo") String returnNo) {
        ReturnOrderPayRespDto returnOrderPayRespDto = this.returnOrderService.getMgmtPayRecord(returnNo);
        return new RestResponse((Object)returnOrderPayRespDto);
    }

    @GetMapping(value={"/method-list/{orderNo}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNo", value="\u8ba2\u5355\u6d41\u6c34\u53f7 ", dataType="String", paramType="path", required=true)})
    @ApiOperation(value="\u6839\u636e\u8ba2\u5355\u6d41\u6c34\u53f7\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5bf9\u5e94\u7684\u652f\u4ed8\u8bb0\u5f55", notes="\u6839\u636e\u8ba2\u5355\u6d41\u6c34\u53f7\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5bf9\u5e94\u7684\u652f\u4ed8\u8bb0\u5f55")
    RestResponse<List<PayMethodRecordRespDto>> queryPayMethodRecordByOrderNo(@PathVariable(value="orderNo") String orderNo) {
        List list = this.orderService.queryPayMethodRecordByOrderNo(orderNo);
        return new RestResponse((Object)list);
    }

    @GetMapping(value={"/return_rule/{orderNo}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNo", value="\u8ba2\u5355\u53f7 ", dataType="String", paramType="path", required=true)})
    @ApiOperation(value="\u6839\u636e\u8ba2\u5355\u6d41\u6c34\u53f7\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5bf9\u5e94\u7684\u652f\u4ed8\u8bb0\u5f55,\u4ee5\u53ca\u6839\u636e\u9000\u6b3e\u4f18\u5148\u7ea7\u914d\u7f6e\u83b7\u53d6\u53ef\u9000\u7684\u6570\u91cf\u53ca\u91d1\u989d", notes="\u6839\u636e\u8ba2\u5355\u6d41\u6c34\u53f7\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5bf9\u5e94\u7684\u652f\u4ed8\u8bb0\u5f55,\u4ee5\u53ca\u6839\u636e\u9000\u6b3e\u4f18\u5148\u7ea7\u914d\u7f6e\u83b7\u53d6\u53ef\u9000\u7684\u6570\u91cf\u53ca\u91d1\u989d")
    RestResponse<List<PayMethodRecordRespDto>> queryPayMethodRecordAndConfigByOrderNo(@PathVariable(value="orderNo") String orderNo, @RequestParam(value="returnNo") String returnNo) {
        List list = this.orderService.queryPayMethodRecordAndConfigByOrderNo(orderNo, returnNo);
        return new RestResponse((Object)list);
    }

    @PostMapping(value={"/pay-record"})
    @ApiOperation(value="\u6dfb\u52a0\u9000\u6b3e\u8bb0\u5f55")
    public RestResponse<Void> addRefundRecord(@Valid @RequestBody RefundRecordSaveReqDto refundRecordSaveReqDto) {
        this.orderService.addRefundRecord(refundRecordSaveReqDto);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/confirm-refund"})
    @ApiOperation(value="\u786e\u8ba4\u9000\u6b3e", notes="\u786e\u8ba4\u9000\u6b3e")
    RestResponse<Void> confirmRefund(@Valid @RequestBody ReFundOrderReceiveSaveToBReqDto returnConfirmRefundReqDto) {
        this.returnOrderService.confirmRefund(returnConfirmRefundReqDto);
        return RestResponse.VOID;
    }

    @DeleteMapping(value={"/remove-refund"})
    @ApiOperation(value="\u5220\u9664\u9000\u6b3e\u5355", notes="\u5220\u9664\u9000\u6b3e\u5355")
    RestResponse<Void> removeRefund(@RequestBody ReturnConfirmRefundReqDto returnConfirmRefundReqDto) {
        this.returnOrderService.removeRefund(returnConfirmRefundReqDto);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/mgmt/delivered-record/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5df2\u5165\u5e93/\u6536\u8d27\u8bb0\u5f55\u5217\u8868\uff08\u540e\u53f0\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", dataType="String", paramType="query", value="\u5173\u952e\u5b57(\u5165\u5e93\u5355\u53f7/\u6765\u6e90\u5355\u53f7/\u4ed3\u5e93)"), @ApiImplicitParam(name="returnNo", dataType="String", paramType="query", required=true, value="\u9000\u8ba2\u5355\u53f7"), @ApiImplicitParam(name="pageNum", dataType="Int", paramType="query", required=true, value="\u5f53\u524d\u9875"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query", required=true, value="\u9875\u9762\u5927\u5c0f")})
    public RestResponse<PageInfo<OrderDeliveredRespDto>> getMgmtReceivedRecordPage(@RequestParam(value="keyword", required=false) String keyword, @RequestParam(value="returnNo") String returnNo, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.returnOrderService.getMgmtReceivedRecordPage(keyword, returnNo, pageNum, pageSize));
    }

    @GetMapping(value={"/mgmt/order-detail/{orderNo}"})
    @ApiOperation(value="\u9000\u8ba2\u5355\u4e2d\u67e5\u8be2\u8ba2\u8d27\u5355\u8be6\u60c5\uff08\u540e\u53f0\uff09")
    @ApiImplicitParam(name="orderNo", dataType="String", paramType="path", required=true, value="\u8ba2\u8d27\u5355\u53f7")
    public RestResponse<OrderRespDto> getMgmtOrderDetail(@PathVariable(value="orderNo") String orderNo) {
        OrderRespDto orderRespDto1 = this.orderService.getMgmtOrderDetail(orderNo);
        return new RestResponse((Object)orderRespDto1);
    }

    @PostMapping(value={"/mgmt/aduit"})
    @ApiOperation(value="\u7ec4\u5408\u652f\u4ed8\u9000\u6b3e\u5ba1\u6279")
    public RestResponse<Void> aduit(@RequestBody AuditReqDto auditReqDto) {
        this.returnOrderService.aduit(auditReqDto);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/modify/itemOrigPrice"})
    @ApiOperation(value="\u4fee\u6539\u9000\u8d27\u5546\u54c1\u9500\u552e\u4ef7(\u4ec5\u4fee\u6539\u9500\u552e\u4ef7)")
    public RestResponse<Void> modifyItemOrigPriceById(@RequestParam(value="id") Long id, @RequestParam(value="itemOrigPrice") BigDecimal itemOrigPrice) {
        this.returnOrderService.modifyItemOrigPriceById(id, itemOrigPrice);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/return-item/page"})
    @ApiOperation(value="\u67e5\u8be2\u552e\u540e\u5546\u54c1\u660e\u7ec6", notes="\u67e5\u8be2\u552e\u540e\u5546\u54c1\u660e\u7ec6")
    RestResponse<PageInfo<ReturnItemRespDto>> queryReturnItemByPage(ReturnQueryReqDto returnQueryReqDto, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        return this.returnOrderService.queryReturnItemByPage(returnQueryReqDto, pageNum, pageSize);
    }

    @PostMapping(value={"/refund/gift"})
    @ApiOperation(value="\u8ba1\u7b97\u8d60\u54c1\u989d\u5ea6\u9000\u6b3e", notes="\u8ba1\u7b97\u8d60\u54c1\u989d\u5ea6\u9000\u6b3e")
    RestResponse<BigDecimal> giftRefund(@RequestBody @Valid GiftAccountReqDto dto) {
        return new RestResponse((Object)this.returnOrderService.giftRefund(dto));
    }
}

