/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageExtDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationBatchReqDto;
import com.dtyunxi.yundt.module.bitem.biz.service.IBInventoryService;
import com.dtyunxi.yundt.module.trade.api.IinventoryService;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.QueryBatchReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.inventory.DeliveryItemLogisticsRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.inventory.DeliveryItemRecordRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.inventory.DeliveryItemRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e93\u5b58\u7ec4\u4ef6\uff1a\u53d1\u8d27\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/inventory"})
public class InventoryRest {
    @Resource
    private IinventoryService service;
    @Resource
    private ITcbjInventoryApi tcbjInventoryApi;
    @Resource
    private IBInventoryService inventoryService;

    @GetMapping(value={"/delivery/item/{id}"})
    @ApiOperation(value="\u6839\u636e\u51fa\u5e93\u5355\u53f7\u67e5\u8be2\u53d1\u8d27\u5546\u54c1", notes="\u6839\u636e\u51fa\u5e93\u5355\u53f7\u67e5\u8be2\u53d1\u8d27\u5546\u54c1")
    public RestResponse<List<DeliveryItemRespDto>> queryDeliveryItem(@PathVariable(value="id") @NotNull Long id) {
        return new RestResponse((Object)this.service.queryDeliveryItem(id));
    }

    @GetMapping(value={"/delivery/item/record/{orderNo}"})
    @ApiOperation(value="\u6839\u636e\u53d1\u8d27\u8ba2\u5355\u53f7\u67e5\u8be2\u53d1\u8d27\u8bb0\u5f55", notes="\u6839\u636e\u53d1\u8d27\u8ba2\u5355\u53f7\u67e5\u8be2\u53d1\u8d27\u8bb0\u5f55")
    public RestResponse<PageInfo<DeliveryItemRecordRespDto>> queryDeliveryItemRecord(@PathVariable(value="orderNo") @NotNull String orderNo, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return new RestResponse((Object)this.service.queryDeliveryItemRecord(orderNo, pageNum, pageSize));
    }

    @GetMapping(value={"/delivery/item/logistics/{orderNo}"})
    @ApiOperation(value="\u6839\u636e\u53d1\u8d27\u8ba2\u5355\u53f7\u67e5\u8be2\u53d1\u8d27\u7269\u6d41", notes="\u6839\u636e\u53d1\u8d27\u8ba2\u5355\u53f7\u67e5\u8be2\u53d1\u8d27\u7269\u6d41")
    public RestResponse<DeliveryItemLogisticsRespDto> queryDeliveryItemLogistics(@PathVariable(value="orderNo") @NotNull String orderNo) {
        return new RestResponse((Object)this.service.queryDeliveryItemLogistics(orderNo));
    }

    @PostMapping(value={"/queryBatchByActivity"})
    @ApiOperation(value="\u5e93\u5b58\u6d3b\u52a8\u6279\u6b21\u53f7\u67e5\u8be2")
    @ApiImplicitParam(name="TcbjCombinationBatchReqDto", dataType="TcbjCombinationBatchReqDto", paramType="body", required=true, value="\u5e93\u5b58\u6d3b\u52a8\u6279\u6b21\u53f7\u67e5\u8be2")
    public RestResponse<PageInfo<CargoStorageExtDto>> queryBatchByActivity(@RequestBody TcbjCombinationBatchReqDto queryBatchReqDto) {
        return this.tcbjInventoryApi.queryBatchByActivity(queryBatchReqDto);
    }

    @PostMapping(value={"/queryBatch"})
    @ApiOperation(value="\u5e93\u5b58\u6279\u6b21\u53f7\u67e5\u8be2")
    @ApiImplicitParam(name="QueryBatchReqDto", dataType="QueryBatchReqDto", paramType="body", required=true, value="\u5e93\u5b58\u6279\u6b21\u53f7\u67e5\u8be2\u53c2\u6570")
    public RestResponse<PageInfo<CargoStorageExtDto>> queryBatch(@RequestBody QueryBatchReqDto queryBatchReqDto) {
        return this.service.queryBatch(queryBatchReqDto);
    }

    @PostMapping(value={"/queryCargoStorage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8d27\u54c1\u5e93\u5b58")
    @ApiImplicitParam(name="CargoStorageDto", dataType="CargoStorageDto", paramType="body", required=true, value="\u5206\u9875\u67e5\u8be2\u8d27\u54c1\u5e93\u5b58")
    public RestResponse<PageInfo<CargoStorageExtDto>> queryCargoStorage(@RequestBody CargoStorageDto cargoStorageDto) {
        return this.tcbjInventoryApi.queryCargoStorage(cargoStorageDto);
    }
}

