/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.rest;

import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.BrotherCustomerShopRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.FactoryDeliveryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionValidTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.ILogService;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.IReturnOrderService;
import com.dtyunxi.yundt.module.trade.api.ITradeService;
import com.dtyunxi.yundt.module.trade.api.ItemService;
import com.dtyunxi.yundt.module.trade.api.dto.CustomerDeliveryTypeRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.ShopGiftReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.ShopRebateTotalAmount;
import com.dtyunxi.yundt.module.trade.api.dto.request.OrderCommonItemDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.PlaceOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.AddPayRecordReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.CancelOrderToBReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ConfirmDeliverOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.DeliveryConfirmReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ItemSkuListQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ModOrderItemReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.NullifyOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderAuditToBReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderItemAddAgainReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderListQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderReviewDetailsReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderStatSalesmanReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OutboundConfirmReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.SubmitOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.activity.OrderActivityBizReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.activity.OrderJoinActivityBizReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.OrderEngineResult;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ItemSkuListRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderDeliveredDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderDeliveredRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderDeliveryToBRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderItemAddAgainRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderListRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderListTotalRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderLogRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderPayRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderShareUrlRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderStatSalesmanRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderStatusRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderSubmitRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderTradeStatusRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.PayRecordAppRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.PreviewOrderRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.TcbjItemInfoExcelRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.OrderTradeStatusEnum;
import com.dtyunxi.yundt.module.trade.api.enums.TradeServiceEventEnum;
import com.dtyunxi.yundt.module.trade.biz.storageHelper.IStorageHelper;
import com.dtyunxi.yundt.module.trade.biz.util.RedisLockUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.query.ISellerSkuPriceQueryApi;
import com.yx.tcbj.center.rebate.api.IOfflineBalanceBillApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ea4\u6613\u7ec4\u4ef6\uff1a\u8ba2\u5355\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/trade/order"})
public class OrderRest {
    private static final Logger logger = LoggerFactory.getLogger(OrderRest.class);
    @Autowired
    private IOrderService orderService;
    @Resource
    private ITradeService tradeService;
    @Resource
    private ItemService itemService;
    @Resource
    private ILogService logService;
    @Resource
    private IStorageHelper iStorageHelper;
    @Resource
    private IContext context;
    @Resource
    private IReturnOrderService returnOrderService;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ISellerSkuPriceQueryApi sellerSkuPriceQueryApi;
    private IOfflineBalanceBillApi offlineBalanceBillApi;
    @Resource
    private RedisLockUtil redisLockUtil;

    @GetMapping(value={"/mgmt/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", dataType="Int", paramType="query", required=true, value="\u5f53\u524d\u9875"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query", required=true, value="\u9875\u9762\u5927\u5c0f")})
    public RestResponse<PageInfo<OrderListRespDto>> getMgmtOrderList(OrderListQueryReqDto orderListQueryReqDto, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.orderService.getMgmtOrderPage(orderListQueryReqDto, pageNum, pageSize));
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u5217\u8868\uff08\u5546\u57ce\u7aef\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", dataType="Int", paramType="query", required=true, value="\u5f53\u524d\u9875"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query", required=true, value="\u9875\u9762\u5927\u5c0f")})
    public RestResponse<PageInfo<OrderListRespDto>> getOrderList(OrderListQueryReqDto orderListQueryReqDto, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.orderService.getOrderPage(orderListQueryReqDto, pageNum, pageSize));
    }

    @GetMapping(value={"/page/total"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u5217\u8868\uff08\u5546\u57ce\u7aef\uff09\u5e26\u8ba2\u5355\u603b\u989d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", dataType="Int", paramType="query", required=true, value="\u5f53\u524d\u9875"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query", required=true, value="\u9875\u9762\u5927\u5c0f")})
    public RestResponse<OrderListTotalRespDto> getOrderListTotal(OrderListQueryReqDto orderListQueryReqDto, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.orderService.getOrderListTotal(orderListQueryReqDto, pageNum, pageSize));
    }

    @GetMapping(value={"/page/export"})
    @ApiOperation(value="\u5bfc\u51fa\u8ba2\u5355\u5217\u8868\uff08\u5546\u57ce\u7aef\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="totalSize", dataType="Long", paramType="query", required=true, value="\u8ba2\u5355\u603b\u6570")})
    public RestResponse<Object> exportOrderList(OrderListQueryReqDto orderListQueryReqDto, @RequestParam(value="totalSize") Long totalSize) {
        return new RestResponse(this.orderService.exportOrderList(orderListQueryReqDto, totalSize));
    }

    @GetMapping(value={"/status/num"})
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u72b6\u6001\u6570\u91cf\uff08\u5546\u57ce\u7aef\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="srcType", dataType="Int", paramType="query", value="\u6765\u6e90\u7c7b\u578b\uff081:\u7ecf\u9500\u5546\u5c0f\u7a0b\u5e8f\u7aef\uff0c2:PC\u7ba1\u7406\u7aef\uff0c3:\u4e1a\u52a1\u5458\u5c0f\u7a0b\u5e8f\u7aef\uff09"), @ApiImplicitParam(name="shopId", dataType="Long", paramType="query", value="\u5e97\u94faid")})
    public RestResponse<OrderStatusRespDto> getOrderStatusNum(@RequestParam(value="srcType", required=false) Integer srcType, @RequestParam(value="shopId", required=false) Long shopId) {
        return new RestResponse((Object)this.orderService.getOrderStatusNum(srcType, shopId));
    }

    @GetMapping(value={"/mgmt/dealer/num"})
    @ApiOperation(value="\u7ecf\u9500\u5546\u5373\u5927B\u540e\u53f0\u67e5\u8be2\u7edf\u8ba1\u6570\u91cf\uff0c\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u52a8\u6001\u53d8\u5316")
    public RestResponse<OrderStatusRespDto> getMgmtDealerNum(OrderListQueryReqDto orderListQueryReqDto) {
        return new RestResponse((Object)this.orderService.getMgmtDealerNum(orderListQueryReqDto));
    }

    @PostMapping(value={"/statistics-order"})
    @ApiOperation(value="\u5ba2\u6237\u8ba2\u5355\u7edf\u8ba1\uff08\u4e1a\u52a1\u5458\u7aef\uff09", notes="\u5ba2\u6237\u8ba2\u5355\u7edf\u8ba1\uff08\u4e1a\u52a1\u5458\u7aef\uff09")
    RestResponse<OrderStatSalesmanRespDto> statisticsOrder(@Valid @RequestBody OrderStatSalesmanReqDto reqDto) {
        return new RestResponse((Object)this.orderService.statisticsOrder(reqDto));
    }

    @PostMapping(value={"/statistics-order/page"})
    @ApiOperation(value="\u5ba2\u6237\u8ba2\u5355\u7edf\u8ba1\u5206\u9875\u67e5\u8be2\uff08\u4e1a\u52a1\u5458\u7aef\uff09", notes="\u5ba2\u6237\u8ba2\u5355\u7edf\u8ba1\u5206\u9875\u67e5\u8be2\uff08\u4e1a\u52a1\u5458\u7aef\uff09")
    RestResponse<PageInfo<OrderStatSalesmanRespDto>> getStatisticsOrderPage(@Valid @RequestBody OrderStatSalesmanReqDto reqDto) {
        return new RestResponse((Object)this.orderService.getStatisticsOrderPage(reqDto));
    }

    @GetMapping(value={"/{orderNo}"})
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\uff08\u5546\u57ce\u7aef\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNo", dataType="String", paramType="path", required=true, value="\u8ba2\u8d27\u5355\u53f7"), @ApiImplicitParam(name="customerId", dataType="Long", paramType="query", value="\u5ba2\u6237ID")})
    public RestResponse<OrderRespDto> getOrderDetail(@PathVariable(value="orderNo") String orderNo, @RequestParam(value="customerId", required=false) Long customerId) {
        return new RestResponse((Object)this.orderService.getOrderDetail(orderNo, customerId, new boolean[]{true}));
    }

    @GetMapping(value={"/copy/{orderNo}"})
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\uff08\u5546\u57ce\u7aef\uff09,\u8fc7\u6ee4\u6362\u8d2d\u5546\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNo", dataType="String", paramType="path", required=true, value="\u8ba2\u8d27\u5355\u53f7"), @ApiImplicitParam(name="customerId", dataType="Long", paramType="query", value="\u5ba2\u6237ID")})
    public RestResponse<OrderRespDto> getOrderDetailToCopy(@PathVariable(value="orderNo") String orderNo, @RequestParam(value="customerId", required=false) Long customerId) {
        return new RestResponse((Object)this.orderService.getOrderDetailToCopy(orderNo, customerId));
    }

    @PostMapping(value={"/addAgain"})
    @ApiOperation(value="\u518d\u6b21\u52a0\u8d2d")
    public RestResponse<OrderItemAddAgainRespDto> addAgain(@RequestBody OrderItemAddAgainReqDto orderItemAddAgainReqDto) {
        return new RestResponse((Object)this.orderService.addAgain(orderItemAddAgainReqDto));
    }

    @GetMapping(value={"/delivered-record/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5df2\u53d1\u8d27\u8bb0\u5f55\u5217\u8868\uff08\u5546\u57ce\u7aef\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNo", dataType="String", paramType="query", required=true, value="\u8ba2\u8d27\u5355\u53f7"), @ApiImplicitParam(name="pageNum", dataType="Int", paramType="query", required=true, value="\u5f53\u524d\u9875"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query", required=true, value="\u9875\u9762\u5927\u5c0f"), @ApiImplicitParam(name="srcType", dataType="Int", paramType="query", value="\u6765\u6e90\u7c7b\u578b\uff081:\u7ecf\u9500\u5546\u5c0f\u7a0b\u5e8f\u7aef\uff0c2:PC\u7ba1\u7406\u7aef\uff0c3:\u4e1a\u52a1\u5458\u5c0f\u7a0b\u5e8f\u7aef\uff09")})
    public RestResponse<PageInfo<OrderDeliveredDetailRespDto>> getDeliveredRecordPage(@RequestParam(value="orderNo") String orderNo, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="srcType", required=false) Integer srcType) {
        return new RestResponse((Object)this.orderService.getDeliveredRecordPage(orderNo, pageNum, pageSize, srcType));
    }

    @GetMapping(value={"/pay-record/list"})
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u8d27\u5355\u4ed8\u6b3e\u8bb0\u5f55\u5217\u8868\uff08\u5546\u57ce\u7aef\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNo", dataType="String", paramType="query", required=true, value="\u8ba2\u8d27\u5355\u53f7"), @ApiImplicitParam(name="auditStatus", dataType="String", paramType="query", value="\u5ba1\u6838\u72b6\u6001,pass:\u5ba1\u6838\u901a\u8fc7\u3001reject:\u5ba1\u6838\u5931\u8d25\u3001wait:\u5f85\u5ba1\u6838")})
    public RestResponse<List<PayRecordAppRespDto>> getPayRecordList(@RequestParam(value="orderNo") String orderNo, @RequestParam(value="auditStatus", required=false) String auditStatus) {
        List payRecordAppList = this.orderService.getPayRecordList(orderNo, auditStatus);
        return new RestResponse((Object)payRecordAppList);
    }

    @ApiOperation(value="\u4e0b\u5355\u9884\u89c8\u63a5\u53e3\uff08\u5546\u57ce\u7aef\uff09", notes="\u7ed3\u7b97\u8ba2\u5355\u91d1\u989d\uff0c\u8fd4\u56de\u8ba2\u5355\u4fe1\u606f\uff0c\u4e0d\u4f1a\u771f\u6b63\u751f\u6210\u8ba2\u5355")
    @ApiImplicitParam(name="placeOrderReqDto", paramType="body", dataType="PlaceOrderReqDto", required=true, value="\u4e0b\u5355\u4fe1\u606f")
    @PostMapping(value={"/place-order"})
    public RestResponse<PreviewOrderRespDto> placeOrder(@RequestBody PlaceOrderReqDto placeOrderReqDto) {
        placeOrderReqDto.setViewType(ConditionValidTypeEnum.NO_THROW_EXCEPTION.getType());
        ServiceEvent serviceEvent = new ServiceEvent(TradeServiceEventEnum.PLACE_ORDER.getCode(), TradeServiceEventEnum.PLACE_ORDER.getName(), (Object)placeOrderReqDto);
        PreviewOrderRespDto orderInfoDto = (PreviewOrderRespDto)this.tradeService.doService(serviceEvent);
        return new RestResponse((Object)orderInfoDto);
    }

    @ApiOperation(value="\u4e0b\u5355\u9884\u89c8\u63a5\u53e3\uff08\u5546\u57ce\u7aef\uff09\u590d\u5408\u63a5\u53e3-\u6309\u5e97\u94fa\u8fdb\u884c\u5206\u7c7b\u8fd4\u56de", notes="\u7ed3\u7b97\u8ba2\u5355\u91d1\u989d\uff0c\u8fd4\u56de\u8ba2\u5355\u4fe1\u606f\uff0c\u4e0d\u4f1a\u771f\u6b63\u751f\u6210\u8ba2\u5355")
    @ApiImplicitParam(name="placeOrderReqDto", paramType="body", dataType="PlaceOrderReqDto", required=true, value="\u4e0b\u5355\u4fe1\u606f")
    @PostMapping(value={"/place-order/mut"})
    public RestResponse<List<PreviewOrderRespDto>> placeOrderMut(@RequestBody PlaceOrderReqDto placeOrderReqDto) {
        List<PlaceOrderReqDto> placeOrderReqDtos = this.buildPlaceOrderList(placeOrderReqDto);
        ArrayList<PreviewOrderRespDto> list = new ArrayList<PreviewOrderRespDto>();
        for (PlaceOrderReqDto orderReqDto : placeOrderReqDtos) {
            ServiceEvent serviceEvent = new ServiceEvent(TradeServiceEventEnum.PLACE_ORDER.getCode(), TradeServiceEventEnum.PLACE_ORDER.getName(), (Object)orderReqDto);
            PreviewOrderRespDto orderInfoDto = (PreviewOrderRespDto)this.tradeService.doService(serviceEvent);
            list.add(orderInfoDto);
        }
        return new RestResponse(list);
    }

    private List<PlaceOrderReqDto> buildPlaceOrderList(PlaceOrderReqDto placeOrderReqDto) {
        Map<Long, ShopRebateTotalAmount> shopRebateTotalAmountMap = placeOrderReqDto.getShopRebateTotalAmounts().stream().collect(Collectors.toMap(e -> e.getShopId(), e -> e, (e1, e2) -> e1));
        Map<Long, ShopGiftReqDto> shopGiftMap = placeOrderReqDto.getShopGiftReqDtos().stream().collect(Collectors.toMap(ShopGiftReqDto::getShopId, e -> e, (e1, e2) -> e1));
        placeOrderReqDto.setViewType(ConditionValidTypeEnum.NO_THROW_EXCEPTION.getType());
        ArrayList<PlaceOrderReqDto> list = new ArrayList<PlaceOrderReqDto>();
        HashMap shopOrderActivityMap = placeOrderReqDto.getOrderActivity() == null ? new HashMap() : placeOrderReqDto.getOrderActivity().getActivityList().stream().collect(Collectors.groupingBy(OrderActivityBizReqDto::getShopId, Collectors.toList()));
        Map shopItemMap = placeOrderReqDto.getItemList().stream().collect(Collectors.groupingBy(OrderCommonItemDto::getShopId, Collectors.toList()));
        Map<Long, BrotherCustomerShopRespDto> customerShopMap = placeOrderReqDto.getBroCustomerShopRespDtos().stream().collect(Collectors.toMap(BrotherCustomerShopRespDto::getId, e -> e, (e1, e2) -> e1));
        for (Map.Entry longListEntry : shopItemMap.entrySet()) {
            PlaceOrderReqDto newPlaceOrderReqDto = new PlaceOrderReqDto();
            BeanUtils.copyProperties((Object)placeOrderReqDto, (Object)newPlaceOrderReqDto);
            List orderActivityBizReqDtos = shopOrderActivityMap == null ? null : (List)shopOrderActivityMap.get(longListEntry.getKey());
            OrderJoinActivityBizReqDto orderJoinActivityBizReqDto = new OrderJoinActivityBizReqDto();
            orderJoinActivityBizReqDto.setActivityList(!CollectionUtils.isEmpty((Collection)orderActivityBizReqDtos) ? orderActivityBizReqDtos : new ArrayList());
            newPlaceOrderReqDto.setOrderActivity(orderJoinActivityBizReqDto);
            newPlaceOrderReqDto.setItemList(longListEntry.getValue());
            BigDecimal rebateTotalAmount = BigDecimal.ZERO;
            if (shopRebateTotalAmountMap.containsKey(longListEntry.getKey())) {
                ShopRebateTotalAmount shopRebateTotalAmount = shopRebateTotalAmountMap.get(longListEntry.getKey());
                rebateTotalAmount = shopRebateTotalAmount.getRebateTotalAmount();
                newPlaceOrderReqDto.setRuleId(shopRebateTotalAmount.getRuleId());
            }
            if (shopGiftMap.containsKey(longListEntry.getKey())) {
                ShopGiftReqDto shopGiftReqDto = shopGiftMap.get(longListEntry.getKey());
                newPlaceOrderReqDto.setGiftAccount(shopGiftReqDto.isGiftAccount());
            }
            newPlaceOrderReqDto.setRebateTotalAmount(rebateTotalAmount);
            BrotherCustomerShopRespDto respDto = customerShopMap.get(longListEntry.getKey());
            if (respDto != null) {
                newPlaceOrderReqDto.setCustomerId(respDto.getCustomerId());
            }
            list.add(newPlaceOrderReqDto);
        }
        return list;
    }

    @ApiOperation(value="\u4fdd\u5b58\u8ba2\u5355")
    @ApiImplicitParam(name="saveOrderReqDto", paramType="body", dataType="SubmitOrderReqDto", required=true, value="\u8ba2\u5355\u4fe1\u606f")
    @PostMapping(value={"/save-order"})
    public RestResponse<Object> saveOrder(@Valid @RequestBody SubmitOrderReqDto saveOrderReqDto) {
        ServiceEvent serviceEvent = new ServiceEvent(TradeServiceEventEnum.SUBMIT_ORDER.getCode(), TradeServiceEventEnum.SUBMIT_ORDER.getName(), (Object)saveOrderReqDto);
        saveOrderReqDto.setDeliveryDate(saveOrderReqDto.getDeliveryDate() == null ? new Date() : saveOrderReqDto.getDeliveryDate());
        Object orderNo = this.tradeService.doService(serviceEvent);
        return new RestResponse(orderNo);
    }

    @ApiOperation(value="\u4fdd\u5b58\u8ba2\u5355-\u590d\u5408\u8ba2\u5355\u4fdd\u5b58")
    @ApiImplicitParam(name="saveOrderReqDto", paramType="body", dataType="SubmitOrderReqDto", required=true, value="\u8ba2\u5355\u4fe1\u606f(\u6682\u5b58\u5219\u8bbe\u7f6esubmitOrNot\u4e3aN)")
    @PostMapping(value={"/save-order/mut"})
    public RestResponse<OrderSubmitRespDto> saveOrderMut(@Valid @RequestBody List<SubmitOrderReqDto> saveOrderReqDtos) {
        SubmitOrderReqDto mainOrder = new SubmitOrderReqDto();
        BeanUtils.copyProperties((Object)saveOrderReqDtos.get(0), (Object)mainOrder);
        mainOrder.setSonOrder(saveOrderReqDtos);
        ServiceEvent serviceEvent = new ServiceEvent(TradeServiceEventEnum.SUBMIT_ORDER.getCode(), TradeServiceEventEnum.SUBMIT_ORDER.getName(), (Object)mainOrder);
        OrderSubmitRespDto orderSubmitRespDto = (OrderSubmitRespDto)this.tradeService.doService(serviceEvent);
        return new RestResponse((Object)orderSubmitRespDto);
    }

    @GetMapping(value={"/mgmt/{orderNo}"})
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5")
    @ApiImplicitParam(name="orderNo", dataType="String", paramType="path", required=true, value="\u8ba2\u8d27\u5355\u53f7")
    public RestResponse<OrderRespDto> getMgmtOrder(@PathVariable(value="orderNo") String orderNo) {
        OrderRespDto OrderRespDto1 = this.orderService.getMgmtOrderDetail(orderNo);
        return new RestResponse((Object)OrderRespDto1);
    }

    @GetMapping(value={"/mgmt/combined/package/{orderNo}"})
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u660e\u7ec6")
    @ApiImplicitParam(name="orderNo", dataType="String", paramType="path", required=true, value="\u8ba2\u8d27\u5355\u53f7")
    public RestResponse<List<ActivityRespDto>> getMgmtCombinedPackage(@PathVariable(value="orderNo") String orderNo) {
        List activityRespDtos = this.orderService.getMgmtCombinedPackage(orderNo);
        return new RestResponse((Object)activityRespDtos);
    }

    @GetMapping(value={"/mgmt/return/{orderNo}"})
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\uff08\u9000\u8ba2\u5355\u65f6\u4e13\u7528\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNo", dataType="String", paramType="path", required=true, value="\u8ba2\u8d27\u5355\u53f7"), @ApiImplicitParam(name="deliveryNo", dataType="String", paramType="query", required=true, value="\u53d1\u8d27\u5355\u53f7")})
    public RestResponse<OrderRespDto> getMgmtOrderForReturn(@PathVariable(value="orderNo") String orderNo, @RequestParam(value="deliveryNo") String deliveryNo) {
        OrderRespDto OrderRespDto1 = this.orderService.getMgmtOrderForReturn(orderNo, deliveryNo);
        return new RestResponse((Object)OrderRespDto1);
    }

    @PutMapping(value={"submit-order"})
    @ApiOperation(value="\u63d0\u4ea4\u8ba2\u5355\u4fe1\u606f", notes="\u8be5\u63a5\u53e3\u652f\u6301\u4fee\u6539\u672a\u652f\u4ed8\u3001\u5f85\u5ba1\u6838\u72b6\u6001\u7684\u8ba2\u8d27\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="order", value="\u8ba2\u5355\u7684\u4fe1\u606f", dataType="OrderModReqDto", paramType="body", required=true)})
    RestResponse<Object> submitOrder(@RequestBody SubmitOrderReqDto saveOrderReqDto) {
        saveOrderReqDto.setOrderNo(saveOrderReqDto.getOrderNo());
        ServiceEvent serviceEvent = new ServiceEvent(TradeServiceEventEnum.MODIFY_ORDER.getCode(), TradeServiceEventEnum.MODIFY_ORDER.getName(), (Object)saveOrderReqDto);
        saveOrderReqDto.setDeliveryDate(saveOrderReqDto.getDeliveryDate() == null ? new Date() : saveOrderReqDto.getDeliveryDate());
        saveOrderReqDto.setSubmitOrNot("Y");
        Object orderNo = this.tradeService.doService(serviceEvent);
        return new RestResponse(orderNo);
    }

    @PutMapping(value={"/update-order"})
    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u4fe1\u606f", notes="\u8be5\u63a5\u53e3\u652f\u6301\u4fee\u6539\u672a\u652f\u4ed8\u3001\u5f85\u5ba1\u6838\u72b6\u6001\u7684\u8ba2\u8d27\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="saveOrderReqDto", value="\u8ba2\u5355\u7684\u4fe1\u606f", dataType="OrderModReqDto", paramType="body", required=true)})
    RestResponse<Object> modifyOrder(@RequestBody SubmitOrderReqDto saveOrderReqDto) {
        saveOrderReqDto.setOrderNo(saveOrderReqDto.getOrderNo());
        ServiceEvent serviceEvent = new ServiceEvent(TradeServiceEventEnum.MODIFY_ORDER.getCode(), TradeServiceEventEnum.MODIFY_ORDER.getName(), (Object)saveOrderReqDto);
        saveOrderReqDto.setDeliveryDate(saveOrderReqDto.getDeliveryDate() == null ? new Date() : saveOrderReqDto.getDeliveryDate());
        Object orderNo = this.tradeService.doService(serviceEvent);
        return new RestResponse(orderNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u8ba2\u5355\u5ba1\u6838")
    @ApiImplicitParam(name="orderAuditReqDto", dataType="OrderAuditReqDto", paramType="body", required=true, value="\u5ba1\u6838\u8ba2\u5355\u53c2\u6570")
    @PostMapping(value={"/audit-order"})
    public RestResponse<OrderEngineResult> auditOrder(@Valid @RequestBody OrderAuditToBReqDto orderAuditToBReqDto) {
        String lockKey = "order-audit:" + orderAuditToBReqDto.getOrderNo();
        String lockValue = this.redisLockUtil.tryGetLock(lockKey);
        if (lockValue == null) {
            throw new BizException("\u8ba2\u5355[" + orderAuditToBReqDto.getOrderNo() + "]\u5df2\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u9891\u7e41\u70b9\u51fb...");
        }
        try {
            RestResponse restResponse = new RestResponse((Object)this.orderService.auditOrder(orderAuditToBReqDto));
            return restResponse;
        }
        finally {
            this.redisLockUtil.releaseLock(lockKey, lockValue);
        }
    }

    @ApiOperation(value="\u6279\u91cf\u8ba2\u5355\u5ba1\u6838")
    @ApiImplicitParam(name="orderAuditReqDto", dataType="OrderAuditReqDto", paramType="body", required=true, value="\u6279\u91cf\u8ba2\u5355\u5ba1\u6838")
    @PostMapping(value={"/batch/audit-order"})
    public RestResponse<OrderEngineResult> batchAuditOrder(@Valid @RequestBody OrderAuditToBReqDto orderAuditToBReqDto) {
        return new RestResponse((Object)this.orderService.batchAuditOrder(orderAuditToBReqDto));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u8ba2\u5355\u8fd4\u5ba1\u6838")
    @ApiImplicitParam(name="orderAuditReqDto", dataType="OrderAuditReqDto", paramType="body", required=true, value="\u5ba1\u6838\u8ba2\u5355\u53c2\u6570")
    @PostMapping(value={"/return-audit-order"})
    public RestResponse<OrderEngineResult> returnAuditOrder(@Valid @RequestBody OrderAuditToBReqDto orderAuditToBReqDto) {
        String lockKey = "order-audit:" + orderAuditToBReqDto.getOrderNo();
        String lockValue = this.redisLockUtil.tryGetLock(lockKey);
        if (lockValue == null) {
            throw new BizException("\u8ba2\u5355[" + orderAuditToBReqDto.getOrderNo() + "]\u5df2\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u9891\u7e41\u70b9\u51fb...");
        }
        try {
            RestResponse restResponse = new RestResponse((Object)this.orderService.returnAuditOrder(orderAuditToBReqDto));
            return restResponse;
        }
        finally {
            this.redisLockUtil.releaseLock(lockKey, lockValue);
        }
    }

    @ApiOperation(value="\u786e\u8ba4\u53d1\u8d27")
    @ApiImplicitParam(name="ConfirmDeliverOrderReqDto", dataType="ConfirmDeliverOrderReqDto", paramType="body", required=true, value="\u8ba2\u5355\u786e\u8ba4\u53d1\u8d27\u8d27\u53c2\u6570")
    @PostMapping(value={"/confirm-deliver"})
    public RestResponse<Void> confirmDeliver(@RequestBody ConfirmDeliverOrderReqDto confirmDeliverOrderReqDto) {
        this.orderService.confirmDeliver(confirmDeliverOrderReqDto);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/cancel-order"})
    @ApiOperation(value="\u53d6\u6d88\u8ba2\u5355", notes="\u53d6\u6d88\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="CancelOrderReqDto", value="\u53d6\u6d88\u8ba2\u5355", dataType="CancelOrderReqDto", paramType="body", required=true)})
    public RestResponse<Void> cancelOrder(@Valid @RequestBody CancelOrderToBReqDto cancelOrderToBReqDto) {
        this.orderService.cancelOrder(cancelOrderToBReqDto);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/delete/{orderId}"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u8ba2\u5355(\u8c28\u614e\u64cd\u4f5c,\u6682\u65e0\u6821\u9a8c)", notes="\u5220\u9664\u8ba2\u5355")
    public RestResponse<Void> logicDeleteOrder(@PathVariable(value="orderId") Long orderId) {
        this.orderService.logicDeleteOrder(orderId);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/nullify-order"})
    @ApiOperation(value="\u4f5c\u5e9f\u8ba2\u5355", notes="\u4f5c\u5e9f\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="NullifyOrderReqDto", value="\u4f5c\u5e9f\u8ba2\u5355", dataType="NullifyOrderReqDto", paramType="body", required=true)})
    public RestResponse<Void> nullifyOrder(@Valid @RequestBody NullifyOrderReqDto nullifyOrderReqDto) {
        this.orderService.nullifyOrder(nullifyOrderReqDto);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/mgmt/delivery-record/{orderNo}"})
    @ApiOperation(value="\u67e5\u8be2\u51fa\u5e93\u53d1\u8d27\u8bb0\u5f55\uff08\u540e\u53f0\uff09")
    @ApiImplicitParam(name="orderNo", dataType="String", paramType="path", required=true, value="\u8ba2\u8d27\u5355\u53f7")
    public RestResponse<OrderDeliveryToBRespDto> getMgmtDeliveryRecord(@PathVariable(value="orderNo") String orderNo) {
        OrderDeliveryToBRespDto orderDeliveryToBRespDto1 = this.orderService.getMgmtDeliveryRecord(orderNo);
        return new RestResponse((Object)orderDeliveryToBRespDto1);
    }

    @GetMapping(value={"/mgmt/outbound-record/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5df2\u51fa\u5e93\u8bb0\u5f55\u5217\u8868\uff08\u540e\u53f0\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", dataType="String", paramType="query", value="\u5173\u952e\u5b57(\u51fa\u5e93\u5355\u53f7/\u6765\u6e90\u5355\u53f7/\u4ed3\u5e93)"), @ApiImplicitParam(name="orderNo", dataType="String", paramType="query", required=true, value="\u8ba2\u8d27\u5355\u53f7"), @ApiImplicitParam(name="pageNum", dataType="Int", paramType="query", required=true, value="\u5f53\u524d\u9875"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query", required=true, value="\u9875\u9762\u5927\u5c0f")})
    public RestResponse<PageInfo<OrderDeliveredRespDto>> getMgmtOutboundRecordPage(@RequestParam(value="keyword", required=false) String keyword, @RequestParam(value="orderNo") String orderNo, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.orderService.getMgmtOutboundRecordPage(keyword, orderNo, pageNum, pageSize));
    }

    @GetMapping(value={"/mgmt/delivered-record/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5df2\u53d1\u8d27\u8bb0\u5f55\u5217\u8868\uff08\u540e\u53f0\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", dataType="String", paramType="query", value="\u5173\u952e\u5b57(\u51fa\u5e93\u5355\u53f7/\u6765\u6e90\u5355\u53f7/\u4ed3\u5e93)"), @ApiImplicitParam(name="orderNo", dataType="String", paramType="query", required=true, value="\u8ba2\u8d27\u5355\u53f7"), @ApiImplicitParam(name="pageNum", dataType="Int", paramType="query", required=true, value="\u5f53\u524d\u9875"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query", required=true, value="\u9875\u9762\u5927\u5c0f")})
    public RestResponse<PageInfo<OrderDeliveredRespDto>> getMgmtDeliveredRecordPage(@RequestParam(value="keyword", required=false) String keyword, @RequestParam(value="orderNo") String orderNo, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.orderService.getMgmtDeliveredRecordPage(keyword, orderNo, pageNum, pageSize));
    }

    @ApiOperation(value="\u51fa\u5e93")
    @ApiImplicitParam(name="outboundConfirmReqDto", paramType="body", dataType="OutboundConfirmReqDto", required=true, value="\u51fa\u5e93\u4fe1\u606f")
    @PostMapping(value={"/outbound"})
    public RestResponse<OrderEngineResult> outbound(@Valid @RequestBody OutboundConfirmReqDto outboundConfirmReqDto) {
        return new RestResponse((Object)this.orderService.outbound(outboundConfirmReqDto));
    }

    @ApiOperation(value="\u53d1\u8d27")
    @ApiImplicitParam(name="deliveryConfirmReqDto", paramType="body", dataType="DeliveryConfirmReqDto", required=true, value="\u53d1\u8d27\u4fe1\u606f")
    @PostMapping(value={"/deliver"})
    public RestResponse<OrderEngineResult> deliver(@Valid @RequestBody DeliveryConfirmReqDto deliveryConfirmReqDto) {
        return new RestResponse((Object)this.orderService.deliver(deliveryConfirmReqDto));
    }

    @GetMapping(value={"/mgmt/pay-record/{orderNo}"})
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u8d27\u5355\u6536/\u9000\u6b3e\u8bb0\u5f55\uff08\u540e\u53f0\uff09")
    @ApiImplicitParam(name="orderNo", dataType="String", paramType="path", required=true, value="\u8ba2\u8d27\u5355\u53f7")
    public RestResponse<OrderPayRespDto> getMgmtPayRecord(@PathVariable(value="orderNo") String orderNo) {
        OrderPayRespDto orderPayRespDto1 = this.orderService.getMgmtPayRecord(orderNo);
        return new RestResponse((Object)orderPayRespDto1);
    }

    @ApiOperation(value="\u652f\u4ed8\u63a5\u53e3(\u65b0\u589e\u7ebf\u4e0b\u6536\u6b3e\u8bb0\u5f55)")
    @ApiImplicitParam(name="addPayRecordReqDto", paramType="body", dataType="AddPayRecordReqDto", required=true, value="\u652f\u4ed8\u63a5\u53e3")
    @PostMapping(value={"/pay-record"})
    public RestResponse<Void> addPayRecord(@Valid @RequestBody AddPayRecordReqDto addPayRecordReqDto) {
        this.orderService.orderPay(addPayRecordReqDto);
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u652f\u4ed8\u63a5\u53e3(\u6279\u91cf\u65b0\u589e\u7ebf\u4e0b\u6536\u6b3e\u8bb0\u5f55)")
    @PostMapping(value={"/pay-record/batch"})
    public RestResponse<Void> batchAddPayRecord(@Valid @RequestBody List<AddPayRecordReqDto> addPayRecordReqDtos) {
        this.orderService.batchOrderPay(addPayRecordReqDtos);
        return RestResponse.VOID;
    }

    @PutMapping(value={"/nullify-payment/{payNo}"})
    @ApiOperation(value="\u5e9f\u5f03\u6536\u6b3e\u8bb0\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="payNo", value="\u652f\u4ed8\u6d41\u6c34\u53f7", dataType="string", paramType="path", required=true)})
    public RestResponse<Void> nullifyPayment(@PathVariable(value="payNo") String payNo) {
        this.returnOrderService.abandonPayRecord(payNo);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/mgmt/log/{orderNo}"})
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u8d27\u5355\u65e5\u5fd7\uff08\u540e\u53f0\uff09")
    @ApiImplicitParam(name="returnNo", dataType="String", paramType="path", required=true, value="\u8ba2\u8d27\u5355\u53f7")
    public RestResponse<OrderLogRespDto> getMgmtOrderLog(@PathVariable(value="orderNo") String orderNo) {
        return new RestResponse((Object)this.logService.getMgmtOrderLog(orderNo));
    }

    @PutMapping(value={"/mgmt/order-item"})
    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\u540e\u8ba1\u7b97\u91d1\u989d\uff08\u540e\u53f0\uff09")
    @ApiImplicitParam(name="modOrderItemReqDto", value="\u4fee\u6539\u8ba2\u5355\u5546\u54c1\u4fe1\u606f", dataType="ModOrderItemReqDto", paramType="body", required=true)
    public RestResponse<OrderRespDto> modifyOrderItem(@Valid @RequestBody ModOrderItemReqDto modOrderItemReqDto) {
        return new RestResponse((Object)new OrderRespDto());
    }

    @GetMapping(value={"/biz-status"})
    @ApiOperation(value="\u67e5\u8be2\u8ba2\u8d27\u5355\u7684\u4e1a\u52a1\u72b6\u6001\u5217\u8868")
    public RestResponse<List<OrderTradeStatusRespDto>> getOrderTradeStatusList() {
        ArrayList list = Lists.newArrayList();
        for (OrderTradeStatusEnum value : OrderTradeStatusEnum.values()) {
            OrderTradeStatusRespDto statusRespDto = new OrderTradeStatusRespDto();
            statusRespDto.setCode(value.getCode());
            statusRespDto.setName(value.getName());
            list.add(statusRespDto);
        }
        return new RestResponse((Object)list);
    }

    @GetMapping(value={"/mgmt/item-sku/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5546\u54c1Sku\u5217\u8868\uff08\u540e\u53f0\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", dataType="Int", paramType="query", required=true, value="\u5f53\u524d\u9875"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query", required=true, value="\u9875\u9762\u5927\u5c0f")})
    public RestResponse<PageInfo<ItemSkuListRespDto>> getItemSkuList(ItemSkuListQueryReqDto itemSkuListQueryReqDto, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        PageInfo page = this.itemService.pageItemSkuList(itemSkuListQueryReqDto, pageNum, pageSize);
        return new RestResponse((Object)page);
    }

    @GetMapping(value={"/sku/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2Sku\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", dataType="Int", paramType="query", required=true, value="\u5f53\u524d\u9875"), @ApiImplicitParam(name="pageSize", dataType="Int", paramType="query", required=true, value="\u9875\u9762\u5927\u5c0f")})
    public RestResponse<PageInfo<ItemSkuListRespDto>> getSkuList(ItemSkuListQueryReqDto itemSkuListQueryReqDto, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        PageInfo page = this.itemService.getSkuList(itemSkuListQueryReqDto, pageNum, pageSize);
        return new RestResponse((Object)page);
    }

    @ApiOperation(value="\u8ba2\u5355\u4fe1\u606f\u6821\u9a8c")
    @ApiImplicitParam(name="saveOrderReqDto", paramType="body", dataType="SubmitOrderReqDto", required=true, value="\u8ba2\u5355\u4fe1\u606f")
    @PostMapping(value={"/validate-order"})
    public RestResponse<List<OrderItemInfoDto>> validateOrder(@Valid @RequestBody SubmitOrderReqDto saveOrderReqDto) {
        List orderItemInfoList = this.orderService.validateOrder(saveOrderReqDto);
        return new RestResponse((Object)orderItemInfoList);
    }

    @ApiOperation(value="\u8ba2\u5355\u4fe1\u606f\u6821\u9a8c-\u590d\u5408\u8ba2\u5355,\u5bf9\u95e8\u5e97\u8fdb\u884c\u5206\u7ec4")
    @ApiImplicitParam(name="saveOrderReqDto", paramType="body", dataType="SubmitOrderReqDto", required=true, value="\u8ba2\u5355\u4fe1\u606f")
    @PostMapping(value={"/validate-order/mut"})
    public RestResponse<Map<Long, List<OrderItemInfoDto>>> validateOrder(@Valid @RequestBody List<SubmitOrderReqDto> saveOrderReqDtos) {
        ArrayList list = new ArrayList();
        for (SubmitOrderReqDto saveOrderReqDto : saveOrderReqDtos) {
            list.addAll(this.orderService.validateOrder(saveOrderReqDto));
        }
        Map group = list.stream().collect(Collectors.groupingBy(OrderItemInfoDto::getShopId, Collectors.toList()));
        return new RestResponse(group);
    }

    @ApiOperation(value="\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\uff08\u5546\u57ce\u7aef\uff09")
    @PostMapping(value={"/getOrderDetailByOrderNos"})
    public RestResponse<List<OrderRespDto>> getOrderDetailByOrderNos(@RequestBody List<String> orderNos) {
        return new RestResponse((Object)this.orderService.getOrderDetailByOrderNos(orderNos));
    }

    @PutMapping(value={"/{orderNo}/deliveryStatus/{statusCode}"})
    @ApiOperation(value="\u66f4\u65b0\u8ba2\u5355\u53d1\u8d27\u72b6\u6001", notes="\u66f4\u65b0\u8ba2\u5355\u53d1\u8d27\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNo", value="\u8ba2\u5355\u4ea4\u6613\u53f7", dataType="String", paramType="path", required=true), @ApiImplicitParam(name="statusCode", value="\u8ba2\u5355\u72b6\u6001\uff08ALL_DELIVERY:\u5df2\u53d1\u8d27\uff1bCONFIRM:\u5df2\u7b7e\u6536\uff09", dataType="String", paramType="path", required=true)})
    public RestResponse<Void> updateOrderDeliveryStatus(@PathVariable(value="orderNo") String orderNo, @PathVariable(value="statusCode") String statusCode) {
        this.orderService.updateOrderDeliveryStatus(orderNo, statusCode);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/audit-artificial"})
    @ApiOperation(value="\u4eba\u5de5\u8d22\u5ba1\uff1a\u63d0\u4f9b\u63a5\u53e3\u7ed9\u8425\u9500\u4e91")
    @ApiImplicitParam(name="orderReviewDetailsReqDto", dataType="OrderReviewDetailsReqDto", paramType="body", required=true, value="\u4eba\u5de5\u8d22\u5ba1\u53c2\u6570")
    public String auditArtificial(@Valid @RequestBody OrderReviewDetailsReqDto orderReviewDetailsReqDto) {
        return this.orderService.auditArtificial(orderReviewDetailsReqDto);
    }

    @GetMapping(value={"/exportItemInfo/{orderNo}"})
    @ApiOperation(value="\u5bfc\u51fa\u5546\u54c1\u8be6\u60c5")
    public RestResponse<Object> exportItemInfo(@PathVariable(value="orderNo") String orderNo) {
        OrderRespDto OrderRespDto1 = this.orderService.getMgmtOrderDetail(orderNo);
        try {
            if (!CollectionUtils.isEmpty((Collection)OrderRespDto1.getItemList())) {
                String exportUrl;
                String remark = StringUtils.isNotEmpty((CharSequence)OrderRespDto1.getBuyerRemark()) ? OrderRespDto1.getBuyerRemark() : "\u65e0";
                ArrayList<TcbjItemInfoExcelRespDto> rList = new ArrayList<TcbjItemInfoExcelRespDto>();
                List itemList = OrderRespDto1.getItemList();
                if (!CollectionUtils.isEmpty((Collection)OrderRespDto1.getGiftItems())) {
                    itemList.addAll(OrderRespDto1.getGiftItems());
                }
                ArrayList<Long> skuIds = new ArrayList<Long>();
                ArrayList<Long> shopIds = new ArrayList<Long>();
                for (ItemRespDto itemRespDto : itemList) {
                    skuIds.add(itemRespDto.getSkuId());
                    shopIds.add(itemRespDto.getSkuShopId());
                }
                ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
                itemAuthReqDto.setTargetType(Integer.valueOf(2));
                itemAuthReqDto.setTargetIdList(shopIds);
                itemAuthReqDto.setBusinessIdList(skuIds);
                RestResponse listRestResponse = this.itemAuthQueryApi.queryByTargetIds(itemAuthReqDto);
                HashMap map = CollectionUtils.isEmpty((Collection)((Collection)listRestResponse.getData())) ? new HashMap() : ((List)listRestResponse.getData()).stream().collect(Collectors.toMap(t -> t.getTargetId() + "-" + t.getBusinessId(), t -> t.getExternalCode(), (last, next) -> next));
                TcbjItemInfoExcelRespDto tcbjItemInfoExcelRespDto = null;
                for (ItemRespDto itemRespDto : itemList) {
                    tcbjItemInfoExcelRespDto = new TcbjItemInfoExcelRespDto();
                    String externalCode = map.containsKey(itemRespDto.getSkuShopId() + "-" + itemRespDto.getSkuId()) ? (String)map.get(itemRespDto.getSkuShopId() + "-" + itemRespDto.getSkuId()) : "\u65e0";
                    tcbjItemInfoExcelRespDto.setExternalCode(externalCode);
                    tcbjItemInfoExcelRespDto.setItemNum(itemRespDto.getItemNum());
                    if (itemRespDto.getBrandSuggestedRetailPrice() != null) {
                        tcbjItemInfoExcelRespDto.setRetailPrice(itemRespDto.getBrandSuggestedRetailPrice().setScale(2, 1));
                    }
                    tcbjItemInfoExcelRespDto.setRemark(remark);
                    rList.add(tcbjItemInfoExcelRespDto);
                }
                Long customerId = OrderRespDto1.getCustomerId();
                CustomerExtDetailRespDto customerExtDetailRespDto = (CustomerExtDetailRespDto)this.customerExtQueryApi.queryById(customerId).getData();
                String excelName = "cube/" + customerExtDetailRespDto.getName() + "-\u8ba2\u5355\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)OrderRespDto1.getPlaceTime(), (String)"yyyyMMddHHmmss");
                try {
                    exportUrl = EasyPoiExportUtil.getExportUrl(rList, TcbjItemInfoExcelRespDto.class, null, (String)excelName, (String)"xls");
                }
                catch (Exception e) {
                    logger.error("\u5bfc\u51fa\u5546\u54c1\u8be6\u60c5-\u9519\u8bef:{}", (Object)e.toString());
                    return new RestResponse("-1", "\u5bfc\u51fa\u5546\u54c1\u8be6\u60c5-\u9519\u8bef:" + e);
                }
                return new RestResponse("0", "\u5bfc\u51fa\u5546\u54c1\u8be6\u60c5\u6210\u529f", (Object)exportUrl);
            }
            return new RestResponse("-1", "\u5bfc\u51fa\u5546\u54c1\u8be6\u60c5,\u6570\u636e\u4e3a\u7a7a", null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new RestResponse("-1", "\u5bfc\u51fa\u5931\u8d25", null);
        }
    }

    @GetMapping(value={"/mgmt/share/{orderNo}"})
    @ApiOperation(value="\u5206\u4eab\u8ba2\u5355(\u540e\u7ba1)")
    public RestResponse<OrderShareUrlRespDto> mgmtShareOrder(@PathVariable(value="orderNo") String orderNo) {
        return this.orderService.mgmtShareOrder(orderNo);
    }

    @PostMapping(value={"/factoryDelivery"})
    @ApiOperation(value="\u540e\u7ba1\u5382\u5bb6\u53d1\u8d27")
    public RestResponse<String> factoryDelivery(@RequestBody FactoryDeliveryReqDto factoryDeliveryReqDto) {
        return this.orderService.factoryDelivery(factoryDeliveryReqDto);
    }

    @PostMapping(value={"/queryCurrCustomerDelivery"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u9646\u5ba2\u6237\u53d1\u8d27\u7c7b\u578b")
    public RestResponse<List<CustomerDeliveryTypeRespDto>> queryCurrCustomerDelivery(@RequestBody List<Long> customerIds) {
        return this.orderService.queryCurrCustomerDelivery(customerIds);
    }
}

