package com.dtyunxi.yundt.module.customer.api.enums;

/**
 * 来源类型
 *
 * @author zhuiming
 * @date 2021/3/3
 */
public enum SrcTypeEnum {
    /**
     * 经销商小程序端
     */
    CUSTOMER(1, "经销商小程序端"),
    /**
     * PC管理端
     */
    MANAGER(2, "PC管理端"),
    /**
     * 业务员小程序端
     */
    SALESMAN(3, "业务员小程序端"),

    ;

    private final Integer code;
    private final String name;

    SrcTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


    public static SrcTypeEnum fromCode(Integer status) {
        for (SrcTypeEnum typeEnum : SrcTypeEnum.values()) {
            if (typeEnum.getCode().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static Integer toCode(Integer status) {
        SrcTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(Integer status) {
        SrcTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }
}
