package com.dtyunxi.yundt.module.customer.api.enums;

/**
 * 商家表sc_seller的店铺状态，禁用的店铺不允许卖东西，启用的店铺允许卖。
 *
 * @author lsw
 * @date 2022/8/2
 */
public enum SellerStatusEnum {

    NORMAL("NORMAL", "启用"),

    BANNED("BANNED", "禁用"),
    ;

    private final String code;
    private final String name;

    SellerStatusEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


    public static SellerStatusEnum fromCode(String status) {
        for (SellerStatusEnum typeEnum : SellerStatusEnum.values()) {
            if (typeEnum.getCode().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        SellerStatusEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        SellerStatusEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }
}
