package com.dtyunxi.yundt.module.customer.api.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.ChooseOrgRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.OrgRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.tcbj.OrgRoleRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.OrgRoleExtRespDto;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @author jiejun
 * @Description 组织角色管理服务
 * @since 1.0.0
 */
public interface IOrgRoleService {

    /**
     * 创建组织角色
     * @param orgRoleReqDto 请求对象
     * @return 请求结果
     */
    RestResponse<Long> create(OrgRoleReqDto orgRoleReqDto);

    /**
     * 修改组织角色
     * @param orgRoleReqDto 请求对象
     */
    RestResponse<Void> update(OrgRoleReqDto orgRoleReqDto);

    /**
     * 删除组织角色
     * @param id 删除ID
     */
    RestResponse<Void> delete(Long id);

    /**
     * 查询组织角色详情
     * @param id 请求ID
     * @return 请求结果
     */
    RestResponse<OrgRoleExtRespDto> queryDetail(Long id);

    /**
     * 查询选择绑定组织角色分页列表
     * @param reqDto reqDto 参数对象
     * @return 请求结果
     */
    RestResponse<PageInfo<RoleDto>> queryChoosePage(ChooseOrgRoleReqDto reqDto);

    /**
     * 获取系统应用列表
     * @return 请求结果
     */
    RestResponse<List<AppInstanceDto>> queryAppInstanceList();
}
