package com.dtyunxi.yundt.module.customer.api.dto.request.user;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgOrgDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;

/**
 * @author liangfa
 * @Description 员工信息ReqDto
 * @date 2022-01-13 18:13
 * @since 1.0.0
 */
@ApiModel(value = "EmployeeExpandReqDto", description = "员工扩展信息")
public class EmployeeExpandReqDto extends EmployeeExtReqDto {

    /**
     * 区域
     */
    @ApiModelProperty(name = "regionCodeList",value = "区域")
    private List<EmployeeRegionReqDto> regionInfoList;

    /**
     * 客户
     */
    @ApiModelProperty(name = "customerIdList",value = "客户")
    private List<EmployeeCustomerReqDto> customerInfoList;

    /**
     * 客户黑名单
     */
    @ApiModelProperty(name = "customerIdBlackList",value = "客户黑名单")
    private List<EmployeeCustomerBlacklistReqDto> customerBlackList;

    public List<EmployeeRegionReqDto> getRegionInfoList() {
        return regionInfoList;
    }

    public void setRegionInfoList(List<EmployeeRegionReqDto> regionInfoList) {
        this.regionInfoList = regionInfoList;
    }

    public List<EmployeeCustomerReqDto> getCustomerInfoList() {
        return customerInfoList;
    }

    public void setCustomerInfoList(List<EmployeeCustomerReqDto> customerInfoList) {
        this.customerInfoList = customerInfoList;
    }

    public List<EmployeeCustomerBlacklistReqDto> getCustomerBlackList() {
        return customerBlackList;
    }

    public void setCustomerBlackList(List<EmployeeCustomerBlacklistReqDto> customerBlackList) {
        this.customerBlackList = customerBlackList;
    }
}
