package com.dtyunxi.yundt.module.customer.api.dto.request;

import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 用户账号信息
 * Created by sumo on 2020/10/9 0009
 *
 * @author sumo
 */
@ApiModel(value = "UserAccountReqDto", description = "用户账号信息保存dto")
public class UserAccountReqDto extends BaseReqDto {

    /**
     * 组织信息ID
     */

    @ApiModelProperty(value = "组织信息ID,必填")
    @NotNull(message = "组织信息ID不能为空")
    private Long orgInfoId;

    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名,必填")
    private String account;

    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名,必填")
    private String userName;
    /**
     * 密码
     */
    @ApiModelProperty(value = "密码,为空则默认不修改")
    private String password;

    /**
     * 账号状态id
     */
    @ApiModelProperty(value = "账号状态id,必填")
    @NotNull(message = "账号状态ID不能为空")
    private Long statusId;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id,编辑时必填")
    private Long userId;

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Long getOrgInfoId() {
        return orgInfoId;
    }

    public void setOrgInfoId(Long orgInfoId) {
        this.orgInfoId = orgInfoId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getStatusId() {
        return statusId;
    }

    public void setStatusId(Long statusId) {
        this.statusId = statusId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

}