/*
 * @(#) LoginDto.java 1.1.0 2019-06-24
 * Copyright (c)  2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.module.customer.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;

/**
 * 登录获取权限dto
 *
 * @author sumo on 2020/10/20 0020
 */
public class LoginDto {
    private String accessToken; //登陆通行证

    private String code;

    private Long tenantId;//租户ID*

    private String appId;//接入应用appId

    private Long instanceId;//用户中心的应用实例ID

    private Long userId;//登录用户userId

    private String userCode;//登录用户名

    private String openId;//登录用户微信

    private String userType;//登录用户类型

    private String channel;//何种登录途径

    private String authKey;//authKey

    private UserAccessVo userAccessVo;//登录用户角色列表与权限

    //    i-sales全局管理 左侧导航栏（资源权限）
    private String menuType;

    public LoginDto() {
    }

    public LoginDto(String accessToken, Long userId) {
        this.accessToken = accessToken;
        this.userId = userId;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getAuthKey() {
        return authKey;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    public UserAccessVo getUserAccessVo() {
        return userAccessVo;
    }

    public void setUserAccessVo(UserAccessVo userAccessVo) {
        this.userAccessVo = userAccessVo;
    }

    public String getMenuType() {
        return menuType;
    }

    public void setMenuType(String menuType) {
        this.menuType = menuType;
    }
}
