package com.dtyunxi.yundt.module.customer.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "VerifyCustomerByOrgIdReqDto", description = "批量校验三要素ByOrgId")
public class VerifyCustomerByOrgIdReqDto{

    /************ 查询参数 *******************/

    @ApiModelProperty(value = "客户编号")
    private String cusCode;

    @ApiModelProperty(value = "第三方id")
    private String thirdPartyId;

    @ApiModelProperty(value = "第三方客户父级ID")
    private String thirdParentPartyId;

    /************ 校验参数 *******************/

    @ApiModelProperty("organization_info.org_name")
    private String orgName;

    @ApiModelProperty("organization_info.credit_code")
    private String creditCode;

    @ApiModelProperty("organization_info.legal_name")
    private String legalName;

    @ApiModelProperty(value = "公司所属省份")
    private String province;
    private String provinceCode;

    @ApiModelProperty(value = "公司所属城市")
    private String city;
    private String cityCode;

    @ApiModelProperty(value = "公司所属地区")
    private String district;
    private String districtCode;

    /*********** 处理参数 ********************/

    @ApiModelProperty(value = "处理结果")
    private boolean success;

    @ApiModelProperty(value = "处理异常信息")
    private String msg;

    /************* table处理参数 ******************/

    @ApiModelProperty(value = "处理任务Id")
    private String taskId;


}
