/*
 * *
 *  * @(#)ResetPasswordReqDto.java 2.0.0 2/27/20, 1:34 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.module.customer.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 重置密码参数
 * 
 * @author wu.sheng
 * @time 2019年8月1日 下午3:18:21
 */
@ApiModel(value = "ResetPasswordReqDto", description = "重置密码参数")
public class ResetPasswordReqDto {

	@ApiModelProperty(name = "captcha", value = "验证码", required = true)
	@NotNull
	private String captcha;

	/**
	 * 验证码唯一标识
	 */
	@ApiModelProperty(name = "captchaId", value = "验证码唯一标识")
	@NotNull
	private String captchaId;
	@ApiModelProperty(name = "type", value = " 1 短信  ")
	@NotNull
	private Integer type;
	@ApiModelProperty(name = "newPassword", value = "新密码", required = true)
	@NotNull
	private String newPassword;
	@ApiModelProperty(name = "target", value = "发送实体邮箱或手机， 如 手机：1364089665887", required = true)
	@NotNull
	private String target;

	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getCaptcha() {
		return captcha;
	}

	public void setCaptcha(String captcha) {
		this.captcha = captcha;
	}

	public String getCaptchaId() {
		return captchaId;
	}

	public void setCaptchaId(String captchaId) {
		this.captchaId = captchaId;
	}

	public String getNewPassword() {
		return newPassword;
	}

	public void setNewPassword(String newPassword) {
		this.newPassword = newPassword;
	}

}
