/**
 * @(#)IOauth2Login.java 1.0 2019年7月15日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.api.user;

import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;

/**
 * 第三方登录服务（目前仅支持微信）
 *
 * @author wu.sheng
 * @time 2019年7月15日 下午9:09:44
 */
public interface IOauth2Login {

    /**
     * 第一步：获取授权地址
     *
     * @param authLoginReqDto
     * @return
     */
    String getAuthUri(AuthLoginReqDto authLoginReqDto);

    /**
     * 第二步：根据授权码获取access_token,openid,已绑定的用户直接返回认证中心token
     *
     * @param authLoginTokenReqDto
     * @return
     */
    ThirdLoginRespDto getAuthToken(AuthLoginTokenReqDto authLoginTokenReqDto);

    /**
     * 第三步：openId绑定手机号,并生成认证中心token令牌
     *
     * @param userBindLoginThirdDto
     * @return
     */
    TokenRespDto bind(UserBindLoginThirdDto userBindLoginThirdDto);
}
