package com.dtyunxi.yundt.module.customer.api.dto.request;

import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author lius5
 * 企业三要素信息校验
 */
@Data
@ApiModel(value = "verifyCompanyReqDto", description = "企业三要素信息校验")
public class VerifyCompanyReqDto extends BaseReqDto {

    @ApiModelProperty(value = "企业信用代码,必填")
    @NotNull(message = "企业信用贷不能为空")
    private String creditCode;

    @ApiModelProperty(value = "企业法人,必填")
    @NotNull(message = "企业法人不能为空")
    private String legalPersonName;

    @ApiModelProperty(value = "企业名称,必填")
    @NotNull(message = "企业名称不能为空")
    private String name;
}
