package com.dtyunxi.yundt.module.customer.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 客户SKU授权批量数量统计响应DTO
 *
 * @author system
 * @date 2024-01-01
 */
@ApiModel(value = "客户SKU授权批量数量统计响应DTO")
public class CustomerSkuAuthBatchCountRespDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "SKU授权统计列表")
    private List<CustomerSkuAuthCountRespDto> skuAuthCounts;

    @ApiModelProperty(value = "查询的SKU总数")
    private Integer totalSkuCount;

    @ApiModelProperty(value = "查询成功的SKU数量")
    private Integer successCount;

    public CustomerSkuAuthBatchCountRespDto() {
    }

    public CustomerSkuAuthBatchCountRespDto(List<CustomerSkuAuthCountRespDto> skuAuthCounts) {
        this.skuAuthCounts = skuAuthCounts;
        this.totalSkuCount = skuAuthCounts != null ? skuAuthCounts.size() : 0;
        this.successCount = this.totalSkuCount;
    }

    public List<CustomerSkuAuthCountRespDto> getSkuAuthCounts() {
        return skuAuthCounts;
    }

    public void setSkuAuthCounts(List<CustomerSkuAuthCountRespDto> skuAuthCounts) {
        this.skuAuthCounts = skuAuthCounts;
    }

    public Integer getTotalSkuCount() {
        return totalSkuCount;
    }

    public void setTotalSkuCount(Integer totalSkuCount) {
        this.totalSkuCount = totalSkuCount;
    }

    public Integer getSuccessCount() {
        return successCount;
    }

    public void setSuccessCount(Integer successCount) {
        this.successCount = successCount;
    }

    @Override
    public String toString() {
        return "CustomerSkuAuthBatchCountRespDto{" +
                "skuAuthCounts=" + skuAuthCounts +
                ", totalSkuCount=" + totalSkuCount +
                ", successCount=" + successCount +
                '}';
    }
} 