package com.dtyunxi.yundt.module.customer.biz.util;

import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 树状集合转为平铺集合
 *
 * @ClassName TreeToList
 * @Author liuji
 * @Date 2021/04/06 16:40
 */
public class TreeToListUtil {

    public static List<OrganizationDto> treeToList(List<OrganizationDto> OrganizationDtos) {
        List<OrganizationDto> result = new ArrayList<>();
        for (OrganizationDto entity : OrganizationDtos) {
            result.add(entity);
            List<OrganizationDto> childDto = entity.getChildren();
            if (CollectionUtils.isNotEmpty(childDto)) {
                List<OrganizationDto> entityList = treeToList(childDto);
                result.addAll(entityList);
            }
        }
        /*if (result.size() > 0) {
            for (OrganizationDto entity : result) {
                entity.setChildren(null);
            }
        }*/
        Collections.reverse(result);
        return result;
    }
}
