package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IOrgInfoExtApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrganizationInfoExtDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrgInfoExtQueryApi;
import com.dtyunxi.yundt.module.customer.api.user.IOrgInfoExtService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class OrgInfoExtServiceImpl implements IOrgInfoExtService {
    private static final Logger logger = LoggerFactory.getLogger(OrgInfoExtServiceImpl.class);
    @Resource
    private IOrgInfoExtApi orgInfoExtApi;
    @Resource
    private IOrgInfoExtQueryApi orgInfoExtQueryApi;

    @Override
    public RestResponse<Long> addOrUpd(OrganizationInfoExtDto reqDto) {
        return orgInfoExtApi.addOrUpd(reqDto);
    }

    @Override
    public RestResponse<List<OrganizationInfoExtDto>> queryOrgInfoByOrgId( List<Long> orgIdList) {
        return orgInfoExtQueryApi.queryOrgInfoByOrgId(orgIdList);
    }


}
