package com.dtyunxi.yundt.module.customer.biz.service;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import org.springframework.web.multipart.MultipartFile;

/**
 * 药店数据模块
 * @author lius5
 */
public interface IStoreService {

    /**
     * 药店数据修改
     * @param reqDto
     */
    RestResponse<Void> saveOrUpdateStore(StoreReqDto reqDto);



    /**
     * 根据导入Excel处理数据
     * @param file
     */
    RestResponse<Void> saveOrUpdateStoreByExcel(MultipartFile file);

    /**
     * 同步药店修改信息到customer。该方法写在service是为了使Async注解生效
     */
    void syncStoreState2Customer(StoreReqDto reqDto);
}
