package com.dtyunxi.yundt.module.customer.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerGroupApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupModifyReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupTreeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerGroupQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerGroupService;
import com.github.pagehelper.PageInfo;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class CustomerGroupServiceImpl implements ICustomerGroupService {
    @Resource
    private IContext context;

    @Resource
    private ICustomerGroupApi customerGroupApi;
    @Resource
    private ICustomerGroupQueryApi customerGroupQueryApi;

    @Override
    public Long add(CustomerGroupAddReqDto addReqDto) {
        Long instanceId = context.instanceId();
        Long tenantId = context.tenantId();
        addReqDto.setInstanceId(instanceId);
        addReqDto.setTenantId(tenantId);
        RestResponse<Long> restResponse = customerGroupApi.add(addReqDto);
        return RestResponseHelper.extractData(restResponse);
    }

    @Override
    public void modify(CustomerGroupModifyReqDto modifyReqDto) {
        customerGroupApi.modify(modifyReqDto);
    }

    @Override
    public void remove(Long id) {
        customerGroupApi.remove(id);
    }

    @Override
    public CustomerGroupRespDto queryById(Long id) {
        RestResponse<CustomerGroupRespDto> restResponse = customerGroupQueryApi.queryById(id);
        return RestResponseHelper.extractData(restResponse);
    }

    @Override
    public PageInfo<CustomerGroupRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerGroupQueryReqDto searchReqDto = new CustomerGroupQueryReqDto();
        if (StringUtils.isNotBlank(filter)) {
            searchReqDto = JSONObject.parseObject(filter, CustomerGroupQueryReqDto.class);
        }
        searchReqDto.setInstanceId(context.instanceId());
        searchReqDto.setTenantId(context.tenantId());
        RestResponse<PageInfo<CustomerGroupRespDto>> restResponse = customerGroupQueryApi.queryByPage(searchReqDto, pageNum, pageSize);
        return RestResponseHelper.extractData(restResponse);
    }

    @Override
    public List<CustomerGroupTreeRespDto> queryForTree() {
        return RestResponseHelper.extractData(customerGroupQueryApi.queryForTree());
    }
}
