/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.module.dao.das.TenantGuideDas;
import com.dtyunxi.icommerce.module.dao.eo.TenantGuideEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.response.UserInfoRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.SrcTypeEnum;
import com.dtyunxi.yundt.module.customer.api.user.IUserService;
import com.dtyunxi.yundt.module.customer.api.user.dto.response.OrganizationPackageDto;
import com.dtyunxi.yundt.module.customer.biz.util.TreeToListUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="userService")
public class UserServiceImpl
implements IUserService {
    private static Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private TenantGuideDas tenantGuideDas;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;

    public UserInfoRespDto queryUserInfo(Long userId, Integer srcType) {
        OrgAndOrgInfoRespDto orgAndOrgInfoRespDto;
        UserInfoRespDto userInfoRespDto = new UserInfoRespDto();
        if (userId == null) {
            userId = this.context.userId();
        }
        userInfoRespDto.setUserId(userId);
        if (SrcTypeEnum.SALESMAN.getCode().equals(srcType)) {
            RestResponse listRestResp = this.organizationQueryApi.queryEmployeeByUserId(userId, "{}");
            EmployeeDto employeeDto = new EmployeeDto();
            if (CollectionUtils.isEmpty((Collection)((Collection)listRestResp.getData()))) {
                CustomerSearchExtReqDto customerSearchDto = new CustomerSearchExtReqDto();
                customerSearchDto.setSalesmanId(userId);
                PageInfo customerRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.employeeCustomerQueryApi.queryValidCustomerPage(customerSearchDto));
                EmployeeExtQueryReqDto employeeExtQueryReqDto = new EmployeeExtQueryReqDto();
                employeeExtQueryReqDto.setUserIds((List)Lists.newArrayList((Object[])new Long[]{userId}));
                employeeExtQueryReqDto.setStatus(Integer.valueOf(1));
                logger.info("\u67e5\u8be2\u7528\u6237\u7ed1\u5b9a\u7684\u542f\u7528\u72b6\u6001\u5458\u5de5={}", (Object)JSONObject.toJSONString((Object)employeeExtQueryReqDto));
                List employeeExtRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.getEmployeeByUserOrgList(employeeExtQueryReqDto));
                if (CollectionUtils.isEmpty((Collection)employeeExtRespDtos)) {
                    throw new BizException("\u8be5\u4e1a\u52a1\u5458\u8d26\u53f7\u672a\u7ed1\u5b9a\u5bf9\u5e94\u7684\u5458\u5de5\u4fe1\u606f\uff01");
                }
                CubeBeanUtils.copyProperties((Object)employeeDto, employeeExtRespDtos.get(0), (String[])new String[0]);
            } else {
                List employeeDtoList = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
                employeeDto = (EmployeeDto)employeeDtoList.get(0);
            }
            userInfoRespDto.setSalesmanName(employeeDto.getName());
            userInfoRespDto.setSalesmanNo(employeeDto.getEmployeeNo());
            userInfoRespDto.setPhone(employeeDto.getPhoneNum());
            userInfoRespDto.setEmail(employeeDto.getEmail());
            TenantGuideEo selectGuide = new TenantGuideEo();
            selectGuide.setTenantId(this.context.tenantId());
            List guideEos = this.tenantGuideDas.select((BaseEo)selectGuide);
            if (CollectionUtils.isNotEmpty((Collection)guideEos)) {
                userInfoRespDto.setCompanyName(((TenantGuideEo)guideEos.get(0)).getCompanyName());
            }
        } else {
            RestResponse longRestResp;
            RestResponse userRestResp = this.userQueryApi.queryById(userId, "{}");
            UserDto userDto = (UserDto)RestResponseHelper.extractData((RestResponse)userRestResp);
            if (Objects.nonNull(userDto)) {
                userInfoRespDto.setUserName(userDto.getUserName());
            }
            if (Objects.isNull((longRestResp = this.customerExtQueryApi.queryOrgIdByUserId(userId)).getData())) {
                List orgIdList = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.getEmployeeOrgIdByUserId(userId));
                if (CollectionUtils.isNotEmpty((Collection)orgIdList)) {
                    userInfoRespDto.setOrgInfoId((Long)orgIdList.get(0));
                }
            } else {
                Long orgId = (Long)RestResponseHelper.extractData((RestResponse)longRestResp);
                userInfoRespDto.setOrgInfoId(orgId);
            }
            RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(userInfoRespDto.getOrgInfoId());
            OrgAdvDetailRespDto orgAdvDetail = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
            if (Objects.nonNull(orgAdvDetail)) {
                userInfoRespDto.setOrgName(orgAdvDetail.getName());
            }
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(Arrays.asList(userInfoRespDto.getOrgInfoId()));
        List orgAndOrgInfoByIds = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOrgAndOrgInfoByIds(orgIds));
        logger.info("\u83b7\u53d6\u6240\u5c5eorgInfo orgAndOrgInfoList = {}", (Object)JSONObject.toJSONString((Object)orgAndOrgInfoByIds));
        if (orgAndOrgInfoByIds != null && (orgAndOrgInfoRespDto = (OrgAndOrgInfoRespDto)orgAndOrgInfoByIds.stream().filter(e -> userInfoRespDto.getOrgInfoId().equals(e.getOrganizationDto().getId())).findAny().orElse(null)) != null && orgAndOrgInfoRespDto.getOrganizationInfoDto() != null) {
            userInfoRespDto.setOrganizationName(orgAndOrgInfoRespDto.getOrganizationInfoDto().getOrgName());
        }
        return userInfoRespDto;
    }

    public OrganizationPackageDto showOrgIds(Long orgId) {
        List fullAddOrgs = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOrgByCurUser(new UserOrgQueryReqDto()));
        List<Object> currShowOrgs = new ArrayList();
        if (Objects.nonNull(orgId)) {
            currShowOrgs = this.processOrgs(fullAddOrgs, orgId);
        }
        return new OrganizationPackageDto(fullAddOrgs, currShowOrgs);
    }

    private List<OrganizationDto> processOrgs(List<OrganizationDto> fullAddOrgs, Long orgId) {
        ArrayList<OrganizationDto> currShowOrgs = new ArrayList<OrganizationDto>();
        ArrayList<OrganizationDto> fullCopyOrgs = new ArrayList<OrganizationDto>();
        CubeBeanUtils.copyCollection(fullCopyOrgs, fullAddOrgs, OrganizationDto.class);
        Map<Long, OrganizationDto> orgMap = TreeToListUtil.treeToList(fullCopyOrgs).stream().collect(Collectors.toMap(OrganizationDto::getId, dto -> {
            OrganizationDto organizationDto = new OrganizationDto();
            organizationDto.setId(dto.getId());
            organizationDto.setName(dto.getName());
            organizationDto.setParentId(dto.getParentId());
            return organizationDto;
        }));
        while (!Objects.isNull(orgMap.get(orgId))) {
            currShowOrgs.add(orgMap.get(orgId));
            orgId = orgMap.get(orgId).getParentId();
        }
        if (CollectionUtils.isEmpty(currShowOrgs)) {
            OrganizationDto dto2 = new OrganizationDto();
            dto2.setId(orgId);
            currShowOrgs.add(dto2);
        }
        return currShowOrgs;
    }

    public Long getCurrentUserOrgId(Long userId) {
        return (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
    }
}

