package com.dtyunxi.yundt.module.customer.biz.impl.user;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.module.dao.das.TenantGuideDas;
import com.dtyunxi.icommerce.module.dao.eo.TenantGuideEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.RCustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserOrgQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.response.UserInfoRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.SrcTypeEnum;
import com.dtyunxi.yundt.module.customer.api.exception.CustomerModuleExceptionCode;
import com.dtyunxi.yundt.module.customer.api.user.IUserService;
import com.dtyunxi.yundt.module.customer.api.user.dto.response.OrganizationPackageDto;
import com.dtyunxi.yundt.module.customer.biz.util.TreeToListUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 用户服务实现
 *
 * @author: xuhuaqiang
 */
@Service("userService")
public class UserServiceImpl implements IUserService {

    private static Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);

    @Resource
    private IContext context;

    @Resource
    private IUserQueryApi userQueryApi;

    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Resource
    private TenantGuideDas tenantGuideDas;

    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;

    @Override
    public UserInfoRespDto queryUserInfo(Long userId, Integer srcType) {

        UserInfoRespDto userInfoRespDto = new UserInfoRespDto();
        if (userId == null) {
            userId = context.userId();
        }
        userInfoRespDto.setUserId(userId);
        //判断是否是业务员小程序端
        if (SrcTypeEnum.SALESMAN.getCode().equals(srcType)) {
            //查询该业务员对应的员工信息
            RestResponse<List<EmployeeDto>> listRestResp = organizationQueryApi.queryEmployeeByUserId(userId, "{}");
            EmployeeDto employeeDto = new EmployeeDto();
            if (CollectionUtils.isEmpty(listRestResp.getData())) {
                EmployeeExtQueryReqDto employeeExtQueryReqDto = new EmployeeExtQueryReqDto();
                employeeExtQueryReqDto.setUserIds(Lists.newArrayList(userId));
                employeeExtQueryReqDto.setStatus(1);
                logger.info("查询用户绑定的启用状态员工={}",JSONObject.toJSONString(employeeExtQueryReqDto));
                List<EmployeeExtRespDto> employeeExtRespDtos = RestResponseHelper.extractData(employeeExpandQueryApi.getEmployeeByUserOrgList(employeeExtQueryReqDto));
                if (CollectionUtils.isEmpty(employeeExtRespDtos)) {
                    throw new BizException("该业务员账号未绑定对应的员工信息！");
                }
                CubeBeanUtils.copyProperties(employeeDto,employeeExtRespDtos.get(0));
            }else{
                List<EmployeeDto> employeeDtoList = RestResponseHelper.extractData(listRestResp);
                employeeDto = employeeDtoList.get(0);
            }


            userInfoRespDto.setSalesmanName(employeeDto.getName());
            userInfoRespDto.setSalesmanNo(employeeDto.getEmployeeNo());
            userInfoRespDto.setPhone(employeeDto.getPhoneNum());
            userInfoRespDto.setEmail(employeeDto.getEmail());
            //获取该租户对应的公司名称
            TenantGuideEo selectGuide = new TenantGuideEo();
            selectGuide.setTenantId(context.tenantId());
            List<TenantGuideEo> guideEos = tenantGuideDas.select(selectGuide);
            if (CollectionUtils.isNotEmpty(guideEos)) {
                userInfoRespDto.setCompanyName(guideEos.get(0).getCompanyName());
            }
        } else {
            //查询用户信息
            RestResponse<UserDto> userRestResp = userQueryApi.queryById(userId, "{}");
            UserDto userDto = RestResponseHelper.extractData(userRestResp);
            if (Objects.nonNull(userDto)) {
                userInfoRespDto.setUserName(userDto.getUserName());
            }
            //获取登录人绑定的组织
            RestResponse<Long> longRestResp = customerExtQueryApi.queryOrgIdByUserId(userId);
            if (Objects.isNull(longRestResp.getData())) {
                List<Long> orgIdList = RestResponseHelper.extractData(employeeExpandQueryApi.getEmployeeOrgIdByUserId(userId));
                if (CollectionUtils.isNotEmpty(orgIdList)) {
                    userInfoRespDto.setOrgInfoId(orgIdList.get(0));
                }
            } else {
                Long orgId = RestResponseHelper.extractData(longRestResp);
                userInfoRespDto.setOrgInfoId(orgId);
            }

            RestResponse<OrgAdvDetailRespDto> orgAdvDetailRestResp = organizationQueryExtApi.queryById(userInfoRespDto.getOrgInfoId());
            OrgAdvDetailRespDto orgAdvDetail = RestResponseHelper.extractData(orgAdvDetailRestResp);
            if (Objects.nonNull(orgAdvDetail)) {
                userInfoRespDto.setOrgName(orgAdvDetail.getName());
            }
//            RestResponse<PageInfo<OrganizationDto>> pageInfoRestResponse = organizationQueryApi.queryUserOrgRelation(userId, 1, 1);
//            PageInfo<OrganizationDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);
//            Assert.isTrue(CollectionUtils.isNotEmpty(pageInfo.getList()),"当前登录人未绑定组织");
//            Long orgInfoId = pageInfo.getList().get(0).getId();

            //查询客户以及客户类型信息
//            CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
//            searchReqDto.setOrgInfoIds(Lists.newArrayList(orgInfoId));
//            searchReqDto.setTenantId(context.tenantId());
//            RestResponse<PageInfo<CustomerRespDto>> customerRestResp = customerExtQueryApi.queryByPage(JSON.toJSONString(searchReqDto),1,1);
//            PageInfo<CustomerRespDto> customerPageInfo = RestResponseHelper.extractData(customerRestResp);
//            if (Objects.nonNull(customerPageInfo) && CollectionUtils.isNotEmpty(customerPageInfo.getList())){
//                userInfoRespDto.setCustomerTypeId(customerPageInfo.getList().get(0).getCustomerTypeId());
//                userInfoRespDto.setCustomerTypeName(customerPageInfo.getList().get(0).getCustomerTypeName());
//                userInfoRespDto.setCustomerId(customerPageInfo.getList().get(0).getId());
//                userInfoRespDto.setCustomerName(customerPageInfo.getList().get(0).getName());
//            }
        }
        //获取org列表
        ArrayList<Long> orgIds = new ArrayList<>(Arrays.asList(userInfoRespDto.getOrgInfoId()));
        List<OrgAndOrgInfoRespDto> orgAndOrgInfoByIds = RestResponseHelper.extractData(organizationQueryApi.queryOrgAndOrgInfoByIds(orgIds));
        logger.info("获取所属orgInfo orgAndOrgInfoList = {}", JSONObject.toJSONString(orgAndOrgInfoByIds));
        if (orgAndOrgInfoByIds != null) {
            OrgAndOrgInfoRespDto orgAndOrgInfoRespDto = orgAndOrgInfoByIds.stream().filter(e -> userInfoRespDto.getOrgInfoId().equals(e.getOrganizationDto().getId())).findAny().orElse(null);
            if (orgAndOrgInfoRespDto != null && orgAndOrgInfoRespDto.getOrganizationInfoDto() != null) {
                userInfoRespDto.setOrganizationName(orgAndOrgInfoRespDto.getOrganizationInfoDto().getOrgName());
            }
        }

        return userInfoRespDto;
    }

    @Override
    public OrganizationPackageDto showOrgIds(Long orgId) {
        List<OrganizationDto> fullAddOrgs = RestResponseHelper.extractData(organizationQueryApi.queryOrgByCurUser(new UserOrgQueryReqDto()));
        List<OrganizationDto> currShowOrgs = new ArrayList<>();
        if (Objects.nonNull(orgId)) {
            currShowOrgs = processOrgs(fullAddOrgs, orgId);
        }

        return new OrganizationPackageDto(fullAddOrgs, currShowOrgs);
    }

    private List<OrganizationDto> processOrgs(List<OrganizationDto> fullAddOrgs, Long orgId) {
        List<OrganizationDto> currShowOrgs = new ArrayList<>();
        List<OrganizationDto> fullCopyOrgs = new ArrayList<>();
        CubeBeanUtils.copyCollection(fullCopyOrgs, fullAddOrgs, OrganizationDto.class);
        Map<Long, OrganizationDto> orgMap = TreeToListUtil.treeToList(fullCopyOrgs).stream().
                collect(Collectors.toMap(OrganizationDto::getId, dto -> {
                    OrganizationDto organizationDto = new OrganizationDto();
                    organizationDto.setId(dto.getId());
                    organizationDto.setName(dto.getName());
                    organizationDto.setParentId(dto.getParentId());
                    return organizationDto;
                }));
        while (true) {
            if (Objects.isNull(orgMap.get(orgId))) {
                break;
            }
            currShowOrgs.add(orgMap.get(orgId));
            orgId = orgMap.get(orgId).getParentId();
        }
        // 如果传入的组织id找不到dto；new一个dto返回
        if (CollectionUtils.isEmpty(currShowOrgs)) {
            OrganizationDto dto = new OrganizationDto();
            dto.setId(orgId);
            currShowOrgs.add(dto);
        }
        return currShowOrgs;
    }

    @Override
    public Long getCurrentUserOrgId(Long userId) {
//        ServiceContext serviceContext = ServiceContext.getContext();
//        Object object = serviceContext.get("yes.req.cus.tcbj.organizationid");
//        if (object != null){
//            return Long.valueOf((String) object);
//        }
//
//        Assert.isTrue(userId!=null, "找不到userId:");
//
//        RestResponse<PageInfo<OrganizationDto>> pageInfoRestResponse = organizationQueryApi.queryUserOrgRelation(userId, 1, 1);
//        PageInfo<OrganizationDto> pageInfo = RestResponseHelper.extractData(pageInfoRestResponse);
//        Assert.isTrue(!org.springframework.util.CollectionUtils.isEmpty(pageInfo.getList()),"当前登录人未绑定组织");
//        return pageInfo.getList().get(0).getId();
        return RestResponseHelper.extractData(customerExtQueryApi.queryOrgIdByUserId(userId));
    }
}
