/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.module.dao.das.TenantGuideDas;
import com.dtyunxi.icommerce.module.dao.eo.TenantGuideEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.Base64;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.query.IPostAssignmentQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerSalesmanQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.identity.api.ITokenApi;
import com.dtyunxi.yundt.cube.center.identity.api.IVerifyCodeApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.user.api.IAuthorizeApi;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserModifyPasswordDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.ResetPasswordReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.TenantGuideRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.SrcTypeEnum;
import com.dtyunxi.yundt.module.customer.api.exception.CustomerModuleExceptionCode;
import com.dtyunxi.yundt.module.customer.api.user.IAuthentication;
import com.dtyunxi.yundt.module.customer.api.user.dto.response.CurrentPartner;
import com.dtyunxi.yundt.module.customer.api.user.dto.response.H5LoginDtoResp;
import com.dtyunxi.yundt.module.customer.api.user.dto.response.HttpResponseDto;
import com.dtyunxi.yundt.module.customer.biz.util.HttpExtUtil;
import com.dtyunxi.yundt.module.customer.bo.LoginInfo;
import com.dtyunxi.yundt.module.customer.bo.TokenInfo;
import com.dtyunxi.yundt.module.domain.util.ConvertUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationImpl
implements IAuthentication {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationImpl.class);
    private static final String h5Pwd = "ZJJK123456";
    @Resource
    private ITokenApi tokenApi;
    @Resource
    private IContext context;
    @Resource
    IVerifyCodeApi verifyCodeApi;
    @Resource
    private ISecurityApi securityApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IAuthorizeApi authorizeApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private TenantGuideDas tenantGuideDas;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private HttpExtUtil httpExtUtil;
    @Resource
    private IPostAssignmentQueryApi postAssignmentQueryApi;
    @Value(value="${marketing.cloud.h5.login.url:https://nyxyapp.by-health.com/micro-csp/simpleLogin}")
    private String h5LoginUrl;
    @Value(value="${marketing.cloud.h5.login:false}")
    private Boolean isCloudH5Login;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerSalesmanQueryApi customerSalesmanQueryApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Value(value="${icommerceb.post.postCode}")
    private String sysPostCode;
    @Value(value="${comm.master.data.onoff:false}")
    private Boolean onoffFlag;

    public TokenInfo login(LoginInfo loginInfo) {
        RestResponse listRestResp;
        List customerRespDtos;
        if (loginInfo.getType() != 1 && this.isCloudH5Login.booleanValue()) {
            return this.newLogin(loginInfo);
        }
        UserLoginReqDto userLoginReqDto = this.convert2UserLoginReqDto(loginInfo);
        userLoginReqDto.setInstanceId(this.context.instanceId());
        userLoginReqDto.setTenantId(this.context.tenantId());
        Long instanceId = this.context.instanceId();
        logger.info("\u767b\u5f55instanceId={}", (Object)instanceId);
        String applicationKey = ServiceContext.getContext().getAttachment("Application-Key");
        logger.info("\u767b\u5f55applicationKey={}", (Object)applicationKey);
        logger.info("\u767b\u5f55\u53c2\u6570userLoginReqDto={}", (Object)ObjectHelper.bean2Json((Object)userLoginReqDto));
        RestResponse restResponse = this.tokenApi.createToken(userLoginReqDto);
        TokenRespDto tokenRespDto = (TokenRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        if (null == tokenRespDto) {
            throw new BizException(CustomerModuleExceptionCode.LOGIN_FAIL.getCode(), CustomerModuleExceptionCode.LOGIN_FAIL.getMsg());
        }
        if (SrcTypeEnum.SALESMAN.getCode().equals(loginInfo.getSrcType()) && CollectionUtils.isEmpty((Collection)(customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)(listRestResp = this.customerSalesmanQueryApi.queryByUserId(tokenRespDto.getUserId())))))) {
            CustomerSearchExtReqDto customerSearchDto = new CustomerSearchExtReqDto();
            customerSearchDto.setSalesmanId(tokenRespDto.getUserId());
            PageInfo customerRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.employeeCustomerQueryApi.queryValidCustomerPage(customerSearchDto));
            if (CollectionUtils.isEmpty((Collection)customerRespDtoPageInfo.getList())) {
                throw new BizException(CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getCode(), CustomerModuleExceptionCode.SALESMAN_LOGIN_FAIL.getMsg());
            }
        }
        TokenInfo tokenInfo = (TokenInfo)ConvertUtil.convert((Object)restResponse.getData(), TokenInfo.class);
        UserDto userDto = (UserDto)this.userQueryApi.queryById(((TokenRespDto)restResponse.getData()).getUserId(), null).getData();
        tokenInfo.setUserType(userDto.getUserType());
        tokenInfo.setPhone(userDto.getPhone());
        tokenInfo.setInstanceId(userLoginReqDto.getInstanceId());
        tokenInfo.setTenantId(userLoginReqDto.getTenantId());
        if (loginInfo.getType() != 1) {
            RestResponse longRestResp = this.customerExtQueryApi.queryOrgIdByUserId(tokenInfo.getUserId());
            if (Objects.isNull(longRestResp.getData())) {
                List orgIdList = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.getEmployeeOrgIdByUserId(tokenInfo.getUserId()));
                if (CollectionUtils.isEmpty((Collection)orgIdList)) {
                    throw new BizException(CustomerModuleExceptionCode.LOGIN_USER_FAIL.getCode(), CustomerModuleExceptionCode.LOGIN_USER_FAIL.getMsg());
                }
                tokenInfo.setOrgInfoId((Long)orgIdList.get(0));
            } else {
                Long orgId = (Long)RestResponseHelper.extractData((RestResponse)longRestResp);
                tokenInfo.setOrgInfoId(orgId);
            }
        }
        tokenInfo.setIsFirstLogin(Integer.valueOf(0));
        return tokenInfo;
    }

    private UserLoginReqDto convert2UserLoginReqDto(LoginInfo loginInfo) {
        UserLoginReqDto userLoginReqDto = new UserLoginReqDto();
        userLoginReqDto.setLoginType(loginInfo.getLoginType());
        userLoginReqDto.setIdCode(loginInfo.getLoginName());
        userLoginReqDto.setCode(loginInfo.getCaptcha());
        userLoginReqDto.setUniqueId(loginInfo.getCaptchaId());
        userLoginReqDto.setCheckCode(loginInfo.getCaptcha());
        userLoginReqDto.setCheckCodeUniqueId(loginInfo.getCaptchaId());
        userLoginReqDto.setPhone(loginInfo.getLoginName());
        userLoginReqDto.setUserName(loginInfo.getLoginName());
        userLoginReqDto.setPassword(loginInfo.getPassword());
        userLoginReqDto.setEmail(loginInfo.getLoginName());
        if (null != loginInfo.getKeepDays()) {
            Integer tokenValidTime = loginInfo.getKeepDays() * 24 * 3600;
            userLoginReqDto.setTokenValidTime(tokenValidTime);
        }
        return userLoginReqDto;
    }

    public void logout(Long userId) {
        RestResponse restResponse = this.tokenApi.deleteToken(String.valueOf(userId));
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    public void modifyPassword(String userName, String password, String newPassword) {
        UserModifyPasswordDto userModifyPasswordDto = new UserModifyPasswordDto();
        userModifyPasswordDto.setInstanceId(this.context.instanceId());
        userModifyPasswordDto.setNewPassword(newPassword);
        userModifyPasswordDto.setPassword(password);
        userModifyPasswordDto.setUserName(userName);
        RestResponse voidRestResponse = this.securityApi.modifyPassword(userModifyPasswordDto);
        RestResponseHelper.checkOrThrow((RestResponse)voidRestResponse);
    }

    public void resetPassword(ResetPasswordReqDto resetPasswordReqDto) {
        if (resetPasswordReqDto.getType() == null) {
            throw new BizException("\u9a8c\u8bc1\u7801\u7c7b\u578b\u9519\u8bef");
        }
        switch (resetPasswordReqDto.getType()) {
            case 1: {
                resetPasswordReqDto.setType(Integer.valueOf(2));
                break;
            }
            default: {
                throw new BizException("\u9a8c\u8bc1\u7801\u7c7b\u578b\u9519\u8bef");
            }
        }
        RequestDto requestDto = new RequestDto();
        requestDto.setInstanceId(this.context.instanceId());
        requestDto.setTenantId(this.context.tenantId());
        if (!resetPasswordReqDto.getCaptchaId().contains(resetPasswordReqDto.getTarget())) {
            throw new BizException("\u4fee\u6539\u9a8c\u8bc1\u7801\u548c\u624b\u673a\u4e0d\u4e00\u81f4");
        }
        RestResponse restResponse1 = this.verifyCodeApi.checkVerifyCode(resetPasswordReqDto.getCaptcha(), resetPasswordReqDto.getCaptchaId(), resetPasswordReqDto.getType());
        Boolean isCheck = (Boolean)RestResponseHelper.extractData((RestResponse)restResponse1);
        if (!isCheck.booleanValue()) {
            throw new BizException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        RestResponse userDtoRestResponse = this.userQueryApi.queryByPhone(resetPasswordReqDto.getTarget(), JSON.toJSONString((Object)requestDto));
        UserDto userDto = (UserDto)RestResponseHelper.extractData((RestResponse)userDtoRestResponse);
        if (userDto == null) {
            throw new BizException("\u624b\u673a\u53f7\u65e0\u6cd5\u5230\u67e5\u8be2\u7528\u6237\u4fe1\u606f");
        }
        RestResponse restResponse = this.securityApi.resetPasswordByAdmin(userDto.getId(), resetPasswordReqDto.getNewPassword());
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    public void resetPassword(Long userId, String newPassword) {
        RestResponse restResponse = this.securityApi.resetPasswordByAdmin(userId, newPassword);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        Boolean flag = this.setFirstLoginFlag(userId.toString());
    }

    public void bindPhone(Long userId, String phone) {
        RestResponse restResponse = this.authorizeApi.bindPhone(this.context.instanceId(), userId, phone);
        RestResponseHelper.extractData((RestResponse)restResponse);
    }

    public void unbindPhone(Long userId, String phone) {
        RestResponse restResponse = this.authorizeApi.unbindPhone(this.context.instanceId(), userId, phone);
        RestResponseHelper.extractData((RestResponse)restResponse);
    }

    public TenantGuideRespDto tenantGuide(Long tenantId) {
        TenantGuideRespDto guideRespDto = new TenantGuideRespDto();
        TenantGuideEo selectGuide = new TenantGuideEo();
        selectGuide.setTenantId(tenantId);
        List guideEos = this.tenantGuideDas.select((BaseEo)selectGuide);
        if (CollectionUtils.isNotEmpty((Collection)guideEos)) {
            BeanUtils.copyProperties(guideEos.get(0), (Object)guideRespDto);
        }
        return guideRespDto;
    }

    public TokenInfo newLogin(LoginInfo loginInfo) {
        List<H5LoginDtoResp> list = this.postImarketingServiceLogin(loginInfo);
        UserLoginReqDto userLoginReqDto = this.convert2UserLoginReqDto(loginInfo);
        userLoginReqDto.setInstanceId(this.context.instanceId());
        userLoginReqDto.setTenantId(this.context.tenantId());
        userLoginReqDto.setPassword(Base64.encodeString((String)h5Pwd).replaceAll("=", ""));
        logger.info("\u767b\u5f55\u53c2\u6570userLoginReqDto={}", (Object)ObjectHelper.bean2Json((Object)userLoginReqDto));
        RestResponse restResponse = this.tokenApi.createToken(userLoginReqDto);
        logger.info("\u767b\u5f55\u8fd4\u56de\u7684\u7ed3\u679c={}", restResponse.getData());
        TokenRespDto tokenRespDto = (TokenRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        if (null == tokenRespDto) {
            throw new BizException(CustomerModuleExceptionCode.LOGIN_FAIL.getCode(), CustomerModuleExceptionCode.LOGIN_FAIL.getMsg());
        }
        TokenInfo tokenInfo = (TokenInfo)ConvertUtil.convert((Object)restResponse.getData(), TokenInfo.class);
        CurrentPartner currentPartner = list.get(0).getCurrentPartner();
        if (currentPartner != null && StringUtils.equals((String)"true", (String)currentPartner.getOrg())) {
            List orgCodes = list.stream().map(H5LoginDtoResp::getId).collect(Collectors.toList());
            List organizationDtoList = (List)this.organizationQueryApi.queryListByOrgCode(Long.valueOf(-1L), orgCodes).getData();
            if (CollectionUtils.isNotEmpty((Collection)organizationDtoList)) {
                tokenInfo.setOrgInfoId(((OrganizationDto)organizationDtoList.get(0)).getId());
            }
        }
        tokenInfo.setIsFirstLogin(Integer.valueOf(0));
        return tokenInfo;
    }

    private List<H5LoginDtoResp> postImarketingServiceLogin(LoginInfo loginInfo) {
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("password", Base64.decodeString((byte[])loginInfo.getPassword().getBytes(StandardCharsets.UTF_8)));
        mapParam.put("account", loginInfo.getLoginName());
        HttpResponseDto httpResponseDto = this.httpExtUtil.httpPost(this.h5LoginUrl, mapParam, HttpResponseDto.class);
        logger.info("\u8c03\u7528\u8425\u9500\u4e91H5\u767b\u9646\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a:{}", (Object)JacksonUtil.toJson((Object)httpResponseDto));
        Assert.isTrue((httpResponseDto != null ? 1 : 0) != 0, (String)"1000001", (String)"\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u62a5\u9519");
        String errorCode = httpResponseDto.getErrorCode();
        Assert.isTrue((boolean)"0000".equals(errorCode), (String)"100000", (String)"\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u62a5\u9519");
        Object returnObject = httpResponseDto.getReturnObject();
        return (List)JacksonUtil.readValue((String)JacksonUtil.toJson((Object)returnObject), (TypeReference)new TypeReference<List<H5LoginDtoResp>>(){});
    }

    private String getFirstLoginCacheKey(String userId) {
        StringBuffer sb = new StringBuffer();
        sb.append("FIRST_LOGIN").append(":").append(userId);
        return sb.toString();
    }

    public String getFirstLoginFlag(String userId) {
        return (String)this.cacheService.getCache(this.getFirstLoginCacheKey(userId), String.class);
    }

    public Boolean setFirstLoginFlag(String userId) {
        String cacheKey = this.getFirstLoginCacheKey(userId);
        Long result = this.cacheService.setnx(cacheKey, "1");
        return result == 1L;
    }
}

