package com.dtyunxi.yundt.module.customer.biz.mq.process;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.biz.commons.utils.ExcelUtil;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerDataApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerImportSaveReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportEventReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportUpdateReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.SupplierInfoExcelReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportStatusEnum;
import com.dtyunxi.yundt.module.customer.biz.mq.constants.MessageTag;
import com.dtyunxi.yundt.module.customer.biz.mq.constants.MessageTopic;
import com.dtyunxi.yundt.module.customer.biz.service.ISupplierImportLogService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;

/**
 * 供应商信息导入监听与处理
 *
 * @author sumo on 2020/10/13 0013
 */

@Component
@MQDesc(topic = MessageTopic.SUPPLIER_INFO_IMPORT_TOPIC, tag = MessageTag.SUPPLIER_INFO_IMPORT_TAG)
public class SupplierInfoImportProcessor implements IMessageProcessor<CustomerImportSaveReqDto> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICacheService cacheService;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private ICustomerDataApi iCustomerDataApi;
    @Resource
    private ISupplierImportLogService supplierImportLogService;
    @Resource
    private OssRegistryVo ossRegistryVo;

    @Override
    public MessageResponse process(CustomerImportSaveReqDto eventDto) {
        logger.info("客户批量导入 ---> 收到批量客户信息批量导入的MQ消息" + eventDto.getTenantId());
        //注入实例id
        ServiceContext.getContext().setAttachment("yes.req.tenantId", String.valueOf(eventDto.getTenantId()));
        ServiceContext.getContext().setAttachment("yes.req.instanceId", String.valueOf(eventDto.getInstanceId()));
        //注入实例id
        MDC.put("yes.req.requestId", UUID.randomUUID().toString().replace("-", ""));

        logger.info("供应商批量导入 ---> 收到批量供应商信息批量导入的MQ消息:{}", JSON.toJSONString(eventDto));
        //检查消息体内容信息
        if (eventDto.getUrl() == null) {
            logger.error("消息体内容不全，忽略处理");
            return MessageResponse.SUCCESS;
        }
        if (StringUtils.isNotBlank(cacheService.getCache("supplierExcelImportKey", eventDto.getId() + "", String.class))) {
            //该文件正在处理中，不处理
            return MessageResponse.SUCCESS;
        } else {
            cacheService.setCache("supplierExcelImportKey", eventDto.getId() + "", "{}", 10);
        }
        final ImportUpdateReqDto memberImportRespDto = new ImportUpdateReqDto();
        try {
            //2、获取消息体的导入文件URL地址
            InputStream is = getInputStream(eventDto.getUrl());
            // 转换导入数据
            logger.info("客户批量导入进行中 ---> 开始下载excel");
            long currentTimeMillis = System.currentTimeMillis();
            logger.info("客户批量导入进行中 ---> 开始读取excel");
            ExcelImportResult<SupplierInfoExcelReqDto> objectExcelImportResult =
                    EasyPoiExportUtil.importExcel(is, 0, 1, SupplierInfoExcelReqDto.class);
            logger.info("客户批量导入进行中 ---> 读取excel成功,时间花费{}毫秒", System.currentTimeMillis() - currentTimeMillis);
            List<SupplierInfoExcelReqDto> supplierInfoExcelReqDtos = objectExcelImportResult.getList();
            logger.info("客户批量导入进行中 ---> 数据量" + supplierInfoExcelReqDtos.size());
            //todo:sumo 做好超大数据校验
            if (supplierInfoExcelReqDtos.isEmpty() || supplierInfoExcelReqDtos.size() > 50000) {
                logger.error("供应商信息批量导入数据为空或者超过最大数量");
                ImportUpdateReqDto eo = new ImportUpdateReqDto();
                eo.setId(eventDto.getId());
                eo.setStatus(ImportStatusEnum.EMPTY.getCode());
                eo.setTotalNum(0);
                eo.setErrorNum(0);
                eo.setSuccessNum(0);
                eo.setRepeatNum(0);
                eo.setErrorReason("供应商信息批量导入数据为空或者超过最大数量");
                iCustomerDataApi.update(eo);
                return MessageResponse.SUCCESS;
            }

            ImportEventReqDto importEventReqDto = new ImportEventReqDto();
            BeanUtils.copyProperties(eventDto, importEventReqDto);
            importEventReqDto.setSupplierInfoExcelReqList(supplierInfoExcelReqDtos);
            int totalSize = supplierInfoExcelReqDtos.size();
            memberImportRespDto.setStatus(ImportStatusEnum.SUCCESS.getCode());
            logger.info("客户批量导入进行中 ---> 开始针对excel进行导入");
            supplierImportLogService.importSupplier(importEventReqDto, dataValidateResult -> {

                /*********************************************   数据校验结果处理  ***********************************************************/
                String downloadUrl = null;
                if (dataValidateResult.getErrorSupplierInfoExcelList().size() > 0) {
                    //封装Excel文件
                    String fileName = "供应商信息错误列表" + com.dtyunxi.cube.utils.DateUtil.getDateFormat(new Date(), "yyyyMMddHHmmss") + String.format("%02d", new Random().nextInt(100)) + ".xls";
                    //生成excel并输出inputStream
                    InputStream inputStream = ExcelUtil.createExcel(new String[]{"供应商信息错误列表"}, dataValidateResult.getErrorSupplierInfoExcelList());
                    //上传到oss
                    objectStorageService.put(ossRegistryVo.getBucketName(), fileName, inputStream);
                    //拼接下载链接
                    downloadUrl = objectStorageService.getFileUrl(fileName);
                    logger.info("供应商批量导入 ---> 上传错误的Excel成功，连接地址：{}", downloadUrl);
                }

                Integer errorNum = dataValidateResult.getErrorSupplierInfoExcelList().size();
                Integer successNum = dataValidateResult.getOkSupplierinfoexcelreqdtos().size();

                memberImportRespDto.setTotalNum(totalSize);
                memberImportRespDto.setErrorNum(errorNum);
                memberImportRespDto.setSuccessNum(totalSize - errorNum);
                memberImportRespDto.setStatus(ImportStatusEnum.LOADING.getCode());
                memberImportRespDto.setErrorReason(downloadUrl);
                memberImportRespDto.setStatus(memberImportRespDto.getTotalNum().equals(memberImportRespDto.getErrorNum()) ? ImportStatusEnum.ERROR.getCode() : ImportStatusEnum.SUCCESS.getCode());
                logger.info("供应商批量导入 --->总数量:{} 不合格的数据量：{}，合格的数据量：{}", memberImportRespDto.getTotalNum(), errorNum, successNum);


                //就算有不合格数据，合格的数据先进行注册
                return true;
            });


            memberImportRespDto.setId(eventDto.getId());
            iCustomerDataApi.update(memberImportRespDto);
            logger.info("供应商批量导入 ---> 结束标志任务执行完成状态");
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("供应商批量导入异常 ---> 该消息不再重新投递");
            memberImportRespDto.setStatus(ImportStatusEnum.ERROR.getCode());
            memberImportRespDto.setRemark(e.getMessage());
            iCustomerDataApi.update(memberImportRespDto);
            logger.info("供应商批量导入 ---> 结束标志任务执行失败状态");
            return MessageResponse.SUCCESS;
        }


        return MessageResponse.SUCCESS;
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        return conn.getInputStream();
    }
}
