package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeRoleApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.IEmployeeRoleService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author liangfa
 * @Description 人员角色信息接口
 * @date 2022-01-14 17:38
 * @since 1.0.0
 */
@Service
public class EmployeeRoleServiceImpl implements IEmployeeRoleService {

    @Resource
    private IEmployeeRoleApi employeeRoleApi;


    @Override
    public RestResponse<Long> addEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto) {
        return employeeRoleApi.addEmployeeRole(instanceId, reqDto);
    }

    @Override
    public RestResponse<Void> modifyEmployeeRole(Long instanceId, EmployeeRoleReqDto reqDto) {
        employeeRoleApi.modifyEmployeeRole(instanceId, reqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Long> setSuperAdmin(Long instanceId, EmployeeRoleReqDto reqDto) {
        return employeeRoleApi.setSuperAdmin(instanceId,reqDto);
    }
}
