package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OrgSellerCustomerQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrgSellerCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IOrgSellerCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrgRoleApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.ChooseOrgRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.OrgRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.tcbj.OrgRoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrgRoleQueryApi;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.OrgRoleExtRespDto;
import com.dtyunxi.yundt.module.customer.api.user.IOrgRoleService;
import com.github.pagehelper.PageInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class OrgRoleServiceImpl implements IOrgRoleService {
    private static final Logger logger = LoggerFactory.getLogger(OrgRoleServiceImpl.class);

    @Resource
    private IOrgSellerCustomerQueryApi orgSellerCustomerQueryApi;
    @Resource
    private IOrgRoleApi orgRoleApi;
    @Resource
    private IOrgRoleQueryApi orgRoleQueryApi;

    @Override
    public RestResponse<Long> create(OrgRoleReqDto orgRoleReqDto) {
        return new RestResponse<>(RestResponseHelper.extractData(orgRoleApi.create(orgRoleReqDto)));
    }

    @Override
    public RestResponse<Void> update(OrgRoleReqDto orgRoleReqDto) {
       return new RestResponse<>(RestResponseHelper.extractData(orgRoleApi.update(orgRoleReqDto)));
    }

    @Override
    public RestResponse<Void> delete(Long id) {
        return new RestResponse<>(RestResponseHelper.extractData(orgRoleApi.delete(id)));
    }

    @Override
    public RestResponse<OrgRoleExtRespDto> queryDetail(Long id) {
        OrgRoleRespDto orgRoleRespDto = RestResponseHelper.extractData(orgRoleQueryApi.queryDetail(id));
        OrgRoleExtRespDto orgRoleExtRespDto = new OrgRoleExtRespDto();
        CubeBeanUtils.copyProperties(orgRoleExtRespDto,orgRoleRespDto);
        //获取组织角色所属组织信息
        if (ObjectUtils.isNotEmpty(orgRoleExtRespDto.getRoleDto().getBelongOrgId())){
            OrgSellerCustomerQueryReqDto queryReqDto = new OrgSellerCustomerQueryReqDto();
            queryReqDto.setOrganizationId(orgRoleExtRespDto.getRoleDto().getBelongOrgId());
            queryReqDto.setPageNum(1);
            queryReqDto.setPageSize(1);
            PageInfo<OrgSellerCustomerRespDto> OrgPageInfo = RestResponseHelper.extractData(orgSellerCustomerQueryApi.orgSellerCustomerPage(queryReqDto));
            if (ObjectUtils.isNotEmpty(OrgPageInfo) && CollectionUtils.isNotEmpty(OrgPageInfo.getList())){
                orgRoleExtRespDto.setOrgSellerCustomerRespDto(OrgPageInfo.getList().get(0));
            }
        }
        return new RestResponse<>(orgRoleExtRespDto);
    }

    @Override
    public RestResponse<PageInfo<RoleDto>> queryChoosePage(ChooseOrgRoleReqDto reqDto) {
        return orgRoleQueryApi.queryChoosePage(reqDto);
    }

    @Override
    public RestResponse<List<AppInstanceDto>> queryAppInstanceList() {
        return orgRoleQueryApi.queryAppInstanceList();
    }


}
