/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AppInstanceQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.MenuQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.module.customer.api.user.IAccessExtService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IAccessExtServiceImpl
implements IAccessExtService {
    private static final Logger logger = LoggerFactory.getLogger(IAccessExtServiceImpl.class);
    @Resource
    private IAccessExtQueryApi accessExtQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IDictQueryApi dictQueryApi;
    @Resource
    private IApplicationQueryApi applicationQueryApi;

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    public RestResponse<UserAccessRespDto> queryUserAccess(Long userId, Long instanceId) {
        UserAccessRespDto respDto = new UserAccessRespDto();
        respDto.setUserId(userId);
        respDto.setMenus(new ArrayList());
        String organizationId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            logger.error("\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID");
            return new RestResponse((Object)respDto);
        }
        RestResponse dictDtoRestResponse = this.dictQueryApi.queryByGroupCodeAndCode(Long.valueOf(1L), "master_data_org", organizationId);
        if (Objects.isNull(dictDtoRestResponse) || Objects.isNull(dictDtoRestResponse.getData()) || Objects.equals(((DictDto)dictDtoRestResponse.getData()).getStatus(), 2)) {
            MenuQueryResDto menuQueryResDto;
            UserAccessRespDto userAccessRespDto = new UserAccessRespDto();
            AppInstanceQueryResDto appInstanceQueryResDto = (AppInstanceQueryResDto)RestResponseHelper.extractData((RestResponse)this.applicationQueryApi.queryInsByInstanceIdAndResources(instanceId, null, (List)Lists.newArrayList((Object[])new String[]{"buttons", "menus"}), "{}"));
            MenuQueryResDto menus = appInstanceQueryResDto.getMenus();
            ArrayList menusNew = Lists.newArrayList();
            if (Objects.nonNull(menus) && CollectionUtils.isNotEmpty((Collection)menus.getChildren()) && CollectionUtils.isNotEmpty((Collection)(menuQueryResDto = (MenuQueryResDto)menus.getChildren().get(0)).getChildren())) {
                CubeBeanUtils.copyCollection((Collection)menusNew, (Collection)menuQueryResDto.getChildren(), MenuDto.class);
            }
            List buttons = appInstanceQueryResDto.getButtons();
            ArrayList buttonsNew = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)buttonsNew, (Collection)buttons, MenuDto.class);
            userAccessRespDto.setMenus((List)menusNew);
            userAccessRespDto.setButtons((List)buttonsNew);
            return new RestResponse((Object)userAccessRespDto);
        }
        ServiceContext.getContext().setAttachment("yes.req.cus.b2b.organizationId", organizationId);
        UserAccessRespDto userAccessRespDto = (UserAccessRespDto)RestResponseHelper.extractData((RestResponse)this.accessExtQueryApi.queryUserAccess(userId, organizationId, instanceId));
        if (userAccessRespDto != null) {
            List newList = userAccessRespDto.getMenus().stream().filter(a -> instanceId.equals(a.getInstanceId())).collect(Collectors.toList());
            userAccessRespDto.setMenus(newList);
        }
        return new RestResponse((Object)userAccessRespDto);
    }
}

