package com.dtyunxi.yundt.module.customer.biz.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * 药店类型
 */
@Getter
@AllArgsConstructor
public enum TianyanchaProvinceEnum {

    AH("ah", "340000", "安徽省"),
    BJ("bj", "110000", "北京"),
    CQ("cq", "500000", "重庆"),
    FJ("fj", "350000", "福建省"),
    GD("gd", "440000", "广东省"),
    GS("gs", "620000", "甘肃省"),
    GX("gx", "450000", "广西壮族自治区"),
    GZ("gz", "520000", "贵州省"),
    HAN("han", "460000", "海南省"),
    HEB("heb", "130000", "河北省"),
    HEN("hen", "410000", "河南省"),
    HK("hk", "810000", "香港特别行政区"),
    HLJ("hlj", "230000", "黑龙江省"),
    HUB("hub", "420000", "湖北省"),
    HUN("hun", "430000", "湖南省"),
    JL("jl", "220000", "吉林省"),
    JS("js", "320000", "江苏省"),
    JX("jx", "360000", "江西省"),
    LN("ln", "210000", "辽宁省"),
    NMG("nmg", "150000", "内蒙古自治区"),
    NX("nx", "640000", "宁夏回族自治区"),
    QH("qh", "630000", "青海省"),
    SC("sc", "510000", "四川省"),
    SD("sd", "370000", "山东省"),
    SH("sh", "310000", "上海"),
    SNX("snx", "610000", "陕西省"),
    SX("sx", "140000", "山西省"),
    TJ("tj", "120000", "天津"),
    XJ("xj", "650000", "新疆维吾尔自治区"),
    XZ("xz", "540000", "西藏自治区"),
    YN("yn", "530000", "云南省"),
    ZJ("zj", "330000", "浙江省"),

    ;

    private final String tianyanchaName;
    private final String provinceCode;
    private final String provinceName;

    public static TianyanchaProvinceEnum find(String tianyanchaName){
        for (TianyanchaProvinceEnum value : TianyanchaProvinceEnum.values()) {
            if(tianyanchaName.equals(value.getTianyanchaName())){
                return value;
            }
        }
        return null;
    }

    public static final List<String> BIG_CITY =  Arrays.asList("北京", "天津", "上海", "重庆");

}
