package com.dtyunxi.yundt.module.customer.api.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 人员导入excel实体类
 */
@Data
public class EmployeeExcelExtVo {

    @Excel(name = "类型")
    private String type; // 新增/修改
    
    @Excel(name = "工号")
    private String employeeCode;

    @Excel(name = "登录账号", isImportField = "true")
    private String account;

    @Excel(name = "角色", isImportField = "true")
    private String roleName;

    @Excel(name = "姓名", isImportField = "true")
    private String userName;

    @Excel(name = "职位", isImportField = "true")
    private String position;

    @Excel(name = "人员类型", isImportField = "true")
    private String employeeType;

    @Excel(name = "手机号码", isImportField = "true")
    private String phoneNumber;

    @Excel(name = "管理类型", isImportField = "true")
    private String governType;

    @Excel(name = "销售区")
    private String saleArea;

    @Excel(name = "大区")
    private String bigArea;

    @Excel(name = "区域")
    private String district;

    @Excel(name = "管理客户（客户编号）")
    private String governCustomer;

    @Excel(name = "管理黑名单（客户编号）")
    private String blacklist;

    @Excel(name = "开始日期", importFormat = "yyyy-MM-dd")
    private Date startDate;

    @Excel(name = "结束日期", importFormat = "yyyy-MM-dd")
    private Date endDate;

    @Excel(name = "备注")
    private String remark;

    /**
     * 账号id
     */
    private Long userId;

    /**
     * 组织id
     */
    private Long orgId;

    /**
     * 角色名称
     */
    private EmployeeRoleReqDto role;

    /**
     * 角色集合
     */
    private List<EmployeeRoleReqDto> roleList;


    /**
     * 区域对象
     */
    private EmployeeRegionReqDto area;

    @Excel(name = "失败原因", width = 40)
    private String errorMsg;

    /**
     * 管理区域集合
     */
    private List<EmployeeRegionReqDto> areaList;

    /**
     * 管理客户对象
     */
    private EmployeeCustomerReqDto customerDto;

    /**
     * 管理客户集合
     */
    private List<EmployeeCustomerReqDto> customerInfoList;

    /**
     * 管理客户黑名单对象
     */
    private EmployeeCustomerBlacklistReqDto customerBlackDto;

    /**
     * 管理客户黑名单集合
     */
    private List<EmployeeCustomerBlacklistReqDto> customerBlackList;
} 