/*
 * @(#) RoleServiceImpl.java 1.1.0 2019-06-24
 * Copyright (c)  2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.module.customer.biz.service.impl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.module.customer.biz.service.IRoleService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;


/**
 * 角色
 *
 * @author sumo on 2020/10/21 0021
 */
@Service
public class RoleServiceImpl implements IRoleService {

    @Resource
    private IAccessQueryApi accessQueryApi;

    @Override
    public RestResponse<UserAccessVo> queryUserAccess(Long appInstanceId, Long userId) {
        return accessQueryApi.queryUserAccess(appInstanceId, userId, "{}");
    }

    @Override
    public RestResponse<UserAccessRespDto> queryUserAccessResources(Long userId) {
        return accessQueryApi.queryUserAccessResources(userId, "{}");
    }

}
