package com.dtyunxi.yundt.module.customer.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.IAccountApi;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.CreateAccForCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.IBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerOrgInfoApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.CustomerOrgInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.query.ICustomerOrgInfoQueryApi;
import com.dtyunxi.yundt.module.customer.biz.constant.AccountConstant;
import com.dtyunxi.yundt.module.customer.biz.constant.RebateConstant;
import com.dtyunxi.yundt.module.customer.biz.mq.constants.MessageTag;
import com.dtyunxi.yundt.module.customer.biz.mq.constants.MessageTopic;
import com.dtyunxi.yundt.module.customer.biz.util.CustomerUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * @Description: 企业/法人/组织信息新增和修改事件监听处理器
 * @Author: 追命
 * @Date: 2021/4/13
 * @Version: 0.1.0
 */
@Component
@MQDesc(topic = MessageTopic.CUSTOMER_CHANGE_TOPIC, tag = MessageTag.CUSTOMER_CHANGE_TAG)
public class CustomerChangeProcessor implements IMessageProcessor<String> {

    private static Logger logger = LoggerFactory.getLogger(CustomerChangeProcessor.class);

    @Resource
    private ICustomerOrgInfoApi customerOrgInfoApi;

    @Resource
    private ICustomerOrgInfoQueryApi customerOrgInfoQueryApi;

    @Resource
    private IAccountApi accountApi;

    @Resource
    private IBalanceApi balanceApi;

    /**
     * 启动创建余额账户标识 0 启动，1 不启动，默认不启动
     */
    @Value("${yundt.cube.create.account:1}")
    private Integer accountCreateFlag = 1;

    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;

    @Override
    public MessageResponse process(String orgInfoJson) {
        logger.info("接收的客户新增和修改信息：{}", orgInfoJson);
        if(StringUtils.isEmpty(orgInfoJson)) {
            return MessageResponse.SUCCESS;
        }
        CustomerOrgInfoDto dto = JSON.parseObject(orgInfoJson, CustomerOrgInfoDto.class);
        if(dto==null || dto.getId()==null ) {
            logger.warn("组织信息缺失，不处理");
            return MessageResponse.SUCCESS;
        }
        //判断是新增还是更新
        RestResponse<CustomerOrgInfoDto> orgInfoRestResp = customerOrgInfoQueryApi.queryById(dto.getId());
        CustomerOrgInfoDto customerOrgInfoDto = RestResponseHelper.extractData(orgInfoRestResp);
        if (Objects.isNull(customerOrgInfoDto)){
            RestResponse<Long> addRestResp = customerOrgInfoApi.addCustomerOrgInfo(dto);
            RestResponseHelper.extractData(addRestResp);
        } else {
            RestResponse<Void> updateRestResp = customerOrgInfoApi.updateCustomerOrgInfo(dto);
            RestResponseHelper.checkOrThrow(updateRestResp);
        }

        //启动创建余额账户
        if(accountCreateFlag == 0){
            createAccount(dto);
        }

        //创建返利账户
        createRebateAccount(dto);
        return MessageResponse.SUCCESS;
    }

    private void createRebateAccount(CustomerOrgInfoDto dto){
        try{
            BalanceAddReqDto balanceAddReqDto = new BalanceAddReqDto();
            balanceAddReqDto.setUserId(dto.getId());
            balanceAddReqDto.setUserName(dto.getOrgName());
            balanceAddReqDto.setUserType(RebateConstant.USER_TYPE_CUSTOMER);
            balanceAddReqDto.setBalance(BigDecimal.ZERO);
            balanceAddReqDto.setInstanceId(dto.getInstanceId());
            balanceAddReqDto.setTenantId(dto.getTenantId());
            balanceAddReqDto.setBelongTo(RebateConstant.BELONG_TO_DEFAULT);
            logger.info("createRebateAccount params:{}",JSON.toJSONString(balanceAddReqDto));
            balanceApi.addBalance(balanceAddReqDto);
        }catch (Exception e){
            logger.error("createRebateAccount error: userId="+dto.getId(),e.getMessage());
        }

    }

    private void createAccount(CustomerOrgInfoDto dto){
        try{
            CreateAccForCustomerReqDto createAccForCustomerReqDto = new CreateAccForCustomerReqDto();
            RestResponse<CustomerRespDto>  customerRestResp = customerQueryApi.queryById(dto.getId()) ;
            CustomerRespDto custDto = RestResponseHelper.extractData(customerRestResp);

            createAccForCustomerReqDto.setUserId(dto.getId());
            createAccForCustomerReqDto.setAccountType(AccountConstant.ACCOUNT_TYPE_NORMAL);
            createAccForCustomerReqDto.setUserType(AccountConstant.ACCOUNT_USER_TYPE_CUSTOMER);
            createAccForCustomerReqDto.setTenantId(dto.getTenantId());
            createAccForCustomerReqDto.setInstanceId(dto.getInstanceId());
            if(custDto!=null){
                //客户类型冗余到账户信息中.
                createAccForCustomerReqDto.setUserSubTypeId(custDto.getCustomerTypeId());
                createAccForCustomerReqDto.setUserSubType(custDto.getCustomerTypeName());
            }
            createAccForCustomerReqDto.setCustomerNo(dto.getOrgCode());//客户编号
            createAccForCustomerReqDto.setNickName(dto.getOrgName());
            createAccForCustomerReqDto.setMemberNo(CustomerUtil.generateTradeNo("YEZH"));
            logger.info("createAccForCustomerReqDto.getOrgType={}",createAccForCustomerReqDto.getUserSubType());
            accountApi.createAccountForCustomer(createAccForCustomerReqDto);
        }catch (Exception e){
            logger.error("createAccount error: userId="+dto.getId(),e.getMessage());
        }
    }
}
