/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.user.api.dto.entity.ImportBaseResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeImportReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandReqDto;
import com.dtyunxi.yundt.module.customer.api.user.ICustomerEmployeeExpandService;
import com.dtyunxi.yundt.module.customer.api.user.IEmployeeExpand2Service;
import com.dtyunxi.yundt.module.customer.api.vo.CustomerEmployeeExcelVo;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import com.dtyunxi.yundt.module.customer.biz.util.EasyPoiExportUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerEmployeeExpandServiceImpl
implements ICustomerEmployeeExpandService {
    private static final Logger logger = LoggerFactory.getLogger(CustomerEmployeeExpandServiceImpl.class);
    @Resource
    private IEmployeeExpand2Service employeeExpand2Service;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IContext context;

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    public Long tenantId() {
        Long tenantId = this.context.tenantId();
        logger.info("tenantId >>> {}", (Object)tenantId);
        return tenantId;
    }

    public RestResponse<ImportBaseResponse> importExcelEmployee(EmployeeImportReqDto importReqDto) {
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        Long instanceId = importReqDto.getInstanceId();
        String orgIdStr = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
        if (StringUtils.isBlank((CharSequence)orgIdStr)) {
            orgIdStr = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
        }
        AssertUtil.assertNotBlank((String)orgIdStr, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        Long orgId = Long.valueOf(orgIdStr);
        ImportBaseResponse response = new ImportBaseResponse();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setKeyIndex(null);
        List<CustomerEmployeeExcelVo> importDataList = new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)EasyPoiExportUtil.getInputStream(fileUrl), CustomerEmployeeExcelVo.class, (ImportParams)importParams);
            if (ObjectUtils.isNotEmpty((Object)result)) {
                importDataList = result.getList();
                importDataList = BeanPropertyNullUtil.getAllFieldNullList(importDataList);
            }
            if (CollectionUtils.isEmpty(importDataList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        if (CollectionUtils.isEmpty(importDataList)) {
            response.setTotalNum(0);
            response.setSuccessNum(0);
            response.setErrorNum(0);
            return new RestResponse((Object)response);
        }
        logger.info("\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(importDataList));
        response.setTotalNum(importDataList.size());
        List accountList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getAccount())).map(CustomerEmployeeExcelVo::getAccount).distinct().collect(Collectors.toList());
        logger.info("\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u83b7\u53d6\u8d26\u53f7\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(accountList));
        Map userOrgMap = this.employeeExpand2Service.getAccoutMap(accountList);
        List customerCodeList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getCustomerCode())).map(CustomerEmployeeExcelVo::getCustomerCode).distinct().collect(Collectors.toList());
        Map orgCustomerMap = this.employeeExpand2Service.getOrgCustomerMap(customerCodeList);
        importDataList = this.verifyData(importDataList, orgCustomerMap, userOrgMap, orgId);
        List successList = importDataList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorMsg())).collect(Collectors.toList());
        Map employeeInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(successList)) {
            List userIdList = successList.stream().map(CustomerEmployeeExcelVo::getUserId).collect(Collectors.toList());
            employeeInfoMap = this.employeeExpand2Service.getEmployeeMap(userIdList, Collections.singletonList(((CustomerEmployeeExcelVo)successList.get(0)).getOrgId()));
        }
        for (CustomerEmployeeExcelVo data2 : successList) {
            EmployeeExpandReqDto employeeExtReqDto = new EmployeeExpandReqDto();
            employeeExtReqDto.setOrganizationId(data2.getOrganizationId());
            employeeExtReqDto.setOrgId(data2.getOrgId());
            employeeExtReqDto.setName(data2.getUserName());
            employeeExtReqDto.setPosition(data2.getPosition());
            employeeExtReqDto.setSex(data2.getSex());
            employeeExtReqDto.setStation(data2.getDepartment());
            employeeExtReqDto.setPhoneNum(data2.getPhoneNumber());
            employeeExtReqDto.setUserId(data2.getUserId());
            employeeExtReqDto.setOrganizationStatus(YesOrNoEnum.NO.getStatus());
            employeeExtReqDto.setType(Integer.valueOf("\u5185\u90e8".equals(data2.getEmployeeType()) ? 0 : 1));
            String key = data2.getOrganizationId() + "_" + data2.getUserId() + "_" + data2.getPhoneNumber();
            try {
                if (!employeeInfoMap.isEmpty() && employeeInfoMap.containsKey(key)) {
                    Long id = (Long)employeeInfoMap.get(key);
                    employeeExtReqDto.setId(id);
                    logger.info("\u4fee\u6539\u5ba2\u6237\u4eba\u5458\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)employeeExtReqDto));
                    this.employeeExpand2Service.modifyEmployee(instanceId, employeeExtReqDto);
                    continue;
                }
                employeeExtReqDto.setStartTime(new Date());
                employeeExtReqDto.setStatus(Integer.valueOf(1));
                employeeExtReqDto.setType(Integer.valueOf(1));
                logger.info("\u65b0\u589e\u5ba2\u6237\u4eba\u5458\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)employeeExtReqDto));
                this.employeeExpand2Service.addEmployee(instanceId, employeeExtReqDto);
            }
            catch (Exception e) {
                logger.info("\u5ba2\u6237\u4eba\u5458\u6267\u884c\u5931\u8d25:{}", (Throwable)e);
                this.setErrorsMsg(importDataList, data2.getAccount(), "\u6267\u884c\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        List errorList = importDataList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errorList)) {
            response.setErrorNum(errorList.size());
            String excelName = "\u5ba2\u6237\u4eba\u5458\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, CustomerEmployeeExcelVo.class, null, excelName, "xls");
                response.setErrorFileUrl(exportUrl);
            }
            catch (Exception e) {
                logger.info("\u5ba2\u6237\u4eba\u5458\u5bfc\u5165\u5931\u8d25\u4fe1\u606f\u6587\u4ef6\u751f\u6210\u5931\u8d25");
                logger.info(e.getMessage(), (Throwable)e);
            }
        }
        response.setSuccessNum(response.getTotalNum() - response.getErrorNum());
        return new RestResponse((Object)response);
    }

    public List<CustomerEmployeeExcelVo> setErrorsMsg(List<CustomerEmployeeExcelVo> list, String account, String errorMsg) {
        list.forEach(vo -> {
            if (StringUtils.isBlank((CharSequence)vo.getErrorMsg()) && vo.getAccount().equals(account)) {
                vo.setErrorMsg(errorMsg);
            }
        });
        return list;
    }

    public List<CustomerEmployeeExcelVo> verifyData(List<CustomerEmployeeExcelVo> list, Map<String, CustomerRespDto> orgCustomerMap, Map<String, List<UserOrgizationRespDto>> userOrgMap, Long orgId) {
        for (CustomerEmployeeExcelVo vo : list) {
            if (StringUtils.isBlank((CharSequence)vo.getCustomerCode())) {
                vo.setErrorMsg("\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (orgCustomerMap.isEmpty() || !orgCustomerMap.containsKey(vo.getCustomerCode())) {
                vo.setErrorMsg("\u5ba2\u6237\u7f16\u53f7\u6570\u636e\u9519\u8bef");
                continue;
            }
            CustomerRespDto customerRespDto = orgCustomerMap.get(vo.getCustomerCode());
            if (Objects.isNull(customerRespDto.getMerchantId()) || customerRespDto.getMerchantId().compareTo(orgId) != 0) {
                vo.setErrorMsg("\u5ba2\u6237\u7f16\u53f7\u6240\u5c5e\u7ec4\u7ec7\u6570\u636e\u9519\u8bef");
                continue;
            }
            vo.setCustomerId(customerRespDto.getId());
            if (StringUtils.isBlank((CharSequence)vo.getAccount())) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (userOrgMap.isEmpty() || !userOrgMap.containsKey(vo.getAccount())) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u9519\u8bef");
                continue;
            }
            List<UserOrgizationRespDto> userOrgizationVos = userOrgMap.get(vo.getAccount());
            List userOrgList = userOrgizationVos.stream().filter(e -> orgId.compareTo(e.getOrgId()) == 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userOrgList)) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                continue;
            }
            vo.setUserId(((UserOrgizationRespDto)userOrgList.get(0)).getUserId());
            vo.setOrgId(orgId);
            vo.setOrganizationId(customerRespDto.getOrgInfoId());
            if (StringUtils.isBlank((CharSequence)vo.getUserName())) {
                vo.setErrorMsg("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getPosition())) {
                vo.setErrorMsg("\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getEmployeeType())) {
                vo.setErrorMsg("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (!"\u5185\u90e8".equals(vo.getEmployeeType()) && !"\u5916\u90e8".equals(vo.getEmployeeType())) {
                vo.setErrorMsg("\u4eba\u5458\u7c7b\u578b\u53ea\u80fd\u4e3a'\u5185\u90e8'\u6216'\u5916\u90e8'");
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber()) || CommonUtil.checkPhoneNum(vo.getPhoneNumber())) continue;
            vo.setErrorMsg("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e;");
        }
        return list;
    }
}

