package com.dtyunxi.yundt.module.customer.biz.impl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.IEmployeeCustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerImportReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerBlacklistRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerImportRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerBlacklistQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.module.customer.api.IEmployeeCustomerService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author: xiuji
 * @Date: 2022/1/20 10:05 AM
 */
@Service
public class EmployeeCustomerServiceImpl implements IEmployeeCustomerService {

    @Resource
    private IEmployeeCustomerApi employeeCustomerApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;

    @Resource
    private IEmployeeCustomerBlacklistQueryApi employeeCustomerBlacklistQueryApi;


    /**
     * 查询人员所属客户
     *
     * @param queryReqDto
     * @return
     */
    @Override
    public RestResponse<List<EmployeeCustomerRespDto>> queryEmployeeCustomerList(EmployeeCustomerQueryReqDto queryReqDto) {
        return employeeCustomerQueryApi.queryEmployeeCustomerList(queryReqDto);
    }

    /**
     * 客户导入
     * 返回客户信息集合，成功数，失败数，失败文档
     *
     * @param importReqDto
     */
    @Override
    public RestResponse<EmployeeCustomerImportRespDto> customerImport(EmployeeCustomerImportReqDto importReqDto) {
        return employeeCustomerApi.customerImport(importReqDto);
    }

    /**
     * 查询人员-客户黑名单
     *
     * @param queryReqDto
     * @return
     */
    @Override
    public RestResponse<List<EmployeeCustomerBlacklistRespDto>> queryEmployeeCustomerBlackList(EmployeeCustomerBlacklistQueryReqDto queryReqDto) {
        return employeeCustomerBlacklistQueryApi.queryEmployeeCustomerBlackList(queryReqDto);
    }
}
