/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.IAccountApi;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.CreateAccForCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.IBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerOrgInfoApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.CustomerOrgInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.query.ICustomerOrgInfoQueryApi;
import com.dtyunxi.yundt.module.customer.biz.util.CustomerUtil;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="${icomb.common.topic.customer.change:CUSTOMER_CHANGE_TOPIC}", tag="CUSTOMER_CHANGE_TAG")
public class CustomerChangeProcessor
implements IMessageProcessor<String> {
    private static Logger logger = LoggerFactory.getLogger(CustomerChangeProcessor.class);
    @Resource
    private ICustomerOrgInfoApi customerOrgInfoApi;
    @Resource
    private ICustomerOrgInfoQueryApi customerOrgInfoQueryApi;
    @Resource
    private IAccountApi accountApi;
    @Resource
    private IBalanceApi balanceApi;
    @Value(value="${yundt.cube.create.account:1}")
    private Integer accountCreateFlag = 1;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;

    public MessageResponse process(String orgInfoJson) {
        logger.info("\u63a5\u6536\u7684\u5ba2\u6237\u65b0\u589e\u548c\u4fee\u6539\u4fe1\u606f\uff1a{}", (Object)orgInfoJson);
        if (StringUtils.isEmpty((CharSequence)orgInfoJson)) {
            return MessageResponse.SUCCESS;
        }
        CustomerOrgInfoDto dto = (CustomerOrgInfoDto)JSON.parseObject((String)orgInfoJson, CustomerOrgInfoDto.class);
        if (dto == null || dto.getId() == null) {
            logger.warn("\u7ec4\u7ec7\u4fe1\u606f\u7f3a\u5931\uff0c\u4e0d\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        RestResponse orgInfoRestResp = this.customerOrgInfoQueryApi.queryById(dto.getId());
        CustomerOrgInfoDto customerOrgInfoDto = (CustomerOrgInfoDto)RestResponseHelper.extractData((RestResponse)orgInfoRestResp);
        if (Objects.isNull(customerOrgInfoDto)) {
            RestResponse addRestResp = this.customerOrgInfoApi.addCustomerOrgInfo(dto);
            RestResponseHelper.extractData((RestResponse)addRestResp);
        } else {
            RestResponse updateRestResp = this.customerOrgInfoApi.updateCustomerOrgInfo(dto);
            RestResponseHelper.checkOrThrow((RestResponse)updateRestResp);
        }
        if (this.accountCreateFlag == 0) {
            this.createAccount(dto);
        }
        this.createRebateAccount(dto);
        return MessageResponse.SUCCESS;
    }

    private void createRebateAccount(CustomerOrgInfoDto dto) {
        try {
            BalanceAddReqDto balanceAddReqDto = new BalanceAddReqDto();
            balanceAddReqDto.setUserId(dto.getId());
            balanceAddReqDto.setUserName(dto.getOrgName());
            balanceAddReqDto.setUserType("CUSTOMER");
            balanceAddReqDto.setBalance(BigDecimal.ZERO);
            balanceAddReqDto.setInstanceId(dto.getInstanceId());
            balanceAddReqDto.setTenantId(dto.getTenantId());
            balanceAddReqDto.setBelongTo("-1");
            logger.info("createRebateAccount params:{}", (Object)JSON.toJSONString((Object)balanceAddReqDto));
            this.balanceApi.addBalance(balanceAddReqDto);
        }
        catch (Exception e) {
            logger.error("createRebateAccount error: userId=" + dto.getId(), (Object)e.getMessage());
        }
    }

    private void createAccount(CustomerOrgInfoDto dto) {
        try {
            CreateAccForCustomerReqDto createAccForCustomerReqDto = new CreateAccForCustomerReqDto();
            RestResponse customerRestResp = this.customerQueryApi.queryById(dto.getId());
            CustomerRespDto custDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRestResp);
            createAccForCustomerReqDto.setUserId(dto.getId());
            createAccForCustomerReqDto.setAccountType("NORMAL");
            createAccForCustomerReqDto.setUserType("ENTERPRISE");
            createAccForCustomerReqDto.setTenantId(dto.getTenantId());
            createAccForCustomerReqDto.setInstanceId(dto.getInstanceId());
            if (custDto != null) {
                createAccForCustomerReqDto.setUserSubTypeId(custDto.getCustomerTypeId());
                createAccForCustomerReqDto.setUserSubType(custDto.getCustomerTypeName());
            }
            createAccForCustomerReqDto.setCustomerNo(dto.getOrgCode());
            createAccForCustomerReqDto.setNickName(dto.getOrgName());
            createAccForCustomerReqDto.setMemberNo(CustomerUtil.generateTradeNo("YEZH"));
            logger.info("createAccForCustomerReqDto.getOrgType={}", (Object)createAccForCustomerReqDto.getUserSubType());
            this.accountApi.createAccountForCustomer(createAccForCustomerReqDto);
        }
        catch (Exception e) {
            logger.error("createAccount error: userId=" + dto.getId(), (Object)e.getMessage());
        }
    }
}

