/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.IMapApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.company.CompanyVerifyReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.MapTextRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.module.settlement.biz.service.SettlementAccountRegisterRelationService;
import com.dtyunxi.yundt.cube.center.customer.api.IImportRecordApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizImportEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsCustomerEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreDataOriginEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.ImportRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerExtService;
import com.dtyunxi.yundt.module.customer.api.enums.BizChannelEnum;
import com.dtyunxi.yundt.module.customer.api.enums.CompanyVerifyEnum;
import com.dtyunxi.yundt.module.customer.api.enums.DefaultSettingEnum;
import com.dtyunxi.yundt.module.customer.biz.constant.StoreConstant;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.customer.biz.vo.StoreExportVo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.ICustomerSyncCreditApi;
import com.yx.tcbj.center.customer.api.IStoreApi;
import com.yx.tcbj.center.customer.api.dto.request.FindCustomerByCreditReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class StoreServiceImpl
implements IStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IStoreApi storeApi;
    @Resource
    private ICustomerSyncCreditApi customerSyncCreditApi;
    @Resource
    private IStoreQueryApi storeQueryApi;
    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;
    @Resource
    private IMapApi mapApi;
    @Resource
    private IContext context;
    @Resource
    private IImportRecordApi importRecordApi;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private SettlementAccountRegisterRelationService settlementAccountRegisterRelationService;
    AtomicInteger counter = new AtomicInteger(1);
    private final ThreadPoolExecutor importExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 4, 120L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(3, true), r -> new Thread(r, "Thread-import[" + this.counter.addAndGet(1) + "]"), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> saveOrUpdateStore(StoreReqDto reqDto) {
        this.logger.info("saveOrUpdateStore \u8bf7\u6c42\u5f00\u59cb reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        this.checkSaveOrUpdateStoreParam(reqDto);
        this.processSaveOrUpdateStoreParam(reqDto);
        if (!ObjectUtils.isEmpty((Object)reqDto.getId())) {
            this.logger.info("saveOrUpdateStore \u5165\u53c2id\u5b58\u5728\uff0c\u66f4\u65b0\u836f\u5e97 reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
            RestResponse voidRestResponse = this.storeApi.updateStoreBatch((List)Lists.newArrayList((Object[])new StoreReqDto[]{reqDto}));
            RestResponseHelper.extractData((RestResponse)voidRestResponse);
        } else {
            this.logger.info("saveOrUpdateStore \u5165\u53c2id\u4e0d\u5b58\u5728\uff0c\u65b0\u589e\u836f\u5e97 reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
            RestResponse storeRespDtoResp = this.storeQueryApi.queryStoreRespDtoByCreditNum(reqDto.getSocialCreditNum());
            StoreRespDto respDto = (StoreRespDto)RestResponseHelper.extractData((RestResponse)storeRespDtoResp);
            Assert.isTrue((!reqDto.getSocialCreditNum().equals(respDto.getSocialCreditNum()) ? 1 : 0) != 0, (String)"0003", (String)"\u5df2\u5b58\u5728\u76f8\u540c\u4fe1\u7528\u4ee3\u7801\u836f\u5e97\uff01\uff01\uff01");
            RestResponse voidRestResponse = this.storeApi.addStore(reqDto);
            RestResponseHelper.extractData((RestResponse)voidRestResponse);
        }
        this.processSaveOrUpdateStoreRelation(reqDto);
        this.logger.info("saveOrUpdateStore \u8bf7\u6c42\u7ed3\u675f reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        return RestResponse.VOID;
    }

    private void processSaveOrUpdateStoreParam(StoreReqDto reqDto) {
        this.logger.info("saveOrUpdateStore \u53c2\u6570\u5904\u7406\u5f00\u59cb reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        reqDto.setSocialCreditNum(reqDto.getSocialCreditNum().trim().toUpperCase(Locale.ROOT));
        StoreExportVo storeExportVo = new StoreExportVo();
        CubeBeanUtils.copyProperties((Object)storeExportVo, (Object)reqDto, (String[])new String[0]);
        this.extractedAddress(storeExportVo);
        reqDto.setLog(storeExportVo.getLog());
        reqDto.setLat(storeExportVo.getLat());
        this.logger.info("saveOrUpdateStore \u53c2\u6570\u5904\u7406\u7ed3\u675f reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
    }

    private void processSaveOrUpdateStoreRelation(StoreReqDto reqDto) {
        this.logger.info("saveOrUpdateStore \u66f4\u65b0\u836f\u5e97\u540e\u7684\u5173\u8054\u8868/\u5b57\u6bb5\u5904\u7406\u5f00\u59cb reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        this.logger.info("\u540c\u6b65\u836f\u5e97\u72b6\u6001\u5230\u5c0fb\u5ba2\u6237\u72b6\u6001 reqDto={}", (Object)reqDto);
        ((IStoreService)this.applicationContext.getBean(IStoreService.class)).syncStoreState2Customer(reqDto);
        if (ObjectUtils.isNotEmpty((Object)reqDto.getId()) && StringUtils.isNotEmpty((CharSequence)reqDto.getOldSocialCreditNum())) {
            this.logger.info("\u540c\u6b65store\u7684\u65b0\u4fe1\u7528\u4ee3\u7801\u53ca\u5176\u4ed6\u5b57\u6bb5\u5230\u8be5\u5c0fb\u96f6\u552e\u5546 reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
            RestResponseHelper.extractData((RestResponse)this.customerSyncCreditApi.syncStoreNewCredit2Customer(reqDto));
        }
        this.processParentStoreInfo(reqDto);
        this.logger.info("saveOrUpdateStore \u66f4\u65b0\u836f\u5e97\u540e\u7684\u5173\u8054\u8868/\u5b57\u6bb5\u5904\u7406\u7ed3\u675f reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
    }

    private void processParentStoreInfo(StoreReqDto reqDto) {
        StoreReqDto updateStoreReqDto;
        this.logger.info("\u66f4\u65b0\u836f\u5e97\u65f6\uff0c\u82e5\u5f53\u524d\u95e8\u5e97(\u4e0a\u7ea7\u95e8\u5e97)\u5b58\u5728\u4e0b\u7ea7\u95e8\u5e97\uff0c\u5219\u7528\u5f53\u524d\u836f\u5e97\u7684\u6570\u636e\uff0c\u540c\u6b65\u8986\u76d6\u6240\u6709\u7684\u4e0b\u7ea7\u95e8\u5e97\u3002 reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        List subStoreRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.storeQueryApi.queryStoreByParentSocialCreditNum(reqDto.getSocialCreditNum()));
        if (subStoreRespDtos != null && !subStoreRespDtos.isEmpty()) {
            for (StoreRespDto subStoreDto : subStoreRespDtos) {
                updateStoreReqDto = new StoreReqDto();
                updateStoreReqDto.setStoreId(subStoreDto.getStoreId());
                updateStoreReqDto.setIsCustomer(reqDto.getIsCustomer());
                updateStoreReqDto.setBizChannel(reqDto.getBizChannel());
                updateStoreReqDto.setCustomerSystem(reqDto.getCustomerSystem());
                updateStoreReqDto.setBusinessPattern(reqDto.getBusinessPattern());
                updateStoreReqDto.setStoreParentName(reqDto.getStoreName());
                updateStoreReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());
                updateStoreReqDto.setUpdatePerson(this.context.userName());
                this.logger.info("\u66f4\u65b0\u4e0b\u7ea7\u95e8\u5e97 updateStoreReqDto={}", (Object)JSONObject.toJSONString((Object)updateStoreReqDto));
                this.storeApi.updateStore(updateStoreReqDto);
            }
        }
        this.logger.info("\u66f4\u65b0\u836f\u5e97\u65f6\uff0c\u82e5\u5f53\u524d\u836f\u5e97(\u4e0b\u7ea7\u95e8\u5e97)\u5b58\u5728\u4e0a\u7ea7\u95e8\u5e97\uff0c\u5219\u7528\u4e0a\u7ea7\u95e8\u5e97\u7684\u6570\u636e\uff0c\u8986\u76d6\u8be5\u4e0b\u7ea7\u95e8\u5e97\u3002 reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        if (StringUtils.isBlank((CharSequence)reqDto.getParentSocialCreditNum())) {
            return;
        }
        List parentStoreRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.storeQueryApi.querySocialCreditNums((List)Lists.newArrayList((Object[])new String[]{reqDto.getParentSocialCreditNum()})));
        if (parentStoreRespDtos != null && !parentStoreRespDtos.isEmpty()) {
            StoreRespDto parentStore = (StoreRespDto)parentStoreRespDtos.get(0);
            updateStoreReqDto = new StoreReqDto();
            updateStoreReqDto.setSocialCreditNum(reqDto.getSocialCreditNum());
            updateStoreReqDto.setIsCustomer(parentStore.getIsCustomer());
            updateStoreReqDto.setBizChannel(parentStore.getBizChannel());
            updateStoreReqDto.setCustomerSystem(parentStore.getCustomerSystem());
            updateStoreReqDto.setBusinessPattern(parentStore.getBusinessPattern());
            updateStoreReqDto.setStoreParentName(parentStore.getStoreName());
            updateStoreReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());
            updateStoreReqDto.setUpdatePerson(this.context.userName());
            this.logger.info("\u7528\u4e0a\u7ea7\u95e8\u5e97\u6570\u636e\u8986\u76d6\u5f53\u524d\u95e8\u5e97 updateStoreReqDto={}", (Object)JSONObject.toJSONString((Object)updateStoreReqDto));
            this.storeApi.updateStore(updateStoreReqDto);
        }
    }

    private void checkSaveOrUpdateStoreParam(StoreReqDto reqDto) {
        this.logger.info("saveOrUpdateStore \u53c2\u6570\u6821\u9a8c reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        this.checkParentParam(reqDto);
        this.checkSyncStoreInfo2Customer(reqDto);
    }

    private void checkParentParam(StoreReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)reqDto.getParentSocialCreditNum())) {
            return;
        }
        if (reqDto.getParentSocialCreditNum().equals(reqDto.getSocialCreditNum())) {
            throw new BizException("\u4e0a\u7ea7\u95e8\u5e97\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e0e\u5f53\u524d\u4fe1\u7528\u4ee3\u7801\u76f8\u540c");
        }
    }

    private void checkSyncStoreInfo2Customer(StoreReqDto reqDto) {
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) && StringUtils.isNotEmpty((CharSequence)reqDto.getOldSocialCreditNum())) {
            throw new BizException("\u65b0\u589e\u836f\u5e97\u65f6\u4e0d\u5141\u8bb8\u5173\u8054[\u5386\u53f2\u4fe1\u7528\u4ee3\u7801]\uff0c\u8bf7\u65b0\u589e\u6210\u529f\u540e\u518d\u7f16\u8f91\u5173\u8054\u3002\uff08\u5386\u53f2\u4fe1\u7528\u4ee3\u7801\u6d89\u53ca\u4e09\u8981\u7d20\u8ba4\u8bc1\uff0c\u4e09\u8981\u7d20\u8ba4\u8bc1\u4f1a\u81ea\u52a8\u751f\u6210\u95e8\u5e97\uff0c\u529f\u80fd\u51b2\u7a81\uff09");
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getOldSocialCreditNum())) {
            return;
        }
        if (reqDto.getOldSocialCreditNum().equals(reqDto.getSocialCreditNum())) {
            throw new BizException("\u5173\u8054\u65e7\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e0e\u5f53\u524d\u4fe1\u7528\u4ee3\u7801\u76f8\u540c");
        }
        CompanyVerifyReqDto CompanyVerifyReqDto2 = new CompanyVerifyReqDto();
        CompanyVerifyReqDto2.setCode(reqDto.getSocialCreditNum());
        CompanyVerifyReqDto2.setName(reqDto.getStoreName());
        CompanyVerifyReqDto2.setLegalPersonName(reqDto.getLegalPersonName());
        CompanyVerifyRespDto companyVerifyRespDto = ((ICustomerExtService)this.applicationContext.getBean(ICustomerExtService.class)).verifyCompany(CompanyVerifyReqDto2);
        if (!Objects.equals(companyVerifyRespDto.getResult(), CompanyVerifyEnum.SUCCESS.getCode())) {
            throw new BizException(companyVerifyRespDto.getRemark());
        }
        this.checkCreditCodeChangeByCredit(reqDto.getOldSocialCreditNum());
    }

    private void checkCreditCodeChangeByCredit(String oldSocialCreditNum) {
        List CustomerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerSyncCreditApi.findCustomerByCredit(FindCustomerByCreditReqDto.builder().socialCreditNum(oldSocialCreditNum).customerType(CustomerTypeEnum.RETAILER.getCode()).build()));
        if (CustomerRespDtos == null || CustomerRespDtos.isEmpty()) {
            this.logger.info("check \u540c\u6b65\u5168\u91cf\u5e93\u836f\u5e97\u72b6\u6001(\u8f6c\u6362\u540e)\u5230\u5c0fb\u96f6\u552e\u5546 CustomerRespDtos == null. end");
            return;
        }
        for (CustomerRespDto customerRespDto : CustomerRespDtos) {
            this.settlementAccountRegisterRelationService.checkCreditCodeChage(customerRespDto.getId(), null, oldSocialCreditNum);
        }
    }

    @Override
    @Async
    public void syncStoreState2Customer(StoreReqDto reqDto) {
        this.logger.info("\u836f\u5e97\u72b6\u6001\u6709\u66f4\u6539\u65f6\uff0c\u540c\u6b65\u8f6c\u6362\u540e\u7684\u72b6\u6001\u5230\u5c0fb(\u5c0fb\u9700\u4e3a\u542f\u7528\u3001\u6ce8\u9500\u72b6\u6001) reqDto={}", (Object)JSON.toJSONString((Object)reqDto));
        RestResponseHelper.extractData((RestResponse)this.customerSyncCreditApi.syncStoreState2Customer(reqDto));
    }

    @Override
    @Async
    public void syncStoreState2CustomerBatch(List<StoreReqDto> reqDtos) {
        this.logger.info("\u836f\u5e97\u72b6\u6001\u6709\u66f4\u6539\u65f6\uff0c\u540c\u6b65\u8f6c\u6362\u540e\u7684\u72b6\u6001\u5230\u5c0fb(\u5c0fb\u9700\u4e3a\u542f\u7528\u3001\u6ce8\u9500\u72b6\u6001) reqDto={}", (Object)JSON.toJSONString(reqDtos));
        for (StoreReqDto reqDto : reqDtos) {
            RestResponseHelper.extractData((RestResponse)this.customerSyncCreditApi.syncStoreState2Customer(reqDto));
        }
    }

    private void extractedAddress(StoreExportVo storeExportVo) {
        StringBuffer storeParesAddress = new StringBuffer(StringUtils.defaultString((String)storeExportVo.getProvince(), (String)""));
        storeParesAddress.append(StringUtils.defaultString((String)storeExportVo.getCity(), (String)"")).append(StringUtils.defaultString((String)storeExportVo.getDistrict(), (String)"")).append(StringUtils.defaultString((String)storeExportVo.getStoreAddr(), (String)""));
        RestResponse mapRespDtoRestResponse = this.mapApi.parserText(storeParesAddress.toString());
        MapTextRespDto mapTextRespDto = (MapTextRespDto)RestResponseHelper.extractData((RestResponse)mapRespDtoRestResponse);
        if (ObjectUtils.isNotEmpty((Object)mapTextRespDto)) {
            this.logger.info("\u3010\u9ad8\u5fb7\u5730\u56fe\u3011\u83b7\u53d6\u95e8\u5e97\u8be6\u7ec6\u5730\u5740\u7ecf\u7eac\u5ea6 response : {}", (Object)JSON.toJSONString((Object)mapTextRespDto));
            if (CollectionUtils.isNotEmpty((Collection)mapTextRespDto.getPois())) {
                MapTextRespDto.Pois pois = (MapTextRespDto.Pois)mapTextRespDto.getPois().stream().findFirst().get();
                List<String> location = Arrays.asList(pois.getLocation().split(","));
                storeExportVo.setLog((String)location.stream().findFirst().get());
                storeExportVo.setLat((String)location.stream().skip(location.size() - 1).findFirst().get());
            }
        }
    }

    private void extractedArea(StoreExportVo reqDto, List<StoreAreaRespDto> storeAreaRespDtos) {
        StoreAreaRespDto city;
        StoreAreaRespDto province;
        StoreAreaRespDto storeAreaRespDto = province = !StringUtils.isNotBlank((CharSequence)reqDto.getProvince()) ? null : this.getStoreAreaRespDtos(reqDto.getProvince(), storeAreaRespDtos);
        StoreAreaRespDto storeAreaRespDto2 = !StringUtils.isNotBlank((CharSequence)reqDto.getCity()) ? null : (city = this.getStoreAreaRespDtos(reqDto.getCity(), ObjectUtils.isEmpty((Object)province) ? Lists.newArrayList() : province.getChildren()));
        StoreAreaRespDto district = !StringUtils.isNotBlank((CharSequence)reqDto.getDistrict()) ? null : this.getStoreAreaRespDtos(reqDto.getDistrict(), ObjectUtils.isEmpty((Object)city) ? Lists.newArrayList() : city.getChildren());
        reqDto.setProvinceCode(ObjectUtils.isEmpty((Object)province) ? "" : province.getCode());
        reqDto.setProvince(ObjectUtils.isEmpty((Object)province) ? reqDto.getProvince() : province.getName());
        reqDto.setCityCode(ObjectUtils.isEmpty((Object)city) ? "" : city.getCode());
        reqDto.setCity(ObjectUtils.isEmpty((Object)city) ? reqDto.getCity() : city.getName());
        if (!ObjectUtils.isEmpty((Object)city) && CollectionUtils.isEmpty((Collection)city.getChildren())) {
            reqDto.setDistrictCode("-");
            reqDto.setDistrict("-");
        } else {
            reqDto.setDistrictCode(ObjectUtils.isEmpty((Object)district) ? "" : district.getCode());
            reqDto.setDistrict(ObjectUtils.isEmpty((Object)district) ? reqDto.getDistrict() : district.getName());
        }
    }

    private StoreAreaRespDto getStoreAreaRespDtos(String name, List<StoreAreaRespDto> storeAreaRespDtos) {
        List collect;
        if (CollectionUtils.isNotEmpty(storeAreaRespDtos) && CollectionUtils.isNotEmpty(collect = storeAreaRespDtos.stream().filter(c -> name.indexOf(c.getName()) != -1).collect(Collectors.toList()))) {
            return (StoreAreaRespDto)collect.stream().findFirst().get();
        }
        return null;
    }

    private void getParentStore(List<StoreExportVo> storeExportVos, Map<String, StoreExportVo> parentStoreExportList) {
        if (CollectionUtils.isNotEmpty(storeExportVos)) {
            for (StoreExportVo storeExportVo : storeExportVos) {
                List<StoreExportVo> children = storeExportVo.getChildren();
                StoreExportVo orDefault = parentStoreExportList.getOrDefault(storeExportVo.getSocialCreditNum(), null);
                if (null == orDefault) continue;
                parentStoreExportList.remove(storeExportVo.getSocialCreditNum());
                children.add(orDefault);
                this.getParentStore(storeExportVo.getChildren(), parentStoreExportList);
                storeExportVo.setChildren(children);
            }
        }
    }

    public void returnStore(List<StoreExportVo> parentStoreExportVo, List<StoreExportVo> storeExportList) {
        if (CollectionUtils.isNotEmpty(parentStoreExportVo)) {
            for (StoreExportVo storeExportVo : parentStoreExportVo) {
                storeExportList.addAll(storeExportVo.getChildren());
                this.returnStore(storeExportVo.getChildren(), storeExportList);
            }
        }
    }

    @Override
    public RestResponse<Void> saveOrUpdateStoreByExcel(MultipartFile file) {
        ImportRecordReqDto importRecordReqDto = new ImportRecordReqDto();
        importRecordReqDto.setCode(BizImportEnum.STORE_IMPORT.getCode());
        importRecordReqDto.setName(BizImportEnum.STORE_IMPORT.getImportName());
        importRecordReqDto.setStatus(ImportStatusEnum.LOADING.getCode());
        Long recordId = (Long)RestResponseHelper.extractData((RestResponse)this.importRecordApi.addImportRecord(importRecordReqDto));
        this.logger.info("\u65b0\u589e\u836f\u5e97\u5bfc\u5165 recordId={}", (Object)recordId);
        this.logger.info("\u4e0a\u4f20\u6587\u4ef6\u8def\u5f84: {}", (Object)file.getOriginalFilename());
        byte[] fileContent = null;
        try {
            fileContent = file.getBytes();
        }
        catch (IOException e) {
            this.logger.error("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25", (Throwable)e);
            return RestResponse.FAIL;
        }
        byte[] finalFileContent = fileContent;
        CompletableFuture.runAsync(() -> {
            ImportParams importParams = new ImportParams();
            importParams.setHeadRows(1);
            importParams.setTitleRows(0);
            importRecordReqDto.setId(recordId);
            this.logger.info("\u5f00\u59cb\u5f02\u6b65\u836f\u5e97\u5bfc\u5165 recordId={}", (Object)recordId);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(finalFileContent);){
                ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)inputStream, StoreExportVo.class, (ImportParams)importParams);
                List list = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
                if (!CollectionUtils.isNotEmpty(list)) {
                    importRecordReqDto.setStatus(ImportStatusEnum.EMPTY.getCode());
                } else {
                    ArrayList notLegalList = Lists.newArrayList();
                    if (CollectionUtils.isNotEmpty(list)) {
                        Map<String, StoreExportVo> storeExportMap = list.stream().collect(Collectors.toMap(StoreExportVo::getSocialCreditNum, val -> val, (v1, v2) -> v1));
                        List<StoreExportVo> storeExportVoResult = this.verifyStoreExport(Lists.newArrayList(storeExportMap.values()));
                        List<StoreExportVo> legalList = storeExportVoResult.stream().filter(storeExportVo -> !StringUtils.isNotBlank((CharSequence)storeExportVo.getReason())).collect(Collectors.toList());
                        notLegalList.addAll(storeExportVoResult.stream().filter(storeExportVo -> StringUtils.isNotBlank((CharSequence)storeExportVo.getReason())).collect(Collectors.toList()));
                        this.getStoreRespDtos(legalList, this.context.userName());
                    }
                    importRecordReqDto.setStatus(!ObjectUtils.isEmpty((Object)notLegalList) ? ImportStatusEnum.ERROR.getCode() : ImportStatusEnum.SUCCESS.getCode());
                    importRecordReqDto.setImportDesc(String.format(BizImportEnum.STORE_IMPORT.getDescModel(), file.getOriginalFilename(), list.size(), notLegalList.size(), list.size() - notLegalList.size()));
                    if (!ObjectUtils.isEmpty((Object)notLegalList)) {
                        String excelName = "cube/\u5bfc\u5165\u836f\u5e97\u6570\u636e\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                        importRecordReqDto.setErrorUrl(EasyPoiExportUtil.getExportUrl((List)notLegalList, StoreExportVo.class, (String)null, (String)excelName, (String)"xls"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                importRecordReqDto.setStatus(ImportStatusEnum.ERROR.getCode());
                importRecordReqDto.setImportDesc("\u836f\u5e97\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
                this.logger.error("\u836f\u5e97\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff0c\u7cfb\u7edf\u5f02\u5e38\uff1a", (Throwable)e);
            }
            RestResponseHelper.extractData((RestResponse)this.importRecordApi.modifyImportRecord(importRecordReqDto));
        }, this.importExecutor);
        return RestResponse.SUCCESS;
    }

    private void getStoreRespDtos(List<StoreExportVo> list, String userName) {
        if (userName == null || userName.isEmpty()) {
            userName = "updateByExcel";
        }
        String finalUserName = userName;
        this.logger.info("\u3010{}\u3011\u89e6\u53d1\u5206\u6279\u5904\u7406\u836f\u5e97\u6570\u636e\u5bfc\u5165 count:{},content:{}", new Object[]{userName, list.size(), JSON.toJSONString(list)});
        List<StoreReqDto> storeReqDtoList = list.stream().map(c -> {
            StoreReqDto storeReqDto = new StoreReqDto();
            CubeBeanUtils.copyProperties((Object)storeReqDto, (Object)c, (String[])new String[0]);
            return storeReqDto;
        }).collect(Collectors.toList());
        Map<String, StoreReqDto> storeExportMap = storeReqDtoList.stream().collect(Collectors.toMap(StoreReqDto::getSocialCreditNum, c -> c, (k1, k2) -> k1));
        ArrayList creditNumLists = Lists.newArrayList(storeExportMap.keySet());
        RestResponse listRestResponse = this.storeQueryApi.querySocialCreditNums((List)creditNumLists);
        List storeRespDtoList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        Map<String, StoreRespDto> storeRespDtoMap = storeRespDtoList.stream().collect(Collectors.toMap(k -> k.getSocialCreditNum().toUpperCase(Locale.ROOT), val -> val, (k1, k2) -> k2));
        List creditNumExit = storeRespDtoList.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
        creditNumLists.removeAll(creditNumExit);
        this.logger.info("\u5206\u6279\u5bfc\u5165\u836f\u5e97\u65b0\u589e\u836f\u5e97\u4fe1\u7528\u4ee3\u7801\uff1a{}", (Object)JSON.toJSONString((Object)creditNumLists));
        if (CollectionUtils.isNotEmpty((Collection)creditNumLists)) {
            List notExitList = creditNumLists.stream().map(c -> {
                StoreReqDto storeReqDto = (StoreReqDto)storeExportMap.get(c);
                storeReqDto.setCreatePerson(finalUserName);
                storeReqDto.setSocialCreditNum(storeReqDto.getSocialCreditNum().toUpperCase(Locale.ROOT));
                storeReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());
                storeReqDto.setDataOrigin(StoreDataOriginEnum.MANUALLY_ENTER.getCode());
                return storeReqDto;
            }).collect(Collectors.toList());
            this.logger.info("\u95e8\u5e97\u65b0\u589e\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(notExitList));
            if (CollectionUtils.isNotEmpty(notExitList)) {
                this.storeApi.addStoreBatch(notExitList);
            }
        }
        if (CollectionUtils.isNotEmpty(creditNumExit)) {
            List<StoreReqDto> isExitList = creditNumExit.stream().map(c -> {
                StoreReqDto storeReqDto = (StoreReqDto)storeExportMap.get(c);
                storeReqDto.setUpdatePerson(finalUserName);
                String socialCreditNum = storeReqDto.getSocialCreditNum().toUpperCase(Locale.ROOT);
                storeReqDto.setSocialCreditNum(socialCreditNum);
                StoreRespDto orDefault = storeRespDtoMap.getOrDefault(socialCreditNum, null);
                storeReqDto.setStoreId(ObjectUtils.isNotEmpty((Object)orDefault) ? orDefault.getStoreId() : "");
                storeReqDto.setIsReplenish(DefaultSettingEnum.YES.getCode());
                return storeReqDto;
            }).collect(Collectors.toList());
            this.logger.info("\u95e8\u5e97\u66f4\u65b0\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(isExitList));
            if (CollectionUtils.isNotEmpty(isExitList)) {
                this.storeApi.updateStoreBatch(isExitList);
                ((IStoreService)this.applicationContext.getBean(IStoreService.class)).syncStoreState2CustomerBatch(isExitList);
            }
        }
        List<StoreReqDto> collect = storeReqDtoList.stream().filter(c -> StoreConstant.IS_CUSTOMER.equals(c.getIsCustomer())).collect(Collectors.toList());
        collect.forEach(c -> {
            StoreReqDto storeReq = new StoreReqDto();
            storeReq.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReq.setIsCustomer(StoreConstant.IS_CUSTOMER);
            storeReq.setUpdatePerson(finalUserName);
            storeReq.setIsReplenish(DefaultSettingEnum.YES.getCode());
            this.storeApi.updateStore(storeReq);
        });
        List parentSocialCreditNumList = storeReqDtoList.stream().map(c -> c.getParentSocialCreditNum()).filter(c -> StringUtils.isNotBlank((CharSequence)c)).distinct().collect(Collectors.toList());
        List storeRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.storeQueryApi.querySocialCreditNums(parentSocialCreditNumList));
        storeRespDtos.forEach(c -> {
            StoreReqDto storeReq = new StoreReqDto();
            storeReq.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReq.setCustomerSystem(c.getCustomerSystem());
            storeReq.setBusinessPattern(c.getBusinessPattern());
            storeReq.setBizChannel(c.getBizChannel());
            storeReq.setUpdatePerson(finalUserName);
            storeReq.setIsReplenish(DefaultSettingEnum.YES.getCode());
            this.storeApi.updateStore(storeReq);
        });
        storeReqDtoList.forEach(c -> {
            StoreReqDto storeReq = new StoreReqDto();
            storeReq.setParentSocialCreditNum(c.getSocialCreditNum());
            storeReq.setCustomerSystem(c.getCustomerSystem());
            storeReq.setBusinessPattern(c.getBusinessPattern());
            storeReq.setBizChannel(c.getBizChannel());
            storeReq.setUpdatePerson(finalUserName);
            storeReq.setIsReplenish(DefaultSettingEnum.YES.getCode());
            this.storeApi.updateStore(storeReq);
        });
    }

    private List<StoreExportVo> verifyStoreExport(List<StoreExportVo> list) {
        Map<String, StoreExportVo> collect = list.stream().collect(Collectors.toMap(StoreExportVo::getSocialCreditNum, c -> c, (key1, key2) -> key2));
        for (StoreExportVo c2 : list) {
            List<String> validStoreTypes;
            List<String> bizChannel;
            StoreExportVo orDefault;
            if (StringUtils.isNotBlank((CharSequence)c2.getParentSocialCreditNum()) && null == (orDefault = (StoreExportVo)collect.getOrDefault(c2.getParentSocialCreditNum(), null))) {
                RestResponse storeRespDtoRestResponse = this.storeQueryApi.queryStoreRespDtoByCreditNum(c2.getParentSocialCreditNum());
                StoreRespDto storeRespDto = (StoreRespDto)RestResponseHelper.extractData((RestResponse)storeRespDtoRestResponse);
                this.logger.info("\u5f53\u524d\u7236\u7ea7\u95e8\u5e97\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)storeRespDto));
                if (BeanPropertyNullUtil.isAllFieldNull(storeRespDto)) {
                    c2.setReason("\u4e0d\u5b58\u5728\u5f53\u524d\u4e0a\u7ea7\u95e8\u5e97");
                    continue;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)c2.getProvince()) || StringUtils.isNotBlank((CharSequence)c2.getDistrict()) || StringUtils.isNotBlank((CharSequence)c2.getCity())) {
                List storeAreaRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.storeAreaQueryApi.queryTree());
                this.extractedArea(c2, storeAreaRespDtos);
                if (!(StringUtils.isNotBlank((CharSequence)c2.getProvinceCode()) && StringUtils.isNotBlank((CharSequence)c2.getDistrictCode()) && StringUtils.isNotBlank((CharSequence)c2.getCityCode()))) {
                    c2.setReason("\u7701\u5e02\u533a\u89e3\u6790\u5f02\u5e38");
                    continue;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)c2.getStoreAddr()) && StringUtils.isAllBlank((CharSequence[])new CharSequence[]{c2.getLog()}) && StringUtils.isAllBlank((CharSequence[])new CharSequence[]{c2.getLat()})) {
                this.extractedAddress(c2);
                if (!StringUtils.isNotBlank((CharSequence)c2.getLog()) || !StringUtils.isNotBlank((CharSequence)c2.getLat())) {
                    c2.setReason("\u7ecf\u7eac\u5ea6\u89e3\u6790\u5f02\u5e38");
                    continue;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)c2.getBizChannel()) && c2.getIsCustomer().equals(IsCustomerEnum.IS_CUSTOMER.getCode()) && ObjectUtils.isNotEmpty(bizChannel = Arrays.asList(c2.getBizChannel().split("\\+")))) {
                List bizChannelCodes = bizChannel.stream().map(biz -> BizChannelEnum.fromName((String)biz).getCode()).collect(Collectors.toList());
                c2.setBizChannel(StringUtils.join(bizChannelCodes, (String)","));
            }
            if (StringUtils.isBlank((CharSequence)c2.getStoreName())) {
                c2.setReason("* \u836f\u5e97\u540d\u79f0\uff08\u516c\u53f8\u540d\u79f0\uff09\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)c2.getSocialCreditNum())) {
                c2.setReason("* \u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)c2.getStoreType())) {
                c2.setReason("* \u673a\u6784\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)c2.getProvince())) {
                c2.setReason("* \u673a\u6784\u6240\u5c5e\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)c2.getCity())) {
                c2.setReason("* \u673a\u6784\u6240\u5c5e\u57ce\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)c2.getDistrict())) {
                c2.setReason("* \u673a\u6784\u6240\u5c5e\u533a\u53bf\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)c2.getStoreAddr())) {
                c2.setReason("* \u673a\u6784\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)c2.getState())) {
                c2.setReason("* \u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)c2.getLegalPersonName())) {
                c2.setReason("* \u6cd5\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (c2.getIsFlag() == null) {
                c2.setReason("* \u662f\u5426\u4fe1\u7528\u4ee3\u7801\u6ce8\u518c\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)c2.getStoreType()) && !(validStoreTypes = Arrays.asList("\u7ecf\u9500\u5546", "\u5355\u4f53\u836f\u5e97", "\u8fde\u9501\u603b\u90e8", "\u8fde\u9501\u95e8\u5e97", "\u8fde\u9501\u52a0\u76df\u5e97", "\u7b2c\u4e09\u7ec8\u7aef", "\u8fde\u9501\u65d7\u8230\u5e97", "\u5176\u4ed6")).contains(c2.getStoreType())) {
                c2.setReason("\u65e0\u6548\u7684\u673a\u6784\u7c7b\u578b: " + c2.getStoreType());
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)c2.getState()) && !(validStoreTypes = Arrays.asList("\u5b58\u7eed", "\u6ce8\u9500", "\u6b63\u5e38", "\u5728\u4e1a")).contains(c2.getState())) {
                c2.setReason("\u65e0\u6548\u7684\u72b6\u6001: " + c2.getState());
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)c2.getStoreName())) {
                c2.setStoreName(c2.getStoreName().trim());
            }
            if (StringUtils.isBlank((CharSequence)c2.getSocialCreditNum())) continue;
            c2.setSocialCreditNum(c2.getSocialCreditNum().trim());
        }
        return list;
    }
}

