/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerInfoExcelReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportEventReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerImportDataValidateRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerLevelRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerStatusRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerLevelQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IAuthItemRuleApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ContactsInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerService;
import com.dtyunxi.yundt.module.customer.api.dto.request.CustomerDetailReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.UserAccountReqDto;
import com.dtyunxi.yundt.module.customer.biz.service.ICustomerImportLogService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanHelper;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerImportLogServiceImpl
implements ICustomerImportLogService {
    private Logger logger = LoggerFactory.getLogger(CustomerImportLogServiceImpl.class);
    @Autowired
    private IAreaQueryApi areaQueryApi;
    @Autowired
    private ICustomerTypeQueryApi iCustomerTypeQueryApi;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    @Resource
    private ICustomerStatusQueryApi iCustomerStatusQueryApi;
    @Autowired
    private IUserQueryApi iUserQueryApi;
    @Autowired
    private ICustomerService iCustomerService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerLevelQueryApi customerLevelQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IAuthItemRuleApi authItemRuleApi;

    @Override
    public void importCustomer(ImportEventReqDto memberImportReqDto, Predicate<CustomerImportDataValidateRespDto> dataValidateResultHandler) {
        this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u83b7\u53d6\u6821\u9a8c\u6240\u9700\u6570\u636e\u4e2d" + memberImportReqDto.getUrl());
        List customerTypeEos = (List)this.iCustomerTypeQueryApi.queryAllSimpleCustomerType(memberImportReqDto.getType()).getData();
        List customerStatusRespDtoList = (List)this.iCustomerStatusQueryApi.queryByList("").getData();
        PageInfo groupRespDtoPageInfo = (PageInfo)this.areaGroupQueryApi.queryByPage("{}", Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)).getData();
        List areaGroupRespDtoList = groupRespDtoPageInfo.getList();
        List<String> regionNameList = areaGroupRespDtoList.stream().map(AreaGroupRespDto::getName).collect(Collectors.toList());
        Map<String, String> regionCodeMap = areaGroupRespDtoList.stream().collect(Collectors.toMap(AreaGroupRespDto::getName, AreaGroupRespDto::getCode, (e1, e2) -> e1));
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        if (Objects.isNull(searchReqDto.getTenantId())) {
            searchReqDto.setTenantId(this.context.tenantId());
        }
        RestResponse listRestResponse = this.customerQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List customerRespList = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        RestResponse levelRestResp = this.customerLevelQueryApi.queryByList("{}");
        List levelList = (List)RestResponseHelper.extractData((RestResponse)levelRestResp);
        Map<String, Long> levelIdMap = levelList.stream().collect(Collectors.toMap(CustomerLevelRespDto::getName, BaseRespDto::getId, (e1, e2) -> e1));
        PageInfo userDtoPageInfo = (PageInfo)this.iUserQueryApi.queryUser(memberImportReqDto.getTenantId(), "", "", "", "", Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)).getData();
        List userDtoList = userDtoPageInfo.getList();
        this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u5f00\u59cb\u5bfc\u5165\u6570\u636e\u6821\u9a8c");
        CustomerImportDataValidateRespDto dataValidateResult = this.importDataVerify(memberImportReqDto, customerTypeEos, customerStatusRespDtoList, regionNameList, userDtoList, customerRespList, levelList);
        this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u7ed3\u675f\u5bfc\u5165\u6570\u636e\u6821\u9a8c");
        this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u5f00\u59cb\u5ba2\u6237\u5bfc\u5165\u4e1a\u52a1");
        dataValidateResult.getCustomerInfoExcelList().parallelStream().forEach(customerInfoExcelReqDto -> {
            try {
                this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u8fdb\u884c\u6570\u636e\u6784\u5efa" + memberImportReqDto.getUrl());
                BeanHelper.beanAttributeValueTrim(customerInfoExcelReqDto);
                CustomerDetailReqDto customerDetailReqDto1 = this.getCustomerDetailReqDto(memberImportReqDto, customerTypeEos, customerStatusRespDtoList, regionCodeMap, (CustomerInfoExcelReqDto)customerInfoExcelReqDto, userDtoList, customerRespList, levelIdMap);
                this.buildUserAccountReqDto((CustomerInfoExcelReqDto)customerInfoExcelReqDto, customerDetailReqDto1);
                ArrayList<ContactsInfoDto> contactsInfoDtos = new ArrayList<ContactsInfoDto>(1);
                contactsInfoDtos.add(this.buildContactsInfoDto((CustomerInfoExcelReqDto)customerInfoExcelReqDto));
                customerDetailReqDto1.setContactsInfoList(contactsInfoDtos);
                ArrayList<BillInfoDto> billInfoDtos = new ArrayList<BillInfoDto>(1);
                billInfoDtos.add(this.buildBillInfoDto((CustomerInfoExcelReqDto)customerInfoExcelReqDto));
                customerDetailReqDto1.setBillInfoList(billInfoDtos);
                if (StringUtils.isNotBlank((CharSequence)customerInfoExcelReqDto.getProvince())) {
                    customerDetailReqDto1.setAddressDto(this.buildAddressDto((CustomerInfoExcelReqDto)customerInfoExcelReqDto));
                }
                this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u8c03\u7528\u63a5\u53e3\u4fdd\u5b58" + memberImportReqDto.getUrl());
                this.iCustomerService.saveAll(customerDetailReqDto1);
                ArrayList authItemRuleReqDtoList = Lists.newArrayList();
                AuthItemRuleReqDto authItemRuleReqDto = new AuthItemRuleReqDto();
                authItemRuleReqDto.setCustomerId(customerDetailReqDto1.getId());
                authItemRuleReqDto.setCustomerCode(customerDetailReqDto1.getCode());
                authItemRuleReqDto.setCustomerName(customerDetailReqDto1.getName());
                authItemRuleReqDto.setAuthType(Integer.valueOf(0));
                authItemRuleReqDto.setOrganizationId(customerDetailReqDto1.getMerchantId());
                authItemRuleReqDto.setTenantId(customerDetailReqDto1.getTenantId());
                authItemRuleReqDto.setInstanceId(customerDetailReqDto1.getInstanceId());
                authItemRuleReqDtoList.add(authItemRuleReqDto);
                this.authItemRuleApi.initAuthItemRule((List)authItemRuleReqDtoList);
            }
            catch (Exception e) {
                customerInfoExcelReqDto.setReason(e.getMessage());
                dataValidateResult.getErrorCustomerInfoExcelList().add(customerInfoExcelReqDto);
            }
        });
        if (!dataValidateResultHandler.test(dataValidateResult)) {
            return;
        }
        this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u7ed3\u675f\u5ba2\u6237\u5bfc\u5165\u4e1a\u52a1");
    }

    private CustomerDetailReqDto getCustomerDetailReqDto(ImportEventReqDto memberImportReqDto, List<CustomerTypeRespDto> customerTypeEos, List<CustomerStatusRespDto> customerStatusRespDtoList, Map<String, String> regionCodeMap, CustomerInfoExcelReqDto customerInfoExcelReqDto, List<UserDto> userDtoList, List<CustomerRespDto> customerRespList, Map<String, Long> levelIdMap) {
        CustomerDetailReqDto customerDetailReqDto1 = new CustomerDetailReqDto();
        BeanUtils.copyProperties((Object)customerInfoExcelReqDto, (Object)customerDetailReqDto1);
        if (StringUtils.isNotEmpty((CharSequence)customerInfoExcelReqDto.getProvince())) {
            customerDetailReqDto1.setProvinceCode(this.getAreaCode(customerInfoExcelReqDto.getProvince(), 0));
            customerDetailReqDto1.setProvince(customerInfoExcelReqDto.getProvince());
        }
        if (StringUtils.isNotEmpty((CharSequence)customerInfoExcelReqDto.getCity())) {
            customerDetailReqDto1.setCityCode(this.getAreaCode(customerInfoExcelReqDto.getCity(), 1));
            customerDetailReqDto1.setCity(customerInfoExcelReqDto.getCity());
        }
        if (StringUtils.isNotEmpty((CharSequence)customerInfoExcelReqDto.getCounty())) {
            customerDetailReqDto1.setCountyCode(this.getAreaCode(customerInfoExcelReqDto.getCounty(), 2));
            customerDetailReqDto1.setCounty(customerInfoExcelReqDto.getCounty());
        }
        customerDetailReqDto1.setInstanceId(memberImportReqDto.getInstanceId());
        customerDetailReqDto1.setTenantId(memberImportReqDto.getTenantId());
        String[] split = customerInfoExcelReqDto.getRegion().split("/");
        ArrayList<String> regionCodeList = new ArrayList<String>();
        ArrayList<String> regionNameList = new ArrayList<String>();
        for (String regionName : split) {
            String regionCode = regionCodeMap.get(regionName);
            regionNameList.add(regionName);
            regionCodeList.add(regionCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)customerInfoExcelReqDto.getCustomerLevel())) {
            Long levelId = levelIdMap.get(customerInfoExcelReqDto.getCustomerLevel());
            customerDetailReqDto1.setLevelId(levelId);
        }
        customerDetailReqDto1.setRegionCodeList(regionCodeList);
        customerDetailReqDto1.setRegionNameList(regionNameList);
        for (CustomerRespDto customerRespDto : customerRespList) {
            if (!customerRespDto.getName().equals(customerInfoExcelReqDto.getParentCustomer())) continue;
            customerDetailReqDto1.setParentCustomerId(customerRespDto.getId());
            break;
        }
        for (CustomerStatusRespDto customerStatusRespDto : customerStatusRespDtoList) {
            if (!customerStatusRespDto.getName().equals(customerInfoExcelReqDto.getAccountStatusName())) continue;
            customerDetailReqDto1.setStatusId(customerStatusRespDto.getId());
            break;
        }
        for (CustomerTypeRespDto customerTypeEo : customerTypeEos) {
            if (!customerTypeEo.getName().equals(customerInfoExcelReqDto.getCustomerType())) continue;
            customerDetailReqDto1.setCustomerTypeId(customerTypeEo.getId());
            break;
        }
        for (UserDto userDto : userDtoList) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{customerInfoExcelReqDto.getSalesmanNameMobile()}) || !customerInfoExcelReqDto.getSalesmanNameMobile().equals(userDto.getPhone())) continue;
            customerDetailReqDto1.setSalesmanId(userDto.getId());
            break;
        }
        return customerDetailReqDto1;
    }

    private AddressDto buildAddressDto(CustomerInfoExcelReqDto customerInfoExcelReqDto) {
        AddressDto addressDto = new AddressDto();
        BeanUtils.copyProperties((Object)customerInfoExcelReqDto, (Object)addressDto);
        addressDto.setProvinceCode(this.getAreaCode(customerInfoExcelReqDto.getProvince(), 0));
        addressDto.setCityCode(this.getAreaCode(customerInfoExcelReqDto.getCity(), 1));
        addressDto.setDistrictCode(this.getAreaCode(customerInfoExcelReqDto.getCounty(), 2));
        addressDto.setProvince(customerInfoExcelReqDto.getProvince());
        addressDto.setCity(customerInfoExcelReqDto.getCity());
        addressDto.setDistrict(customerInfoExcelReqDto.getCounty());
        addressDto.setStatus(Integer.valueOf(1));
        if (StringUtils.isNotEmpty((CharSequence)customerInfoExcelReqDto.getAddressType())) {
            addressDto.setAddressType(((Stream)Arrays.stream(AddressTypeEnum.values()).sequential()).filter(r -> r.getDesc().equals(customerInfoExcelReqDto.getAddressType())).map(AddressTypeEnum::getCode).findFirst().orElse(AddressTypeEnum.DELIVERY.getCode()));
        }
        return addressDto;
    }

    private BillInfoDto buildBillInfoDto(CustomerInfoExcelReqDto customerInfoExcelReqDto) {
        BillInfoDto billInfoDto = new BillInfoDto();
        BeanUtils.copyProperties((Object)customerInfoExcelReqDto, (Object)billInfoDto);
        billInfoDto.setCompanyName(customerInfoExcelReqDto.getAccountName());
        billInfoDto.setDepositBank(customerInfoExcelReqDto.getBranchAccountName());
        billInfoDto.setBankAccount(customerInfoExcelReqDto.getBranchAccountNum());
        billInfoDto.setInvoiceStatus(Integer.valueOf(1));
        return billInfoDto;
    }

    private ContactsInfoDto buildContactsInfoDto(CustomerInfoExcelReqDto customerInfoExcelReqDto) {
        ContactsInfoDto contactsInfoDto = new ContactsInfoDto();
        BeanUtils.copyProperties((Object)customerInfoExcelReqDto, (Object)contactsInfoDto);
        contactsInfoDto.setPhoneNum(customerInfoExcelReqDto.getMobile());
        contactsInfoDto.setLinkName(customerInfoExcelReqDto.getContactPerson());
        contactsInfoDto.setStatus(Integer.valueOf(1));
        return contactsInfoDto;
    }

    private String getAreaCode(String name, Integer levelId) {
        AreaQueryReqDto queryReqDto = new AreaQueryReqDto();
        queryReqDto.setLevelId(levelId);
        queryReqDto.setName(name);
        List areaDtos = ((PageInfo)this.areaQueryApi.queryByPage(queryReqDto).getData()).getList();
        return !CollectionUtils.isEmpty((Collection)areaDtos) ? ((AreaDto)areaDtos.get(0)).getCode() : null;
    }

    private void buildUserAccountReqDto(CustomerInfoExcelReqDto customerInfoExcelReqDto, CustomerDetailReqDto customerDetailReqDto1) {
        UserAccountReqDto userAccountReqDto = new UserAccountReqDto();
        BeanUtils.copyProperties((Object)customerInfoExcelReqDto, (Object)userAccountReqDto);
        List customerStatusRespDtoList = (List)this.iCustomerStatusQueryApi.queryByList("").getData();
        for (CustomerStatusRespDto customerStatusRespDto : customerStatusRespDtoList) {
            if (!customerStatusRespDto.getName().equals(customerInfoExcelReqDto.getAccountStatusName())) continue;
            userAccountReqDto.setStatusId(customerStatusRespDto.getId());
        }
        customerDetailReqDto1.setUserAccountReqDto(userAccountReqDto);
    }

    @Override
    public CustomerImportDataValidateRespDto importDataVerify(ImportEventReqDto importEventReqDto, List<CustomerTypeRespDto> customerTypeEos, List<CustomerStatusRespDto> customerStatusRespDtoList, List<String> regionNameList, List<UserDto> userDtoList, List<CustomerRespDto> customerRespList, List<CustomerLevelRespDto> levelList) {
        List memberInfoExcelReqDtoList = importEventReqDto.getCustomerInfoExcelReqList();
        ArrayList errorCustomerList = Lists.newArrayList();
        for (CustomerInfoExcelReqDto customerInfoExcelReqDto : memberInfoExcelReqDtoList) {
            boolean reserveMobileIsExit;
            boolean userIsExit;
            boolean parentIsExit;
            boolean levelIsExit;
            if (StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getName()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getCustomerType()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getRegion()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getContactPerson()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getMobile()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getUserName()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getPassword()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getAccountStatusName()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getAccountName()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getBranchAccountName()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getBranchAccountNum()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getTaxpayerId()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getInvoiceTitle())) {
                customerInfoExcelReqDto.setReason("\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a,\u8bf7\u68c0\u67e5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            boolean customerTypeIsExit = customerTypeEos.stream().anyMatch(customerTypeEo -> customerTypeEo.getName().equals(customerInfoExcelReqDto.getCustomerType()));
            if (!customerTypeIsExit) {
                customerInfoExcelReqDto.setReason("\u7531\u4e8e\u5ba2\u6237\u7c7b\u578b\u4e0d\u5339\u914d,\u8bf7\u68c0\u67e5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            List<String> needRegionList = Arrays.asList(customerInfoExcelReqDto.getRegion().split("/"));
            needRegionList.retainAll(regionNameList);
            if (CollectionUtils.isEmpty(needRegionList)) {
                customerInfoExcelReqDto.setReason("[\u5ba2\u6237\u533a\u57df]\u9519\u8bef,\u8bf7\u68c0\u67e5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            customerInfoExcelReqDto.setRegion(StringUtils.join(needRegionList, (String)"/"));
            boolean bl = levelIsExit = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{customerInfoExcelReqDto.getCustomerLevel()}) && levelList.stream().noneMatch(level -> customerInfoExcelReqDto.getCustomerLevel().equals(level.getName()));
            if (levelIsExit) {
                customerInfoExcelReqDto.setReason("[\u5ba2\u6237\u7ea7\u522b\u540d\u79f0]\u4e0d\u6b63\u786e,\u8bf7\u68c0\u67e5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            boolean bl2 = parentIsExit = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{customerInfoExcelReqDto.getParentCustomer()}) && customerRespList.stream().noneMatch(customer -> customerInfoExcelReqDto.getParentCustomer().equals(customer.getName()));
            if (parentIsExit) {
                customerInfoExcelReqDto.setReason("[\u6240\u5c5e\u4e0a\u7ea7]\u9519\u8bef,\u8bf7\u68c0\u67e5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)customerInfoExcelReqDto.getProvince()) && !this.isExit(customerInfoExcelReqDto.getProvince(), 0)) {
                customerInfoExcelReqDto.setReason("[\u6240\u5c5e\u7701\u540d]\u9519\u8bef,\u8bf7\u68c0\u67e5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)customerInfoExcelReqDto.getCity()) && !this.isExit(customerInfoExcelReqDto.getCity(), 1)) {
                customerInfoExcelReqDto.setReason("[\u6240\u5c5e\u5e02\u540d]\u9519\u8bef,\u8bf7\u68c0\u67e5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)customerInfoExcelReqDto.getCounty()) && !this.isExit(customerInfoExcelReqDto.getCounty(), 2)) {
                customerInfoExcelReqDto.setReason("[\u6240\u5c5e\u533a\u540d]\u9519\u8bef,\u8bf7\u68c0\u67e5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{customerInfoExcelReqDto.getSalesmanNameMobile()}) && CollectionUtils.isEmpty(userDtoList)) {
                customerInfoExcelReqDto.setReason("\u7cfb\u7edf\u627e\u4e0d\u5230\u5458\u5de5\u6570\u636e,\u65e0\u6cd5\u9a8c\u8bc1\u4e1a\u52a1\u5458\u624b\u673a\u53f7,\u8bf7\u5c1d\u8bd5\u5220\u9664\u4e1a\u52a1\u5458\u624b\u673a\u53f7\u6d3b\u65b0\u589e\u5458\u5de5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            boolean bl3 = userIsExit = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{customerInfoExcelReqDto.getSalesmanNameMobile()}) && !userDtoList.stream().anyMatch(userDto -> customerInfoExcelReqDto.getSalesmanNameMobile().equals(userDto.getPhone()));
            if (userIsExit) {
                customerInfoExcelReqDto.setReason("[\u6240\u5c5e\u4e1a\u52a1\u5458\u624b\u673a]\u9519\u8bef,\u8bf7\u68c0\u67e5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            boolean mobileIsExit = CommonUtil.validateMobilePhone(customerInfoExcelReqDto.getMobile());
            if (!mobileIsExit) {
                customerInfoExcelReqDto.setReason("[\u624b\u673a]\u683c\u5f0f\u9519\u8bef,\u8bf7\u68c0\u67e5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            boolean bl4 = reserveMobileIsExit = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{customerInfoExcelReqDto.getReserveMobile()}) && !CommonUtil.validateMobilePhone(customerInfoExcelReqDto.getReserveMobile());
            if (reserveMobileIsExit) {
                customerInfoExcelReqDto.setReason("[\u9884\u7559\u624b\u673a]\u683c\u5f0f\u9519\u8bef,\u8bf7\u68c0\u67e5");
                errorCustomerList.add(customerInfoExcelReqDto);
                continue;
            }
            boolean statusIsExit = customerStatusRespDtoList.stream().anyMatch(customerStatusRespDto -> customerStatusRespDto.getName().equals(customerInfoExcelReqDto.getAccountStatusName()));
            if (statusIsExit) continue;
            customerInfoExcelReqDto.setReason("[\u8d26\u53f7\u72b6\u6001]\u4e0e\u7cfb\u7edf\u4e0d\u5339\u914d,\u8bf7\u68c0\u67e5");
            errorCustomerList.add(customerInfoExcelReqDto);
        }
        CustomerImportDataValidateRespDto resultDto = new CustomerImportDataValidateRespDto();
        resultDto.setErrorCustomerInfoExcelList((List)errorCustomerList);
        memberInfoExcelReqDtoList.removeAll(errorCustomerList);
        resultDto.setCustomerInfoExcelList(memberInfoExcelReqDtoList);
        return resultDto;
    }

    private boolean isExit(String name, Integer levelId) {
        AreaQueryReqDto queryReqDto = new AreaQueryReqDto();
        queryReqDto.setLevelId(levelId);
        queryReqDto.setName(name);
        List areaDtos = ((PageInfo)this.areaQueryApi.queryByPage(queryReqDto).getData()).getList();
        return !CollectionUtils.isEmpty((Collection)areaDtos);
    }
}

