/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportEventReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.SupplierInfoExcelReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.supplier.ISupplierApi;
import com.dtyunxi.yundt.cube.center.customer.api.supplier.dto.request.SupplierReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.supplier.dto.response.SupplierImportDataValidateRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.supplier.query.ISupplierQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.module.customer.biz.service.ISupplierImportLogService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanHelper;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SupplierImportLogServiceImpl
implements ISupplierImportLogService {
    @Autowired
    private IAreaQueryApi areaQueryApi;
    @Autowired
    private ISupplierApi iSupplierApi;
    @Autowired
    private ISupplierQueryApi iSupplierQueryApi;
    private Logger logger = LoggerFactory.getLogger(SupplierImportLogServiceImpl.class);

    @Override
    public SupplierImportDataValidateRespDto importDataVerify(ImportEventReqDto importEventReqDto) {
        List supplierInfoExcelReqList = importEventReqDto.getSupplierInfoExcelReqList();
        ArrayList errorCustomerList = Lists.newArrayList();
        List allCode = (List)this.iSupplierQueryApi.findAllCode(importEventReqDto.getInstanceId(), importEventReqDto.getTenantId()).getData();
        HashSet<String> codeSet = new HashSet<String>(allCode == null ? new ArrayList() : allCode);
        for (SupplierInfoExcelReqDto customerInfoExcelReqDto : supplierInfoExcelReqList) {
            try {
                boolean mobileIsExit;
                boolean add = codeSet.add(customerInfoExcelReqDto.getCode());
                if (!add) {
                    customerInfoExcelReqDto.setReason("\u4f9b\u5e94\u5546\u7f16\u7801\u91cd\u590d,\u8bf7\u68c0\u67e5");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getName()) || StringUtils.isBlank((CharSequence)customerInfoExcelReqDto.getCode())) {
                    customerInfoExcelReqDto.setReason("\u5fc5\u586b\u5b57\u6bb5\u4e3a\u7a7a,\u8bf7\u68c0\u67e5");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)customerInfoExcelReqDto.getProvince()) && !this.isExit(customerInfoExcelReqDto.getProvince(), 0)) {
                    customerInfoExcelReqDto.setReason("[\u6240\u5c5e\u7701\u540d]\u9519\u8bef,\u8bf7\u68c0\u67e5");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)customerInfoExcelReqDto.getCity()) && !this.isExit(customerInfoExcelReqDto.getCity(), 1)) {
                    customerInfoExcelReqDto.setReason("[\u6240\u5c5e\u5e02\u540d]\u9519\u8bef,\u8bf7\u68c0\u67e5");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)customerInfoExcelReqDto.getCounty()) && !this.isExit(customerInfoExcelReqDto.getCounty(), 2)) {
                    customerInfoExcelReqDto.setReason("[\u6240\u5c5e\u533a\u540d]\u9519\u8bef,\u8bf7\u68c0\u67e5");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }
                boolean bl = mobileIsExit = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{customerInfoExcelReqDto.getContactMobile()}) && !CommonUtil.validateMobilePhone(customerInfoExcelReqDto.getContactMobile());
                if (mobileIsExit) {
                    customerInfoExcelReqDto.setReason("[\u624b\u673a]\u683c\u5f0f\u9519\u8bef,\u8bf7\u68c0\u67e5");
                    errorCustomerList.add(customerInfoExcelReqDto);
                    continue;
                }
                BeanHelper.beanAttributeValueTrim(customerInfoExcelReqDto);
                SupplierReqDto supplierReqDto = this.initSupplierDetailReqDto(customerInfoExcelReqDto);
                supplierReqDto.setInstanceId(importEventReqDto.getInstanceId());
                supplierReqDto.setTenantId(importEventReqDto.getTenantId());
                this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165\u8fdb\u884c\u4e2d ---> \u5f00\u59cb\u4fdd\u5b58excel\u6570\u636e{}", (Object)supplierReqDto.toString());
                RestResponseHelper.checkOrThrow((RestResponse)this.iSupplierApi.add(supplierReqDto));
            }
            catch (Exception e) {
                e.printStackTrace();
                customerInfoExcelReqDto.setReason(e.getMessage());
                errorCustomerList.add(customerInfoExcelReqDto);
            }
        }
        SupplierImportDataValidateRespDto resultDto = new SupplierImportDataValidateRespDto();
        resultDto.setErrorSupplierInfoExcelList((List)errorCustomerList);
        supplierInfoExcelReqList.removeAll(errorCustomerList);
        resultDto.setOkSupplierinfoexcelreqdtos(supplierInfoExcelReqList);
        return resultDto;
    }

    @Override
    public void importSupplier(ImportEventReqDto importEventReqDto, Predicate<SupplierImportDataValidateRespDto> dataValidateResultHandler) {
        ServiceContext.getContext().setAttachment("yes.req.tenantId", String.valueOf(importEventReqDto.getTenantId()));
        ServiceContext.getContext().setAttachment("yes.req.instanceId", String.valueOf(importEventReqDto.getInstanceId()));
        this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165\u8fdb\u884c\u4e2d ---> \u5f00\u59cb\u6821\u9a8cexcel\u6570\u636e");
        SupplierImportDataValidateRespDto supplierImportDataValidateRespDto = this.importDataVerify(importEventReqDto);
        if (!dataValidateResultHandler.test(supplierImportDataValidateRespDto)) {
            return;
        }
        this.logger.info("\u5ba2\u6237\u6279\u91cf\u5bfc\u5165 ---> \u7ed3\u675f\u5ba2\u6237\u5bfc\u5165\u4e1a\u52a1");
    }

    private SupplierReqDto initSupplierDetailReqDto(SupplierInfoExcelReqDto infoExcelReqDto) {
        SupplierReqDto supplierReqDto = new SupplierReqDto();
        BeanUtils.copyProperties((Object)infoExcelReqDto, (Object)supplierReqDto);
        supplierReqDto.setProvinceCode(this.getAreaCode(infoExcelReqDto.getProvince(), 0));
        supplierReqDto.setCityCode(this.getAreaCode(infoExcelReqDto.getCity(), 1));
        supplierReqDto.setCountyCode(this.getAreaCode(infoExcelReqDto.getCounty(), 2));
        supplierReqDto.setProvince(infoExcelReqDto.getProvince());
        supplierReqDto.setCity(infoExcelReqDto.getCity());
        supplierReqDto.setCounty(infoExcelReqDto.getCounty());
        return supplierReqDto;
    }

    private String getAreaCode(String name, Integer levelId) {
        AreaQueryReqDto queryReqDto = new AreaQueryReqDto();
        queryReqDto.setLevelId(levelId);
        queryReqDto.setName(name);
        List areaDtos = ((PageInfo)this.areaQueryApi.queryByPage(queryReqDto).getData()).getList();
        return !CollectionUtils.isEmpty((Collection)areaDtos) ? ((AreaDto)areaDtos.get(0)).getCode() : null;
    }

    private boolean isExit(String name, Integer levelId) {
        AreaQueryReqDto queryReqDto = new AreaQueryReqDto();
        queryReqDto.setLevelId(levelId);
        queryReqDto.setName(name);
        List areaDtos = ((PageInfo)this.areaQueryApi.queryByPage(queryReqDto).getData()).getList();
        return !CollectionUtils.isEmpty((Collection)areaDtos);
    }
}

